# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['graph4nlp',
 'graph4nlp.pytorch',
 'graph4nlp.pytorch.data',
 'graph4nlp.pytorch.datasets',
 'graph4nlp.pytorch.models',
 'graph4nlp.pytorch.modules',
 'graph4nlp.pytorch.modules.config',
 'graph4nlp.pytorch.modules.config.graph_construction',
 'graph4nlp.pytorch.modules.config.graph_embedding',
 'graph4nlp.pytorch.modules.config.prediction',
 'graph4nlp.pytorch.modules.config.prediction.generation',
 'graph4nlp.pytorch.modules.evaluation',
 'graph4nlp.pytorch.modules.evaluation.bleu_tool',
 'graph4nlp.pytorch.modules.evaluation.cider_tool',
 'graph4nlp.pytorch.modules.evaluation.meteor_tool',
 'graph4nlp.pytorch.modules.evaluation.meteor_tool.data',
 'graph4nlp.pytorch.modules.evaluation.rouge_tool',
 'graph4nlp.pytorch.modules.graph_construction',
 'graph4nlp.pytorch.modules.graph_embedding',
 'graph4nlp.pytorch.modules.loss',
 'graph4nlp.pytorch.modules.prediction',
 'graph4nlp.pytorch.modules.prediction.classification',
 'graph4nlp.pytorch.modules.prediction.classification.graph_classification',
 'graph4nlp.pytorch.modules.prediction.classification.kg_completion',
 'graph4nlp.pytorch.modules.prediction.classification.link_prediction',
 'graph4nlp.pytorch.modules.prediction.classification.node_classification',
 'graph4nlp.pytorch.modules.prediction.generation',
 'graph4nlp.pytorch.modules.utils',
 'graph4nlp.pytorch.test',
 'graph4nlp.pytorch.test.data_structure',
 'graph4nlp.pytorch.test.dataset',
 'graph4nlp.pytorch.test.evaluation',
 'graph4nlp.pytorch.test.example',
 'graph4nlp.pytorch.test.example.jobs',
 'graph4nlp.pytorch.test.example.jobs.graph2seq',
 'graph4nlp.pytorch.test.example.kinship',
 'graph4nlp.pytorch.test.generation.tree_decoder',
 'graph4nlp.pytorch.test.graph_classification',
 'graph4nlp.pytorch.test.graph_construction',
 'graph4nlp.pytorch.test.graph_embedding',
 'graph4nlp.pytorch.test.kg_completion',
 'graph4nlp.pytorch.test.kg_completion.src.spodernet',
 'graph4nlp.pytorch.test.kg_completion.src.spodernet.examples',
 'graph4nlp.pytorch.test.kg_completion.src.spodernet.spodernet',
 'graph4nlp.pytorch.test.kg_completion.src.spodernet.spodernet.backends',
 'graph4nlp.pytorch.test.kg_completion.src.spodernet.spodernet.data',
 'graph4nlp.pytorch.test.kg_completion.src.spodernet.spodernet.preprocessing',
 'graph4nlp.pytorch.test.kg_completion.src.spodernet.spodernet.utils',
 'graph4nlp.pytorch.test.kg_completion.src.spodernet.tests',
 'graph4nlp.pytorch.test.link_prediction',
 'graph4nlp.pytorch.test.node_classification',
 'graph4nlp.pytorch.test.seq_decoder.graph2seq.src',
 'graph4nlp.pytorch.test.seq_decoder.graph2seq.src.g2s_v2',
 'graph4nlp.pytorch.test.seq_decoder.graph2seq.src.g2s_v2.config',
 'graph4nlp.pytorch.test.seq_decoder.graph2seq.src.g2s_v2.core',
 'graph4nlp.pytorch.test.seq_decoder.graph2seq.src.g2s_v2.core.layers',
 'graph4nlp.pytorch.test.seq_decoder.graph2seq.src.g2s_v2.core.models',
 'graph4nlp.pytorch.test.seq_decoder.graph2seq.src.g2s_v2.core.utils',
 'graph4nlp.pytorch.test.seq_decoder.graph2seq.src.g2s_v2.scripts']

package_data = \
{'': ['*'],
 'graph4nlp.pytorch.modules.config': ['loss/*'],
 'graph4nlp.pytorch.modules.config.prediction': ['classification/link_prediction/*',
                                                 'classification/node_classification/*'],
 'graph4nlp.pytorch.test': ['seq_decoder/*', 'seq_decoder/graph2seq/*'],
 'graph4nlp.pytorch.test.dataset': ['conll/raw/*',
                                    'jobs/raw/*',
                                    'kinship/raw/*'],
 'graph4nlp.pytorch.test.generation.tree_decoder': ['data/*',
                                                    'data/GraphConstruction/*',
                                                    'data/TextData/*',
                                                    'data/geo880/*',
                                                    'data/jobs640/*'],
 'graph4nlp.pytorch.test.graph_embedding': ['gat_config/*'],
 'graph4nlp.pytorch.test.kg_completion': ['data/*'],
 'graph4nlp.pytorch.test.kg_completion.src.spodernet.tests': ['test_data/*'],
 'graph4nlp.pytorch.test.link_prediction': ['data/*'],
 'graph4nlp.pytorch.test.seq_decoder.graph2seq.src.g2s_v2.config': ['JOBS/*']}

install_requires = \
['PyYAML>=6.0,<7.0',
 'dgl>=0.6.1,<0.7.0',
 'networkx>=2.5',
 'nltk>=3.5',
 'ogb>=1.3.2,<2.0.0',
 'pythonds>=1.2.1,<2.0.0',
 'scikit-learn>=0.23.2',
 'scipy>=1.5.2',
 'stanfordcorenlp>=3.9.1,<4.0.0',
 'tqdm>=4.29.0',
 'transformers>=4.11.3,<5.0.0']

setup_kwargs = {
    'name': 'verbcl-graph4nlp-cpu',
    'version': '0.1.0',
    'description': 'Fork of Graph4NLP specific for VerbCL Graph on CPU',
    'long_description': None,
    'author': 'Julien ROSSI',
    'author_email': 'j.rossi@uva.nl',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
