# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-04-29 15:59
from __future__ import unicode_literals

import django.db.models.deletion
from django.db import migrations, models

import ditto.core.models


class Migration(migrations.Migration):

    dependencies = [
        ("flickr", "0007_auto_20160414_1637"),
    ]

    operations = [
        migrations.CreateModel(
            name="Photoset",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "time_created",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="The time this item was created in the database.",
                    ),
                ),
                (
                    "time_modified",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="The time this item was last saved to the database.",
                    ),
                ),
                ("flickr_id", models.BigIntegerField(unique=True)),
                ("title", models.CharField(max_length=255)),
                (
                    "description",
                    models.TextField(blank=True, help_text="Can contain HTML"),
                ),
                ("photo_count", models.PositiveIntegerField(default=0)),
                ("video_count", models.PositiveIntegerField(default=0)),
                (
                    "view_count",
                    models.PositiveIntegerField(
                        default=0,
                        help_text="How many times this had been viewed when fetched",
                    ),
                ),
                (
                    "comment_count",
                    models.PositiveIntegerField(
                        default=0, help_text="How many comments this had when fetched"
                    ),
                ),
                (
                    "last_update_time",
                    models.DateTimeField(
                        blank=True,
                        help_text="The last time the set was modified on Flickr. UTC.",
                        null=True,
                    ),
                ),
                (
                    "flickr_created_time",
                    models.DateTimeField(
                        blank=True,
                        help_text="When the set was created on Flickr. UTC.",
                        null=True,
                    ),
                ),
                (
                    "raw",
                    models.TextField(
                        blank=True, help_text="The raw JSON from the API."
                    ),
                ),
            ],
            options={"ordering": ["-flickr_created_time"]},
            bases=(ditto.core.models.DiffModelMixin, models.Model),
        ),
        migrations.AlterField(
            model_name="photo",
            name="comment_count",
            field=models.PositiveIntegerField(
                default=0, help_text="How many comments this had when fetched"
            ),
        ),
        migrations.AlterField(
            model_name="photo",
            name="sizes_raw",
            field=models.TextField(
                blank=True,
                help_text="The raw JSON from the API - flickr.photos.getSizes.",
            ),
        ),
        migrations.AlterField(
            model_name="user",
            name="raw",
            field=models.TextField(blank=True, help_text="The raw JSON from the API."),
        ),
        migrations.AddField(
            model_name="photoset",
            name="primary_photo",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="flickr.Photo",
            ),
        ),
        migrations.AddField(
            model_name="photoset",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="flickr.User"
            ),
        ),
    ]
