# coding: utf-8

"""
    Welcome to the Atera API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from atera_client.api_client import ApiClient


class TicketApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def ticket_delete(self, ticket_id, **kwargs):  # noqa: E501
        """Delete specified ticket  # noqa: E501

        Deletes the specified ticket. Requires the ticket ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_delete(ticket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.ticket_delete_with_http_info(ticket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.ticket_delete_with_http_info(ticket_id, **kwargs)  # noqa: E501
            return data

    def ticket_delete_with_http_info(self, ticket_id, **kwargs):  # noqa: E501
        """Delete specified ticket  # noqa: E501

        Deletes the specified ticket. Requires the ticket ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_delete_with_http_info(ticket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ticket_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method ticket_delete" % key)
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ticket_id' is set
        if self.api_client.client_side_validation and (
            "ticket_id" not in params or params["ticket_id"] is None
        ):  # noqa: E501
            raise ValueError("Missing the required parameter `ticket_id` when calling `ticket_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ticket_id" in params:
            path_params["ticketId"] = params["ticket_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/tickets/{ticketId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def ticket_get(self, **kwargs):  # noqa: E501
        """Find tickets  # noqa: E501

        Returns a list of tickets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Optional - Page index (default is 1), based on items per page
        :param int items_in_page: Optional - Number of items per page (default is 20, max is 50)
        :param int customer_id:
        :param str ticket_status:
        :return: APIResultWrapperTicketQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.ticket_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.ticket_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def ticket_get_with_http_info(self, **kwargs):  # noqa: E501
        """Find tickets  # noqa: E501

        Returns a list of tickets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Optional - Page index (default is 1), based on items per page
        :param int items_in_page: Optional - Number of items per page (default is 20, max is 50)
        :param int customer_id:
        :param str ticket_status:
        :return: APIResultWrapperTicketQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["page", "items_in_page", "customer_id", "ticket_status"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method ticket_get" % key)
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "page" in params:
            query_params.append(("page", params["page"]))  # noqa: E501
        if "items_in_page" in params:
            query_params.append(("itemsInPage", params["items_in_page"]))  # noqa: E501
        if "customer_id" in params:
            query_params.append(("customerId", params["customer_id"]))  # noqa: E501
        if "ticket_status" in params:
            query_params.append(("ticketStatus", params["ticket_status"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/json"])  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/tickets",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="APIResultWrapperTicketQueryDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def ticket_get_0(self, ticket_id, **kwargs):  # noqa: E501
        """Find specified ticket  # noqa: E501

        Returns the specified ticket. Requires the ticket ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_get_0(ticket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :return: TicketQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.ticket_get_0_with_http_info(ticket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.ticket_get_0_with_http_info(ticket_id, **kwargs)  # noqa: E501
            return data

    def ticket_get_0_with_http_info(self, ticket_id, **kwargs):  # noqa: E501
        """Find specified ticket  # noqa: E501

        Returns the specified ticket. Requires the ticket ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_get_0_with_http_info(ticket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :return: TicketQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ticket_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method ticket_get_0" % key)
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ticket_id' is set
        if self.api_client.client_side_validation and (
            "ticket_id" not in params or params["ticket_id"] is None
        ):  # noqa: E501
            raise ValueError("Missing the required parameter `ticket_id` when calling `ticket_get_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ticket_id" in params:
            path_params["ticketId"] = params["ticket_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/tickets/{ticketId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="TicketQueryDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def ticket_get_billable_duration(self, ticket_id, **kwargs):  # noqa: E501
        """Find specified ticket (billable duration)  # noqa: E501

        Returns the specified ticket (billable duration). Requires the ticket ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_get_billable_duration(ticket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :return: TicketDurationQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.ticket_get_billable_duration_with_http_info(ticket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.ticket_get_billable_duration_with_http_info(ticket_id, **kwargs)  # noqa: E501
            return data

    def ticket_get_billable_duration_with_http_info(self, ticket_id, **kwargs):  # noqa: E501
        """Find specified ticket (billable duration)  # noqa: E501

        Returns the specified ticket (billable duration). Requires the ticket ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_get_billable_duration_with_http_info(ticket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :return: TicketDurationQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ticket_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method ticket_get_billable_duration" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ticket_id' is set
        if self.api_client.client_side_validation and (
            "ticket_id" not in params or params["ticket_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `ticket_id` when calling `ticket_get_billable_duration`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ticket_id" in params:
            path_params["ticketId"] = params["ticket_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/tickets/{ticketId}/billableduration",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="TicketDurationQueryDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def ticket_get_comments(self, ticket_id, **kwargs):  # noqa: E501
        """Find ticket comments list  # noqa: E501

        Returns the ticket comments. Requires the ticket ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_get_comments(ticket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :param int page: Optional - Page index (default is 1), based on items per page
        :param int items_in_page: Optional - Number of items per page (default is 20, max is 50)
        :return: APIResultWrapperTicketCommentQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.ticket_get_comments_with_http_info(ticket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.ticket_get_comments_with_http_info(ticket_id, **kwargs)  # noqa: E501
            return data

    def ticket_get_comments_with_http_info(self, ticket_id, **kwargs):  # noqa: E501
        """Find ticket comments list  # noqa: E501

        Returns the ticket comments. Requires the ticket ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_get_comments_with_http_info(ticket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :param int page: Optional - Page index (default is 1), based on items per page
        :param int items_in_page: Optional - Number of items per page (default is 20, max is 50)
        :return: APIResultWrapperTicketCommentQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ticket_id", "page", "items_in_page"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method ticket_get_comments" % key)
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ticket_id' is set
        if self.api_client.client_side_validation and (
            "ticket_id" not in params or params["ticket_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `ticket_id` when calling `ticket_get_comments`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ticket_id" in params:
            path_params["ticketId"] = params["ticket_id"]  # noqa: E501

        query_params = []
        if "page" in params:
            query_params.append(("page", params["page"]))  # noqa: E501
        if "items_in_page" in params:
            query_params.append(("itemsInPage", params["items_in_page"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/json"])  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/tickets/{ticketId}/comments",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="APIResultWrapperTicketCommentQueryDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def ticket_get_non_billable_duration(self, ticket_id, **kwargs):  # noqa: E501
        """Find specified ticket (non-billable duration)  # noqa: E501

        Returns the specified ticket (non-billable duration). Requires the ticket ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_get_non_billable_duration(ticket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :return: TicketDurationQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.ticket_get_non_billable_duration_with_http_info(ticket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.ticket_get_non_billable_duration_with_http_info(ticket_id, **kwargs)  # noqa: E501
            return data

    def ticket_get_non_billable_duration_with_http_info(self, ticket_id, **kwargs):  # noqa: E501
        """Find specified ticket (non-billable duration)  # noqa: E501

        Returns the specified ticket (non-billable duration). Requires the ticket ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_get_non_billable_duration_with_http_info(ticket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :return: TicketDurationQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ticket_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method ticket_get_non_billable_duration" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ticket_id' is set
        if self.api_client.client_side_validation and (
            "ticket_id" not in params or params["ticket_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `ticket_id` when calling `ticket_get_non_billable_duration`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ticket_id" in params:
            path_params["ticketId"] = params["ticket_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/tickets/{ticketId}/nonbillableduration",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="TicketDurationQueryDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def ticket_get_workhours(self, ticket_id, **kwargs):  # noqa: E501
        """Find specified ticket (workhours duration)  # noqa: E501

        Returns a record of the specified ticket's billable and non-billable workhours. Requires the ticket ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_get_workhours(ticket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :return: TicketTimeEntriesSummaryQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.ticket_get_workhours_with_http_info(ticket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.ticket_get_workhours_with_http_info(ticket_id, **kwargs)  # noqa: E501
            return data

    def ticket_get_workhours_with_http_info(self, ticket_id, **kwargs):  # noqa: E501
        """Find specified ticket (workhours duration)  # noqa: E501

        Returns a record of the specified ticket's billable and non-billable workhours. Requires the ticket ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_get_workhours_with_http_info(ticket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :return: TicketTimeEntriesSummaryQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ticket_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method ticket_get_workhours" % key)
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ticket_id' is set
        if self.api_client.client_side_validation and (
            "ticket_id" not in params or params["ticket_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `ticket_id` when calling `ticket_get_workhours`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ticket_id" in params:
            path_params["ticketId"] = params["ticket_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/tickets/{ticketId}/workhours",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="TicketTimeEntriesSummaryQueryDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def ticket_get_workhours_records(self, ticket_id, **kwargs):  # noqa: E501
        """Find tickets (workhour list)  # noqa: E501

        Returns the ticket's workhours. Requires the ticket ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_get_workhours_records(ticket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :param int page: Optional - Page index (default is 1), based on items per page
        :param int items_in_page: Optional - Number of items per page (default is 20, max is 50)
        :return: APIResultWrapperTicketTimeEntriesQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.ticket_get_workhours_records_with_http_info(ticket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.ticket_get_workhours_records_with_http_info(ticket_id, **kwargs)  # noqa: E501
            return data

    def ticket_get_workhours_records_with_http_info(self, ticket_id, **kwargs):  # noqa: E501
        """Find tickets (workhour list)  # noqa: E501

        Returns the ticket's workhours. Requires the ticket ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_get_workhours_records_with_http_info(ticket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :param int page: Optional - Page index (default is 1), based on items per page
        :param int items_in_page: Optional - Number of items per page (default is 20, max is 50)
        :return: APIResultWrapperTicketTimeEntriesQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ticket_id", "page", "items_in_page"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method ticket_get_workhours_records" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ticket_id' is set
        if self.api_client.client_side_validation and (
            "ticket_id" not in params or params["ticket_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `ticket_id` when calling `ticket_get_workhours_records`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ticket_id" in params:
            path_params["ticketId"] = params["ticket_id"]  # noqa: E501

        query_params = []
        if "page" in params:
            query_params.append(("page", params["page"]))  # noqa: E501
        if "items_in_page" in params:
            query_params.append(("itemsInPage", params["items_in_page"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/json"])  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/tickets/{ticketId}/workhoursrecords",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="APIResultWrapperTicketTimeEntriesQueryDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def ticket_post(self, ticket, **kwargs):  # noqa: E501
        """Create ticket  # noqa: E501

        Creates a new ticket. Requires the enduser contact ID, title, and description.              <br /><br />               If you wish to create a new enduser for the ticket then you need to provide:              <br /><br />               Contact first name (EndUserFirstName)              <br />               Contact last name (EndUserLastName)              <br />               Email (EndUserEmail)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_post(ticket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateTicketDTO ticket: Required - System Ticket object (required)
        :return: Result
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.ticket_post_with_http_info(ticket, **kwargs)  # noqa: E501
        else:
            (data) = self.ticket_post_with_http_info(ticket, **kwargs)  # noqa: E501
            return data

    def ticket_post_with_http_info(self, ticket, **kwargs):  # noqa: E501
        """Create ticket  # noqa: E501

        Creates a new ticket. Requires the enduser contact ID, title, and description.              <br /><br />               If you wish to create a new enduser for the ticket then you need to provide:              <br /><br />               Contact first name (EndUserFirstName)              <br />               Contact last name (EndUserLastName)              <br />               Email (EndUserEmail)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_post_with_http_info(ticket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateTicketDTO ticket: Required - System Ticket object (required)
        :return: Result
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ticket"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method ticket_post" % key)
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ticket' is set
        if self.api_client.client_side_validation and (
            "ticket" not in params or params["ticket"] is None
        ):  # noqa: E501
            raise ValueError("Missing the required parameter `ticket` when calling `ticket_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "ticket" in params:
            body_params = params["ticket"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/json"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/tickets",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Result",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def ticket_put(self, ticket_id, ticket, **kwargs):  # noqa: E501
        """Update specified ticket  # noqa: E501

        Updates an existing ticket. Requires the ticket ID.              <br /><br />               The following fields are editable:              <br /><br />               Ticket Title (TicketTitle)              <br />              Ticket Status (TicketStatus)              <br />               Ticket Type (TicketType)              <br />              Ticket Priority (TicketPriority)              <br />              Ticket Impact (TicketImpact)              <br />              Assigned Technician ID (TechnicianContactID)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_put(ticket_id, ticket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :param UpdateTicketDTO ticket: Required - System Ticket object (required)
        :return: Result
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.ticket_put_with_http_info(ticket_id, ticket, **kwargs)  # noqa: E501
        else:
            (data) = self.ticket_put_with_http_info(ticket_id, ticket, **kwargs)  # noqa: E501
            return data

    def ticket_put_with_http_info(self, ticket_id, ticket, **kwargs):  # noqa: E501
        """Update specified ticket  # noqa: E501

        Updates an existing ticket. Requires the ticket ID.              <br /><br />               The following fields are editable:              <br /><br />               Ticket Title (TicketTitle)              <br />              Ticket Status (TicketStatus)              <br />               Ticket Type (TicketType)              <br />              Ticket Priority (TicketPriority)              <br />              Ticket Impact (TicketImpact)              <br />              Assigned Technician ID (TechnicianContactID)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_put_with_http_info(ticket_id, ticket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :param UpdateTicketDTO ticket: Required - System Ticket object (required)
        :return: Result
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ticket_id", "ticket"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method ticket_put" % key)
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ticket_id' is set
        if self.api_client.client_side_validation and (
            "ticket_id" not in params or params["ticket_id"] is None
        ):  # noqa: E501
            raise ValueError("Missing the required parameter `ticket_id` when calling `ticket_put`")  # noqa: E501
        # verify the required parameter 'ticket' is set
        if self.api_client.client_side_validation and (
            "ticket" not in params or params["ticket"] is None
        ):  # noqa: E501
            raise ValueError("Missing the required parameter `ticket` when calling `ticket_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ticket_id" in params:
            path_params["ticketId"] = params["ticket_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "ticket" in params:
            body_params = params["ticket"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/json"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/tickets/{ticketId}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Result",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def ticket_put_0(self, ticket_id, ticket, **kwargs):  # noqa: E501
        """Update specified ticket  # noqa: E501

        Updates an existing ticket. Requires the ticket ID.              <br /><br />               The following fields are editable:              <br /><br />               Ticket Title (TicketTitle)              <br />              Ticket Status (TicketStatus)              <br />               Ticket Type (TicketType)              <br />              Ticket Priority (TicketPriority)              <br />              Ticket Impact (TicketImpact)              <br />              Assigned Technician ID (TechnicianContactID)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_put_0(ticket_id, ticket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :param UpdateTicketDTO ticket: Required - System Ticket object (required)
        :return: Result
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.ticket_put_0_with_http_info(ticket_id, ticket, **kwargs)  # noqa: E501
        else:
            (data) = self.ticket_put_0_with_http_info(ticket_id, ticket, **kwargs)  # noqa: E501
            return data

    def ticket_put_0_with_http_info(self, ticket_id, ticket, **kwargs):  # noqa: E501
        """Update specified ticket  # noqa: E501

        Updates an existing ticket. Requires the ticket ID.              <br /><br />               The following fields are editable:              <br /><br />               Ticket Title (TicketTitle)              <br />              Ticket Status (TicketStatus)              <br />               Ticket Type (TicketType)              <br />              Ticket Priority (TicketPriority)              <br />              Ticket Impact (TicketImpact)              <br />              Assigned Technician ID (TechnicianContactID)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_put_0_with_http_info(ticket_id, ticket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :param UpdateTicketDTO ticket: Required - System Ticket object (required)
        :return: Result
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ticket_id", "ticket"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method ticket_put_0" % key)
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ticket_id' is set
        if self.api_client.client_side_validation and (
            "ticket_id" not in params or params["ticket_id"] is None
        ):  # noqa: E501
            raise ValueError("Missing the required parameter `ticket_id` when calling `ticket_put_0`")  # noqa: E501
        # verify the required parameter 'ticket' is set
        if self.api_client.client_side_validation and (
            "ticket" not in params or params["ticket"] is None
        ):  # noqa: E501
            raise ValueError("Missing the required parameter `ticket` when calling `ticket_put_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ticket_id" in params:
            path_params["ticketId"] = params["ticket_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "ticket" in params:
            body_params = params["ticket"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/json"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/tickets/{ticketId}",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Result",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def ticket_track_status_modified(self, **kwargs):  # noqa: E501
        """Find resolved and closed tickets  # noqa: E501

        Returns a list of resolved and closed tickets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_track_status_modified(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Optional - Page index (default is 1), based on items per page
        :param int items_in_page: Optional - Number of items per page (default is 20, max is 50)
        :return: APIResultWrapperTicketQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.ticket_track_status_modified_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.ticket_track_status_modified_with_http_info(**kwargs)  # noqa: E501
            return data

    def ticket_track_status_modified_with_http_info(self, **kwargs):  # noqa: E501
        """Find resolved and closed tickets  # noqa: E501

        Returns a list of resolved and closed tickets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ticket_track_status_modified_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Optional - Page index (default is 1), based on items per page
        :param int items_in_page: Optional - Number of items per page (default is 20, max is 50)
        :return: APIResultWrapperTicketQueryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["page", "items_in_page"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method ticket_track_status_modified" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "page" in params:
            query_params.append(("page", params["page"]))  # noqa: E501
        if "items_in_page" in params:
            query_params.append(("itemsInPage", params["items_in_page"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/json"])  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/tickets/statusmodified",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="APIResultWrapperTicketQueryDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
