# coding: utf-8

"""
    Welcome to the Atera API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from atera_client.api_client import ApiClient


class CustomValuesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def custom_values_get(self, row_id, **kwargs):  # noqa: E501
        """Find custom field value  # noqa: E501

        Returns a custom field value. Requires a custom value ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get(row_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str row_id: Required - Custom Value ID (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_get_with_http_info(row_id, **kwargs)  # noqa: E501
        else:
            (data) = self.custom_values_get_with_http_info(row_id, **kwargs)  # noqa: E501
            return data

    def custom_values_get_with_http_info(self, row_id, **kwargs):  # noqa: E501
        """Find custom field value  # noqa: E501

        Returns a custom field value. Requires a custom value ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_with_http_info(row_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str row_id: Required - Custom Value ID (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["row_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method custom_values_get" % key)
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'row_id' is set
        if self.api_client.client_side_validation and (
            "row_id" not in params or params["row_id"] is None
        ):  # noqa: E501
            raise ValueError("Missing the required parameter `row_id` when calling `custom_values_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "row_id" in params:
            path_params["rowId"] = params["row_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/{rowId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CustomValueQueryDTO]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_get_agent_field(self, agent_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified agent  # noqa: E501

        Returns a custom field value for a specified agent. Requires the agent ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_agent_field(agent_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int agent_id: Required - System Agent ID (required)
        :param str field_name: Required - System Custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_get_agent_field_with_http_info(agent_id, field_name, **kwargs)  # noqa: E501
        else:
            (data) = self.custom_values_get_agent_field_with_http_info(agent_id, field_name, **kwargs)  # noqa: E501
            return data

    def custom_values_get_agent_field_with_http_info(self, agent_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified agent  # noqa: E501

        Returns a custom field value for a specified agent. Requires the agent ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_agent_field_with_http_info(agent_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int agent_id: Required - System Agent ID (required)
        :param str field_name: Required - System Custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["agent_id", "field_name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_get_agent_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'agent_id' is set
        if self.api_client.client_side_validation and (
            "agent_id" not in params or params["agent_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `agent_id` when calling `custom_values_get_agent_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_get_agent_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "agent_id" in params:
            path_params["agentId"] = params["agent_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/agentfield/{agentId}/{fieldName}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CustomValueQueryDTO]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_get_contact_field(self, contact_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified contact  # noqa: E501

        Returns a custom field value for a specified contact. Requires the contact ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_contact_field(contact_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int contact_id: Required - System Contact ID (required)
        :param str field_name: Required - System custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_get_contact_field_with_http_info(contact_id, field_name, **kwargs)  # noqa: E501
        else:
            (data) = self.custom_values_get_contact_field_with_http_info(contact_id, field_name, **kwargs)  # noqa: E501
            return data

    def custom_values_get_contact_field_with_http_info(self, contact_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified contact  # noqa: E501

        Returns a custom field value for a specified contact. Requires the contact ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_contact_field_with_http_info(contact_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int contact_id: Required - System Contact ID (required)
        :param str field_name: Required - System custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["contact_id", "field_name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_get_contact_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'contact_id' is set
        if self.api_client.client_side_validation and (
            "contact_id" not in params or params["contact_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `contact_id` when calling `custom_values_get_contact_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_get_contact_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "contact_id" in params:
            path_params["contactId"] = params["contact_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/contactfield/{contactId}/{fieldName}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CustomValueQueryDTO]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_get_contract_field(self, contract_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified contract  # noqa: E501

        Returns a custom field value for a specified contract. Requires the contract ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_contract_field(contract_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int contract_id: Required - System contract ID (required)
        :param str field_name: Required - System custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_get_contract_field_with_http_info(contract_id, field_name, **kwargs)  # noqa: E501
        else:
            (data) = self.custom_values_get_contract_field_with_http_info(
                contract_id, field_name, **kwargs
            )  # noqa: E501
            return data

    def custom_values_get_contract_field_with_http_info(self, contract_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified contract  # noqa: E501

        Returns a custom field value for a specified contract. Requires the contract ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_contract_field_with_http_info(contract_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int contract_id: Required - System contract ID (required)
        :param str field_name: Required - System custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["contract_id", "field_name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_get_contract_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'contract_id' is set
        if self.api_client.client_side_validation and (
            "contract_id" not in params or params["contract_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `contract_id` when calling `custom_values_get_contract_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_get_contract_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "contract_id" in params:
            path_params["contractId"] = params["contract_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/contractfield/{contractId}/{fieldName}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CustomValueQueryDTO]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_get_custom_fields(self, **kwargs):  # noqa: E501
        """Get list of custom field and value options  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_custom_fields(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[CustomFieldQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_get_custom_fields_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.custom_values_get_custom_fields_with_http_info(**kwargs)  # noqa: E501
            return data

    def custom_values_get_custom_fields_with_http_info(self, **kwargs):  # noqa: E501
        """Get list of custom field and value options  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_custom_fields_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[CustomFieldQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_get_custom_fields" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/customfields",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CustomFieldQueryDTO]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_get_customer_field(self, customer_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified customer  # noqa: E501

        Returns a custom field value for a specified customer. Requires a customer ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_customer_field(customer_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: Required - System Customer ID (required)
        :param str field_name: Required - System custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_get_customer_field_with_http_info(customer_id, field_name, **kwargs)  # noqa: E501
        else:
            (data) = self.custom_values_get_customer_field_with_http_info(
                customer_id, field_name, **kwargs
            )  # noqa: E501
            return data

    def custom_values_get_customer_field_with_http_info(self, customer_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified customer  # noqa: E501

        Returns a custom field value for a specified customer. Requires a customer ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_customer_field_with_http_info(customer_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: Required - System Customer ID (required)
        :param str field_name: Required - System custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["customer_id", "field_name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_get_customer_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and (
            "customer_id" not in params or params["customer_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `customer_id` when calling `custom_values_get_customer_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_get_customer_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "customer_id" in params:
            path_params["customerId"] = params["customer_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/customerfield/{customerId}/{fieldName}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CustomValueQueryDTO]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_get_generic_field(self, generic_device_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified generic  # noqa: E501

        Returns a custom field value for a specified generic. Requires the generic ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_generic_field(generic_device_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int generic_device_id: Required - System Generic ID (required)
        :param str field_name: Required - System Custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_get_generic_field_with_http_info(
                generic_device_id, field_name, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_get_generic_field_with_http_info(
                generic_device_id, field_name, **kwargs
            )  # noqa: E501
            return data

    def custom_values_get_generic_field_with_http_info(self, generic_device_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified generic  # noqa: E501

        Returns a custom field value for a specified generic. Requires the generic ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_generic_field_with_http_info(generic_device_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int generic_device_id: Required - System Generic ID (required)
        :param str field_name: Required - System Custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["generic_device_id", "field_name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_get_generic_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'generic_device_id' is set
        if self.api_client.client_side_validation and (
            "generic_device_id" not in params or params["generic_device_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `generic_device_id` when calling `custom_values_get_generic_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_get_generic_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "generic_device_id" in params:
            path_params["genericDeviceId"] = params["generic_device_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/genericfield/{genericDeviceId}/{fieldName}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CustomValueQueryDTO]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_get_http_field(self, http_device_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified HTTP  # noqa: E501

        Returns a custom field value for a specified HTTP. Requires the HTTP ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_http_field(http_device_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int http_device_id: Required - System HTTP ID (required)
        :param str field_name: Required - System Custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_get_http_field_with_http_info(http_device_id, field_name, **kwargs)  # noqa: E501
        else:
            (data) = self.custom_values_get_http_field_with_http_info(
                http_device_id, field_name, **kwargs
            )  # noqa: E501
            return data

    def custom_values_get_http_field_with_http_info(self, http_device_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified HTTP  # noqa: E501

        Returns a custom field value for a specified HTTP. Requires the HTTP ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_http_field_with_http_info(http_device_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int http_device_id: Required - System HTTP ID (required)
        :param str field_name: Required - System Custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["http_device_id", "field_name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_get_http_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'http_device_id' is set
        if self.api_client.client_side_validation and (
            "http_device_id" not in params or params["http_device_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `http_device_id` when calling `custom_values_get_http_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_get_http_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "http_device_id" in params:
            path_params["httpDeviceId"] = params["http_device_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/httpfield/{httpDeviceId}/{fieldName}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CustomValueQueryDTO]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_get_sla_field(self, sla_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified SLA  # noqa: E501

        Returns a custom field value for a specified SLA. Requires the SLA ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_sla_field(sla_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sla_id: Required - System SLA ID (required)
        :param str field_name: Required - System Custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_get_sla_field_with_http_info(sla_id, field_name, **kwargs)  # noqa: E501
        else:
            (data) = self.custom_values_get_sla_field_with_http_info(sla_id, field_name, **kwargs)  # noqa: E501
            return data

    def custom_values_get_sla_field_with_http_info(self, sla_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified SLA  # noqa: E501

        Returns a custom field value for a specified SLA. Requires the SLA ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_sla_field_with_http_info(sla_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sla_id: Required - System SLA ID (required)
        :param str field_name: Required - System Custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["sla_id", "field_name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_get_sla_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'sla_id' is set
        if self.api_client.client_side_validation and (
            "sla_id" not in params or params["sla_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `sla_id` when calling `custom_values_get_sla_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_get_sla_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "sla_id" in params:
            path_params["slaId"] = params["sla_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/slafield/{slaId}/{fieldName}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CustomValueQueryDTO]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_get_snmp_field(self, snmp_device_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified SNMP  # noqa: E501

        Returns a custom field value for a specified SNMP. Requires the SNMP ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_snmp_field(snmp_device_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int snmp_device_id: Required - System SNMP ID (required)
        :param str field_name: Required - System Custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_get_snmp_field_with_http_info(snmp_device_id, field_name, **kwargs)  # noqa: E501
        else:
            (data) = self.custom_values_get_snmp_field_with_http_info(
                snmp_device_id, field_name, **kwargs
            )  # noqa: E501
            return data

    def custom_values_get_snmp_field_with_http_info(self, snmp_device_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified SNMP  # noqa: E501

        Returns a custom field value for a specified SNMP. Requires the SNMP ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_snmp_field_with_http_info(snmp_device_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int snmp_device_id: Required - System SNMP ID (required)
        :param str field_name: Required - System Custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["snmp_device_id", "field_name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_get_snmp_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'snmp_device_id' is set
        if self.api_client.client_side_validation and (
            "snmp_device_id" not in params or params["snmp_device_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `snmp_device_id` when calling `custom_values_get_snmp_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_get_snmp_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "snmp_device_id" in params:
            path_params["snmpDeviceId"] = params["snmp_device_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/snmpfield/{snmpDeviceId}/{fieldName}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CustomValueQueryDTO]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_get_tcp_field(self, tcp_device_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified TCP  # noqa: E501

        Returns a custom field value for a specified TCP. Requires the TCP ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_tcp_field(tcp_device_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tcp_device_id: Required - System TCP ID (required)
        :param str field_name: Required - System Custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_get_tcp_field_with_http_info(tcp_device_id, field_name, **kwargs)  # noqa: E501
        else:
            (data) = self.custom_values_get_tcp_field_with_http_info(tcp_device_id, field_name, **kwargs)  # noqa: E501
            return data

    def custom_values_get_tcp_field_with_http_info(self, tcp_device_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified TCP  # noqa: E501

        Returns a custom field value for a specified TCP. Requires the TCP ID and custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_tcp_field_with_http_info(tcp_device_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tcp_device_id: Required - System TCP ID (required)
        :param str field_name: Required - System Custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["tcp_device_id", "field_name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_get_tcp_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'tcp_device_id' is set
        if self.api_client.client_side_validation and (
            "tcp_device_id" not in params or params["tcp_device_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `tcp_device_id` when calling `custom_values_get_tcp_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_get_tcp_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "tcp_device_id" in params:
            path_params["tcpDeviceId"] = params["tcp_device_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/tcpfield/{tcpDeviceId}/{fieldName}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CustomValueQueryDTO]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_get_ticket_field(self, ticket_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified ticket  # noqa: E501

        Returns a custom field value for a specified ticket. Requires a ticket ID and a custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_ticket_field(ticket_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :param str field_name: Required - System custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_get_ticket_field_with_http_info(ticket_id, field_name, **kwargs)  # noqa: E501
        else:
            (data) = self.custom_values_get_ticket_field_with_http_info(ticket_id, field_name, **kwargs)  # noqa: E501
            return data

    def custom_values_get_ticket_field_with_http_info(self, ticket_id, field_name, **kwargs):  # noqa: E501
        """Find custom field value for specified ticket  # noqa: E501

        Returns a custom field value for a specified ticket. Requires a ticket ID and a custom field name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_get_ticket_field_with_http_info(ticket_id, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket ID (required)
        :param str field_name: Required - System custom field name (required)
        :return: list[CustomValueQueryDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ticket_id", "field_name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_get_ticket_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ticket_id' is set
        if self.api_client.client_side_validation and (
            "ticket_id" not in params or params["ticket_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `ticket_id` when calling `custom_values_get_ticket_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_get_ticket_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ticket_id" in params:
            path_params["ticketId"] = params["ticket_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/ticketfield/{ticketId}/{fieldName}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CustomValueQueryDTO]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_agent_field(self, agent_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Agent  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_agent_field(agent_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int agent_id: Required - System Agent id (required)
        :param str field_name: Required - System Custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_agent_field_with_http_info(
                agent_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_agent_field_with_http_info(
                agent_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_agent_field_with_http_info(self, agent_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Agent  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_agent_field_with_http_info(agent_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int agent_id: Required - System Agent id (required)
        :param str field_name: Required - System Custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["agent_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_agent_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'agent_id' is set
        if self.api_client.client_side_validation and (
            "agent_id" not in params or params["agent_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `agent_id` when calling `custom_values_set_agent_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_agent_field`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_agent_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "agent_id" in params:
            path_params["agentId"] = params["agent_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "value" in params:
            body_params = params["value"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/agentfield/{agentId}/{fieldName}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_agent_field_0(self, agent_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Agent  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_agent_field_0(agent_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int agent_id: Required - System Agent id (required)
        :param str field_name: Required - System Custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_agent_field_0_with_http_info(
                agent_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_agent_field_0_with_http_info(
                agent_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_agent_field_0_with_http_info(self, agent_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Agent  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_agent_field_0_with_http_info(agent_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int agent_id: Required - System Agent id (required)
        :param str field_name: Required - System Custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["agent_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_agent_field_0" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'agent_id' is set
        if self.api_client.client_side_validation and (
            "agent_id" not in params or params["agent_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `agent_id` when calling `custom_values_set_agent_field_0`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_agent_field_0`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_agent_field_0`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "agent_id" in params:
            path_params["agentId"] = params["agent_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501
        if "value" in params:
            path_params["value"] = params["value"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/agentfield/{agentId}/{fieldName}/{value}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_contact_field(self, contact_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Contact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_contact_field(contact_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int contact_id: Required - System Contact id (required)
        :param str field_name: Required - System custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_contact_field_with_http_info(
                contact_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_contact_field_with_http_info(
                contact_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_contact_field_with_http_info(self, contact_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Contact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_contact_field_with_http_info(contact_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int contact_id: Required - System Contact id (required)
        :param str field_name: Required - System custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["contact_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_contact_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'contact_id' is set
        if self.api_client.client_side_validation and (
            "contact_id" not in params or params["contact_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `contact_id` when calling `custom_values_set_contact_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_contact_field`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_contact_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "contact_id" in params:
            path_params["contactId"] = params["contact_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "value" in params:
            body_params = params["value"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/contactfield/{contactId}/{fieldName}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_contact_field_0(self, contact_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Contact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_contact_field_0(contact_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int contact_id: Required - System Contact id (required)
        :param str field_name: Required - System custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_contact_field_0_with_http_info(
                contact_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_contact_field_0_with_http_info(
                contact_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_contact_field_0_with_http_info(self, contact_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Contact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_contact_field_0_with_http_info(contact_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int contact_id: Required - System Contact id (required)
        :param str field_name: Required - System custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["contact_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_contact_field_0" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'contact_id' is set
        if self.api_client.client_side_validation and (
            "contact_id" not in params or params["contact_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `contact_id` when calling `custom_values_set_contact_field_0`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_contact_field_0`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_contact_field_0`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "contact_id" in params:
            path_params["contactId"] = params["contact_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501
        if "value" in params:
            path_params["value"] = params["value"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/contactfield/{contactId}/{fieldName}/{value}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_contract_field(self, contract_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Contract  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_contract_field(contract_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int contract_id: Required - System contract id (required)
        :param str field_name: Required - System custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_contract_field_with_http_info(
                contract_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_contract_field_with_http_info(
                contract_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_contract_field_with_http_info(self, contract_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Contract  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_contract_field_with_http_info(contract_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int contract_id: Required - System contract id (required)
        :param str field_name: Required - System custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["contract_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_contract_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'contract_id' is set
        if self.api_client.client_side_validation and (
            "contract_id" not in params or params["contract_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `contract_id` when calling `custom_values_set_contract_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_contract_field`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_contract_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "contract_id" in params:
            path_params["contractId"] = params["contract_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "value" in params:
            body_params = params["value"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/contractfield/{contractId}/{fieldName}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_contract_field_0(self, contract_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Contract  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_contract_field_0(contract_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int contract_id: Required - System contract id (required)
        :param str field_name: Required - System custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_contract_field_0_with_http_info(
                contract_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_contract_field_0_with_http_info(
                contract_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_contract_field_0_with_http_info(self, contract_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Contract  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_contract_field_0_with_http_info(contract_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int contract_id: Required - System contract id (required)
        :param str field_name: Required - System custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["contract_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_contract_field_0" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'contract_id' is set
        if self.api_client.client_side_validation and (
            "contract_id" not in params or params["contract_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `contract_id` when calling `custom_values_set_contract_field_0`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_contract_field_0`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_contract_field_0`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "contract_id" in params:
            path_params["contractId"] = params["contract_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501
        if "value" in params:
            path_params["value"] = params["value"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/contractfield/{contractId}/{fieldName}/{value}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_customer_field(self, customer_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_customer_field(customer_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: Required - System Customer id (required)
        :param str field_name: Required - System custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_customer_field_with_http_info(
                customer_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_customer_field_with_http_info(
                customer_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_customer_field_with_http_info(self, customer_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_customer_field_with_http_info(customer_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: Required - System Customer id (required)
        :param str field_name: Required - System custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["customer_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_customer_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and (
            "customer_id" not in params or params["customer_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `customer_id` when calling `custom_values_set_customer_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_customer_field`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_customer_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "customer_id" in params:
            path_params["customerId"] = params["customer_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "value" in params:
            body_params = params["value"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/customerfield/{customerId}/{fieldName}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_customer_field_0(self, customer_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_customer_field_0(customer_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: Required - System Customer id (required)
        :param str field_name: Required - System custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_customer_field_0_with_http_info(
                customer_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_customer_field_0_with_http_info(
                customer_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_customer_field_0_with_http_info(self, customer_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_customer_field_0_with_http_info(customer_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: Required - System Customer id (required)
        :param str field_name: Required - System custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["customer_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_customer_field_0" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and (
            "customer_id" not in params or params["customer_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `customer_id` when calling `custom_values_set_customer_field_0`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_customer_field_0`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_customer_field_0`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "customer_id" in params:
            path_params["customerId"] = params["customer_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501
        if "value" in params:
            path_params["value"] = params["value"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/customerfield/{customerId}/{fieldName}/{value}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_generic_field(self, generic_device_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Generic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_generic_field(generic_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int generic_device_id: Required - System Generic id (required)
        :param str field_name: Required - System Custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_generic_field_with_http_info(
                generic_device_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_generic_field_with_http_info(
                generic_device_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_generic_field_with_http_info(
        self, generic_device_id, field_name, value, **kwargs
    ):  # noqa: E501
        """Set value of custom field for specified Generic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_generic_field_with_http_info(generic_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int generic_device_id: Required - System Generic id (required)
        :param str field_name: Required - System Custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["generic_device_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_generic_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'generic_device_id' is set
        if self.api_client.client_side_validation and (
            "generic_device_id" not in params or params["generic_device_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `generic_device_id` when calling `custom_values_set_generic_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_generic_field`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_generic_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "generic_device_id" in params:
            path_params["genericDeviceId"] = params["generic_device_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "value" in params:
            body_params = params["value"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/genericfield/{genericDeviceId}/{fieldName}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_generic_field_0(self, generic_device_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified Generic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_generic_field_0(generic_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int generic_device_id: Required - System Generic id (required)
        :param str field_name: Required - System Custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_generic_field_0_with_http_info(
                generic_device_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_generic_field_0_with_http_info(
                generic_device_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_generic_field_0_with_http_info(
        self, generic_device_id, field_name, value, **kwargs
    ):  # noqa: E501
        """Set value of custom field for specified Generic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_generic_field_0_with_http_info(generic_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int generic_device_id: Required - System Generic id (required)
        :param str field_name: Required - System Custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["generic_device_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_generic_field_0" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'generic_device_id' is set
        if self.api_client.client_side_validation and (
            "generic_device_id" not in params or params["generic_device_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `generic_device_id` when calling `custom_values_set_generic_field_0`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_generic_field_0`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_generic_field_0`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "generic_device_id" in params:
            path_params["genericDeviceId"] = params["generic_device_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501
        if "value" in params:
            path_params["value"] = params["value"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/genericfield/{genericDeviceId}/{fieldName}/{value}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_http_field(self, http_device_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified HTTP  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_http_field(http_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int http_device_id: Required - System HTTP id (required)
        :param str field_name: Required - System Custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_http_field_with_http_info(
                http_device_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_http_field_with_http_info(
                http_device_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_http_field_with_http_info(self, http_device_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified HTTP  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_http_field_with_http_info(http_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int http_device_id: Required - System HTTP id (required)
        :param str field_name: Required - System Custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["http_device_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_http_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'http_device_id' is set
        if self.api_client.client_side_validation and (
            "http_device_id" not in params or params["http_device_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `http_device_id` when calling `custom_values_set_http_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_http_field`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_http_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "http_device_id" in params:
            path_params["httpDeviceId"] = params["http_device_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "value" in params:
            body_params = params["value"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/httpfield/{httpDeviceId}/{fieldName}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_http_field_0(self, http_device_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified HTTP  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_http_field_0(http_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int http_device_id: Required - System HTTP id (required)
        :param str field_name: Required - System Custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_http_field_0_with_http_info(
                http_device_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_http_field_0_with_http_info(
                http_device_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_http_field_0_with_http_info(self, http_device_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified HTTP  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_http_field_0_with_http_info(http_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int http_device_id: Required - System HTTP id (required)
        :param str field_name: Required - System Custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["http_device_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_http_field_0" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'http_device_id' is set
        if self.api_client.client_side_validation and (
            "http_device_id" not in params or params["http_device_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `http_device_id` when calling `custom_values_set_http_field_0`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_http_field_0`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_http_field_0`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "http_device_id" in params:
            path_params["httpDeviceId"] = params["http_device_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501
        if "value" in params:
            path_params["value"] = params["value"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/httpfield/{httpDeviceId}/{fieldName}/{value}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_sla_field(self, sla_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified SLA  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_sla_field(sla_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sla_id: Required - System SLA id (required)
        :param str field_name: Required - System Custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_sla_field_with_http_info(sla_id, field_name, value, **kwargs)  # noqa: E501
        else:
            (data) = self.custom_values_set_sla_field_with_http_info(sla_id, field_name, value, **kwargs)  # noqa: E501
            return data

    def custom_values_set_sla_field_with_http_info(self, sla_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified SLA  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_sla_field_with_http_info(sla_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sla_id: Required - System SLA id (required)
        :param str field_name: Required - System Custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["sla_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_sla_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'sla_id' is set
        if self.api_client.client_side_validation and (
            "sla_id" not in params or params["sla_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `sla_id` when calling `custom_values_set_sla_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_sla_field`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_sla_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "sla_id" in params:
            path_params["slaId"] = params["sla_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "value" in params:
            body_params = params["value"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/slafield/{slaId}/{fieldName}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_sla_field_0(self, sla_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified SLA  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_sla_field_0(sla_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sla_id: Required - System SLA id (required)
        :param str field_name: Required - System Custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_sla_field_0_with_http_info(sla_id, field_name, value, **kwargs)  # noqa: E501
        else:
            (data) = self.custom_values_set_sla_field_0_with_http_info(
                sla_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_sla_field_0_with_http_info(self, sla_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified SLA  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_sla_field_0_with_http_info(sla_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sla_id: Required - System SLA id (required)
        :param str field_name: Required - System Custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["sla_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_sla_field_0" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'sla_id' is set
        if self.api_client.client_side_validation and (
            "sla_id" not in params or params["sla_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `sla_id` when calling `custom_values_set_sla_field_0`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_sla_field_0`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_sla_field_0`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "sla_id" in params:
            path_params["slaId"] = params["sla_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501
        if "value" in params:
            path_params["value"] = params["value"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/slafield/{slaId}/{fieldName}/{value}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_snmp_field(self, snmp_device_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified SNMP  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_snmp_field(snmp_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int snmp_device_id: Required - System SNMP id (required)
        :param str field_name: Required - System Custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_snmp_field_with_http_info(
                snmp_device_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_snmp_field_with_http_info(
                snmp_device_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_snmp_field_with_http_info(self, snmp_device_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified SNMP  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_snmp_field_with_http_info(snmp_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int snmp_device_id: Required - System SNMP id (required)
        :param str field_name: Required - System Custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["snmp_device_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_snmp_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'snmp_device_id' is set
        if self.api_client.client_side_validation and (
            "snmp_device_id" not in params or params["snmp_device_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `snmp_device_id` when calling `custom_values_set_snmp_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_snmp_field`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_snmp_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "snmp_device_id" in params:
            path_params["snmpDeviceId"] = params["snmp_device_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "value" in params:
            body_params = params["value"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/snmpfield/{snmpDeviceId}/{fieldName}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_snmp_field_0(self, snmp_device_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified SNMP  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_snmp_field_0(snmp_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int snmp_device_id: Required - System SNMP id (required)
        :param str field_name: Required - System Custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_snmp_field_0_with_http_info(
                snmp_device_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_snmp_field_0_with_http_info(
                snmp_device_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_snmp_field_0_with_http_info(self, snmp_device_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified SNMP  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_snmp_field_0_with_http_info(snmp_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int snmp_device_id: Required - System SNMP id (required)
        :param str field_name: Required - System Custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["snmp_device_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_snmp_field_0" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'snmp_device_id' is set
        if self.api_client.client_side_validation and (
            "snmp_device_id" not in params or params["snmp_device_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `snmp_device_id` when calling `custom_values_set_snmp_field_0`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_snmp_field_0`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_snmp_field_0`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "snmp_device_id" in params:
            path_params["snmpDeviceId"] = params["snmp_device_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501
        if "value" in params:
            path_params["value"] = params["value"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/snmpfield/{snmpDeviceId}/{fieldName}/{value}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_tcp_field(self, tcp_device_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified TCP  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_tcp_field(tcp_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tcp_device_id: Required - System TCP id (required)
        :param str field_name: Required - System Custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_tcp_field_with_http_info(
                tcp_device_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_tcp_field_with_http_info(
                tcp_device_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_tcp_field_with_http_info(self, tcp_device_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified TCP  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_tcp_field_with_http_info(tcp_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tcp_device_id: Required - System TCP id (required)
        :param str field_name: Required - System Custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["tcp_device_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_tcp_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'tcp_device_id' is set
        if self.api_client.client_side_validation and (
            "tcp_device_id" not in params or params["tcp_device_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `tcp_device_id` when calling `custom_values_set_tcp_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_tcp_field`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_tcp_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "tcp_device_id" in params:
            path_params["tcpDeviceId"] = params["tcp_device_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "value" in params:
            body_params = params["value"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/tcpfield/{tcpDeviceId}/{fieldName}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_tcp_field_0(self, tcp_device_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified TCP  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_tcp_field_0(tcp_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tcp_device_id: Required - System TCP id (required)
        :param str field_name: Required - System Custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_tcp_field_0_with_http_info(
                tcp_device_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_tcp_field_0_with_http_info(
                tcp_device_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_tcp_field_0_with_http_info(self, tcp_device_id, field_name, value, **kwargs):  # noqa: E501
        """Set value of custom field for specified TCP  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_tcp_field_0_with_http_info(tcp_device_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tcp_device_id: Required - System TCP id (required)
        :param str field_name: Required - System Custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["tcp_device_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_tcp_field_0" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'tcp_device_id' is set
        if self.api_client.client_side_validation and (
            "tcp_device_id" not in params or params["tcp_device_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `tcp_device_id` when calling `custom_values_set_tcp_field_0`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_tcp_field_0`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_tcp_field_0`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "tcp_device_id" in params:
            path_params["tcpDeviceId"] = params["tcp_device_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501
        if "value" in params:
            path_params["value"] = params["value"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/tcpfield/{tcpDeviceId}/{fieldName}/{value}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_ticket_field(self, ticket_id, field_name, value, **kwargs):  # noqa: E501
        """Set custom field value for specified Ticket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_ticket_field(ticket_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket id (required)
        :param str field_name: Required - System custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_ticket_field_with_http_info(
                ticket_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_ticket_field_with_http_info(
                ticket_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_ticket_field_with_http_info(self, ticket_id, field_name, value, **kwargs):  # noqa: E501
        """Set custom field value for specified Ticket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_ticket_field_with_http_info(ticket_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket id (required)
        :param str field_name: Required - System custom field name (required)
        :param SetCustomValueDTO value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ticket_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_ticket_field" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ticket_id' is set
        if self.api_client.client_side_validation and (
            "ticket_id" not in params or params["ticket_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `ticket_id` when calling `custom_values_set_ticket_field`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_ticket_field`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_ticket_field`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ticket_id" in params:
            path_params["ticketId"] = params["ticket_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "value" in params:
            body_params = params["value"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/ticketfield/{ticketId}/{fieldName}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def custom_values_set_ticket_field_0(self, ticket_id, field_name, value, **kwargs):  # noqa: E501
        """Set custom field value for specified Ticket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_ticket_field_0(ticket_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket id (required)
        :param str field_name: Required - System custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.custom_values_set_ticket_field_0_with_http_info(
                ticket_id, field_name, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.custom_values_set_ticket_field_0_with_http_info(
                ticket_id, field_name, value, **kwargs
            )  # noqa: E501
            return data

    def custom_values_set_ticket_field_0_with_http_info(self, ticket_id, field_name, value, **kwargs):  # noqa: E501
        """Set custom field value for specified Ticket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.custom_values_set_ticket_field_0_with_http_info(ticket_id, field_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ticket_id: Required - System Ticket id (required)
        :param str field_name: Required - System custom field name (required)
        :param str value: Required - System custom value to set (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ticket_id", "field_name", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method custom_values_set_ticket_field_0" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ticket_id' is set
        if self.api_client.client_side_validation and (
            "ticket_id" not in params or params["ticket_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `ticket_id` when calling `custom_values_set_ticket_field_0`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `custom_values_set_ticket_field_0`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and ("value" not in params or params["value"] is None):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `value` when calling `custom_values_set_ticket_field_0`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ticket_id" in params:
            path_params["ticketId"] = params["ticket_id"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501
        if "value" in params:
            path_params["value"] = params["value"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/json", "application/xml", "text/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v3/customvalues/ticketfield/{ticketId}/{fieldName}/{value}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
