# atera-client
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v3
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com//.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com//.git`)

Then import the package:
```python
import atera_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import atera_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import atera_client
from atera_client.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = atera_client.AgentApi(atera_client.ApiClient(configuration))
agent_id = 789 # int | Required - System agent ID

try:
    # Get specified agent
    api_response = api_instance.agent_agent_query_dto(agent_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AgentApi->agent_agent_query_dto: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://app.atera.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AgentApi* | [**agent_agent_query_dto**](docs/AgentApi.md#agent_agent_query_dto) | **GET** /api/v3/agents/{agentId} | Get specified agent
*AgentApi* | [**agent_delete**](docs/AgentApi.md#agent_delete) | **DELETE** /api/v3/agents/{agentId} | Delete specified agent
*AgentApi* | [**agent_get**](docs/AgentApi.md#agent_get) | **GET** /api/v3/agents | Find agents
*AgentApi* | [**agent_get_agents_by_machine_name**](docs/AgentApi.md#agent_get_agents_by_machine_name) | **GET** /api/v3/agents/machine/{machineName} | Get agents for specified machine.
*AgentApi* | [**agent_get_by_customer**](docs/AgentApi.md#agent_get_by_customer) | **GET** /api/v3/agents/customer/{customerId} | Find agents for specified customer
*AlertApi* | [**alert_delete**](docs/AlertApi.md#alert_delete) | **DELETE** /api/v3/alerts/{alertId} | Delete specified alert
*AlertApi* | [**alert_get**](docs/AlertApi.md#alert_get) | **GET** /api/v3/alerts | Find alerts
*AlertApi* | [**alert_get_0**](docs/AlertApi.md#alert_get_0) | **GET** /api/v3/alerts/{alertId} | Find specified alert
*AlertApi* | [**alert_post**](docs/AlertApi.md#alert_post) | **POST** /api/v3/alerts | Create alert
*BillingApi* | [**billing_get**](docs/BillingApi.md#billing_get) | **GET** /api/v3/billing/invoices | Find invoices
*BillingApi* | [**billing_invoice_query_dto**](docs/BillingApi.md#billing_invoice_query_dto) | **GET** /api/v3/billing/invoice/{invoiceNumber} | Find specified invoice
*ContactApi* | [**contact_delete**](docs/ContactApi.md#contact_delete) | **DELETE** /api/v3/contacts/{contactId} | Delete specified contact
*ContactApi* | [**contact_get**](docs/ContactApi.md#contact_get) | **GET** /api/v3/contacts | Find Contacts
*ContactApi* | [**contact_get_0**](docs/ContactApi.md#contact_get_0) | **GET** /api/v3/contacts/{contactId} | Find specified contact
*ContactApi* | [**contact_post**](docs/ContactApi.md#contact_post) | **POST** /api/v3/contacts | Create contact
*ContactApi* | [**contact_put**](docs/ContactApi.md#contact_put) | **PUT** /api/v3/contacts/{contactId} | Update specified contact
*ContactApi* | [**contact_put_0**](docs/ContactApi.md#contact_put_0) | **POST** /api/v3/contacts/{contactId} | Update specified contact
*ContractsApi* | [**contracts_contract_query_dto**](docs/ContractsApi.md#contracts_contract_query_dto) | **GET** /api/v3/contracts/{contractId} | Find specified contract
*ContractsApi* | [**contracts_get**](docs/ContractsApi.md#contracts_get) | **GET** /api/v3/contracts | Find contracts
*ContractsApi* | [**contracts_get_by_customer**](docs/ContractsApi.md#contracts_get_by_customer) | **GET** /api/v3/contracts/customer/{customerId} | Find contracts for specified customer
*CustomValuesApi* | [**custom_values_get**](docs/CustomValuesApi.md#custom_values_get) | **GET** /api/v3/customvalues/{rowId} | Find custom field value
*CustomValuesApi* | [**custom_values_get_agent_field**](docs/CustomValuesApi.md#custom_values_get_agent_field) | **GET** /api/v3/customvalues/agentfield/{agentId}/{fieldName} | Find custom field value for specified agent
*CustomValuesApi* | [**custom_values_get_contact_field**](docs/CustomValuesApi.md#custom_values_get_contact_field) | **GET** /api/v3/customvalues/contactfield/{contactId}/{fieldName} | Find custom field value for specified contact
*CustomValuesApi* | [**custom_values_get_contract_field**](docs/CustomValuesApi.md#custom_values_get_contract_field) | **GET** /api/v3/customvalues/contractfield/{contractId}/{fieldName} | Find custom field value for specified contract
*CustomValuesApi* | [**custom_values_get_custom_fields**](docs/CustomValuesApi.md#custom_values_get_custom_fields) | **GET** /api/v3/customvalues/customfields | Get list of custom field and value options
*CustomValuesApi* | [**custom_values_get_customer_field**](docs/CustomValuesApi.md#custom_values_get_customer_field) | **GET** /api/v3/customvalues/customerfield/{customerId}/{fieldName} | Find custom field value for specified customer
*CustomValuesApi* | [**custom_values_get_generic_field**](docs/CustomValuesApi.md#custom_values_get_generic_field) | **GET** /api/v3/customvalues/genericfield/{genericDeviceId}/{fieldName} | Find custom field value for specified generic
*CustomValuesApi* | [**custom_values_get_http_field**](docs/CustomValuesApi.md#custom_values_get_http_field) | **GET** /api/v3/customvalues/httpfield/{httpDeviceId}/{fieldName} | Find custom field value for specified HTTP
*CustomValuesApi* | [**custom_values_get_sla_field**](docs/CustomValuesApi.md#custom_values_get_sla_field) | **GET** /api/v3/customvalues/slafield/{slaId}/{fieldName} | Find custom field value for specified SLA
*CustomValuesApi* | [**custom_values_get_snmp_field**](docs/CustomValuesApi.md#custom_values_get_snmp_field) | **GET** /api/v3/customvalues/snmpfield/{snmpDeviceId}/{fieldName} | Find custom field value for specified SNMP
*CustomValuesApi* | [**custom_values_get_tcp_field**](docs/CustomValuesApi.md#custom_values_get_tcp_field) | **GET** /api/v3/customvalues/tcpfield/{tcpDeviceId}/{fieldName} | Find custom field value for specified TCP
*CustomValuesApi* | [**custom_values_get_ticket_field**](docs/CustomValuesApi.md#custom_values_get_ticket_field) | **GET** /api/v3/customvalues/ticketfield/{ticketId}/{fieldName} | Find custom field value for specified ticket
*CustomValuesApi* | [**custom_values_set_agent_field**](docs/CustomValuesApi.md#custom_values_set_agent_field) | **PUT** /api/v3/customvalues/agentfield/{agentId}/{fieldName} | Set value of custom field for specified Agent
*CustomValuesApi* | [**custom_values_set_agent_field_0**](docs/CustomValuesApi.md#custom_values_set_agent_field_0) | **PUT** /api/v3/customvalues/agentfield/{agentId}/{fieldName}/{value} | Set value of custom field for specified Agent
*CustomValuesApi* | [**custom_values_set_contact_field**](docs/CustomValuesApi.md#custom_values_set_contact_field) | **PUT** /api/v3/customvalues/contactfield/{contactId}/{fieldName} | Set value of custom field for specified Contact
*CustomValuesApi* | [**custom_values_set_contact_field_0**](docs/CustomValuesApi.md#custom_values_set_contact_field_0) | **PUT** /api/v3/customvalues/contactfield/{contactId}/{fieldName}/{value} | Set value of custom field for specified Contact
*CustomValuesApi* | [**custom_values_set_contract_field**](docs/CustomValuesApi.md#custom_values_set_contract_field) | **PUT** /api/v3/customvalues/contractfield/{contractId}/{fieldName} | Set value of custom field for specified Contract
*CustomValuesApi* | [**custom_values_set_contract_field_0**](docs/CustomValuesApi.md#custom_values_set_contract_field_0) | **PUT** /api/v3/customvalues/contractfield/{contractId}/{fieldName}/{value} | Set value of custom field for specified Contract
*CustomValuesApi* | [**custom_values_set_customer_field**](docs/CustomValuesApi.md#custom_values_set_customer_field) | **PUT** /api/v3/customvalues/customerfield/{customerId}/{fieldName} | Set value of custom field for specified Customer
*CustomValuesApi* | [**custom_values_set_customer_field_0**](docs/CustomValuesApi.md#custom_values_set_customer_field_0) | **PUT** /api/v3/customvalues/customerfield/{customerId}/{fieldName}/{value} | Set value of custom field for specified Customer
*CustomValuesApi* | [**custom_values_set_generic_field**](docs/CustomValuesApi.md#custom_values_set_generic_field) | **PUT** /api/v3/customvalues/genericfield/{genericDeviceId}/{fieldName} | Set value of custom field for specified Generic
*CustomValuesApi* | [**custom_values_set_generic_field_0**](docs/CustomValuesApi.md#custom_values_set_generic_field_0) | **PUT** /api/v3/customvalues/genericfield/{genericDeviceId}/{fieldName}/{value} | Set value of custom field for specified Generic
*CustomValuesApi* | [**custom_values_set_http_field**](docs/CustomValuesApi.md#custom_values_set_http_field) | **PUT** /api/v3/customvalues/httpfield/{httpDeviceId}/{fieldName} | Set value of custom field for specified HTTP
*CustomValuesApi* | [**custom_values_set_http_field_0**](docs/CustomValuesApi.md#custom_values_set_http_field_0) | **PUT** /api/v3/customvalues/httpfield/{httpDeviceId}/{fieldName}/{value} | Set value of custom field for specified HTTP
*CustomValuesApi* | [**custom_values_set_sla_field**](docs/CustomValuesApi.md#custom_values_set_sla_field) | **PUT** /api/v3/customvalues/slafield/{slaId}/{fieldName} | Set value of custom field for specified SLA
*CustomValuesApi* | [**custom_values_set_sla_field_0**](docs/CustomValuesApi.md#custom_values_set_sla_field_0) | **PUT** /api/v3/customvalues/slafield/{slaId}/{fieldName}/{value} | Set value of custom field for specified SLA
*CustomValuesApi* | [**custom_values_set_snmp_field**](docs/CustomValuesApi.md#custom_values_set_snmp_field) | **PUT** /api/v3/customvalues/snmpfield/{snmpDeviceId}/{fieldName} | Set value of custom field for specified SNMP
*CustomValuesApi* | [**custom_values_set_snmp_field_0**](docs/CustomValuesApi.md#custom_values_set_snmp_field_0) | **PUT** /api/v3/customvalues/snmpfield/{snmpDeviceId}/{fieldName}/{value} | Set value of custom field for specified SNMP
*CustomValuesApi* | [**custom_values_set_tcp_field**](docs/CustomValuesApi.md#custom_values_set_tcp_field) | **PUT** /api/v3/customvalues/tcpfield/{tcpDeviceId}/{fieldName} | Set value of custom field for specified TCP
*CustomValuesApi* | [**custom_values_set_tcp_field_0**](docs/CustomValuesApi.md#custom_values_set_tcp_field_0) | **PUT** /api/v3/customvalues/tcpfield/{tcpDeviceId}/{fieldName}/{value} | Set value of custom field for specified TCP
*CustomValuesApi* | [**custom_values_set_ticket_field**](docs/CustomValuesApi.md#custom_values_set_ticket_field) | **PUT** /api/v3/customvalues/ticketfield/{ticketId}/{fieldName} | Set custom field value for specified Ticket
*CustomValuesApi* | [**custom_values_set_ticket_field_0**](docs/CustomValuesApi.md#custom_values_set_ticket_field_0) | **PUT** /api/v3/customvalues/ticketfield/{ticketId}/{fieldName}/{value} | Set custom field value for specified Ticket
*CustomerApi* | [**customer_delete**](docs/CustomerApi.md#customer_delete) | **DELETE** /api/v3/customers/{customerId} | Delete specified customer
*CustomerApi* | [**customer_get**](docs/CustomerApi.md#customer_get) | **GET** /api/v3/customers | Find Customers
*CustomerApi* | [**customer_get_0**](docs/CustomerApi.md#customer_get_0) | **GET** /api/v3/customers/{customerId} | Find specified customer
*CustomerApi* | [**customer_post**](docs/CustomerApi.md#customer_post) | **POST** /api/v3/customers | Create Customer
*CustomerApi* | [**customer_post_0**](docs/CustomerApi.md#customer_post_0) | **POST** /api/v3/customers/folders | Create Customer Folder
*CustomerApi* | [**customer_post_1**](docs/CustomerApi.md#customer_post_1) | **POST** /api/v3/customers/attachments | Create Customer Attachment
*CustomerApi* | [**customer_put**](docs/CustomerApi.md#customer_put) | **PUT** /api/v3/customers/{customerId} | Update specified customer
*CustomerApi* | [**customer_put_0**](docs/CustomerApi.md#customer_put_0) | **POST** /api/v3/customers/{customerId} | Update specified customer
*DeviceApi* | [**device_create_generic_device**](docs/DeviceApi.md#device_create_generic_device) | **POST** /api/v3/devices/genericdevice | Create Generic device
*DeviceApi* | [**device_create_http_device**](docs/DeviceApi.md#device_create_http_device) | **POST** /api/v3/devices/httpdevice | Create HTTP device
*DeviceApi* | [**device_create_snmp_device_v1_v2**](docs/DeviceApi.md#device_create_snmp_device_v1_v2) | **POST** /api/v3/devices/snmpdevice/v1v2 | Create SNMP device V1/V2
*DeviceApi* | [**device_create_snmp_device_v3**](docs/DeviceApi.md#device_create_snmp_device_v3) | **POST** /api/v3/devices/snmpdevice/v3 | Create SNMP device V3
*DeviceApi* | [**device_create_tcp_device**](docs/DeviceApi.md#device_create_tcp_device) | **POST** /api/v3/devices/tcpdevice | Create TCP device
*DeviceApi* | [**device_delete**](docs/DeviceApi.md#device_delete) | **DELETE** /api/v3/devices/genericdevice/{deviceId} | Delete specified Generic device
*DeviceApi* | [**device_delete_http**](docs/DeviceApi.md#device_delete_http) | **DELETE** /api/v3/devices/httpdevice/{deviceId} | Delete specified HTTP device
*DeviceApi* | [**device_delete_snmp**](docs/DeviceApi.md#device_delete_snmp) | **DELETE** /api/v3/devices/snmpdevice/{deviceId} | Delete specified SNMP device
*DeviceApi* | [**device_delete_tcp**](docs/DeviceApi.md#device_delete_tcp) | **DELETE** /api/v3/devices/tcpdevice/{deviceId} | Delete specified TCP device
*DeviceApi* | [**device_get_generic_device**](docs/DeviceApi.md#device_get_generic_device) | **GET** /api/v3/devices/genericdevice/{deviceId} | Find specified Generic device
*DeviceApi* | [**device_get_generic_devices**](docs/DeviceApi.md#device_get_generic_devices) | **GET** /api/v3/devices/genericdevices | Find Generic devices
*DeviceApi* | [**device_get_http_device**](docs/DeviceApi.md#device_get_http_device) | **GET** /api/v3/devices/httpdevice/{deviceId} | Find specified HTTP device
*DeviceApi* | [**device_get_http_devices**](docs/DeviceApi.md#device_get_http_devices) | **GET** /api/v3/devices/httpdevices | Find HTTP devices
*DeviceApi* | [**device_get_snmp_device**](docs/DeviceApi.md#device_get_snmp_device) | **GET** /api/v3/devices/snmpdevice/{deviceId} | Find specified SNMP device
*DeviceApi* | [**device_get_snmp_devices**](docs/DeviceApi.md#device_get_snmp_devices) | **GET** /api/v3/devices/snmpdevices | Find SNMP devices
*DeviceApi* | [**device_get_tcp_device**](docs/DeviceApi.md#device_get_tcp_device) | **GET** /api/v3/devices/tcpdevice/{deviceId} | Find specified TCP device
*DeviceApi* | [**device_get_tcp_devices**](docs/DeviceApi.md#device_get_tcp_devices) | **GET** /api/v3/devices/tcpdevices | Find TCP devices
*KnowledgeBaseApi* | [**knowledge_base_get**](docs/KnowledgeBaseApi.md#knowledge_base_get) | **GET** /api/v3/knowledgebases | Find articles
*RatesApi* | [**rates_delete_expense**](docs/RatesApi.md#rates_delete_expense) | **DELETE** /api/v3/rates/expenses/{expenseId} | Delete specified expense
*RatesApi* | [**rates_delete_product**](docs/RatesApi.md#rates_delete_product) | **DELETE** /api/v3/rates/products/{productId} | Delete specified product
*RatesApi* | [**rates_expense_query_dto**](docs/RatesApi.md#rates_expense_query_dto) | **GET** /api/v3/rates/expenses/{expenseId} | Find specified expense
*RatesApi* | [**rates_get_expenses**](docs/RatesApi.md#rates_get_expenses) | **GET** /api/v3/rates/expenses | Find expenses
*RatesApi* | [**rates_get_products**](docs/RatesApi.md#rates_get_products) | **GET** /api/v3/rates/products | Find products
*RatesApi* | [**rates_post_expense**](docs/RatesApi.md#rates_post_expense) | **POST** /api/v3/rates/expenses | Create expense
*RatesApi* | [**rates_post_product**](docs/RatesApi.md#rates_post_product) | **POST** /api/v3/rates/products | Create product
*RatesApi* | [**rates_product_query_dto**](docs/RatesApi.md#rates_product_query_dto) | **GET** /api/v3/rates/products/{productId} | Find specified product
*RatesApi* | [**rates_put_expense**](docs/RatesApi.md#rates_put_expense) | **PUT** /api/v3/rates/expenses/{expenseId} | Update specified expense
*RatesApi* | [**rates_put_product**](docs/RatesApi.md#rates_put_product) | **PUT** /api/v3/rates/products/{productId} | Update specified product
*TicketApi* | [**ticket_delete**](docs/TicketApi.md#ticket_delete) | **DELETE** /api/v3/tickets/{ticketId} | Delete specified ticket
*TicketApi* | [**ticket_get**](docs/TicketApi.md#ticket_get) | **GET** /api/v3/tickets | Find tickets
*TicketApi* | [**ticket_get_0**](docs/TicketApi.md#ticket_get_0) | **GET** /api/v3/tickets/{ticketId} | Find specified ticket
*TicketApi* | [**ticket_get_billable_duration**](docs/TicketApi.md#ticket_get_billable_duration) | **GET** /api/v3/tickets/{ticketId}/billableduration | Find specified ticket (billable duration)
*TicketApi* | [**ticket_get_comments**](docs/TicketApi.md#ticket_get_comments) | **GET** /api/v3/tickets/{ticketId}/comments | Find ticket comments list
*TicketApi* | [**ticket_get_non_billable_duration**](docs/TicketApi.md#ticket_get_non_billable_duration) | **GET** /api/v3/tickets/{ticketId}/nonbillableduration | Find specified ticket (non-billable duration)
*TicketApi* | [**ticket_get_workhours**](docs/TicketApi.md#ticket_get_workhours) | **GET** /api/v3/tickets/{ticketId}/workhours | Find specified ticket (workhours duration)
*TicketApi* | [**ticket_get_workhours_records**](docs/TicketApi.md#ticket_get_workhours_records) | **GET** /api/v3/tickets/{ticketId}/workhoursrecords | Find tickets (workhour list)
*TicketApi* | [**ticket_post**](docs/TicketApi.md#ticket_post) | **POST** /api/v3/tickets | Create ticket
*TicketApi* | [**ticket_put**](docs/TicketApi.md#ticket_put) | **PUT** /api/v3/tickets/{ticketId} | Update specified ticket
*TicketApi* | [**ticket_put_0**](docs/TicketApi.md#ticket_put_0) | **POST** /api/v3/tickets/{ticketId} | Update specified ticket
*TicketApi* | [**ticket_track_status_modified**](docs/TicketApi.md#ticket_track_status_modified) | **GET** /api/v3/tickets/statusmodified | Find resolved and closed tickets


## Documentation For Models

 - [APIResultWrapperAgentQueryDTO](docs/APIResultWrapperAgentQueryDTO.md)
 - [APIResultWrapperAlertQueryDTO](docs/APIResultWrapperAlertQueryDTO.md)
 - [APIResultWrapperContactQueryDTO](docs/APIResultWrapperContactQueryDTO.md)
 - [APIResultWrapperContractQueryDTO](docs/APIResultWrapperContractQueryDTO.md)
 - [APIResultWrapperCustomerQueryDTO](docs/APIResultWrapperCustomerQueryDTO.md)
 - [APIResultWrapperGenericDeviceQueryDTO](docs/APIResultWrapperGenericDeviceQueryDTO.md)
 - [APIResultWrapperHttpDeviceQueryDTO](docs/APIResultWrapperHttpDeviceQueryDTO.md)
 - [APIResultWrapperInvoiceQueryDTO](docs/APIResultWrapperInvoiceQueryDTO.md)
 - [APIResultWrapperKnowledgeBaseQueryDTO](docs/APIResultWrapperKnowledgeBaseQueryDTO.md)
 - [APIResultWrapperRateQueryDTO](docs/APIResultWrapperRateQueryDTO.md)
 - [APIResultWrapperSNMPDeviceQueryDTO](docs/APIResultWrapperSNMPDeviceQueryDTO.md)
 - [APIResultWrapperTcpDeviceQueryDTO](docs/APIResultWrapperTcpDeviceQueryDTO.md)
 - [APIResultWrapperTicketCommentQueryDTO](docs/APIResultWrapperTicketCommentQueryDTO.md)
 - [APIResultWrapperTicketQueryDTO](docs/APIResultWrapperTicketQueryDTO.md)
 - [APIResultWrapperTicketTimeEntriesQueryDTO](docs/APIResultWrapperTicketTimeEntriesQueryDTO.md)
 - [AgentQueryDTO](docs/AgentQueryDTO.md)
 - [AlertQueryDTO](docs/AlertQueryDTO.md)
 - [BlockHoursContractQueryDTO](docs/BlockHoursContractQueryDTO.md)
 - [BlockMoneyContractQueryDTO](docs/BlockMoneyContractQueryDTO.md)
 - [ContactDetails](docs/ContactDetails.md)
 - [ContactQueryDTO](docs/ContactQueryDTO.md)
 - [ContactsSearchOptions](docs/ContactsSearchOptions.md)
 - [ContractQueryDTO](docs/ContractQueryDTO.md)
 - [CreateAlertDTO](docs/CreateAlertDTO.md)
 - [CreateContactDTO](docs/CreateContactDTO.md)
 - [CreateCustomerAttachmentDTO](docs/CreateCustomerAttachmentDTO.md)
 - [CreateCustomerDTO](docs/CreateCustomerDTO.md)
 - [CreateCustomerFolderDTO](docs/CreateCustomerFolderDTO.md)
 - [CreateGenericDTO](docs/CreateGenericDTO.md)
 - [CreateHttpDTO](docs/CreateHttpDTO.md)
 - [CreateProductExpenseRateDTO](docs/CreateProductExpenseRateDTO.md)
 - [CreateSNMPDTOV1V2](docs/CreateSNMPDTOV1V2.md)
 - [CreateSNMPDTOV3](docs/CreateSNMPDTOV3.md)
 - [CreateTCPDTO](docs/CreateTCPDTO.md)
 - [CreateTicketDTO](docs/CreateTicketDTO.md)
 - [CreatedDeviceRes](docs/CreatedDeviceRes.md)
 - [CustomFieldQueryDTO](docs/CustomFieldQueryDTO.md)
 - [CustomValueQueryDTO](docs/CustomValueQueryDTO.md)
 - [CustomerQueryDTO](docs/CustomerQueryDTO.md)
 - [GenericDeviceQueryDTO](docs/GenericDeviceQueryDTO.md)
 - [HourlyContractQueryDTO](docs/HourlyContractQueryDTO.md)
 - [HttpDeviceQueryDTO](docs/HttpDeviceQueryDTO.md)
 - [InvoiceLineItemQueryDTO](docs/InvoiceLineItemQueryDTO.md)
 - [InvoiceQueryDTO](docs/InvoiceQueryDTO.md)
 - [KnowledgeBaseQueryDTO](docs/KnowledgeBaseQueryDTO.md)
 - [Object](docs/Object.md)
 - [OnlineBackupContractQueryDTO](docs/OnlineBackupContractQueryDTO.md)
 - [OptionFieldValues](docs/OptionFieldValues.md)
 - [Port](docs/Port.md)
 - [PortQueryDTO](docs/PortQueryDTO.md)
 - [ProjectHourlyRateContractQueryDTO](docs/ProjectHourlyRateContractQueryDTO.md)
 - [ProjectOneTimeFeeContractQueryDTO](docs/ProjectOneTimeFeeContractQueryDTO.md)
 - [RateQueryDTO](docs/RateQueryDTO.md)
 - [RemoteMonitoringContractQueryDTO](docs/RemoteMonitoringContractQueryDTO.md)
 - [Result](docs/Result.md)
 - [RetainerFlatFeeContractQueryDTO](docs/RetainerFlatFeeContractQueryDTO.md)
 - [SNMPDeviceQueryDTO](docs/SNMPDeviceQueryDTO.md)
 - [SetCustomValueDTO](docs/SetCustomValueDTO.md)
 - [TcpDeviceQueryDTO](docs/TcpDeviceQueryDTO.md)
 - [TicketCommentQueryDTO](docs/TicketCommentQueryDTO.md)
 - [TicketDurationQueryDTO](docs/TicketDurationQueryDTO.md)
 - [TicketQueryDTO](docs/TicketQueryDTO.md)
 - [TicketTimeEntriesQueryDTO](docs/TicketTimeEntriesQueryDTO.md)
 - [TicketTimeEntriesSummaryQueryDTO](docs/TicketTimeEntriesSummaryQueryDTO.md)
 - [UpdateContactDTO](docs/UpdateContactDTO.md)
 - [UpdateCustomerDTO](docs/UpdateCustomerDTO.md)
 - [UpdateProductExpenseRateDTO](docs/UpdateProductExpenseRateDTO.md)
 - [UpdateTicketDTO](docs/UpdateTicketDTO.md)


## Documentation For Authorization


## api-key API

- **Type**: API key
- **API key parameter name**: X-API-KEY
- **Location**: HTTP header


## Author



