# -*- coding:utf-8 -*-
#
# Copyright (c) nexB Inc. and others. All rights reserved.
# ScanCode is a trademark of nexB Inc.
# SPDX-License-Identifier:Apache-2.0
# See http://www.apache.org/licenses/LICENSE-2.0 for the license text.
# See https://github.com/nexB/scancode-toolkit for support or download.
# See https://aboutcode.org for more information about nexB OSS projects.
#
# This is a list of words that are specific to licenses. This list is used to
# classify words as legalese or as less interesting non-legalese aka. junk words
# add a new value and run to regenerate a sorted file.

common_license_words = {
'3orgplv2':0,
'4suite':1,
'abandon':2,
'abandoned':3,
'abandons':4,
'abbreviated':5,
'abbreviations':6,
'abide':7,
'abiding':8,
'ability':9,
'abridgement':10,
'abridgment':11,
'abridgments':12,
'abrogate':13,
'abstraction':14,
'abused':15,
'abusive':16,
'acccuracy':17,
'accelerates':18,
'acceptable':19,
'acceptance':20,
'acceptation':21,
'accepte':22,
'accepted':23,
'accepting':24,
'accepts':25,
'accesses':26,
'accessing':27,
'accessories':28,
'accessory':29,
'accident':30,
'accidental':31,
'accidents':32,
'accommodate':33,
'accommodation':34,
'accompanied':35,
'accompanies':36,
'accompany':37,
'accompanying':38,
'accomplishes':39,
'accomplishing':40,
'accordance':41,
'according':42,
'accordingly':43,
'accords':44,
'accountability':45,
'accounted':46,
'accounting':47,
'accrue':48,
'accrued':49,
'accruing':50,
'accuracy':51,
'accurately':52,
'accusations':53,
'accused':54,
'accusing':55,
'achieves':56,
'acknowldgement':57,
'acknowledegement':58,
'acknowledge':59,
'acknowledged':60,
'acknowledgement':61,
'acknowledgements':62,
'acknowledges':63,
'acknowledging':64,
'acknowledgment':65,
'acknowledgments':66,
'acknowlegdement':67,
'acknowlegement':68,
'acknowlegements':69,
'acompanies':70,
'acquiescence':71,
'acquire':72,
'acquired':73,
'acquires':74,
'acquiring':75,
'acquisition':76,
'acquisitions':77,
'acronyms':78,
'act':79,
'acting':80,
'actional':81,
'activates':82,
'activating':83,
'activations':84,
'activities':85,
'acts':86,
'adaptation':87,
'adaptations':88,
'adapted':89,
'adapters':90,
'adapting':91,
'adaption':92,
'adaptions':93,
'adaptive':94,
'adapts':95,
'addendum':96,
'addendums':97,
'adding':98,
'addional':99,
'additionally':100,
'additions':101,
'addressable':102,
'addressee':103,
'adequacy':104,
'adhere':105,
'adhered':106,
'adherence':107,
'adheres':108,
'adhering':109,
'adhesion':110,
'adjudicate':111,
'adjudication':112,
'adjusting':113,
'adjusts':114,
'administer':115,
'administers':116,
'admission':117,
'admitted':118,
'adopted':119,
'adopters':120,
'adopting':121,
'adress':122,
'advancing':123,
'adversary':124,
'adverse':125,
'adversely':126,
'advertise':127,
'advertised':128,
'advertisement':129,
'advertisements':130,
'advertisers':131,
'advertises':132,
'advertising':133,
'adverts':134,
'advice':135,
'advise':136,
'advised':137,
'advises':138,
'advising':139,
'afero':140,
'affected':141,
'affecting':142,
'affects':143,
'affero':144,
'affichage':145,
'affiliate':146,
'affiliated':147,
'affiliates':148,
'affiliation':149,
'affirm':150,
'affirmative':151,
'affirmatively':152,
'affirmed':153,
'affirming':154,
'affirms':155,
'affix':156,
'affixed':157,
'affixes':158,
'afforded':159,
'affording':160,
'afl21':161,
'aforementioned':162,
'aforesaid':163,
'afpl':164,
'agencies':165,
'agency':166,
'aggregate':167,
'aggregated':168,
'aggregates':169,
'aggregating':170,
'aggregation':171,
'agpl':172,
'agpl1':173,
'agpl1+':174,
'agpl2':175,
'agpl2+':176,
'agpl20':177,
'agpl20+':178,
'agpl3':179,
'agpl3+':180,
'agpl30':181,
'agpl30+':182,
'agpld':183,
'agpled':184,
'agpllicense':185,
'agplv1':186,
'agplv1+':187,
'agplv10':188,
'agplv10+':189,
'agplv2':190,
'agplv2+':191,
'agplv20':192,
'agplv20+':193,
'agplv3':194,
'agplv3+':195,
'agplv30':196,
'agplv30+':197,
'agree':198,
'agreeable':199,
'agreed':200,
'agreeing':201,
'agreement':202,
'agreements':203,
'agrees':204,
'aiding':205,
'akin':206,
'al2':207,
'albeit':208,
'aligned':209,
'allegation':210,
'allege':211,
'alleged':212,
'allegedly':213,
'alleges':214,
'alleging':215,
'alleviate':216,
'alliance':217,
'allocated':218,
'allowable':219,
'allowance':220,
'allowing':221,
'allrights':222,
'alongside':223,
'alter':224,
'alteration':225,
'alterations':226,
'altered':227,
'altering':228,
'alternate':229,
'alternately':230,
'alternatively':231,
'alters':232,
'altogether':233,
'ambiguities':234,
'ambiguous':235,
'amenability':236,
'amend':237,
'amended':238,
'amendements':239,
'amendment':240,
'amendments':241,
'amends':242,
'amicable':243,
'amicably':244,
'amongst':245,
'amounts':246,
'ample':247,
'analogous':248,
'analysis':249,
'analyzes':250,
'ancillary':251,
'annexes':252,
'annotating':253,
'annotations':254,
'announce':255,
'announced':256,
'announcement':257,
'announcements':258,
'announces':259,
'announcing':260,
'annum':261,
'anonymized':262,
'anonymously':263,
'antecedent':264,
'anthologies':265,
'anthology':266,
'anticipate':267,
'anticipates':268,
'anticipatory':269,
'antidiscrimination':270,
'antithetical':271,
'antitrust':272,
'anybody':273,
'anyone':274,
'anytime':275,
'anywhere':276,
'apache2':277,
'apache20':278,
'apacheorg':279,
'apachev2':280,
'apapche':281,
'apcahe':282,
'apcs02':283,
'apgl':284,
'apglv3':285,
'apl':286,
'apl1':287,
'apl2':288,
'aplv2':289,
'apologies':290,
'apparatus':291,
'appeal':292,
'appealable':293,
'appeals':294,
'appearance':295,
'appeared':296,
'appearing':297,
'appelant':298,
'appendices':299,
'appending':300,
'appendix':301,
'appliances':302,
'applicability':303,
'applicable':304,
'applicables':305,
'applied':306,
'applying':307,
'appoint':308,
'appointed':309,
'appoints':310,
'appreciative':311,
'apprised':312,
'appropriate':313,
'appropriateness':314,
'appropriation':315,
'approval':316,
'approvals':317,
'approved':318,
'approving':319,
'approximates':320,
'apsl':321,
'arbitral':322,
'arbitrated':323,
'arbitration':324,
'arbitrator':325,
'arbitrators':326,
'architectures':327,
'archival':328,
'archiving':329,
'arguable':330,
'arise':331,
'arises':332,
'arising':333,
'arithmetic':334,
'arose':335,
'arrange':336,
'arranged':337,
'arrangement':338,
'arrangements':339,
'arranging':340,
'arrears':341,
'artifact':342,
'artifacts':343,
'artistic':344,
'artistic2':345,
'artisticv2':346,
'ascertain':347,
'ascertainable':348,
'ascribable':349,
'ascribed':350,
'asl2':351,
'assemble':352,
'assemblers':353,
'assemblies':354,
'assembling':355,
'assent':356,
'assented':357,
'assenting':358,
'assents':359,
'asserted':360,
'asserting':361,
'assertion':362,
'assertions':363,
'asserts':364,
'assessment':365,
'assessments':366,
'assign':367,
'assignability':368,
'assignable':369,
'assigned':370,
'assignee':371,
'assignees':372,
'assigning':373,
'assignment':374,
'assignments':375,
'assigns':376,
'assimilated':377,
'assist':378,
'assisted':379,
'assisting':380,
'associating':381,
'assume':382,
'assumed':383,
'assumes':384,
'assuming':385,
'assumption':386,
'assumptions':387,
'assurance':388,
'assurances':389,
'assure':390,
'assures':391,
'attaching':392,
'attachments':393,
'attn':394,
'attorney':395,
'attorneys':396,
'attributable':397,
'attributed':398,
'attributing':399,
'attribution':400,
'attributions':401,
'audit':402,
'audited':403,
'auditing':404,
'auditor':405,
'auditors':406,
'audits':407,
'augment':408,
'authentic':409,
'authenticated':410,
'authentication':411,
'authenticity':412,
'author':413,
'authored':414,
'authoring':415,
'authorise':416,
'authorised':417,
'authorises':418,
'authoritative':419,
'authorities':420,
'authority':421,
'authorization':422,
'authorizations':423,
'authorize':424,
'authorized':425,
'authorizes':426,
'authorizing':427,
'authors':428,
'authorship':429,
'authorware':430,
'automate':431,
'automatically':432,
'auxilliary':433,
'availability':434,
'avoidance':435,
'avoids':436,
'awaited':437,
'awarded':438,
'aware':439,
'awhile':440,
'backdoors':441,
'backends':442,
'backups':443,
'bankrupt':444,
'bargain':445,
'barr':446,
'barred':447,
'barring':448,
'bartering':449,
'basis':450,
'bearer':451,
'beerware':452,
'beforehand':453,
'behance':454,
'behaves':455,
'behaving':456,
'behest':457,
'belonging':458,
'benchmark':459,
'benchmarking':460,
'benchmarks':461,
'beneficiaries':462,
'beneficiary':463,
'benefited':464,
'benefiting':465,
'benefits':466,
'benefitted':467,
'berkeley':468,
'berkeleydb':469,
'beware':470,
'bigotry':471,
'bilingually':472,
'bill':473,
'billable':474,
'billboard':475,
'billing':476,
'binaries':477,
'binary':478,
'binders':479,
'binds':480,
'blamed':481,
'blessing':482,
'blessings':483,
'blockages':484,
'blurb':485,
'blurred':486,
'blurs':487,
'bodily':488,
'boilerplate':489,
'borrow':490,
'borrowed':491,
'bounces':492,
'bounds':493,
'bracketed':494,
'brag':495,
'brand':496,
'branded':497,
'branding':498,
'brands':499,
'breached':500,
'breaches':501,
'breaching':502,
'bribery':503,
'broadcastings':504,
'broadcasts':505,
'broadened':506,
'broadest':507,
'broadly':508,
'bsd2':509,
'bsd3':510,
'bsdcopyrightbegin':511,
'bsdcopyrightend':512,
'bsdlicense':513,
'bsl1':514,
'bugfree':515,
'buildable':516,
'bulk':517,
'bulletted':518,
'bullies':519,
'bundled':520,
'bundles':521,
'bundling':522,
'burdening':523,
'burdensome':524,
'businesses':525,
'businessmen':526,
'butors':527,
'buy':528,
'buyer':529,
'buyers':530,
'buying':531,
'buyout':532,
'byproduct':533,
'bytecode':534,
'caching':535,
'campaigned':536,
'canceled':537,
'cancellable':538,
'cancellation':539,
'cancelled':540,
'cancelling':541,
'cancels':542,
'cannot':543,
'canonical':544,
'canonicalize':545,
'capabilities':546,
'capability':547,
'capacity':548,
'capitalised':549,
'capitalizations':550,
'capitalized':551,
'captions':552,
'captivate':553,
'captures':554,
'cardholder':555,
'carefully':556,
'cascade':557,
'cashed':558,
'catalog':559,
'catastrophes':560,
'catastrophic':561,
'categorized':562,
'caused':563,
'causes':564,
'cautioned':565,
'caveat':566,
'caveats':567,
'cc0':568,
'cddl':569,
'cddl+gpl':570,
'cddl1':571,
'cddllicense':572,
'cddlv1':573,
'cease':574,
'ceased':575,
'ceases':576,
'ceasing':577,
'cecill':578,
'cecill1':579,
'cern':580,
'certains':581,
'certainty':582,
'certificate':583,
'certificates':584,
'certification':585,
'certifications':586,
'certified':587,
'certifier':588,
'certifies':589,
'certify':590,
'certifying':591,
'cessation':592,
'cessible':593,
'cession':594,
'changed':595,
'changelog':596,
'changing':597,
'characteristics':598,
'characterization':599,
'characterize':600,
'characterized':601,
'charge':602,
'charged':603,
'charges':604,
'charging':605,
'chartered':606,
'charting':607,
'checker':608,
'cheerefully':609,
'cheerful':610,
'chipsets':611,
'choices':612,
'chooses':613,
'cinematographic':614,
'cinematography':615,
'cipher':616,
'ciphersuites':617,
'circuitry':618,
'circulate':619,
'circulated':620,
'circumstance':621,
'circumstances':622,
'circumvent':623,
'circumvented':624,
'circumventing':625,
'circumvention':626,
'circumventions':627,
'circumvents':628,
'citing':629,
'citizen':630,
'claim':631,
'claimant':632,
'claimed':633,
'claiming':634,
'claims':635,
'clarification':636,
'clarifications':637,
'clarified':638,
'clarifies':639,
'clarify':640,
'clarifying':641,
'clarity':642,
'clash':643,
'classifications':644,
'classifier':645,
'classify':646,
'clause':647,
'clauses':648,
'clearance':649,
'clearances':650,
'clearer':651,
'clients':652,
'closely':653,
'clustered':654,
'cobranding':655,
'codebase':656,
'codecs':657,
'codes':658,
'coextensive':659,
'coherence':660,
'coincidental':661,
'colamd':662,
'collapsed':663,
'collated':664,
'collateral':665,
'collected':666,
'collecting':667,
'collective':668,
'collectively':669,
'collects':670,
'combinations':671,
'combining':672,
'comercial':673,
'commence':674,
'commences':675,
'commencing':676,
'commensurate':677,
'commerce':678,
'commercial':679,
'commercialise':680,
'commerciality':681,
'commercialization':682,
'commercialize':683,
'commercially':684,
'commerical':685,
'commissions':686,
'committee':687,
'communes':688,
'communicated':689,
'communicates':690,
'communicating':691,
'communicator':692,
'communities':693,
'community':694,
'communitysource':695,
'commutative':696,
'companies':697,
'comparable':698,
'comparably':699,
'comparative':700,
'compat':701,
'compatibilite':702,
'compelled':703,
'compensate':704,
'compensated':705,
'compensation':706,
'compete':707,
'competence':708,
'competes':709,
'competing':710,
'competition':711,
'competitive':712,
'competitor':713,
'competitors':714,
'compilable':715,
'compilation':716,
'compilations':717,
'compilers':718,
'compiling':719,
'complain':720,
'complained':721,
'complaining':722,
'complaint':723,
'complaints':724,
'complementary':725,
'complements':726,
'complet':727,
'completely':728,
'completeness':729,
'completes':730,
'completey':731,
'completing':732,
'complexe':733,
'compliance':734,
'compliant':735,
'complicate':736,
'complications':737,
'complied':738,
'complier':739,
'complies':740,
'complile':741,
'comply':742,
'complye':743,
'complying':744,
'composants':745,
'compositions':746,
'comprehensiblity':747,
'compress':748,
'compressing':749,
'compris':750,
'comprise':751,
'comprised':752,
'comprises':753,
'comprising':754,
'compromised':755,
'compromises':756,
'compromising':757,
'compulsory':758,
'concedes':759,
'conceived':760,
'conceptually':761,
'concern':762,
'concerned':763,
'concerning':764,
'concerns':765,
'concertation':766,
'concession':767,
'conciliation':768,
'concisely':769,
'conclude':770,
'concluded':771,
'concludes':772,
'concordance':773,
'concurrence':774,
'concurrent':775,
'concurrently':776,
'concursive':777,
'condensation':778,
'conditional':779,
'conditionally':780,
'conditioned':781,
'conditioning':782,
'conducted':783,
'conducts':784,
'confer':785,
'conferred':786,
'conferring':787,
'confers':788,
'confidence':789,
'confidential':790,
'confidentiality':791,
'configuration':792,
'configured':793,
'configures':794,
'confined':795,
'confirmation':796,
'confirmed':797,
'confirming':798,
'confirms':799,
'conflating':800,
'conflict':801,
'conflicting':802,
'conflicts':803,
'conflit':804,
'conflits':805,
'confluent':806,
'conformance':807,
'conformant':808,
'conformation':809,
'conforming':810,
'conformit':811,
'conformity':812,
'conforms':813,
'confuse':814,
'confusingly':815,
'conjectures':816,
'conjunction':817,
'connected':818,
'connection':819,
'connections':820,
'consecutive':821,
'consensus':822,
'consent':823,
'consented':824,
'consenting':825,
'consents':826,
'consequences':827,
'consequental':828,
'consequential':829,
'consequently':830,
'conservation':831,
'conservatory':832,
'considerable':833,
'consideration':834,
'considerations':835,
'considering':836,
'consignment':837,
'consise':838,
'consist':839,
'consistency':840,
'consistent':841,
'consistently':842,
'consisting':843,
'consists':844,
'consor':845,
'conspicuous':846,
'conspicuously':847,
'constants':848,
'constitue':849,
'constituent':850,
'constitues':851,
'constitute':852,
'constitutes':853,
'constituting':854,
'constrained':855,
'constraints':856,
'construe':857,
'construed':858,
'construing':859,
'consult':860,
'consultant':861,
'consultants':862,
'consultation':863,
'consultations':864,
'consume':865,
'consumed':866,
'consumer':867,
'consumers':868,
'contactable':869,
'contacted':870,
'contacting':871,
'contacts':872,
'contemplated':873,
'contemplates':874,
'contemplating':875,
'contemplation':876,
'contemporaneous':877,
'contemporaneously':878,
'contend':879,
'contesting':880,
'contexts':881,
'contibutors':882,
'contient':883,
'contingent':884,
'continual':885,
'continuations':886,
'continued':887,
'continuing':888,
'continuous':889,
'continuously':890,
'contract':891,
'contractantes':892,
'contractdescription':893,
'contracted':894,
'contracting':895,
'contractor':896,
'contractors':897,
'contracts':898,
'contractual':899,
'contractually':900,
'contradict':901,
'contradicted':902,
'contradiction':903,
'contradicts':904,
'contrary':905,
'contrat':906,
'contravene':907,
'contravention':908,
'contre':909,
'contri':910,
'contrib':911,
'contribs':912,
'contribute':913,
'contributed':914,
'contributers':915,
'contributes':916,
'contributing':917,
'contribution':918,
'contributions':919,
'contributorily':920,
'contributory':921,
'controlled':922,
'controller':923,
'controlling':924,
'controls':925,
'controversies':926,
'convenience':927,
'conveniens':928,
'convenient':929,
'conveniently':930,
'convention':931,
'conventionally':932,
'conventions':933,
'convering':934,
'convey':935,
'conveyance':936,
'conveyed':937,
'conveying':938,
'conveys':939,
'cooperate':940,
'cooperates':941,
'cooperating':942,
'copied':943,
'copyfarleft':944,
'copyfree':945,
'copying':946,
'copying3':947,
'copyingv2':948,
'copyingv23':949,
'copyleft':950,
'copylefted':951,
'copylefts':952,
'copyrightable':953,
'copyrightbegin':954,
'copyrighted':955,
'copyrightend':956,
'copyrighting':957,
'copyrightnotice':958,
'copyrights':959,
'copyrightstart':960,
'cores':961,
'corpora':962,
'corporate':963,
'correcting':964,
'corrections':965,
'correctly':966,
'correctness':967,
'corrects':968,
'correlate':969,
'correlated':970,
'correlations':971,
'correspond':972,
'correspondence':973,
'correspondent':974,
'correspondingly':975,
'corresponds':976,
'corroborated':977,
'corrupt':978,
'corrupted':979,
'corrupting':980,
'cosl':981,
'cost':982,
'costs':983,
'council':984,
'countdown':985,
'counterclaim':986,
'counterclaims':987,
'counterpart':988,
'counterparts':989,
'counties':990,
'countries':991,
'county':992,
'courier':993,
'cours':994,
'court':995,
'courts':996,
'coutries':997,
'covenant':998,
'covenants':999,
'coverage':1000,
'covered':1001,
'covering':1002,
'covers':1003,
'coworkers':1004,
'coypright':1005,
'cpal':1006,
'cpl':1007,
'cpl1':1008,
'cplv1':1009,
'cpol':1010,
'cpol10':1011,
'crashed':1012,
'creating':1013,
'creativecommons':1014,
'creators':1015,
'credential':1016,
'credentials':1017,
'credit':1018,
'crediting':1019,
'creditors':1020,
'crests':1021,
'crime':1022,
'crimes':1023,
'cripple':1024,
'crippled':1025,
'crypto':1026,
'cryptographic':1027,
'cryptography':1028,
'cui':1029,
'culpa':1030,
'culpably':1031,
'curable':1032,
'cured':1033,
'cures':1034,
'curis':1035,
'curit':1036,
'currencies':1037,
'currency':1038,
'currently':1039,
'currentness':1040,
'cursors':1041,
'curt':1042,
'curtail':1043,
'customarily':1044,
'customization':1045,
'customizations':1046,
'customize':1047,
'customizing':1048,
'cutable':1049,
'daemonize':1050,
'daemons':1051,
'damage':1052,
'damages':1053,
'damaging':1054,
'databases':1055,
'datacenter':1056,
'datafiles':1057,
'datasets':1058,
'deactivate':1059,
'deactivation':1060,
'deadlines':1061,
'deal':1062,
'dealer':1063,
'dealers':1064,
'dealing':1065,
'dealings':1066,
'deals':1067,
'deattack':1068,
'debited':1069,
'debtor':1070,
'deceit':1071,
'deceptive':1072,
'decide':1073,
'decided':1074,
'decides':1075,
'deciding':1076,
'decipher':1077,
'decision':1078,
'decisions':1079,
'declaim':1080,
'declaration':1081,
'declarations':1082,
'declaratory':1083,
'declare':1084,
'declared':1085,
'declares':1086,
'declaring':1087,
'declatory':1088,
'decline':1089,
'declined':1090,
'declines':1091,
'declining':1092,
'decoded':1093,
'decoder':1094,
'decoders':1095,
'decodes':1096,
'decoding':1097,
'decommissioned':1098,
'decompilation':1099,
'decompile':1100,
'decompiled':1101,
'decompiling':1102,
'decompose':1103,
'decomposition':1104,
'decompress':1105,
'decompressed':1106,
'decompresses':1107,
'decompressible':1108,
'decompressing':1109,
'decompression':1110,
'decompressor':1111,
'decoupling':1112,
'decreases':1113,
'decree':1114,
'decrypt':1115,
'decrypting':1116,
'decryption':1117,
'dedicate':1118,
'dedicated':1119,
'dedicates':1120,
'dedicating':1121,
'dedication':1122,
'dedications':1123,
'dedicator':1124,
'dedicators':1125,
'deduct':1126,
'deducted':1127,
'deducting':1128,
'deduction':1129,
'deductions':1130,
'deem':1131,
'deemed':1132,
'deems':1133,
'deface':1134,
'defamation':1135,
'defamatory':1136,
'defames':1137,
'defaulting':1138,
'defeats':1139,
'defect':1140,
'defective':1141,
'defects':1142,
'defendant':1143,
'defending':1144,
'defends':1145,
'defenses':1146,
'defer':1147,
'deferred':1148,
'deffects':1149,
'deficiencies':1150,
'deficient':1151,
'definable':1152,
'defines':1153,
'defini':1154,
'defining':1155,
'definitive':1156,
'defraud':1157,
'degraded':1158,
'degrading':1159,
'degree':1160,
'dejacode':1161,
'delegate':1162,
'delegated':1163,
'deletes':1164,
'deleting':1165,
'deletions':1166,
'deliberate':1167,
'deliberately':1168,
'delineated':1169,
'delineates':1170,
'delinquent':1171,
'deliver':1172,
'deliverable':1173,
'deliverables':1174,
'delivered':1175,
'deliveries':1176,
'delivering':1177,
'delivery':1178,
'demand':1179,
'demarcate':1180,
'demonstrate':1181,
'demonstrated':1182,
'demonstrates':1183,
'demonstrating':1184,
'demonstration':1185,
'demonstrations':1186,
'denied':1187,
'denies':1188,
'denominated':1189,
'denominator':1190,
'denoted':1191,
'denying':1192,
'department':1193,
'dependant':1194,
'depict':1195,
'depicted':1196,
'depictions':1197,
'deployed':1198,
'deploying':1199,
'deployment':1200,
'deployments':1201,
'deploys':1202,
'deposited':1203,
'deprecates':1204,
'depreciated':1205,
'depreciation':1206,
'deprive':1207,
'deprives':1208,
'derivate':1209,
'derivates':1210,
'derivation':1211,
'derivations':1212,
'derivative':1213,
'derivatives':1214,
'derivativeworks':1215,
'deriving':1216,
'derogation':1217,
'derogatory':1218,
'dervived':1219,
'descended':1220,
'descramble':1221,
'describes':1222,
'describing':1223,
'descriptions':1224,
'descriptive':1225,
'designate':1226,
'designated':1227,
'designates':1228,
'designation':1229,
'designations':1230,
'designed':1231,
'designee':1232,
'designees':1233,
'designs':1234,
'desiring':1235,
'desist':1236,
'desktop':1237,
'despite':1238,
'destroying':1239,
'destroys':1240,
'destruction':1241,
'destructive':1242,
'detailed':1243,
'detailing':1244,
'deter':1245,
'determination':1246,
'determined':1247,
'determines':1248,
'determining':1249,
'detract':1250,
'detriment':1251,
'detrimental':1252,
'detrimentally':1253,
'developing':1254,
'deviate':1255,
'deviations':1256,
'devised':1257,
'devising':1258,
'devolve':1259,
'dfar':1260,
'dfars':1261,
'dfsg':1262,
'diacritics':1263,
'diagnose':1264,
'diagnostics':1265,
'dialect':1266,
'dictates':1267,
'didactic':1268,
'differentiate':1269,
'differently':1270,
'differs':1271,
'diffused':1272,
'digitally':1273,
'diligence':1274,
'diligent':1275,
'dilutes':1276,
'diminish':1277,
'diminished':1278,
'diplomatic':1279,
'directed':1280,
'directing':1281,
'directives':1282,
'directly':1283,
'directorates':1284,
'directories':1285,
'directs':1286,
'disabling':1287,
'disadvantages':1288,
'disagree':1289,
'disagreement':1290,
'disagreements':1291,
'disallow':1292,
'disallowed':1293,
'disappearing':1294,
'disassemble':1295,
'disassembled':1296,
'disassembling':1297,
'disassembly':1298,
'disbursements':1299,
'discharge':1300,
'disclaim':1301,
'disclaimed':1302,
'disclaimer':1303,
'disclaimers':1304,
'disclaiming':1305,
'disclaims':1306,
'disclose':1307,
'disclosed':1308,
'discloser':1309,
'discloses':1310,
'disclosing':1311,
'disclosure':1312,
'disclosures':1313,
'disconnect':1314,
'disconnected':1315,
'disconnecting':1316,
'discontinuance':1317,
'discontinuation':1318,
'discontinue':1319,
'discontinued':1320,
'discontinues':1321,
'discontinuing':1322,
'discourage':1323,
'discouraged':1324,
'discourages':1325,
'discoverable':1326,
'discoveries':1327,
'discovering':1328,
'discovers':1329,
'discrepancy':1330,
'discretion':1331,
'discriminating':1332,
'discrimination':1333,
'discriminatory':1334,
'discuss':1335,
'discussed':1336,
'discusses':1337,
'discussing':1338,
'disjunctively':1339,
'diskette':1340,
'dismissal':1341,
'disoriented':1342,
'disparaging':1343,
'disparate':1344,
'disperse':1345,
'displayed':1346,
'displays':1347,
'dispose':1348,
'disposing':1349,
'disposition':1350,
'dispositions':1351,
'dispute':1352,
'disputes':1353,
'disregard':1354,
'disregarded':1355,
'disregarding':1356,
'disrupt':1357,
'disruption':1358,
'disruptions':1359,
'disrupts':1360,
'dissatisfied':1361,
'disseminate':1362,
'disseminated':1363,
'dissimilar':1364,
'dissolution':1365,
'distillation':1366,
'distinct':1367,
'distinction':1368,
'distinctive':1369,
'distinctly':1370,
'distinguish':1371,
'distinguished':1372,
'distinguishes':1373,
'distinguishing':1374,
'distort':1375,
'distorted':1376,
'distrabuted':1377,
'distracted':1378,
'distracts':1379,
'distribuable':1380,
'distributable':1381,
'distribute':1382,
'distributed':1383,
'distributee':1384,
'distributees':1385,
'distributes':1386,
'distributing':1387,
'distribution':1388,
'distributions':1389,
'distributor':1390,
'distributors':1391,
'distrubuted':1392,
'disturbance':1393,
'disturbances':1394,
'divergence':1395,
'diverses':1396,
'diversion':1397,
'divert':1398,
'dividuals':1399,
'divisional':1400,
'divulge':1401,
'dmca':1402,
'doctrine':1403,
'doctrines':1404,
'documented':1405,
'documenting':1406,
'dommage':1407,
'dommages':1408,
'doomed':1409,
'dormant':1410,
'doubly':1411,
'doubt':1412,
'doubtful':1413,
'doubts':1414,
'downgraded':1415,
'downloadable':1416,
'downloader':1417,
'downloaders':1418,
'downloading':1419,
'downloads':1420,
'downstream':1421,
'downtime':1422,
'draft':1423,
'drafted':1424,
'drafter':1425,
'drafting':1426,
'drafts':1427,
'dramatisation':1428,
'dramatization':1429,
'drm':1430,
'dually':1431,
'duct':1432,
'dues':1433,
'dug':1434,
'duly':1435,
'dumping':1436,
'duplicated':1437,
'duplicating':1438,
'durability':1439,
'dynamically':1440,
'earthquakes':1441,
'economic':1442,
'ecosgplcopyrightbegin':1443,
'ecosgplcopyrightend':1444,
'editable':1445,
'edited':1446,
'edition':1447,
'editions':1448,
'editorial':1449,
'effect':1450,
'effected':1451,
'effectively':1452,
'effectiveness':1453,
'effectuates':1454,
'effort':1455,
'efforts':1456,
'elaboration':1457,
'elaborations':1458,
'elapsed':1459,
'elect':1460,
'electric':1461,
'electrical':1462,
'electronic':1463,
'electronics':1464,
'elects':1465,
'eligibility':1466,
'eligible':1467,
'eliminating':1468,
'elsewhere':1469,
'embargo':1470,
'embargoed':1471,
'embargoes':1472,
'embarrassment':1473,
'embed':1474,
'embedded':1475,
'embedding':1476,
'embeds':1477,
'emblems':1478,
'embodied':1479,
'embodies':1480,
'embodiment':1481,
'embodiments':1482,
'emit':1483,
'emphasized':1484,
'employees':1485,
'employer':1486,
'employers':1487,
'employing':1488,
'employs':1489,
'empowered':1490,
'emulate':1491,
'emulator':1492,
'enablement':1493,
'enables':1494,
'enabling':1495,
'encapsulated':1496,
'enchancements':1497,
'enclose':1498,
'encoder':1499,
'encodings':1500,
'encompass':1501,
'encourage':1502,
'encouraged':1503,
'encourages':1504,
'encouraging':1505,
'encourge':1506,
'encrypt':1507,
'encrypted':1508,
'encumber':1509,
'encumbered':1510,
'encumbrance':1511,
'encumbrances':1512,
'endanger':1513,
'endangering':1514,
'enddispute':1515,
'endeavor':1516,
'endeavors':1517,
'endeavour':1518,
'endeavours':1519,
'ended':1520,
'endorse':1521,
'endorsed':1522,
'endorsement':1523,
'endorsements':1524,
'endorses':1525,
'enduser':1526,
'enforce':1527,
'enforceability':1528,
'enforceable':1529,
'enforced':1530,
'enforcement':1531,
'enforcements':1532,
'enforcing':1533,
'engagements':1534,
'engages':1535,
'engaging':1536,
'engelen':1537,
'engieered':1538,
'engineer':1539,
'engineered':1540,
'engineers':1541,
'engraving':1542,
'enhance':1543,
'enhancement':1544,
'enhancements':1545,
'enhancing':1546,
'enjoin':1547,
'enjoined':1548,
'enjoining':1549,
'enjoyment':1550,
'enjoys':1551,
'enlarged':1552,
'enquire':1553,
'enquiries':1554,
'enrichment':1555,
'enshrines':1556,
'ensure':1557,
'ensured':1558,
'ensures':1559,
'ensuring':1560,
'entail':1561,
'entanglement':1562,
'entered':1563,
'entertain':1564,
'ential':1565,
'entirety':1566,
'entitle':1567,
'entitled':1568,
'entitlement':1569,
'entitles':1570,
'enumerated':1571,
'epl':1572,
'equitable':1573,
'equivalence':1574,
'equivalently':1575,
'erase':1576,
'erased':1577,
'erasing':1578,
'errant':1579,
'errata':1580,
'erroneously':1581,
'esq':1582,
'essence':1583,
'essental':1584,
'essential':1585,
'essentiality':1586,
'essentially':1587,
'essentials':1588,
'establish':1589,
'established':1590,
'establishes':1591,
'establishment':1592,
'estate':1593,
'estoppel':1594,
'estoppels':1595,
'ethic':1596,
'ethical':1597,
'ethics':1598,
'eula':1599,
'eulas':1600,
'evaluated':1601,
'evaluating':1602,
'evaluations':1603,
'eventually':1604,
'everyone':1605,
'everywhere':1606,
'evidence':1607,
'evidenced':1608,
'evidences':1609,
'evidencing':1610,
'evident':1611,
'evil':1612,
'evolve':1613,
'exactitude':1614,
'exactly':1615,
'excecutable':1616,
'exceeded':1617,
'exceeding':1618,
'exceeds':1619,
'excepted':1620,
'excepting':1621,
'exceptionally':1622,
'excerpt':1623,
'excerpting':1624,
'excerpts':1625,
'exceutable':1626,
'exchangeability':1627,
'exchanged':1628,
'excise':1629,
'excludable':1630,
'excludes':1631,
'exclusion':1632,
'exclusions':1633,
'exclusive':1634,
'exclusively':1635,
'exclusivity':1636,
'exculsion':1637,
'excusable':1638,
'excused':1639,
'executable':1640,
'executables':1641,
'execute':1642,
'executed':1643,
'executes':1644,
'executing':1645,
'executives':1646,
'executors':1647,
'exemplar':1648,
'exemplary':1649,
'exemple':1650,
'exempt':1651,
'exempted':1652,
'exemption':1653,
'exemptions':1654,
'exempts':1655,
'exercice':1656,
'exercise':1657,
'exercised':1658,
'exercises':1659,
'exercising':1660,
'exerpt':1661,
'exertion':1662,
'exhausted':1663,
'exhaustion':1664,
'exhaustive':1665,
'exhaustively':1666,
'exhibit':1667,
'exhibit1':1668,
'exhibits':1669,
'existed':1670,
'existing':1671,
'expansions':1672,
'expectation':1673,
'expedited':1674,
'expend':1675,
'expense':1676,
'expenses':1677,
'expensive':1678,
'experimentation':1679,
'expiration':1680,
'expired':1681,
'expiring':1682,
'expiry':1683,
'explain':1684,
'explained':1685,
'explanation':1686,
'explanatory':1687,
'explcit':1688,
'explicite':1689,
'explicitely':1690,
'explicitly':1691,
'explictly':1692,
'explode':1693,
'exploitation':1694,
'exploited':1695,
'exploiter':1696,
'exploiting':1697,
'explosions':1698,
'exportation':1699,
'exportations':1700,
'exported':1701,
'exporter':1702,
'exporting':1703,
'exposes':1704,
'exposing':1705,
'exposition':1706,
'express':1707,
'expresse':1708,
'expressed':1709,
'expresses':1710,
'expressly':1711,
'expropriate':1712,
'extangular':1713,
'extant':1714,
'extended':1715,
'extending':1716,
'extensive':1717,
'extensively':1718,
'extent':1719,
'extenuating':1720,
'exterieure':1721,
'externally':1722,
'extracting':1723,
'extractor':1724,
'extractors':1725,
'extractres':1726,
'extranet':1727,
'extraordinarily':1728,
'extrinsic':1729,
'facilitate':1730,
'facilitated':1731,
'facilitates':1732,
'facilitating':1733,
'facilitator':1734,
'facsimile':1735,
'factual':1736,
'failing':1737,
'failure':1738,
'fairness':1739,
'faith':1740,
'falsely':1741,
'familiarize':1742,
'farther':1743,
'faults':1744,
'faulty':1745,
'favorable':1746,
'favoring':1747,
'favourable':1748,
'favoured':1749,
'faxed':1750,
'federally':1751,
'federation':1752,
'fee':1753,
'feebearing':1754,
'fees':1755,
'fetched':1756,
'fetcher':1757,
'fidelity':1758,
'fiduciary':1759,
'figurant':1760,
'figurative':1761,
'filed':1762,
'filepath':1763,
'filesharing':1764,
'filesystem':1765,
'finalize':1766,
'finalized':1767,
'finalizing':1768,
'financed':1769,
'finances':1770,
'financially':1771,
'finely':1772,
'fines':1773,
'firewalls':1774,
'firstly':1775,
'fit':1776,
'fitnes':1777,
'fitness':1778,
'fixation':1779,
'fixations':1780,
'flagged':1781,
'flawed':1782,
'flaws':1783,
'floods':1784,
'floss':1785,
'flowcharts':1786,
'fluctuation':1787,
'fluctuations':1788,
'fluent':1789,
'followed':1790,
'follows':1791,
'footnotes':1792,
'fora':1793,
'forbearance':1794,
'forbearances':1795,
'forbid':1796,
'forbidden':1797,
'forbidding':1798,
'forbids':1799,
'forceable':1800,
'forcing':1801,
'forego':1802,
'foregoing':1803,
'foreigner':1804,
'foreseeable':1805,
'foreseen':1806,
'forfeit':1807,
'forfeited':1808,
'forfeiture':1809,
'forgive':1810,
'forgiveness':1811,
'forgoing':1812,
'formal':1813,
'formation':1814,
'formatted':1815,
'formatters':1816,
'formed':1817,
'formulae':1818,
'forwards':1819,
'foss':1820,
'fosters':1821,
'foundation':1822,
'foundry':1823,
'fragmentation':1824,
'fragments':1825,
'frameworks':1826,
'franchisee':1827,
'franklin':1828,
'fraudulent':1829,
'freak':1830,
'freeb':1831,
'freely':1832,
'freemium':1833,
'freer':1834,
'frees':1835,
'freeware':1836,
'frequenting':1837,
'fruition':1838,
'frustrate':1839,
'fulfil':1840,
'fulfilled':1841,
'fulfilling':1842,
'fulfillment':1843,
'fulfilment':1844,
'fulfils':1845,
'fullest':1846,
'fullname':1847,
'functional':1848,
'functionalities':1849,
'functionally':1850,
'functioning':1851,
'fundamentally':1852,
'funded':1853,
'funds':1854,
'furlong':1855,
'furnish':1856,
'furnished':1857,
'furnishes':1858,
'furnishing':1859,
'furthermore':1860,
'garanties':1861,
'gather':1862,
'gathered':1863,
'gathering':1864,
'gaurantees':1865,
'genders':1866,
'general':1867,
'generality':1868,
'generics':1869,
'generis':1870,
'generosity':1871,
'geoapi':1872,
'geocentric':1873,
'geocode':1874,
'geocoded':1875,
'geocodes':1876,
'geocoding':1877,
'geodatabase':1878,
'geometric':1879,
'gfdl':1880,
'gfdl1':1881,
'gilt':1882,
'gladly':1883,
'globally':1884,
'glp':1885,
'glpv2':1886,
'glpv3':1887,
'glyphs':1888,
'gnu':1889,
'gnuchess':1890,
'gnulib':1891,
'gnumaniak':1892,
'gnuorg':1893,
'gnuplot':1894,
'gnutls':1895,
'gnuv2':1896,
'goods':1897,
'goodwill':1898,
'goverened':1899,
'govermental':1900,
'govern':1901,
'governance':1902,
'governed':1903,
'governement':1904,
'governing':1905,
'government':1906,
'governmental':1907,
'governments':1908,
'governs':1909,
'gpl':1910,
'gpl+':1911,
'gpl1':1912,
'gpl1+':1913,
'gpl10':1914,
'gpl10+':1915,
'gpl2':1916,
'gpl2+':1917,
'gpl20':1918,
'gpl20+':1919,
'gpl3':1920,
'gpl3+':1921,
'gpl30':1922,
'gpl30+':1923,
'gplcc':1924,
'gplcopyrightbegin':1925,
'gplcopyrightend':1926,
'gpld':1927,
'gpled':1928,
'gplexception':1929,
'gpllibs':1930,
'gpllicense':1931,
'gplog':1932,
'gpls':1933,
'gplv1':1934,
'gplv1+':1935,
'gplv10':1936,
'gplv10+':1937,
'gplv2':1938,
'gplv2+':1939,
'gplv2+ce':1940,
'gplv20':1941,
'gplv20+':1942,
'gplv2h':1943,
'gplv3':1944,
'gplv3+':1945,
'gplv30':1946,
'gplv30+':1947,
'gppl':1948,
'grained':1949,
'grammars':1950,
'grant':1951,
'granted':1952,
'granting':1953,
'grantor':1954,
'grants':1955,
'gratis':1956,
'gratitude':1957,
'grayed':1958,
'greatfully':1959,
'groundless':1960,
'groupe':1961,
'grouped':1962,
'guarantee':1963,
'guaranteed':1964,
'guaranteeing':1965,
'guarantees':1966,
'guarantuee':1967,
'guidance':1968,
'guidelines':1969,
'guiding':1970,
'guilt':1971,
'halt':1972,
'halves':1973,
'handled':1974,
'handset':1975,
'handsets':1976,
'handwritten':1977,
'harassing':1978,
'hardcoding':1979,
'hardcopy':1980,
'hardship':1981,
'harm':1982,
'harmful':1983,
'harming':1984,
'harmless':1985,
'hateful':1986,
'hatred':1987,
'headings':1988,
'headphone':1989,
'headquarters':1990,
'heap':1991,
'hearn':1992,
'heartened':1993,
'heir':1994,
'heirs':1995,
'henceforth':1996,
'herby':1997,
'hereby':1998,
'herefrom':1999,
'herein':2000,
'hereinabove':2001,
'hereinafter':2002,
'hereof':2003,
'hereto':2004,
'hereunder':2005,
'herewith':2006,
'hexagon':2007,
'hidden':2008,
'hierarchical':2009,
'hinder':2010,
'hindrance':2011,
'hippocratic':2012,
'historic':2013,
'historical':2014,
'hoarding':2015,
'hold':2016,
'holding':2017,
'holdings':2018,
'honoraires':2019,
'honoring':2020,
'hosted':2021,
'hostilities':2022,
'howevercaused':2023,
'howsoever':2024,
'howtos':2025,
'humanist':2026,
'humanly':2027,
'hurricanes':2028,
'hyperlinks':2029,
'hyperspace':2030,
'hypertext':2031,
'hypervisor':2032,
'idealogical':2033,
'ideals':2034,
'identifiable':2035,
'identification':2036,
'identifications':2037,
'identifier':2038,
'identifies':2039,
'identifying':2040,
'idents':2041,
'idiocy':2042,
'ignored':2043,
'ignoring':2044,
'ijg':2045,
'illegal':2046,
'illegality':2047,
'illustrates':2048,
'illustrator':2049,
'imagemagick':2050,
'imagined':2051,
'imbedded':2052,
'imitated':2053,
'imitations':2054,
'immaterial':2055,
'immediate':2056,
'immediately':2057,
'immoral':2058,
'immunities':2059,
'immunity':2060,
'impacting':2061,
'impair':2062,
'impairment':2063,
'impairs':2064,
'impartiality':2065,
'impede':2066,
'impeded':2067,
'impediment':2068,
'impelementing':2069,
'impersonate':2070,
'impersonates':2071,
'implants':2072,
'implement':2073,
'implementations':2074,
'implemented':2075,
'implementer':2076,
'implementers':2077,
'implementing':2078,
'implementors':2079,
'implements':2080,
'implicated':2081,
'implication':2082,
'implicit':2083,
'implicite':2084,
'implicites':2085,
'implicitly':2086,
'impliedly':2087,
'impliedwarranties':2088,
'implies':2089,
'implmentation':2090,
'imply':2091,
'implying':2092,
'implys':2093,
'importance':2094,
'importantes':2095,
'importation':2096,
'importing':2097,
'imposed':2098,
'imposes':2099,
'imposing':2100,
'impossible':2101,
'imposts':2102,
'improbable':2103,
'improper':2104,
'improperly':2105,
'improved':2106,
'improvement':2107,
'improvements':2108,
'improving':2109,
'inability':2110,
'inabilty':2111,
'inaccessible':2112,
'inaccuracies':2113,
'inaccuracy':2114,
'inaccurate':2115,
'inactions':2116,
'inactivity':2117,
'inadvertent':2118,
'inal':2119,
'inamidst':2120,
'inapplicability':2121,
'inapplicable':2122,
'inasmuch':2123,
'inbound':2124,
'incapable':2125,
'incidental':2126,
'inciting':2127,
'incompatibilities':2128,
'incompatibility':2129,
'incomplete':2130,
'incompleteness':2131,
'inconnection':2132,
'inconsequential':2133,
'inconsistencies':2134,
'inconsistency':2135,
'inconsistent':2136,
'inconvenient':2137,
'incorporant':2138,
'incorporate':2139,
'incorporated':2140,
'incorporates':2141,
'incorporating':2142,
'incorporation':2143,
'incorprated':2144,
'incorrect':2145,
'increases':2146,
'incur':2147,
'incurred':2148,
'incurring':2149,
'incurs':2150,
'indebted':2151,
'indecent':2152,
'indefinitely':2153,
'indemnification':2154,
'indemnifications':2155,
'indemnified':2156,
'indemnifies':2157,
'indemnify':2158,
'indemnifying':2159,
'indemnitee':2160,
'indemnitees':2161,
'indemnities':2162,
'indemnity':2163,
'indexing':2164,
'indications':2165,
'indicative':2166,
'indirectly':2167,
'indirects':2168,
'indispensable':2169,
'individual':2170,
'individualization':2171,
'individuals':2172,
'induce':2173,
'inducement':2174,
'induces':2175,
'inducing':2176,
'industrial':2177,
'industry':2178,
'ineffective':2179,
'ineffectiveness':2180,
'ineligibility':2181,
'ineligible':2182,
'inevitable':2183,
'inevitably':2184,
'inexcusable':2185,
'infeasible':2186,
'infer':2187,
'inference':2188,
'inferences':2189,
'inferred':2190,
'inflecting':2191,
'influencing':2192,
'infographics':2193,
'infogroup':2194,
'inform':2195,
'informally':2196,
'informational':2197,
'informations':2198,
'informed':2199,
'informing':2200,
'informs':2201,
'infrastructure':2202,
'infringe':2203,
'infringed':2204,
'infringement':2205,
'infringements':2206,
'infringer':2207,
'infringers':2208,
'infringes':2209,
'infringing':2210,
'infringment':2211,
'ingest':2212,
'inherently':2213,
'inherit':2214,
'inherits':2215,
'inhibit':2216,
'init':2217,
'initative':2218,
'initially':2219,
'initials':2220,
'initiate':2221,
'initiated':2222,
'initiates':2223,
'initiating':2224,
'initiation':2225,
'initiator':2226,
'initio':2227,
'injunction':2228,
'injunctive':2229,
'innovant':2230,
'innovate':2231,
'inoperability':2232,
'inoperable':2233,
'inoperative':2234,
'inoperativeness':2235,
'inordinate':2236,
'inplementation':2237,
'inquiries':2238,
'insecurity':2239,
'inserted':2240,
'inserts':2241,
'insignificant':2242,
'insist':2243,
'insofar':2244,
'insolvency':2245,
'insolvent':2246,
'insomuch':2247,
'inspire':2248,
'installable':2249,
'installation':2250,
'installations':2251,
'installed':2252,
'installers':2253,
'installs':2254,
'instantiate':2255,
'instantiated':2256,
'instigators':2257,
'institute':2258,
'instituted':2259,
'institutes':2260,
'institution':2261,
'institutions':2262,
'instruct':2263,
'instructed':2264,
'instructing':2265,
'instruction':2266,
'instructions':2267,
'instructs':2268,
'instrument':2269,
'instrumentalities':2270,
'instrumentality':2271,
'instruments':2272,
'insubstantial':2273,
'insults':2274,
'insurrections':2275,
'intact':2276,
'intangible':2277,
'intangibles':2278,
'integrated':2279,
'integrates':2280,
'integrator':2281,
'integrators':2282,
'integrees':2283,
'intellectual':2284,
'intellectually':2285,
'intelligence':2286,
'intend':2287,
'intended':2288,
'intending':2289,
'intends':2290,
'intention':2291,
'intentional':2292,
'intentionally':2293,
'intentions':2294,
'intently':2295,
'interact':2296,
'interacted':2297,
'interacting':2298,
'interactively':2299,
'interacts':2300,
'interception':2301,
'interchange':2302,
'interconnect':2303,
'interdependent':2304,
'interdicted':2305,
'interfacing':2306,
'interfere':2307,
'interfered':2308,
'interferes':2309,
'intergovernmental':2310,
'interlog':2311,
'intermediate':2312,
'intermittent':2313,
'internals':2314,
'internationalization':2315,
'interoperability':2316,
'interoperable':2317,
'interoperate':2318,
'interoperates':2319,
'interoperating':2320,
'interoperation':2321,
'interpret':2322,
'interpretation':2323,
'interpretations':2324,
'interpreted':2325,
'interpreter':2326,
'interpreterincompat':2327,
'interpreting':2328,
'interprets':2329,
'interrogatories':2330,
'interrupt':2331,
'interrupted':2332,
'interruption':2333,
'interruptions':2334,
'intially':2335,
'intimidating':2336,
'intranet':2337,
'intranets':2338,
'inure':2339,
'inures':2340,
'invades':2341,
'invalidated':2342,
'invalidity':2343,
'invariable':2344,
'invariant':2345,
'invariants':2346,
'invasive':2347,
'invented':2348,
'invention':2349,
'inventions':2350,
'inventor':2351,
'inventory':2352,
'inversion':2353,
'investigative':2354,
'invites':2355,
'invoice':2356,
'invoices':2357,
'invoking':2358,
'involuntarily':2359,
'involuntary':2360,
'involve':2361,
'involved':2362,
'involvement':2363,
'involves':2364,
'involving':2365,
'irrecoverable':2366,
'irreparable':2367,
'irrespective':2368,
'irreversible':2369,
'irrevocable':2370,
'irrevocably':2371,
'isorecorder':2372,
'isotope':2373,
'issuances':2374,
'issuer':2375,
'iterative':2376,
'jeopardize':2377,
'jeopardizes':2378,
'judge':2379,
'judged':2380,
'judgement':2381,
'judgements':2382,
'judgments':2383,
'judice':2384,
'judicial':2385,
'jure':2386,
'jurisdiction':2387,
'jurisdictions':2388,
'justice':2389,
'justified':2390,
'justify':2391,
'keeper':2392,
'kindly':2393,
'kindness':2394,
'kinds':2395,
'kiosk':2396,
'kiosks':2397,
'knobs':2398,
'knocks':2399,
'knowhow':2400,
'knowing':2401,
'knowingly':2402,
'knowledge':2403,
'labeling':2404,
'labelled':2405,
'labelling':2406,
'lagpl':2407,
'landline':2408,
'languages':2409,
'lapsed':2410,
'lapses':2411,
'larger':2412,
'lasts':2413,
'latest':2414,
'law':2415,
'lawful':2416,
'lawfully':2417,
'laws':2418,
'lawsuit':2419,
'lawsuits':2420,
'lawyer':2421,
'lawyers':2422,
'lax':2423,
'leach':2424,
'leaps':2425,
'learns':2426,
'leased':2427,
'ledger':2428,
'leds':2429,
'legal':2430,
'legalcode':2431,
'legalese':2432,
'legality':2433,
'legalnotice':2434,
'legible':2435,
'legibly':2436,
'legislation':2437,
'legislative':2438,
'legitimate':2439,
'legitimately':2440,
'lend':2441,
'lesser':2442,
'lesserv3':2443,
'lesset':2444,
'letterform':2445,
'letterforms':2446,
'letterman':2447,
'leverages':2448,
'levied':2449,
'levies':2450,
'lex':2451,
'lexicons':2452,
'lglp3':2453,
'lgpl':2454,
'lgpl2':2455,
'lgpl2+':2456,
'lgpl20':2457,
'lgpl20+':2458,
'lgpl21':2459,
'lgpl21+':2460,
'lgpl3':2461,
'lgpl3+':2462,
'lgpl30':2463,
'lgpl30+':2464,
'lgpld':2465,
'lgpled':2466,
'lgpllr':2467,
'lgplv2':2468,
'lgplv2+':2469,
'lgplv20':2470,
'lgplv20+':2471,
'lgplv21':2472,
'lgplv21+':2473,
'lgplv2h':2474,
'lgplv3':2475,
'lgplv3+':2476,
'lgplv30':2477,
'lgplv30+':2478,
'liabilities':2479,
'liability':2480,
'liabilty':2481,
'liable':2482,
'liablity':2483,
'licenc':2484,
'licencable':2485,
'licence':2486,
'licenced':2487,
'licencee':2488,
'licencees':2489,
'licences':2490,
'licencing':2491,
'licens':2492,
'licensable':2493,
'license':2494,
'licensed':2495,
'licensee':2496,
'licensees':2497,
'licenseref':2498,
'licenses':2499,
'licensetext':2500,
'licensetype':2501,
'licenseurl':2502,
'licensing':2503,
'licensor':2504,
'licensors':2505,
'lien':2506,
'liens':2507,
'lifesaving':2508,
'lifted':2509,
'likeness':2510,
'limit':2511,
'limitation':2512,
'limitations':2513,
'limitative':2514,
'limite':2515,
'limiting':2516,
'limits':2517,
'limted':2518,
'lincenced':2519,
'lincense':2520,
'lincensee':2521,
'lineage':2522,
'linguist':2523,
'linguistic':2524,
'linkable':2525,
'linker':2526,
'linkers':2527,
'liquidation':2528,
'liscese':2529,
'lisence':2530,
'lisense':2531,
'literal':2532,
'lithography':2533,
'litigant':2534,
'litigated':2535,
'litigating':2536,
'litigation':2537,
'lizenz':2538,
'llgpl':2539,
'loadable':2540,
'loader':2541,
'locality':2542,
'localized':2543,
'locations':2544,
'lockouts':2545,
'logger':2546,
'logins':2547,
'logos':2548,
'logotype':2549,
'loopholes':2550,
'loss':2551,
'losses':2552,
'lossless':2553,
'machine':2554,
'mailer':2555,
'mainly':2556,
'maintain':2557,
'maintainable':2558,
'maintainers':2559,
'maintaining':2560,
'maintains':2561,
'majesty':2562,
'makefiles':2563,
'malfunction':2564,
'malfunctioning':2565,
'malfunctions':2566,
'malicious':2567,
'malware':2568,
'mammography':2569,
'managers':2570,
'manaufacturers':2571,
'mandated':2572,
'mandatory':2573,
'maneuvers':2574,
'manifesto':2575,
'manipulate':2576,
'manipulated':2577,
'manipulates':2578,
'manipulating':2579,
'manipulations':2580,
'mankind':2581,
'manner':2582,
'manufacturer':2583,
'manufacturers':2584,
'manufactures':2585,
'manufacturing':2586,
'markers':2587,
'marketability':2588,
'marketed':2589,
'marking':2590,
'markings':2591,
'materialization':2592,
'materially':2593,
'materials':2594,
'maximizing':2595,
'mean':2596,
'meaning':2597,
'meaningful':2598,
'meaningfully':2599,
'meanings':2600,
'means':2601,
'meant':2602,
'measurable':2603,
'measured':2604,
'measures':2605,
'mechanism':2606,
'mediainfo':2607,
'mediastreaming':2608,
'mediator':2609,
'member':2610,
'members':2611,
'membership':2612,
'memento':2613,
'mention':2614,
'mentioned':2615,
'mentioning':2616,
'mentions':2617,
'merchantability':2618,
'merchantable':2619,
'merchantablility':2620,
'merchantibility':2621,
'merchantibilty':2622,
'merely':2623,
'mergchantability':2624,
'merged':2625,
'merges':2626,
'metering':2627,
'methodical':2628,
'metrics':2629,
'microcontroller':2630,
'microcontrollers':2631,
'microdiagram':2632,
'microphones':2633,
'microprocessor':2634,
'microprocessors':2635,
'microsytems':2636,
'middleware':2637,
'migrated':2638,
'minimal':2639,
'minimalist':2640,
'minimally':2641,
'minimis':2642,
'minimize':2643,
'minimizing':2644,
'minors':2645,
'misapplication':2646,
'misappropriate':2647,
'misappropriated':2648,
'misappropriates':2649,
'misappropriation':2650,
'miscellaneous':2651,
'misconduct':2652,
'misconfigurations':2653,
'misdelivery':2654,
'misdirected':2655,
'mise':2656,
'mises':2657,
'misidentification':2658,
'mislead':2659,
'misleading':2660,
'misplaced':2661,
'misrepresent':2662,
'misrepresentation':2663,
'misrepresentative':2664,
'misrepresented':2665,
'missiles':2666,
'mistaken':2667,
'mistakes':2668,
'misuse':2669,
'misusing':2670,
'mitcopyrightbegin':2671,
'mitcopyrightend':2672,
'mitigate':2673,
'mock':2674,
'modeled':2675,
'modeler':2676,
'modifiable':2677,
'modifies':2678,
'modify':2679,
'modifying':2680,
'modiﬁcation':2681,
'money':2682,
'monies':2683,
'morale':2684,
'moreover':2685,
'morph':2686,
'motif':2687,
'motivate':2688,
'motivations':2689,
'mozillapl':2690,
'mozpl':2691,
'mpl':2692,
'mplv2':2693,
'multiauthor':2694,
'multilateral':2695,
'multimedia':2696,
'multiplication':2697,
'multivehicle':2698,
'mumble':2699,
'munitions':2700,
'mutandis':2701,
'mutatis':2702,
'mutilate':2703,
'mutilation':2704,
'mutually':2705,
'named':2706,
'namely':2707,
'narcotic':2708,
'narrowly':2709,
'nda':2710,
'neatly':2711,
'necessarily':2712,
'necessary':2713,
'necessitated':2714,
'necessitating':2715,
'needy':2716,
'negate':2717,
'negatively':2718,
'neglect':2719,
'negligence':2720,
'negligent':2721,
'negotiable':2722,
'negotiated':2723,
'negotiating':2724,
'negotiation':2725,
'neighboring':2726,
'neighbour':2727,
'neighbouring':2728,
'neither':2729,
'networking':2730,
'networks':2731,
'nevertheless':2732,
'newsgroup':2733,
'nexb':2734,
'nicer':2735,
'noderivatives':2736,
'noderivs':2737,
'nominating':2738,
'nonassignable':2739,
'noncommercial':2740,
'noncommercially':2741,
'noncommerical':2742,
'noncompliance':2743,
'nonconflicting':2744,
'nonconformities':2745,
'nonconformity':2746,
'noncorporate':2747,
'nondisclosure':2748,
'nondiscrimination':2749,
'nonetheless':2750,
'nonexclusive':2751,
'nonexistence':2752,
'nonfree':2753,
'nonfunctional':2754,
'nongnu':2755,
'nongovernmental':2756,
'noninfringe':2757,
'noninfringement':2758,
'nonobstant':2759,
'nonoperational':2760,
'nonperformance':2761,
'nonprofit':2762,
'nonproprietary':2763,
'nonpublic':2764,
'nonsense':2765,
'nonstandard':2766,
'nonsublicensable':2767,
'nonsublicenseable':2768,
'nontransferable':2769,
'nontrivial':2770,
'normally':2771,
'normative':2772,
'norms':2773,
'notably':2774,
'notarized':2775,
'notations':2776,
'noted':2777,
'noteworthy':2778,
'noticeable':2779,
'notices':2780,
'notification':2781,
'notifications':2782,
'notified':2783,
'notifies':2784,
'notifying':2785,
'noting':2786,
'notwithstanding':2787,
'noun':2788,
'npl':2789,
'nuclear':2790,
'nuisance':2791,
'nul':2792,
'nullification':2793,
'nullifies':2794,
'nullify':2795,
'nullit':2796,
'nullity':2797,
'numbering':2798,
'numerics':2799,
'oagpl':2800,
'obey':2801,
'obeying':2802,
'obfuscate':2803,
'obfuscated':2804,
'obfuscation':2805,
'obfuscator':2806,
'objectif':2807,
'objection':2808,
'objections':2809,
'obligate':2810,
'obligated':2811,
'obligating':2812,
'obligation':2813,
'obligations':2814,
'oblige':2815,
'obliged':2816,
'oblique':2817,
'obliterated':2818,
'obscene':2819,
'obscure':2820,
'obscured':2821,
'obscures':2822,
'observance':2823,
'observed':2824,
'observes':2825,
'obstruct':2826,
'obstructed':2827,
'obtain':2828,
'obtainable':2829,
'obtained':2830,
'obtaining':2831,
'obtainment':2832,
'obtains':2833,
'obvious':2834,
'obviously':2835,
'occupies':2836,
'occur':2837,
'occurred':2838,
'occurrence':2839,
'occurrences':2840,
'occurring':2841,
'occurs':2842,
'offences':2843,
'offering':2844,
'offers':2845,
'oglv2':2846,
'oglv3':2847,
'omission':2848,
'omissions':2849,
'omit':2850,
'omitted':2851,
'omitting':2852,
'ommission':2853,
'ommitting':2854,
'omnibus':2855,
'onboarding':2856,
'onerous':2857,
'onward':2858,
'onwards':2859,
'opaque':2860,
'opensource':2861,
'operability':2862,
'operable':2863,
'operate':2864,
'operated':2865,
'operational':2866,
'optimised':2867,
'optimizer':2868,
'optionally':2869,
'options':2870,
'orally':2871,
'orderable':2872,
'ordinances':2873,
'ordinarily':2874,
'organisation':2875,
'organisations':2876,
'organizations':2877,
'organized':2878,
'orginal':2879,
'originally':2880,
'originals':2881,
'originate':2882,
'originated':2883,
'originates':2884,
'originating':2885,
'originator':2886,
'originators':2887,
'otherwise':2888,
'ours':2889,
'ourselves':2890,
'outages':2891,
'outbound':2892,
'outlawed':2893,
'outlying':2894,
'outputting':2895,
'outset':2896,
'outside':2897,
'outsourced':2898,
'outsourcee':2899,
'outsourcees':2900,
'outsourcers':2901,
'overburden':2902,
'overdue':2903,
'overlapped':2904,
'overriding':2905,
'overrule':2906,
'overseen':2907,
'overt':2908,
'overtly':2909,
'overwrites':2910,
'overwriting':2911,
'overwritten':2912,
'owe':2913,
'owed':2914,
'owing':2915,
'owned':2916,
'owners':2917,
'ownership':2918,
'owning':2919,
'package':2920,
'packager':2921,
'packages':2922,
'pageviews':2923,
'paging':2924,
'paid':2925,
'paisible':2926,
'parameters':2927,
'parentheses':2928,
'parenthesis':2929,
'parse':2930,
'parsed':2931,
'parses':2932,
'partcipating':2933,
'partially':2934,
'participants':2935,
'participate':2936,
'participates':2937,
'participating':2938,
'participation':2939,
'particularly':2940,
'parties':2941,
'partitioning':2942,
'partly':2943,
'partner':2944,
'partners':2945,
'partnership':2946,
'partys':2947,
'passages':2948,
'passing':2949,
'passive':2950,
'patched':2951,
'patches':2952,
'patent':2953,
'patentable':2954,
'patented':2955,
'patentee':2956,
'patenting':2957,
'patents':2958,
'pay':2959,
'payed':2960,
'payment':2961,
'pemission':2962,
'penalised':2963,
'penalties':2964,
'people':2965,
'perceivable':2966,
'perceive':2967,
'perceptible':2968,
'perceptions':2969,
'perceptual':2970,
'percolating':2971,
'perfected':2972,
'perform':2973,
'performance':2974,
'performances':2975,
'performed':2976,
'performer':2977,
'performers':2978,
'performing':2979,
'performs':2980,
'periodic':2981,
'periodical':2982,
'periodically':2983,
'periods':2984,
'perjury':2985,
'permanent':2986,
'permanently':2987,
'permision':2988,
'permissable':2989,
'permissible':2990,
'permission':2991,
'permissions':2992,
'permissive':2993,
'permisson':2994,
'permit':2995,
'permition':2996,
'permits':2997,
'permitted':2998,
'permitting':2999,
'perpetual':3000,
'perpetually':3001,
'perpetuity':3002,
'persevere':3003,
'persist':3004,
'person':3005,
'personality':3006,
'personalization':3007,
'personalize':3008,
'personalized':3009,
'personally':3010,
'personnal':3011,
'personnel':3012,
'persons':3013,
'persuant':3014,
'pertain':3015,
'pertaining':3016,
'pertains':3017,
'pertinent':3018,
'pervasive':3019,
'philosophies':3020,
'phishing':3021,
'phonogram':3022,
'phonograms':3023,
'phonography':3024,
'phonorecord':3025,
'phonorecords':3026,
'photocopy':3027,
'photocopying':3028,
'physical':3029,
'physically':3030,
'piracy':3031,
'plagiarize':3032,
'plainly':3033,
'plaintiff':3034,
'pleadings':3035,
'plural':3036,
'pointers':3037,
'polices':3038,
'policies':3039,
'pornographic':3040,
'pornography':3041,
'portability':3042,
'porting':3043,
'possesses':3044,
'possessing':3045,
'possessive':3046,
'possessor':3047,
'possessors':3048,
'possibilities':3049,
'possibiltiy':3050,
'possiblity':3051,
'possibly':3052,
'posted':3053,
'posting':3054,
'postings':3055,
'powering':3056,
'practicable':3057,
'practicably':3058,
'practical':3059,
'practicing':3060,
'preamble':3061,
'preambule':3062,
'prearranged':3063,
'precautionary':3064,
'precautions':3065,
'precedent':3066,
'preceeding':3067,
'preclude':3068,
'precluded':3069,
'precompiled':3070,
'predates':3071,
'predecessor':3072,
'predefined':3073,
'predictable':3074,
'preeminence':3075,
'preexist':3076,
'preexisting':3077,
'preface':3078,
'prefaced':3079,
'prefer':3080,
'preferably':3081,
'preference':3082,
'preferences':3083,
'prejudice':3084,
'prejudicial':3085,
'prejudicing':3086,
'preliminary':3087,
'premises':3088,
'prepaid':3089,
'preparation':3090,
'preparatory':3091,
'prepares':3092,
'prepay':3093,
'preprinted':3094,
'preprocessor':3095,
'preprocessors':3096,
'prerelease':3097,
'prescribe':3098,
'prescribes':3099,
'presentation':3100,
'presentations':3101,
'presented':3102,
'presenter':3103,
'presently':3104,
'presents':3105,
'preservation':3106,
'preserve':3107,
'preserved':3108,
'preserves':3109,
'preserving':3110,
'prestation':3111,
'prestations':3112,
'presumably':3113,
'presumed':3114,
'presumption':3115,
'pretend':3116,
'pretending':3117,
'prevail':3118,
'prevailing':3119,
'prevails':3120,
'preventing':3121,
'previous':3122,
'previously':3123,
'price':3124,
'prices':3125,
'pricing':3126,
'primarily':3127,
'primecuts':3128,
'principally':3129,
'principes':3130,
'printings':3131,
'printouts':3132,
'pristine':3133,
'privacy':3134,
'privileged':3135,
'proactively':3136,
'probability':3137,
'problematic':3138,
'procedural':3139,
'procedure':3140,
'procedures':3141,
'proceeding':3142,
'proceedings':3143,
'proceeds':3144,
'processing':3145,
'procession':3146,
'procure':3147,
'procurements':3148,
'procuring':3149,
'produced':3150,
'producer':3151,
'producers':3152,
'produces':3153,
'producing':3154,
'profane':3155,
'profanity':3156,
'professional':3157,
'professionalism':3158,
'professionally':3159,
'profit':3160,
'profitability':3161,
'profits':3162,
'programm':3163,
'programmable':3164,
'programme':3165,
'programmed':3166,
'programmer':3167,
'programmers':3168,
'programms':3169,
'prohibit':3170,
'prohibited':3171,
'prohibiting':3172,
'prohibition':3173,
'prohibitions':3174,
'prohibits':3175,
'proliferation':3176,
'prologue':3177,
'prolonged':3178,
'prominently':3179,
'promote':3180,
'promoted':3181,
'promotes':3182,
'promoting':3183,
'promotion':3184,
'promotional':3185,
'promotions':3186,
'prompted':3187,
'prompts':3188,
'promulgate':3189,
'promulgated':3190,
'prone':3191,
'proofpoint':3192,
'proofs':3193,
'propagated':3194,
'propagating':3195,
'propagation':3196,
'proper':3197,
'properly':3198,
'proportionate':3199,
'proportionately':3200,
'proportions':3201,
'propose':3202,
'proposed':3203,
'propriately':3204,
'proprietary':3205,
'proprietize':3206,
'proprietor':3207,
'propriety':3208,
'prorated':3209,
'proscribed':3210,
'prose':3211,
'prosecute':3212,
'prosecuted':3213,
'prosecution':3214,
'prospectively':3215,
'prosperity':3216,
'protect':3217,
'protectable':3218,
'protected':3219,
'protecting':3220,
'protection':3221,
'protections':3222,
'protector':3223,
'protects':3224,
'protocole':3225,
'prototyping':3226,
'provenance':3227,
'provenant':3228,
'proves':3229,
'provider':3230,
'providers':3231,
'providing':3232,
'proving':3233,
'provision':3234,
'provisional':3235,
'provisionally':3236,
'provisioning':3237,
'provisions':3238,
'proviso':3239,
'prudent':3240,
'pseudo':3241,
'pseudocode':3242,
'pseudonym':3243,
'pseudonyms':3244,
'publically':3245,
'publication':3246,
'publications':3247,
'publicdomain':3248,
'publicity':3249,
'publicly':3250,
'publicshed':3251,
'publique':3252,
'publish':3253,
'published':3254,
'publisher':3255,
'publishers':3256,
'publishes':3257,
'publishhed':3258,
'publishing':3259,
'punctuation':3260,
'punitive':3261,
'purchase':3262,
'purchased':3263,
'purchaser':3264,
'purchasers':3265,
'purchases':3266,
'purchasing':3267,
'purdue':3268,
'purge':3269,
'purport':3270,
'purported':3271,
'purporting':3272,
'purports':3273,
'purposes':3274,
'pursuant':3275,
'pursued':3276,
'qualification':3277,
'qualified':3278,
'qualifies':3279,
'qualify':3280,
'qualifying':3281,
'qualitatively':3282,
'quantify':3283,
'quantitatively':3284,
'quickstart':3285,
'quota':3286,
'quotas':3287,
'quoting':3288,
'racist':3289,
'ralink':3290,
'randomly':3291,
'ratifying':3292,
'rationale':3293,
'reachable':3294,
'reactive':3295,
'reactivity':3296,
'readable':3297,
'readjustment':3298,
'readme':3299,
'readmes':3300,
'realises':3301,
'realizes':3302,
'reason':3303,
'reasonable':3304,
'reasonably':3305,
'reasons':3306,
'reassign':3307,
'reassigned':3308,
'reassurances':3309,
'reboot':3310,
'rebranding':3311,
'rebroadcast':3312,
'recast':3313,
'recasting':3314,
'receipt':3315,
'receipts':3316,
'receiver':3317,
'receives':3318,
'receiving':3319,
'recipients':3320,
'reciprocal':3321,
'reciprocate':3322,
'reciprocity':3323,
'recitals':3324,
'recitation':3325,
'recitations':3326,
'recognise':3327,
'recognitions':3328,
'recognizably':3329,
'recognized':3330,
'recombine':3331,
'recombining':3332,
'recommendation':3333,
'recompilation':3334,
'recompile':3335,
'recompiling':3336,
'recompression':3337,
'reconstituted':3338,
'reconstruct':3339,
'recourse':3340,
'rectification':3341,
'rectify':3342,
'recurrence':3343,
'recurring':3344,
'redefined':3345,
'redefining':3346,
'redefinitions':3347,
'redeployments':3348,
'redirects':3349,
'redist':3350,
'redistributable':3351,
'redistributables':3352,
'redistribute':3353,
'redistributed':3354,
'redistributes':3355,
'redistributing':3356,
'redistribution':3357,
'redistributions':3358,
'redistributor':3359,
'redistributors':3360,
'redistricting':3361,
'redistrubute':3362,
'redress':3363,
'redundancy':3364,
'redundant':3365,
'reengineer':3366,
'reexport':3367,
'reexported':3368,
'reexporting':3369,
'refered':3370,
'referenced':3371,
'references':3372,
'referencing':3373,
'referred':3374,
'reflected':3375,
'reflecting':3376,
'reflects':3377,
'reformat':3378,
'reformation':3379,
'reformats':3380,
'reformatted':3381,
'reformed':3382,
'reformulated':3383,
'refrain':3384,
'refund':3385,
'refundable':3386,
'refunded':3387,
'refunds':3388,
'refuses':3389,
'regard':3390,
'regarding':3391,
'regardless':3392,
'registered':3393,
'registering':3394,
'registration':3395,
'registrations':3396,
'regular':3397,
'regularly':3398,
'regulate':3399,
'regulated':3400,
'regulates':3401,
'regulating':3402,
'regulation':3403,
'regulations':3404,
'regulators':3405,
'regulatory':3406,
'reimburse':3407,
'reimbursed':3408,
'reimbursement':3409,
'reimbursements':3410,
'reimplementation':3411,
'reinstall':3412,
'reinstalling':3413,
'reinstate':3414,
'reinstated':3415,
'reinstatement':3416,
'reinstates':3417,
'reintegrate':3418,
'reject':3419,
'rejection':3420,
'rejects':3421,
'relased':3422,
'related':3423,
'relating':3424,
'relaxes':3425,
'releasable':3426,
'releases':3427,
'releasing':3428,
'relevance':3429,
'relevant':3430,
'reliability':3431,
'reliably':3432,
'reliance':3433,
'relicence':3434,
'relicenced':3435,
'relicencing':3436,
'relicense':3437,
'relicensed':3438,
'relicensing':3439,
'relied':3440,
'relief':3441,
'relies':3442,
'relieve':3443,
'relieved':3444,
'relieves':3445,
'relink':3446,
'relinking':3447,
'relinquish':3448,
'relinquished':3449,
'relinquishes':3450,
'relinquishing':3451,
'relinquishment':3452,
'relying':3453,
'remain':3454,
'remainder':3455,
'remained':3456,
'remaining':3457,
'remains':3458,
'remanufactured':3459,
'remediable':3460,
'remedial':3461,
'remediated':3462,
'remedied':3463,
'remedies':3464,
'remit':3465,
'remotely':3466,
'remuneration':3467,
'rename':3468,
'renamed':3469,
'renaming':3470,
'renegotiate':3471,
'renegotiations':3472,
'renewals':3473,
'renonciation':3474,
'renounce':3475,
'rented':3476,
'rents':3477,
'renumbered':3478,
'renunciation':3479,
'reordering':3480,
'reorganization':3481,
'repack':3482,
'repackage':3483,
'repackaging':3484,
'repackagings':3485,
'repaired':3486,
'repealing':3487,
'replacements':3488,
'replaces':3489,
'replacing':3490,
'replicas':3491,
'replicated':3492,
'replications':3493,
'reported':3494,
'repositories':3495,
'reprehensible':3496,
'represent':3497,
'representation':3498,
'representations':3499,
'representative':3500,
'representatives':3501,
'represented':3502,
'representing':3503,
'represents':3504,
'reprises':3505,
'reproduce':3506,
'reproduced':3507,
'reproduces':3508,
'reproducible':3509,
'reproducing':3510,
'reproduct':3511,
'reproduction':3512,
'reproductions':3513,
'republish':3514,
'republished':3515,
'repudiation':3516,
'reputation':3517,
'reputations':3518,
'requested':3519,
'requester':3520,
'requesting':3521,
'requirement':3522,
'requirements':3523,
'requiring':3524,
'requisite':3525,
'requisites':3526,
'rereleased':3527,
'rerouting':3528,
'resale':3529,
'rescinded':3530,
'rescission':3531,
'resell':3532,
'reseller':3533,
'reselling':3534,
'resend':3535,
'reserves':3536,
'resided':3537,
'residence':3538,
'residency':3539,
'resident':3540,
'residents':3541,
'residing':3542,
'residuals':3543,
'resiliation':3544,
'resold':3545,
'resolution':3546,
'resolutory':3547,
'resolved':3548,
'resolving':3549,
'respected':3550,
'respecting':3551,
'respective':3552,
'respectively':3553,
'respects':3554,
'responded':3555,
'responds':3556,
'responsable':3557,
'responsables':3558,
'response':3559,
'responses':3560,
'responsibilities':3561,
'responsibility':3562,
'responsible':3563,
'responsibly':3564,
'restraining':3565,
'restrict':3566,
'restricted':3567,
'restricting':3568,
'restriction':3569,
'restrictions':3570,
'restrictive':3571,
'restrictively':3572,
'restricts':3573,
'restructure':3574,
'resultant':3575,
'resulted':3576,
'resuscitation':3577,
'retailer':3578,
'retailers':3579,
'retain':3580,
'retained':3581,
'retaining':3582,
'retains':3583,
'retitle':3584,
'retract':3585,
'retransfer':3586,
'retrievable':3587,
'retrieved':3588,
'retrieving':3589,
'retroactive':3590,
'retroactively':3591,
'retrospectively':3592,
'reusable':3593,
'reuse':3594,
'reused':3595,
'reuses':3596,
'reusing':3597,
'revealing':3598,
'revenue':3599,
'reversible':3600,
'revert':3601,
'review':3602,
'reviewed':3603,
'reviews':3604,
'revise':3605,
'revised':3606,
'revising':3607,
'revision':3608,
'revisions':3609,
'revived':3610,
'revocable':3611,
'revocation':3612,
'revoke':3613,
'revoked':3614,
'revoking':3615,
'rewrite':3616,
'rewritten':3617,
'righted':3618,
'rightful':3619,
'rightfully':3620,
'rightsholder':3621,
'rightsholders':3622,
'rigorous':3623,
'robotics':3624,
'rollback':3625,
'rosenlaw':3626,
'royalties':3627,
'royalty':3628,
'rue':3629,
'rule':3630,
'rules':3631,
'runnable':3632,
'runtime':3633,
'runtimes':3634,
'safecopy':3635,
'safeguard':3636,
'safeguards':3637,
'safes':3638,
'safest':3639,
'sale':3640,
'sales':3641,
'sampler':3642,
'sanction':3643,
'sanctioned':3644,
'sanctions':3645,
'satisfies':3646,
'satisfying':3647,
'scaffolding':3648,
'scalable':3649,
'scancode':3650,
'scandalous':3651,
'scheduler':3652,
'schemas':3653,
'schematic':3654,
'schematics':3655,
'scrape':3656,
'scraper':3657,
'scraping':3658,
'screamer':3659,
'scriptable':3660,
'seated':3661,
'secondarily':3662,
'secondly':3663,
'secrecy':3664,
'secret':3665,
'secrets':3666,
'sectioning':3667,
'sections':3668,
'secures':3669,
'securised':3670,
'seek':3671,
'seeking':3672,
'seeks':3673,
'segmentation':3674,
'selective':3675,
'selector':3676,
'selects':3677,
'selfhost':3678,
'selfsigned':3679,
'sell':3680,
'selling':3681,
'semblance':3682,
'sentences':3683,
'separable':3684,
'separated':3685,
'separately':3686,
'seperately':3687,
'sequential':3688,
'servicemarks':3689,
'servicing':3690,
'serving':3691,
'settle':3692,
'settled':3693,
'settlement':3694,
'settlements':3695,
'settling':3696,
'sever':3697,
'severability':3698,
'severable':3699,
'severally':3700,
'severed':3701,
'shamelessly':3702,
'sharealike':3703,
'sharedsource':3704,
'shareware':3705,
'shipped':3706,
'shortage':3707,
'shortages':3708,
'shortcomings':3709,
'shortened':3710,
'shortening':3711,
'shortest':3712,
'shortfall':3713,
'shortname':3714,
'shrinkwrap':3715,
'signage':3716,
'signatories':3717,
'signatory':3718,
'signature':3719,
'signatures':3720,
'signed':3721,
'significant':3722,
'significantly':3723,
'signification':3724,
'signifies':3725,
'signify':3726,
'signing':3727,
'signoff':3728,
'similarly':3729,
'simplest':3730,
'simplify':3731,
'simply':3732,
'simultaneous':3733,
'simultaneously':3734,
'singular':3735,
'singularly':3736,
'skeleton':3737,
'sketch':3738,
'sleepycat':3739,
'slicer':3740,
'slogan':3741,
'slogans':3742,
'snippet':3743,
'snippets':3744,
'sold':3745,
'sole':3746,
'solely':3747,
'solicit':3748,
'solicitation':3749,
'solicitations':3750,
'sourced':3751,
'sourcing':3752,
'sovereign':3753,
'specific':3754,
'specifically':3755,
'specifies':3756,
'specify':3757,
'specifying':3758,
'spelled':3759,
'spells':3760,
'splash':3761,
'spokespersons':3762,
'sponsored':3763,
'sponsoring':3764,
'spotted':3765,
'spreadsheets':3766,
'ssleay':3767,
'stability':3768,
'stalking':3769,
'stallman':3770,
'stance':3771,
'standalone':3772,
'standardisation':3773,
'standardization':3774,
'standardized':3775,
'startsmart':3776,
'stated':3777,
'statements':3778,
'statically':3779,
'stating':3780,
'statut':3781,
'statute':3782,
'statutes':3783,
'statutory':3784,
'stencil':3785,
'stencils':3786,
'steward':3787,
'stimulate':3788,
'stipulate':3789,
'stipulated':3790,
'stipulation':3791,
'stipulations':3792,
'stockpiling':3793,
'straightforwardly':3794,
'stringent':3795,
'stylesheet':3796,
'stylesheets':3797,
'styling':3798,
'stylistic':3799,
'stylized':3800,
'subassemblies':3801,
'subclassed':3802,
'subcomponent':3803,
'subcomponents':3804,
'subcontract':3805,
'subcontracting':3806,
'subcontractor':3807,
'subcontractors':3808,
'subdirectories':3809,
'subdirectory':3810,
'subdividing':3811,
'subdomains':3812,
'subjected':3813,
'subjecting':3814,
'sublicence':3815,
'sublicensable':3816,
'sublicense':3817,
'sublicenseable':3818,
'sublicensed':3819,
'sublicensee':3820,
'sublicensees':3821,
'sublicenses':3822,
'sublicensing':3823,
'sublicensor':3824,
'submission':3825,
'submissions':3826,
'submits':3827,
'submitted':3828,
'submitter':3829,
'submitters':3830,
'submitting':3831,
'subpackages':3832,
'subparagraph':3833,
'subpart':3834,
'subparts':3835,
'subpoena':3836,
'subprocessor':3837,
'subprograms':3838,
'subproject':3839,
'subprojects':3840,
'subroutine':3841,
'subroutines':3842,
'subscribe':3843,
'subscribed':3844,
'subscriber':3845,
'subscribers':3846,
'subscription':3847,
'subscriptions':3848,
'subsection':3849,
'subsections':3850,
'subsequent':3851,
'subsequently':3852,
'subsets':3853,
'subsetting':3854,
'subsidiaries':3855,
'subsidiary':3856,
'subsidization':3857,
'subsist':3858,
'subsisting':3859,
'subsituting':3860,
'substance':3861,
'substances':3862,
'substantial':3863,
'substantially':3864,
'substantiate':3865,
'substantiated':3866,
'substantive':3867,
'substantively':3868,
'substitute':3869,
'substituted':3870,
'substitutes':3871,
'substituting':3872,
'substitution':3873,
'subsumed':3874,
'subtitute':3875,
'succeeded':3876,
'succeeds':3877,
'successfully':3878,
'successiva':3879,
'successive':3880,
'successor':3881,
'successors':3882,
'sue':3883,
'sues':3884,
'suffice':3885,
'sufficiency':3886,
'sufficient':3887,
'sufficiently':3888,
'suitability':3889,
'suitably':3890,
'summarize':3891,
'summarized':3892,
'summarizes':3893,
'summarizing':3894,
'supercede':3895,
'superceded':3896,
'supercedes':3897,
'supersede':3898,
'superseded':3899,
'supersedes':3900,
'superseding':3901,
'supersedure':3902,
'supplemental':3903,
'supplementary':3904,
'supplemented':3905,
'supplementing':3906,
'supplements':3907,
'supplier':3908,
'suppliers':3909,
'supplies':3910,
'supplying':3911,
'supporting':3912,
'supposed':3913,
'suppress':3914,
'suppression':3915,
'supremacy':3916,
'surcharges':3917,
'surrender':3918,
'surrendered':3919,
'surrenders':3920,
'surreptitiously':3921,
'survenance':3922,
'surveying':3923,
'survival':3924,
'survive':3925,
'survives':3926,
'surviving':3927,
'survivor':3928,
'survivors':3929,
'survivorship':3930,
'susceptible':3931,
'susceptibles':3932,
'suspected':3933,
'suspects':3934,
'suspend':3935,
'suspending':3936,
'suspension':3937,
'suspicious':3938,
'sustainability':3939,
'sustaining':3940,
'synched':3941,
'synching':3942,
'synchronization':3943,
'synonym':3944,
'systematically':3945,
'tacit':3946,
'tacitly':3947,
'taint':3948,
'tainted':3949,
'takedown':3950,
'tampa':3951,
'tamper':3952,
'tampering':3953,
'tangible':3954,
'tariff':3955,
'tariffs':3956,
'tarnishes':3957,
'taxation':3958,
'taxes':3959,
'taxing':3960,
'team':3961,
'technical':3962,
'technically':3963,
'technologist':3964,
'telecommunication':3965,
'telecommunications':3966,
'telecommuting':3967,
'telecopy':3968,
'telematic':3969,
'telematics':3970,
'tenable':3971,
'tenders':3972,
'tenets':3973,
'terminable':3974,
'terminate':3975,
'terminated':3976,
'terminates':3977,
'terminating':3978,
'termination':3979,
'terrestrial':3980,
'territoriale':3981,
'territory':3982,
'terse':3983,
'tested':3984,
'testimonial':3985,
'textual':3986,
'tgppl':3987,
'thereby':3988,
'therefor':3989,
'therefore':3990,
'therefrom':3991,
'therein':3992,
'thereof':3993,
'thereon':3994,
'thereto':3995,
'thereunder':3996,
'therewith':3997,
'thirdparty':3998,
'thompson':3999,
'thoroughly':4000,
'threaten':4001,
'threatening':4002,
'thrives':4003,
'thwart':4004,
'ticketing':4005,
'tightly':4006,
'timed':4007,
'timeframe':4008,
'timeliness':4009,
'timescale':4010,
'timeshare':4011,
'timesharing':4012,
'titled':4013,
'titles':4014,
'tmate':4015,
'tolerant':4016,
'topography':4017,
'topology':4018,
'tort':4019,
'tortious':4020,
'torts':4021,
'tortuous':4022,
'tou':4023,
'tracing':4024,
'trade':4025,
'trademar':4026,
'trademark':4027,
'trademarked':4028,
'trademarks':4029,
'tradename':4030,
'tradenames':4031,
'tradeshows':4032,
'traffickers':4033,
'tranquil':4034,
'transact':4035,
'transaction':4036,
'transactional':4037,
'transactions':4038,
'transacts':4039,
'transcode':4040,
'transcoding':4041,
'transcribed':4042,
'transcription':4043,
'transfer':4044,
'transferability':4045,
'transferable':4046,
'transferee':4047,
'transferees':4048,
'transferor':4049,
'transferrable':4050,
'transferred':4051,
'transferring':4052,
'transfers':4053,
'transfert':4054,
'transformation':4055,
'transformations':4056,
'transforming':4057,
'transitive':4058,
'translated':4059,
'translates':4060,
'translating':4061,
'translations':4062,
'translator':4063,
'translators':4064,
'transmission':4065,
'transmissions':4066,
'transmit':4067,
'transmits':4068,
'transmitted':4069,
'transmitting':4070,
'transported':4071,
'transposed':4072,
'transpositions':4073,
'treated':4074,
'treaties':4075,
'trespass':4076,
'trespassed':4077,
'trespassing':4078,
'trial':4079,
'tribunal':4080,
'tribunals':4081,
'tributed':4082,
'triggered':4083,
'tripple':4084,
'trivial':4085,
'trouble':4086,
'troubleshoot':4087,
'troubleshooting':4088,
'truncate':4089,
'trusster':4090,
'trust':4091,
'trusted':4092,
'trustee':4093,
'trustees':4094,
'truthfully':4095,
'tryout':4096,
'tuned':4097,
'turing':4098,
'tutorial':4099,
'tweak':4100,
'tweaking':4101,
'typeface':4102,
'typefaces':4103,
'typesetting':4104,
'typewritten':4105,
'typographic':4106,
'typographical':4107,
'ultimately':4108,
'unacceptable':4109,
'unacceptably':4110,
'unaccompanied':4111,
'unaffected':4112,
'unaffiliated':4113,
'unalienable':4114,
'unaltered':4115,
'unambiguous':4116,
'unambiguously':4117,
'unanticipated':4118,
'unauthorised':4119,
'unauthorized':4120,
'unavailability':4121,
'unavoidable':4122,
'unbound':4123,
'unbundle':4124,
'unbundled':4125,
'unbundling':4126,
'uncertain':4127,
'unchanged':4128,
'uncitral':4129,
'unclassified':4130,
'unclear':4131,
'uncombined':4132,
'uncommitted':4133,
'unconditional':4134,
'unconditionally':4135,
'unconstrained':4136,
'uncover':4137,
'uncovered':4138,
'uncovers':4139,
'undeliverable':4140,
'undergo':4141,
'underlined':4142,
'undermine':4143,
'undermined':4144,
'undermining':4145,
'underpaid':4146,
'underpayment':4147,
'underpayments':4148,
'underreported':4149,
'underreports':4150,
'underscorejs':4151,
'underscores':4152,
'undersigned':4153,
'undersigns':4154,
'understand':4155,
'understanding':4156,
'understandings':4157,
'understands':4158,
'understood':4159,
'undertake':4160,
'undertaken':4161,
'undertakes':4162,
'undertaking':4163,
'undertakings':4164,
'undesirable':4165,
'undetermined':4166,
'undisputed':4167,
'undue':4168,
'unduly':4169,
'unearned':4170,
'unencumbered':4171,
'unenforceability':4172,
'unenforceable':4173,
'unequivocal':4174,
'unequivocally':4175,
'unestablished':4176,
'unexpected':4177,
'unfairly':4178,
'unfit':4179,
'unforeseeable':4180,
'unhelpful':4181,
'unhindered':4182,
'unidentified':4183,
'uniform':4184,
'uniformly':4185,
'unilateral':4186,
'unilaterally':4187,
'uninstallation':4188,
'uninstallations':4189,
'uninstalled':4190,
'uninstallers':4191,
'uninstalling':4192,
'uninstalls':4193,
'unintended':4194,
'unintentional':4195,
'unintentionally':4196,
'uninterrupted':4197,
'universal':4198,
'universally':4199,
'universities':4200,
'university':4201,
'unjust':4202,
'unknowingly':4203,
'unknown':4204,
'unlawful':4205,
'unless':4206,
'unlicence':4207,
'unlicenced':4208,
'unlicense':4209,
'unlicensed':4210,
'unlicnse':4211,
'unlimited':4212,
'unliscense':4213,
'unlocking':4214,
'unmaintained':4215,
'unmanned':4216,
'unmodfied':4217,
'unmodified':4218,
'unnamed':4219,
'unnecessarily':4220,
'unnecessary':4221,
'unpack':4222,
'unpacked':4223,
'unpacking':4224,
'unpaid':4225,
'unpatented':4226,
'unported':4227,
'unprecedented':4228,
'unpredictable':4229,
'unprotect':4230,
'unprotected':4231,
'unpublished':4232,
'unreachable':4233,
'unreasonable':4234,
'unreasonably':4235,
'unregister':4236,
'unregistered':4237,
'unrelated':4238,
'unreleased':4239,
'unrest':4240,
'unrestricted':4241,
'unrestrictedly':4242,
'unsafe':4243,
'unscheduled':4244,
'unsigned':4245,
'unsolicited':4246,
'unspecified':4247,
'unsuccessful':4248,
'unsuccessfully':4249,
'unsure':4250,
'untested':4251,
'untied':4252,
'untimely':4253,
'untouched':4254,
'untraceable':4255,
'untrue':4256,
'unusable':4257,
'unverified':4258,
'unwilling':4259,
'unwise':4260,
'upfront':4261,
'upgrade':4262,
'upgraded':4263,
'upgrades':4264,
'upgrading':4265,
'uploads':4266,
'upright':4267,
'upsetting':4268,
'urgence':4269,
'usability':4270,
'usable':4271,
'usage':4272,
'useful':4273,
'usefulbut':4274,
'usefulness':4275,
'usernames':4276,
'uses':4277,
'utah':4278,
'utilisation':4279,
'utilisations':4280,
'utilise':4281,
'utilising':4282,
'utilization':4283,
'utilize':4284,
'utilized':4285,
'utilizes':4286,
'utilizing':4287,
'utlized':4288,
'utmost':4289,
'v1+':4290,
'v2':4291,
'v2+':4292,
'v20':4293,
'v20+':4294,
'v21':4295,
'v21+':4296,
'v2final':4297,
'v3':4298,
'v3+':4299,
'v30':4300,
'v30+':4301,
'vacancies':4302,
'vacancy':4303,
'vague':4304,
'valeur':4305,
'validate':4306,
'validated':4307,
'validating':4308,
'validation':4309,
'validity':4310,
'validly':4311,
'vandalism':4312,
'variant':4313,
'variants':4314,
'variously':4315,
'varsity':4316,
'varying':4317,
'vendor':4318,
'vendors':4319,
'venturers':4320,
'verb':4321,
'verbatim':4322,
'verifiable':4323,
'verified':4324,
'verifying':4325,
'versioning':4326,
'vest':4327,
'vested':4328,
'vetted':4329,
'vicarious':4330,
'viewable':4331,
'vigorously':4332,
'violate':4333,
'violated':4334,
'violates':4335,
'violating':4336,
'violation':4337,
'violators':4338,
'virtualization':4339,
'virtue':4340,
'visibly':4341,
'voided':4342,
'voids':4343,
'voluminous':4344,
'voluntarily':4345,
'volunteer':4346,
'vulgar':4347,
'vulnerabilities':4348,
'vulnerability':4349,
'waivable':4350,
'waive':4351,
'waived':4352,
'waiver':4353,
'waivers':4354,
'waives':4355,
'waiving':4356,
'waranties':4357,
'waranty':4358,
'warrant':4359,
'warranted':4360,
'warrantee':4361,
'warrantees':4362,
'warranties':4363,
'warranting':4364,
'warrants':4365,
'warranty':4366,
'warrenties':4367,
'warrenty':4368,
'watermarks':4369,
'weaken':4370,
'weakening':4371,
'weaker':4372,
'weapon':4373,
'weapons':4374,
'welcomes':4375,
'wether':4376,
'whatever':4377,
'whatsoever':4378,
'whence':4379,
'whenever':4380,
'whereas':4381,
'whereby':4382,
'wherein':4383,
'whereof':4384,
'wherewithal':4385,
'whichever':4386,
'whining':4387,
'whitepapers':4388,
'whoever':4389,
'whole':4390,
'wholly':4391,
'whom':4392,
'whomever':4393,
'widest':4394,
'widgets':4395,
'wildcard':4396,
'wildcards':4397,
'wilful':4398,
'willful':4399,
'willfully':4400,
'willing':4401,
'willingness':4402,
'wishes':4403,
'withdraw':4404,
'withdrawal':4405,
'withdrawn':4406,
'withdraws':4407,
'withheld':4408,
'withhold':4409,
'withholding':4410,
'withholdings':4411,
'within':4412,
'withor':4413,
'withstanding':4414,
'wording':4415,
'wordmark':4416,
'workfile':4417,
'workgroup':4418,
'workings':4419,
'workload':4420,
'workloads':4421,
'workmanlike':4422,
'workmanship':4423,
'workspace':4424,
'workstation':4425,
'workstations':4426,
'worthiness':4427,
'worthwhile':4428,
'writers':4429,
'writes':4430,
'writings':4431,
'wrongdoing':4432,
'wrongful':4433,
'wrongly':4434,
'wxwidgets':4435,
'wxwindows':4436,
'x11':4437,
'x11r5':4438,
'x11r6':4439,
'xerographically':4440,
}


def build_dictionary_from_iterable(seq):
    """
    Return a new legalese mapping with regenerated tids from an iterable of tokens.
    """
    return {tok: tid for tid, tok in enumerate(sorted(seq))}


if __name__ == '__main__':
    with open(__file__) as of:
        of.write('{\n')
        for tok, tid in build_dictionary_from_iterable(common_license_words):
            of.write(f"'{tok}:{tid},\n")
        of.write('}\n')
