# coding: utf-8

"""
    ARLAS persistence API

    persistence REST services

    OpenAPI spec version: 13.0.0-beta.3
    Contact: contact@gisaia.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class PersistApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create(self, zone, key, value, **kwargs):
        """
        Store a new piece of data for the provided zone and key (auto generate id).
        Store a new piece of data for the provided zone and key (auto generate id).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create(zone, key, value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str zone: Zone of the document. (required)
        :param str key: The key of the data. (required)
        :param str value: Value to be persisted. (required)
        :param list[str] readers: Comma separated values of groups authorized to read the data.
        :param list[str] writers: Comma separated values of groups authorized to modify the data.
        :param bool pretty: Pretty print
        :return: DataWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_with_http_info(zone, key, value, **kwargs)
        else:
            (data) = self.create_with_http_info(zone, key, value, **kwargs)
            return data

    def create_with_http_info(self, zone, key, value, **kwargs):
        """
        Store a new piece of data for the provided zone and key (auto generate id).
        Store a new piece of data for the provided zone and key (auto generate id).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_with_http_info(zone, key, value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str zone: Zone of the document. (required)
        :param str key: The key of the data. (required)
        :param str value: Value to be persisted. (required)
        :param list[str] readers: Comma separated values of groups authorized to read the data.
        :param list[str] writers: Comma separated values of groups authorized to modify the data.
        :param bool pretty: Pretty print
        :return: DataWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone', 'key', 'value', 'readers', 'writers', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'zone' is set
        if ('zone' not in params) or (params['zone'] is None):
            raise ValueError("Missing the required parameter `zone` when calling `create`")
        # verify the required parameter 'key' is set
        if ('key' not in params) or (params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `create`")
        # verify the required parameter 'value' is set
        if ('value' not in params) or (params['value'] is None):
            raise ValueError("Missing the required parameter `value` when calling `create`")


        collection_formats = {}

        path_params = {}
        if 'zone' in params:
            path_params['zone'] = params['zone']
        if 'key' in params:
            path_params['key'] = params['key']

        query_params = []
        if 'readers' in params:
            query_params.append(('readers', params['readers']))
            collection_formats['readers'] = 'multi'
        if 'writers' in params:
            query_params.append(('writers', params['writers']))
            collection_formats['writers'] = 'multi'
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'value' in params:
            body_params = params['value']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/persist/resource/{zone}/{key}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DataWithLinks',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete(self, zone, key, **kwargs):
        """
        Delete an entry given its key and id.
        Delete an entry given its key and id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete(zone, key, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str zone: Zone of the document. (required)
        :param str key: The key of the data. (required)
        :param bool pretty: Pretty print
        :return: DataWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_with_http_info(zone, key, **kwargs)
        else:
            (data) = self.delete_with_http_info(zone, key, **kwargs)
            return data

    def delete_with_http_info(self, zone, key, **kwargs):
        """
        Delete an entry given its key and id.
        Delete an entry given its key and id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_with_http_info(zone, key, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str zone: Zone of the document. (required)
        :param str key: The key of the data. (required)
        :param bool pretty: Pretty print
        :return: DataWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone', 'key', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'zone' is set
        if ('zone' not in params) or (params['zone'] is None):
            raise ValueError("Missing the required parameter `zone` when calling `delete`")
        # verify the required parameter 'key' is set
        if ('key' not in params) or (params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `delete`")


        collection_formats = {}

        path_params = {}
        if 'zone' in params:
            path_params['zone'] = params['zone']
        if 'key' in params:
            path_params['key'] = params['key']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/persist/resource/{zone}/{key}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DataWithLinks',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_by_id(self, id, **kwargs):
        """
        Delete an entry given its key and id.
        Delete an entry given its key and id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_by_id(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The id of the data. (required)
        :param bool pretty: Pretty print
        :return: DataWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_by_id_with_http_info(id, **kwargs)
        else:
            (data) = self.delete_by_id_with_http_info(id, **kwargs)
            return data

    def delete_by_id_with_http_info(self, id, **kwargs):
        """
        Delete an entry given its key and id.
        Delete an entry given its key and id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_by_id_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The id of the data. (required)
        :param bool pretty: Pretty print
        :return: DataWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_by_id`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/persist/resource/id/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DataWithLinks',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def exists_by_id(self, id, **kwargs):
        """
        Check the existence of an entry given its id.
        Check the existence of an entry given its id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.exists_by_id(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The id of the data. (required)
        :param bool pretty: Pretty print
        :return: Exists
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.exists_by_id_with_http_info(id, **kwargs)
        else:
            (data) = self.exists_by_id_with_http_info(id, **kwargs)
            return data

    def exists_by_id_with_http_info(self, id, **kwargs):
        """
        Check the existence of an entry given its id.
        Check the existence of an entry given its id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.exists_by_id_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The id of the data. (required)
        :param bool pretty: Pretty print
        :return: Exists
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exists_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `exists_by_id`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/persist/resource/exists/id/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Exists',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def exists_by_key(self, zone, key, **kwargs):
        """
        Check the existence of an entry given its zone and key.
        Check the existence of an entry given its zone and key.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.exists_by_key(zone, key, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str zone: Zone of the document. (required)
        :param str key: The key of the data. (required)
        :param bool pretty: Pretty print
        :return: Exists
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.exists_by_key_with_http_info(zone, key, **kwargs)
        else:
            (data) = self.exists_by_key_with_http_info(zone, key, **kwargs)
            return data

    def exists_by_key_with_http_info(self, zone, key, **kwargs):
        """
        Check the existence of an entry given its zone and key.
        Check the existence of an entry given its zone and key.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.exists_by_key_with_http_info(zone, key, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str zone: Zone of the document. (required)
        :param str key: The key of the data. (required)
        :param bool pretty: Pretty print
        :return: Exists
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone', 'key', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exists_by_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'zone' is set
        if ('zone' not in params) or (params['zone'] is None):
            raise ValueError("Missing the required parameter `zone` when calling `exists_by_key`")
        # verify the required parameter 'key' is set
        if ('key' not in params) or (params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `exists_by_key`")


        collection_formats = {}

        path_params = {}
        if 'zone' in params:
            path_params['zone'] = params['zone']
        if 'key' in params:
            path_params['key'] = params['key']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/persist/resource/exists/{zone}/{key}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Exists',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_by_id(self, id, **kwargs):
        """
        Fetch an entry given its id.
        Fetch an entry given its id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_by_id(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The id of the data. (required)
        :param bool pretty: Pretty print
        :return: DataWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_by_id_with_http_info(id, **kwargs)
        else:
            (data) = self.get_by_id_with_http_info(id, **kwargs)
            return data

    def get_by_id_with_http_info(self, id, **kwargs):
        """
        Fetch an entry given its id.
        Fetch an entry given its id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_by_id_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The id of the data. (required)
        :param bool pretty: Pretty print
        :return: DataWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_by_id`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/persist/resource/id/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DataWithLinks',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_by_key(self, zone, key, **kwargs):
        """
        Fetch an entry given its zone and key.
        Fetch an entry given its zone and key.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_by_key(zone, key, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str zone: Zone of the document. (required)
        :param str key: The key of the data. (required)
        :param bool pretty: Pretty print
        :return: DataWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_by_key_with_http_info(zone, key, **kwargs)
        else:
            (data) = self.get_by_key_with_http_info(zone, key, **kwargs)
            return data

    def get_by_key_with_http_info(self, zone, key, **kwargs):
        """
        Fetch an entry given its zone and key.
        Fetch an entry given its zone and key.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_by_key_with_http_info(zone, key, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str zone: Zone of the document. (required)
        :param str key: The key of the data. (required)
        :param bool pretty: Pretty print
        :return: DataWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone', 'key', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'zone' is set
        if ('zone' not in params) or (params['zone'] is None):
            raise ValueError("Missing the required parameter `zone` when calling `get_by_key`")
        # verify the required parameter 'key' is set
        if ('key' not in params) or (params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_by_key`")


        collection_formats = {}

        path_params = {}
        if 'zone' in params:
            path_params['zone'] = params['zone']
        if 'key' in params:
            path_params['key'] = params['key']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/persist/resource/{zone}/{key}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DataWithLinks',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_groups_by_zone(self, zone, **kwargs):
        """
        Returns the users' groups allowed to interact with the given zone.
        Returns the users' groups allowed to interact with the given zone.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_groups_by_zone(zone, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str zone: Zone of the document. (required)
        :param bool pretty: Pretty print
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_groups_by_zone_with_http_info(zone, **kwargs)
        else:
            (data) = self.get_groups_by_zone_with_http_info(zone, **kwargs)
            return data

    def get_groups_by_zone_with_http_info(self, zone, **kwargs):
        """
        Returns the users' groups allowed to interact with the given zone.
        Returns the users' groups allowed to interact with the given zone.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_groups_by_zone_with_http_info(zone, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str zone: Zone of the document. (required)
        :param bool pretty: Pretty print
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_groups_by_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'zone' is set
        if ('zone' not in params) or (params['zone'] is None):
            raise ValueError("Missing the required parameter `zone` when calling `get_groups_by_zone`")


        collection_formats = {}

        path_params = {}
        if 'zone' in params:
            path_params['zone'] = params['zone']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/persist/groups/{zone}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[str]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list(self, zone, **kwargs):
        """
        Fetch a list of data related to a zone.
        Fetch a list of data related to a zone.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list(zone, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str zone: Zone of the document. (required)
        :param int size: Page Size
        :param int page: Page ID
        :param str order: Date sort order
        :param bool pretty: Pretty print
        :return: DataResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_with_http_info(zone, **kwargs)
        else:
            (data) = self.list_with_http_info(zone, **kwargs)
            return data

    def list_with_http_info(self, zone, **kwargs):
        """
        Fetch a list of data related to a zone.
        Fetch a list of data related to a zone.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_with_http_info(zone, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str zone: Zone of the document. (required)
        :param int size: Page Size
        :param int page: Page ID
        :param str order: Date sort order
        :param bool pretty: Pretty print
        :return: DataResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone', 'size', 'page', 'order', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'zone' is set
        if ('zone' not in params) or (params['zone'] is None):
            raise ValueError("Missing the required parameter `zone` when calling `list`")

        if 'size' in params and params['size'] < 1:
            raise ValueError("Invalid value for parameter `size` when calling `list`, must be a value greater than or equal to `1`")
        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `list`, must be a value greater than or equal to `1`")

        collection_formats = {}

        path_params = {}
        if 'zone' in params:
            path_params['zone'] = params['zone']

        query_params = []
        if 'size' in params:
            query_params.append(('size', params['size']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'order' in params:
            query_params.append(('order', params['order']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/persist/resources/{zone}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DataResource',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update(self, id, value, last_update, **kwargs):
        """
        Update an existing value.
        Update an existing value.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update(id, value, last_update, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The id of the data. (required)
        :param str value: Value to be persisted. (required)
        :param int last_update: Previous date value of last modification known by client. (required)
        :param str key: The key of the data.
        :param list[str] readers: Comma separated values of groups authorized to read the data.
        :param list[str] writers: Comma separated values of groups authorized to modify the data.
        :param bool pretty: Pretty print
        :return: DataWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_with_http_info(id, value, last_update, **kwargs)
        else:
            (data) = self.update_with_http_info(id, value, last_update, **kwargs)
            return data

    def update_with_http_info(self, id, value, last_update, **kwargs):
        """
        Update an existing value.
        Update an existing value.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_with_http_info(id, value, last_update, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The id of the data. (required)
        :param str value: Value to be persisted. (required)
        :param int last_update: Previous date value of last modification known by client. (required)
        :param str key: The key of the data.
        :param list[str] readers: Comma separated values of groups authorized to read the data.
        :param list[str] writers: Comma separated values of groups authorized to modify the data.
        :param bool pretty: Pretty print
        :return: DataWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'value', 'last_update', 'key', 'readers', 'writers', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update`")
        # verify the required parameter 'value' is set
        if ('value' not in params) or (params['value'] is None):
            raise ValueError("Missing the required parameter `value` when calling `update`")
        # verify the required parameter 'last_update' is set
        if ('last_update' not in params) or (params['last_update'] is None):
            raise ValueError("Missing the required parameter `last_update` when calling `update`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))
        if 'readers' in params:
            query_params.append(('readers', params['readers']))
            collection_formats['readers'] = 'multi'
        if 'writers' in params:
            query_params.append(('writers', params['writers']))
            collection_formats['writers'] = 'multi'
        if 'last_update' in params:
            query_params.append(('last_update', params['last_update']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'value' in params:
            body_params = params['value']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/persist/resource/id/{id}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DataWithLinks',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
