## Date Time Persian

This library helps you to convert the Gregorian date to Iranian date and the Iranian date to Gregorian date.  
You can also get the current time along with the date.

This library is supported by [Sarzemin Danesh](https://lssc.ir) team.

You can contact us by sending an email or following our official page on Instagram:

Email : [info@Lssc.ir](mailto:info@Lssc.ir)

Instagram : [@sarzamin.danesh](https://instagram.com/sarzamin.danesh)

---

## How it works?

Use the following command to install this library

```python
pip install DateTimePersian
```

## Use :

**Display the current date and time.**  
The output is a string.

```python
from DateTimePersian import DateTimePersian
get_date = DateTimePersian()
print(get_date)

_________ output _________
1401/9/5  15:09:48
```

**Only show the current date.**  
The output is a string.

```python
from DateTimePersian import DateTimePersian
get_date = DateTimePersian(TIME=False)
print(get_date)

_________ output _________
1401/9/5
```

**Only show the current time.**  
The output is a string.

```python
from DateTimePersian import DateTimePersian
get_date = DateTimePersian(DATE=False)
print(get_date)

_________ output _________
15:09:48
```

**Command today() :**

The desired function displays the current date in numeric and text formats. Two settings named date and type are defined for it.

Date = “fa” / “en”

Type = int / str

**Ex : Default**

```python
from DateTimePersian import DateTimePersian
get_date = DateTimePersian()
print(get_date.today())

_________ output _________
1401/9/5
```

**Ex : Type = str**

```python
from DateTimePersian import DateTimePersian
get_date = DateTimePersian()
print(get_date.today(Type = str))

_________ output _________
1401 آذر 5
```

**Ex : Date = “en”**

```python
from DateTimePersian import DateTimePersian
get_date = DateTimePersian()
print(get_date.today(Date = "en"))

_________ output _________
2022/11/26
```

**Ex: Date = “en” and Type = str**

```python
from DateTimePersian import DateTimePersian
get_date = DateTimePersian()
print(get_date.today(Date = "en", Type = str))

_________ output _________
2022 Nov 26
```

**Other commands:**

| value | command | type | output |
| --- | --- | --- | --- |
| Year | getYear() | object | int |
| Month | getMonth() | object | int |
| Day | getDay() | object | int |
| Hour | getHour() | object | str |
| Minutes | getMin() | object | str |
| Seconds | getSec() | object | str |
| leap year | lYear(year) | static | int |

**Example Leap Year :**

```python
from DateTimePersian import DateTimePersian

print(DateTimePersian.lYear(1401))

_________ output _________
350
```

**Example Convert Gregorian date to Iranian date :**

```python
from DateTimePersian import DateTimePersian
get_date = DateTimePersian()
print(get_date.C_EtoP(2022, 11, 26))

_________ output _________
1401/9/5
```

**Example Convert Iranian date to Gregorian date :**

```python
from DateTimePersian import DateTimePersian
get_date = DateTimePersian()
print(get_date.C_EtoP(1401, 9, 5))

_________ output _________
2022/11/26
```
