import cv2


# Border Constants
BORDERS = {
    "BORDER_CONSTANT": cv2.BORDER_CONSTANT,
    "BORDER_REPLICATE": cv2.BORDER_REPLICATE,
    "BORDER_REFLECT": cv2.BORDER_REFLECT,
    "BORDER_WRAP": cv2.BORDER_WRAP,
    "BORDER_REFLECT_101": cv2.BORDER_REFLECT_101,
    "BORDER_TRANSPARENT": cv2.BORDER_TRANSPARENT,
    "BORDER_DEFAULT": cv2.BORDER_DEFAULT,
    "BORDER_ISOLATED": cv2.BORDER_ISOLATED,
}

# Interpolation Constants
INTERPOLATION = {
    "INTER_NEAREST": cv2.INTER_NEAREST,
    "INTER_LINEAR": cv2.INTER_LINEAR,
    "INTER_AREA": cv2.INTER_AREA,
    "INTER_CUBIC": cv2.INTER_CUBIC,
    "INTER_LANCZOS4": cv2.INTER_LANCZOS4,
}

# Template Matching Constants
TM = {
    "TM_SQDIFF": cv2.TM_SQDIFF,
    "TM_SQDIFF_NORMED": cv2.TM_SQDIFF_NORMED,
    "TM_CCORR": cv2.TM_CCORR,
    "TM_CCORR_NORMED": cv2.TM_CCORR_NORMED,
    "TM_CCOEFF": cv2.TM_CCOEFF,
    "TM_CCOEFF_NORMED": cv2.TM_CCOEFF_NORMED,
}

# Retrieval Constants (for contours)
RETR = {
    "RETR_EXTERNAL": cv2.RETR_EXTERNAL,
    "RETR_LIST": cv2.RETR_LIST,
    "RETR_CCOMP": cv2.RETR_CCOMP,
    "RETR_TREE": cv2.RETR_TREE,
    "RETR_FLOODFILL": cv2.RETR_FLOODFILL,
}

# Chain approximation constants (for contours)
CHAIN_APPROX = {
    "CHAIN_APPROX_NONE": cv2.CHAIN_APPROX_NONE,
    "CHAIN_APPROX_SIMPLE": cv2.CHAIN_APPROX_SIMPLE,
    "CHAIN_APPROX_TC89_L1": cv2.CHAIN_APPROX_TC89_L1,
    "CHAIN_APPROX_TC89_KCOS": cv2.CHAIN_APPROX_TC89_KCOS,
}

# Normalization Constants
NORMS = {
    "NORM_MINMAX": cv2.NORM_MINMAX,
    "NORM_INF": cv2.NORM_INF,
    "NORM_L1": cv2.NORM_L1,
    "NORM_L2": cv2.NORM_L2,
}

# CV MAT_DEPTH
DEPTH = {
    "N/A (-1)": -1,
    "CV_8U": cv2.CV_8U,
    "CV_8S": cv2.CV_8S,
    "CV_16U": cv2.CV_16U,
    "CV_16S": cv2.CV_16S,
    "CV_32S": cv2.CV_32S,
    "CV_32F": cv2.CV_32F,
    "CV_64F": cv2.CV_64F,
}

# LINE_TYPES
LINES = {
    "8-Connected": cv2.LINE_8,
    "4-Connected": cv2.LINE_4,
    "FILLED": cv2.FILLED,
    "Anti Aliased": cv2.LINE_AA,
}


# HOUGH METHODS
HOUGH = {
    "HOUGH_STANDARD": cv2.HOUGH_STANDARD,
    "HOUGH_PROBABILISTIC": cv2.HOUGH_PROBABILISTIC,
    "HOUGH_MULTI_SCALE": cv2.HOUGH_MULTI_SCALE,
    "HOUGH_GRADIENT": cv2.HOUGH_GRADIENT,
    "HOUGH_GRADIENT_ALT": cv2.HOUGH_GRADIENT_ALT,
}


# MORPH SHAPES
MORPH_SHAPES = {
    "MORPH_RECT": cv2.MORPH_RECT,
    "MORPH_CROSS": cv2.MORPH_CROSS,
    "MORPH_ELLIPSE": cv2.MORPH_ELLIPSE,
}

# TERMINATION CRITERIA
TERM = {
    "TERM_CRITERIA_EPS": cv2.TERM_CRITERIA_EPS,
    "TERM_CRITERIA_MAX_ITER": cv2.TERM_CRITERIA_MAX_ITER,
    "EPS + MAX_ITER (Either)": cv2.TERM_CRITERIA_EPS + cv2.TERM_CRITERIA_MAX_ITER,
}

# KMEANS FLAGS
KFLAGS = {
    "KMEANS_PP_CENTERS": cv2.KMEANS_PP_CENTERS,
    "KMEANS_RANDOM_CENTERS": cv2.KMEANS_RANDOM_CENTERS,
}

# COLOR_BGR2*
COLOR_BGR2 = {
    "BGR": "BGR",
    "HSV": cv2.COLOR_BGR2HSV,
    "HLS": cv2.COLOR_BGR2HLS,
    "LAB": cv2.COLOR_BGR2LAB,
    "YUV": cv2.COLOR_BGR2YUV,
    "YCrCb": cv2.COLOR_BGR2YCrCb,
}

# COLOR MAP
COLOR_MAP = {
    "BGR": ("B", "G", "R"),
    cv2.COLOR_BGR2HSV: ("H", "S", "V"),
    cv2.COLOR_BGR2HLS: ("H", "L", "S"),
    cv2.COLOR_BGR2LAB: ("L", "A", "B"),
    cv2.COLOR_BGR2YUV: ("Y", "U", "V"),
    cv2.COLOR_BGR2YCrCb: ("Y", "Cr", "Cb"),
}
