<p align="center">
	<img src="https://raw.githubusercontent.com/DeepRegNet/DeepReg/main/docs/asset/deepreg_logo_purple_beta.svg" alt="deepreg_logo" title="DeepReg" width="200" />
</p>

# DeepReg

[![Build Status](https://travis-ci.org/DeepRegNet/DeepReg.svg?branch=main)](https://travis-ci.org/DeepRegNet/DeepReg)
[![Documentation Status](https://readthedocs.org/projects/deepreg/badge/?version=latest)](https://deepreg.readthedocs.io/en/latest/?badge=latest)
[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![codecov](https://codecov.io/gh/DeepRegNet/DeepReg/branch/main/graph/badge.svg)](https://codecov.io/gh/DeepRegNet/DeepReg)

**DeepReg is a freely available, community-supported open-source toolkit for research
and education in medical image registration using deep learning.**

- TensorFlow2-based for efficient training and rapid deployment;
- Implementing major unsupervised and weakly-supervised algorithms, with their
  combinations and variants;
- Focusing on growing and diverse clinical applications, with all DeepReg Demos using
  open-accessible data;
- Simple built-in command line tools requiring minimal programming and scripting;
- Open, permissible and research-and-education-driven, under the Apache 2.0 license.

> _DeepReg<sup>beta</sup> will be released in Autumn 2020 - however, many tutorials,
> demos and much of the core functionality are already accessible._

---

## Getting Started

- [Documentation, tutorials and a quick start guide](https://deepreg.readthedocs.io/)
- [DeepReg Demos](https://deepreg.readthedocs.io/en/latest/demo/introduction.html)
- Code: https://github.com/DeepRegNet/DeepReg
- Issue tracker: https://github.com/DeepRegNet/DeepReg/issues/new/choose
- Website: http://deepreg.net/

## Contributing

Get involved, and help make DeepReg better!

For guidance on making a contribution to DeepReg, see the
[contribution guidelines](https://deepreg.readthedocs.io/en/latest/contributing/code.html).

If you identified a registration application with openly accessible data, please
consider
[contributing a DeepReg Demo](https://deepreg.readthedocs.io/en/latest/contributing/demo.html).

## MICCAI 2020 Educational Challenge

The MICCAI Educational Challenge notebook can be accessed
[here](https://github.com/DeepRegNet/DeepReg/blob/main/docs/Intro_to_Medical_Image_Registration.ipynb)
or run it on
[Colab](https://colab.research.google.com/github/DeepRegNet/DeepReg/blob/main/docs/Intro_to_Medical_Image_Registration.ipynb).
