"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ecs = require("@aws-cdk/aws-ecs");
const iam = require("@aws-cdk/aws-iam");
/**
 * Batch Job Task Definition
 *
 * Defines a Batch Job Task Definition. The properties of this task definition mirrors
 * those of an {@link ecs.ContainerDefinition}. This class is a wrapper on that structure.
 */
class TaskDefinition {
    constructor(props) {
        this.executionRole = props.executionRole;
    }
    /**
     * Internal function to allow the Batch Job task defintion
     * to match the CDK requirements of an EC2 task definition.
     *
     * @internal
     */
    // tslint:disable-next-line: no-empty
    _linkContainer() { }
    /**
     * Retrieves the execution role for this task definition
     */
    obtainExecutionRole() {
        return this.executionRole;
    }
}
/**
 * The configuration for creating a batch container image.
 */
class JobDefinitionImageConfig {
    constructor(scope, container) {
        const config = this.bindImageConfig(scope, container);
        this.imageName = config.imageName;
    }
    bindImageConfig(scope, container) {
        return container.image.bind(scope, new ecs.ContainerDefinition(scope, 'Resource-Batch-Job-Container-Definition', {
            command: container.command,
            cpu: container.vcpus,
            image: container.image,
            environment: container.environment,
            linuxParameters: container.linuxParams,
            memoryLimitMiB: container.memoryLimitMiB,
            privileged: container.privileged,
            readonlyRootFilesystem: container.readOnly,
            gpuCount: container.gpuCount,
            user: container.user,
            taskDefinition: new TaskDefinition({
                executionRole: container.jobRole || new iam.LazyRole(scope, 'Resource-Batch-Task-Definition-Role', {
                    assumedBy: new iam.ServicePrincipal('batch.amazonaws.com'),
                }),
            }),
        }));
    }
}
exports.JobDefinitionImageConfig = JobDefinitionImageConfig;
//# sourceMappingURL=data:application/json;base64,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