from cosmos_proto import cosmos_pb2 as _cosmos_pb2
from cosmos.group.v1 import types_pb2 as _types_pb2
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union
DESCRIPTOR: _descriptor.FileDescriptor

class EventCreateGroup(_message.Message):
    __slots__ = ['group_id']
    GROUP_ID_FIELD_NUMBER: _ClassVar[int]
    group_id: int

    def __init__(self, group_id: _Optional[int]=...) -> None:
        ...

class EventCreateGroupPolicy(_message.Message):
    __slots__ = ['address']
    ADDRESS_FIELD_NUMBER: _ClassVar[int]
    address: str

    def __init__(self, address: _Optional[str]=...) -> None:
        ...

class EventExec(_message.Message):
    __slots__ = ['logs', 'proposal_id', 'result']
    LOGS_FIELD_NUMBER: _ClassVar[int]
    PROPOSAL_ID_FIELD_NUMBER: _ClassVar[int]
    RESULT_FIELD_NUMBER: _ClassVar[int]
    logs: str
    proposal_id: int
    result: _types_pb2.ProposalExecutorResult

    def __init__(self, proposal_id: _Optional[int]=..., result: _Optional[_Union[_types_pb2.ProposalExecutorResult, str]]=..., logs: _Optional[str]=...) -> None:
        ...

class EventLeaveGroup(_message.Message):
    __slots__ = ['address', 'group_id']
    ADDRESS_FIELD_NUMBER: _ClassVar[int]
    GROUP_ID_FIELD_NUMBER: _ClassVar[int]
    address: str
    group_id: int

    def __init__(self, group_id: _Optional[int]=..., address: _Optional[str]=...) -> None:
        ...

class EventSubmitProposal(_message.Message):
    __slots__ = ['proposal_id']
    PROPOSAL_ID_FIELD_NUMBER: _ClassVar[int]
    proposal_id: int

    def __init__(self, proposal_id: _Optional[int]=...) -> None:
        ...

class EventUpdateGroup(_message.Message):
    __slots__ = ['group_id']
    GROUP_ID_FIELD_NUMBER: _ClassVar[int]
    group_id: int

    def __init__(self, group_id: _Optional[int]=...) -> None:
        ...

class EventUpdateGroupPolicy(_message.Message):
    __slots__ = ['address']
    ADDRESS_FIELD_NUMBER: _ClassVar[int]
    address: str

    def __init__(self, address: _Optional[str]=...) -> None:
        ...

class EventVote(_message.Message):
    __slots__ = ['proposal_id']
    PROPOSAL_ID_FIELD_NUMBER: _ClassVar[int]
    proposal_id: int

    def __init__(self, proposal_id: _Optional[int]=...) -> None:
        ...

class EventWithdrawProposal(_message.Message):
    __slots__ = ['proposal_id']
    PROPOSAL_ID_FIELD_NUMBER: _ClassVar[int]
    proposal_id: int

    def __init__(self, proposal_id: _Optional[int]=...) -> None:
        ...