from setuptools import setup, find_namespace_packages

# reading long description from file
# with open('DESCRIPTION.txt') as file:
#     long_description = file.read()


# specify requirements of your package here
REQUIREMENTS = [
    "SQLAlchemy==1.3.19",
    "Flask-SQLAlchemy==2.4.4",
    "flask-marshmallow==0.14.0",
    "confluent-kafka==1.9.0",
    "requests==2.27.1",
    "python-dotenv==0.20.0",
]

# some more details
CLASSIFIERS = [
    'Development Status :: 4 - Beta',
    'Intended Audience :: Developers',
    'Topic :: Internet',
    'License :: OSI Approved :: MIT License',
    'Programming Language :: Python',
    'Programming Language :: Python :: 3',
    'Programming Language :: Python :: 3.3',
    'Programming Language :: Python :: 3.4',
    'Programming Language :: Python :: 3.5',
    'Programming Language :: Python :: 3.6',
]

setup(
    name='wedeliver_core',
    version='0.0.8',
    description='weDeliverCore package',
    long_description="""# Markdown supported!\n\n* weDeliverCore\n* List of features\n""",
    long_description_content_type='text/markdown',
    url='https://www.wedeliverapp.com/',
    author='Eyad Farra',
    author_email='info@wedeliverapp.com',
    license='MIT',
    packages=find_namespace_packages(include=['wedeliver_core', 'wedeliver_core.*']),  # ['wedeliver_core'],
    classifiers=CLASSIFIERS,
    install_requires=REQUIREMENTS
)
