# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['pytest_metadata', 'pytest_metadata.ci']

package_data = \
{'': ['*']}

install_requires = \
['pytest>=3.0.0,<8.0.0']

entry_points = \
{'pytest11': ['metadata = pytest_metadata.plugin']}

setup_kwargs = {
    'name': 'pytest-metadata',
    'version': '2.0.4',
    'description': 'pytest plugin for test session metadata',
    'long_description': 'pytest-metadata\n===============\n\npytest-metadata is a plugin for `pytest <http://pytest.org>`_ that provides\naccess to test session metadata.\n\n.. image:: https://img.shields.io/badge/license-MPL%202.0-blue.svg\n   :target: https://github.com/pytest-dev/pytest-metadata/blob/master/LICENSE\n   :alt: License\n.. image:: https://img.shields.io/pypi/v/pytest-metadata.svg\n   :target: https://pypi.python.org/pypi/pytest-metadata/\n   :alt: PyPI\n.. image:: https://img.shields.io/travis/pytest-dev/pytest-metadata.svg\n   :target: https://travis-ci.org/pytest-dev/pytest-metadata/\n.. image:: https://img.shields.io/badge/code%20style-black-000000.svg\n   :target: https://github.com/ambv/black\n   :alt: Travis\n.. image:: https://img.shields.io/github/issues-raw/pytest-dev/pytest-metadata.svg\n   :target: https://github.com/pytest-dev/pytest-metadata/issues\n   :alt: Issues\n.. image:: https://img.shields.io/requires/github/pytest-dev/pytest-metadata.svg\n   :target: https://requires.io/github/pytest-dev/pytest-metadata/requirements/?branch=master\n   :alt: Requirements\n\nRequirements\n------------\n\nYou will need the following in order to use pytest-metadata:\n\n- Python 3.7+ or PyPy3\n\nInstallation\n------------\n\nTo install pytest-metadata:\n\n.. code-block:: bash\n\n  $ pip install pytest-metadata\n\nContributing\n------------\n\nWe welcome contributions.\n\nTo learn more, see `Development <https://github.com/pytest-dev/pytest-metadata/blob/master/development.rst>`_\n\nAvailable metadata\n------------------\n\nThe following metadata is gathered by this plugin:\n\n========  =============== ===================================\nKey       Description     Example\n========  =============== ===================================\nPython    Python version  3.6.4\nPlatform  Platform        Darwin-17.4.0-x86_64-i386-64bit\nPackages  pytest packages {\'py\': \'1.5.2\', \'pytest\': \'3.4.1\'}\nPlugins   pytest plugins  {\'metadata\': \'1.6.0\'}\n========  =============== ===================================\n\nAdditional metadata\n-------------------\n\nYou can provide your own metadata (key, value pair) by specifying ``--metadata`` on the commandline::\n\n   pytest --metadata foo bar\n\nNote: You can provide multiple sets of ``--metadata``::\n\n   pytest --metadata foo bar --metadata baz zoo\n\nThere\'s also the possibility of passing in metadata as a JSON string::\n\n    pytest --metadata-from-json \'{"cat_says": "bring the cat nip", "human_says": "yes kitty"}\'\n\nAlternatively a JSON can be read from a given file::\n\n    pytest --metadata-from-json-file path/to/valid/file.json\n\nContinuous integration\n----------------------\n\nWhen run in a continuous integration environment, additional metadata is added\nfrom environment variables. Below is a list of the supported continuous\nintegration providers, along with links to the environment variables that are\nadded to metadata if they\'re present.\n\n* `AppVeyor <https://www.appveyor.com/docs/environment-variables/>`_\n* `Bitbucket <https://confluence.atlassian.com/bitbucket/environment-variables-794502608.html>`_\n* `CircleCI <https://circleci.com/docs/1.0/environment-variables/>`_\n* `GitLab CI <http://docs.gitlab.com/ce/ci/variables/README.html>`_\n* `Jenkins <https://wiki.jenkins-ci.org/display/JENKINS/Building+a+software+project#Buildingasoftwareproject-JenkinsSetEnvironmentVariables>`_\n* `TaskCluster <https://docs.taskcluster.net/reference/workers/docker-worker/environment>`_\n* `Travis CI <https://docs.travis-ci.com/user/environment-variables/>`_\n\nNote that if you\'re using `Tox <http://tox.readthedocs.io/>`_ to run your tests\nthen you will need to `pass down any additional environment variables <http://tox.readthedocs.io/en/latest/example/basic.html#passing-down-environment-variables>`_\nfor these to be picked up.\n\nViewing metadata\n----------------\n\nIf you pass ``--verbose`` on the command line when running your tests, then the\nmetadata will be displayed in the terminal report header::\n\n  pytest --verbose\n  ============================ test session starts ============================\n  platform darwin -- Python 3.6.4, pytest-3.4.1, py-1.5.2, pluggy-0.6.0 -- /usr/bin/python\n  cachedir: .pytest_cache\n  metadata: {\'Python\': \'3.6.4\', \'Platform\': \'Darwin-17.4.0-x86_64-i386-64bit\', \'Packages\': {\'pytest\': \'3.4.1\', \'py\': \'1.5.2\', \'pluggy\': \'0.6.0\'}, \'Plugins\': {\'metadata\': \'1.6.0\'}}\n  plugins: metadata-1.6.0\n\nIncluding metadata in Junit XML\n-------------------------------\n\nPytest-metadata provides the session scoped fixture :code:`include_metadata_in_junit_xml` that you may use to include any metadata in Junit XML as ``property`` tags.\nFor example the following test module\n\n.. code-block:: python\n\n  import pytest\n\n  pytestmark = pytest.mark.usefixtures(\'include_metadata_in_junit_xml\')\n\n  def test():\n      pass\n\nwhen called with\n\n.. code-block:: bash\n\n  pytest --metadata Daffy Duck --junit-xml=results.xml\n\nwould produce the following XML\n\n.. code-block:: xml\n\n  <?xml version="1.0" encoding="utf-8"?>\n  <testsuites>\n    <testsuite name="pytest" errors="0" failures="0" skipped="0" tests="1" time="0.009" timestamp="2020-11-27T06:38:44.407674" hostname="sam">\n      <properties>\n        <property name="Daffy" value="Duck"/>\n  ...\n\nAccessing metadata\n------------------\n\nTo add/modify/delete metadata at the end of metadata collection, you can use the ``pytest_metadata`` hook:\n\n.. code-block:: python\n\n  import pytest\n  @pytest.mark.optionalhook\n  def pytest_metadata(metadata):\n      metadata.pop("password", None)\n\nTo access the metadata from a test or fixture, you can use the ``metadata``\nfixture:\n\n.. code-block:: python\n\n  def test_metadata(metadata):\n      assert \'metadata\' in metadata[\'Plugins\']\n\nTo access the metadata from a plugin, you can use the ``_metadata`` attribute of\nthe ``config`` object. This can be used to read/add/modify the metadata:\n\n.. code-block:: python\n\n  def pytest_configure(config):\n    if hasattr(config, \'_metadata\'):\n        config._metadata[\'foo\'] = \'bar\'\n\nPlugin integrations\n-------------------\n\nHere\'s a handy list of plugins that either read or contribute to the metadata:\n\n* `pytest-base-url <https://pypi.python.org/pypi/pytest-base-url/>`_ - Adds the\n  base URL to the metadata.\n* `pytest-html <https://pypi.python.org/pypi/pytest-html/>`_ - Displays the\n  metadata at the start of each report.\n* `pytest-reporter-html1 <https://pypi.org/project/pytest-reporter-html1/>`_ -\n  Presents metadata as part of the report.\n* `pytest-selenium <https://pypi.python.org/pypi/pytest-selenium/>`_ - Adds the\n  driver, capabilities, and remote server to the metadata.\n\nResources\n---------\n\n- `Release Notes <http://github.com/davehunt/pytest-metadata/blob/master/CHANGES.rst>`_\n- `Issue Tracker <http://github.com/davehunt/pytest-metadata/issues>`_\n- `Code <http://github.com/davehunt/pytest-metadata/>`_\n',
    'author': 'Dave Hunt',
    'author_email': 'dhunt@mozilla.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/pytest-dev/pytest-metadata',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
