/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.easy.CategoricalEncoder;
import java.util.HashMap;
import java.util.Map;

public class OneHotEncoder
implements CategoricalEncoder {
    private final String columnName;
    private final int targetIndex;
    private final Map<String, Integer> domainMap;

    OneHotEncoder(String columnName, int targetIndex, String[] domainValues) {
        this.columnName = columnName;
        this.targetIndex = targetIndex;
        this.domainMap = new HashMap<String, Integer>(domainValues.length);
        for (int j2 = 0; j2 < domainValues.length; ++j2) {
            this.domainMap.put(domainValues[j2], j2);
        }
    }

    @Override
    public boolean encodeCatValue(String levelName, double[] rawData) {
        Integer levelIndex = this.domainMap.get(levelName);
        if (levelIndex == null) {
            return false;
        }
        this.makeHot(levelIndex, rawData);
        return true;
    }

    @Override
    public void encodeNA(double[] rawData) {
        this.makeHot(this.domainMap.size(), rawData);
    }

    private void makeHot(int index, double[] rawData) {
        for (int i2 = 0; i2 < this.domainMap.size() + 1; ++i2) {
            rawData[this.targetIndex + i2] = index == i2 ? 1.0 : 0.0;
        }
    }

    public String toString() {
        return "OneHotEncoder{columnName='" + this.columnName + '\'' + ", targetIndex=" + this.targetIndex + ", domainMap=" + this.domainMap + '}';
    }
}

