/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.word2vec;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.word2vec.Word2VecMojoModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;

public class Word2VecMojoReader
extends ModelMojoReader<Word2VecMojoModel> {
    @Override
    public String getModelName() {
        return "Word2Vec";
    }

    @Override
    protected void readModelData() throws IOException {
        int vecSize;
        int vocabSize = this.readkv("vocab_size", -1);
        ((Word2VecMojoModel)this._model)._vecSize = vecSize = this.readkv("vec_size", -1).intValue();
        ((Word2VecMojoModel)this._model)._embeddings = new HashMap(vocabSize);
        byte[] rawVectors = this.readblob("vectors");
        if (rawVectors.length != vocabSize * vecSize * 4) {
            throw new IOException("Corrupted vector representation, unexpected size: " + rawVectors.length);
        }
        ByteBuffer bb = ByteBuffer.wrap(rawVectors);
        Iterator<String> vocabulary = this.readtext("vocabulary", true).iterator();
        while (vocabulary.hasNext()) {
            float[] vec = new float[vecSize];
            for (int i2 = 0; i2 < vecSize; ++i2) {
                vec[i2] = bb.getFloat();
            }
            ((Word2VecMojoModel)this._model)._embeddings.put(vocabulary.next(), vec);
        }
        if (((Word2VecMojoModel)this._model)._embeddings.size() != vocabSize) {
            throw new IOException("Corrupted model, unexpected number of words: " + ((Word2VecMojoModel)this._model)._embeddings.size());
        }
    }

    @Override
    protected Word2VecMojoModel makeModel(String[] columns, String[][] domains, String responseColumn) {
        return new Word2VecMojoModel(columns, domains, responseColumn);
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }
}

