/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.utils.SubParser;
import org.joda.time.DateTimeFieldType;
import org.joda.time.format.DateTimeParserBucket;

class Year2DigitISOParse
extends SubParser {
    Year2DigitISOParse() {
    }

    @Override
    public int estimateParsedLength() {
        return 2;
    }

    @Override
    public int parseInto(DateTimeParserBucket bucket, String text, int position) {
        int n2;
        if (position < 0) {
            throw new IllegalArgumentException("position cannot be negative");
        }
        if (position > text.length() - 2) {
            return ~position;
        }
        char c2 = text.charAt(position);
        char c3 = text.charAt(position + 1);
        if (c2 < '0' || c2 > '9') {
            return ~position;
        }
        if (c3 < '0' || c3 > '9') {
            return ~(position + 1);
        }
        n2 += (n2 = (c2 - 48) * 10 + c3 - 48) < 69 ? 2000 : 1900;
        int n3 = position + 2;
        if (this.child != null) {
            n3 = this.child.parseInto(bucket, text, n3);
        } else if (this.ignoreSuffix) {
            n3 = text.length();
        }
        if (n3 >= 0) {
            bucket.saveField(DateTimeFieldType.weekyear(), n2);
        }
        return n3;
    }
}

