# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'todonepy'}

packages = \
['commands', 'helpers', 'subcommands']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['to = __init__:to']}

setup_kwargs = {
    'name': 'todonepy',
    'version': '4.0.9',
    'description': 'A developed command-line task manager',
    'long_description': "ToDonePY - A basic command-line tast manager\n============================================\n\n.. image:: https://www.repostatus.org/badges/latest/active.svg\n   :alt: Project Status: Active – The project has reached a stable, usable state and is being actively developed.\n   :target: https://www.repostatus.org/#active\n\n.. image:: https://img.shields.io/badge/License-GPLv3-blue.svg\n   :target: https://www.gnu.org/licenses/gpl-3.0\n   :alt: GPLv3 License\n   \n.. image:: https://img.shields.io/pypi/v/todonepy\n   :target: https://pypi.org/project/todonepy\n   :alt: PyPI\n\n.. image:: https://img.shields.io/pypi/pyversions/todonepy\n   :target: https://pypi.org/project/todonepy\n   :alt: PyPI - Python Versions\n\n.. image:: https://travis-ci.org/rbpatt2019/ToDonePy.svg?branch=master\n   :target: https://travis-ci.org/rbpatt2019/ToDonePy\n   :alt: Build Status\n   \n.. image:: https://readthedocs.org/projects/todonepy/badge/?version=latest\n   :target: https://todonepy.readthedocs.io/en/latest/?badge=latest\n   :alt: Documentation Status\n   \n.. image:: https://codecov.io/gh/rbpatt2019/ToDonePy/branch/master/graph/badge.svg\n   :target: https://codecov.io/gh/rbpatt2019/ToDonePy\n   :alt: Code Coverage\n\n.. image:: https://pyup.io/repos/github/rbpatt2019/ToDonePy/shield.svg\n     :target: https://pyup.io/repos/github/rbpatt2019/ToDonePy/\n     :alt: Updates\n\n.. image:: https://img.shields.io/badge/code%20style-black-000000.svg\n   :target: https://github.com/ambv/black\n   :alt: Codestyle: Black\n\nIntroduction\n------------\n\nMove your ToDo's to ToDone's!\n\n`ToDonePy <https://github.com/rbpatt2019/ToDonePy/>`_ is a command-line interface for managing your to do list. It provides a root command, `to`_, and three subcommands:\n\n- `to do`_ adds a new task to your list at different priorities.\n- `to doing`_ shows you what you should be doing.\n- `to done`_ removes a completed tast from your list.\n\nDocs and Code\n-------------\n\nThe documentation lives at https://ToDonePy.readthedocs.io/ .\n\nThe code lives at https://github.com/rbpatt2019/ToDonePy/ .\n\nInstallation\n------------\n\nThis project has been released on `PyPI <https://pypi.org>`_, so it can be installed with `pip`:\n\n.. code:: sh\n\n        pip install -U ToDonePy\n\nAlternatively, you can install the project manually by cloning the  `repo <https://github.com/rbpatt2019/ToDonePy>`_, and using the included Makefile.\n\n.. code:: sh\n\n    git clone https://github.com/rbpatt2019/ToDonePy/\n    make install\n    \nIf you would like to contribute to development, the install instructions are slightly different. Please see the section on `contributing <https://todonepy.readthedocs.io/en/latest/contributing.html#contributing>`_.\n\nUsage\n-----\n\n.. _to:\n\nThe base command `to`\n~~~~~~~~~~~~~~~~~~~~~\n\nThe base command `to` has a few useful features of its own. To see what version of the command you are using, call:\n\n.. code:: sh\n\n        to --version\n\nAs with any good command-line tool, you can get some basic help by calling:\n\n.. code:: sh\n\n        to --help\n\nYou can get help on any subcommand by calling `--help` after that subcommand. For example, to get help with `to doing`, call:\n\n.. code:: sh\n\n        to doing --help\n\nUnder the hood, `to` creates a Filer object that holds the information on the file you use for tracking you're TODOs. If you don't specify a file to use, it will default to `$HOME/.TODO.tsv`. If you would like to specify a different file to use, than call the command with the `--file/-f` flag like so:\n\n.. code:: sh\n        \n        to --file /path/to/your/TODO.tsv subcommand\n\n.. note:: If you plan to use a file other than the default, I recommend setting it by creating the environmental variable, `TODO_LIST`. \n\nRegardless of whether you use the default or not, calling `to` with any of the subcommands - `do`, `doing`, or `done` - will check to see if the file exists. If it does exist, `to` then pass the path on to the subcommand. If it doesn't exist, then `to` creates an empty file which it then passes on to the subcommand.\n\nAs a final note, it is worth emphasising that the contex object is only created when `to` is invoked with a subcommand. So, after a clean install, calling `to --help` or `to --version` will NOT create your `TODO.tsv` file, even if you pass the `--file/-f` flag. However, call `to do`, and it will pop into existence.\n\n.. _to do:\n\nAdding new tasks with `to do`\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\nTo begin tracking your TODOs, call the command as follows:\n\n.. code:: sh\n\n        to do rank tasks\n\n`to` is the base command. It must be invoked to use any part of the tool. The `do` subcommand is how you add tasks to your `TODO.tsv`. After `to do`, there are two mandatory arguments: `rank` and `tasks`. The first argument is `rank`. `rank` should be a number indicating how important this task is. 1 is very important, 2 less so, etc. Though nothing explicitly bans you from using as many ranks as you want, I would reccomed using 3 for high, medium, and low priority. \n\nThe second argument is `tasks`. Here, specify what it is you need to do. If your task takes more than one word to describe, then you need to include it in quotes. `tasks` supports an indefinite number of arguments, from 1 to as many as you want. \n\n.. note:: All tasks specified will be added at the same rank, so only combine tasks you want to give the same priority.\n\nSo, if you wanted to remind yourself to write an abstract for that paper you have been delaying and to email your boss, call:\n\n.. code:: sh\n        \n        to do 1 'Write my abstract' 'Email boss'\n\nThis will create `TODO.tsv` if it does not already exist, and add 'Write my abstract' and 'Email boss', both with a rank of one, to `TODO.tsv`. `to do` also logs the date and time the task was added, so that you always know how old a task is.\n\nSometimes, you want to sort your tasks as you add them. You can do that with the `--sort/-s` option. This specifies how to sort your list after a new task is added. It must be one of: `[rank, date, both, none]`. `both` sorts by rank and then date, and `none` does not sort, simply appending tasks to the end of your list. It defaults to `none`, on the grounds its better not to do something unless you ask. `Explicit is better than implicit <https://www.python.org/dev/peps/pep-0020/>`_, as they say. If you just wanted to sort by date after adding a new task, then you could call:\n\n.. code:: sh\n\n        to --sort do date 1 'Important work'\n\n.. note:: `--sort` follows the root command `to` as it directly impacts the file and is an option accessible to all subcommands.\n\n\n.. _to doing:\n\nKeeping track of tasks with `to doing`\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\nOnce you have added some TODOs to your list, you need to make sure you stay on top of them. To see what needs to be done, call:\n\n.. code:: sh\n\n        to doing\n\nThis should echo the 5 tasks at the top of your `TODO.tsv` to the terminal.\n\nYou can specify how to sort your tasks by passing the `--sort/-s` flag with one of: `[rank, date, both, none]`. It defaults to `none`, thus preserving the order in your `TODO.tsv`. Any call to sort will also change the order currently in your `TODO.tsv`, not just the order they are echoed.\n\nAlso, specifying the `--number/-n` flag will let you change how many tasks are returned, and it defaults to 5. So, if you want to return 3 tasks sorted by rank, call:\n\n.. code:: sh\n        \n        to -s rank doing -n 3\n\n.. note:: Remember, `-s` is a root command option!\n\nMaybe you prefer a graphic reminder instead of echoing in the terminal - I find this useful for spawning reminders while I am coding in VIM. `ToDonePy` has that covered, too! Just call:\n\n.. code:: sh\n        \n        to doing --reminder\n\nto trigger a notification window. By default, it stays up for 5 seconds. Currently, you can not set the time, though that's in the works!\n\n.. Note:: The graphic flag makes a system call to `notify-send`. If you don't have that installed, the command will fail. It should be installed on most Linux systems, though.\n\nSometimes, you might want to correct an error, change a priority, or in some way edit yout `TODO.tsv`. In these cases, you can call `to doing` in editor mode:\n\n.. code:: sh\n\n        to doing --edit\n        \nThis will open `TODO.tsv` in your system editor. Where you would see something like below, if you have been following along:\n\n.. code:: sh\n\n        ID      Rank    Date    Task\n        1       1       YYYY-MM-DD HH:MM     Write my abstract\n        2       1       YYYY-MM-DD HH:MM     Email boss\n        3       1       YYYY-MM-DD HH:MM     Important work\n\nNothing fancy, just a plain tsv with `ID` in the first column, `rank` in the second column, the date/time of addition in the third, and `task` in the fourth. Now, you can make all the changes you want, then save and close the file to return to the command line.\n\nCalling `--edit` will trump any calls to `sort` or `number` made in the same command.      \n\nThis call opens the default editor on your system, usually defined by the environmental variable EDITOR for Linux systems. If this variable is undefined, then it defaults to VIM - which should be your choice anyways! :P If that command is not found, then it will thros an OSError.\n\n\n.. _to done:\n\nCompleting your tasks with `to done`\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\nAfter the end of a productive work session, you have completed a task from your list. Boom! Time well spent. To remove it from your `TODO.tsv`, call:\n\n.. code:: sh\n\n        to done tasks\n\nAs with `to do`_, `to done` suports an indefinite number of tasks, as long as all multi-word tasks are enclosed in quotes. For example, if you emailed your boss that finished abstract, then you can remove those tasks like so:\n\n.. code:: sh\n        \n        to done 'Write my abstract' 'Email boss'\n\nIf `to done` finds these tasks in your `TODO.tsv`, it'll remove them! If it can't find the tasks, it will print a message saying which ones couldn't be removed.\n\nUnder the hood, `to done` creates a temp file, then performs a string match to each line of your `TODO.tsv`. If a perfect match to ''task'' is not in a line, that line is written to the temp file. If ''task'' is in a line, that line is skipped. This way, the temp file ends up containing only those tasks that aren't completed. Once every line is checked, the temp file replaces `TODO.tsv` with its contents. Task deleted!\n\n.. Warning:: If two different tasks contain the same text, they will both be deleted!\n\nKnown Bugs\n----------\n- Test hang when testing \n\nRecent Changes\n--------------\n\nPlease see the `CHANGELOG <https://github.com/rbpatt2019/ToDonePy/blob/master/CHANGELOG.rst>`_\n\nNext Steps\n----------\n\n- Addition of TODOs from file parsing\n- Support removal of tasks by task ID number\n- Full, OS-independent graphic interface\n\n",
    'author': 'rbpatt2019',
    'author_email': 'rb.patterson.cross@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://pypi.org/project/ToDonePy/',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
