"""
    Global Filings API

     The Filings API provides a comprehensive set of functionalities for searching and retrieving filing documents from various sources.  This API is designed to expose document search and document retrieval functionality. A document search will allow a request to query FactSet document databases based on certain search criteria specified in the request.  In addition, a document count request will provide information on the number of stories available for a particular security.  The meta endpoints, such as sources, formTypes, timeZones, and categories, provide comprehensive lists of available sources, form types, time zones, and categories, respectively.  # noqa: E501

    The version of the OpenAPI document: 2.2.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.GlobalFilings.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.GlobalFilings.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.GlobalFilings.exceptions import ApiException
from fds.sdk.GlobalFilings.model.count_response import CountResponse
from fds.sdk.GlobalFilings.model.error_response import ErrorResponse
from fds.sdk.GlobalFilings.model.search_response import SearchResponse





class FilingsAPIApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.get_count_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (CountResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 500: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/count',
                'operation_id': 'get_count',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ids',
                    'sources',
                    'start_date',
                    'end_date',
                    'time_zone',
                    'categories',
                    'primary_id',
                    'search_text',
                    'form_types',
                ],
                'required': [
                    'ids',
                    'sources',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'ids',
                ]
            },
            root_map={
                'validations': {
                    ('ids',): {

                        'max_items': 1000,
                        'min_items': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ids':
                        ([str],),
                    'sources':
                        ([str],),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'time_zone':
                        (str,),
                    'categories':
                        ([str],),
                    'primary_id':
                        (bool,),
                    'search_text':
                        (str,),
                    'form_types':
                        ([str],),
                },
                'attribute_map': {
                    'ids': 'ids',
                    'sources': 'sources',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'time_zone': 'timeZone',
                    'categories': 'categories',
                    'primary_id': 'primaryId',
                    'search_text': 'searchText',
                    'form_types': 'formTypes',
                },
                'location_map': {
                    'ids': 'query',
                    'sources': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'time_zone': 'query',
                    'categories': 'query',
                    'primary_id': 'query',
                    'search_text': 'query',
                    'form_types': 'query',
                },
                'collection_format_map': {
                    'ids': 'csv',
                    'sources': 'csv',
                    'categories': 'csv',
                    'form_types': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_filings_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (SearchResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 500: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/search',
                'operation_id': 'get_filings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ids',
                    'sources',
                    'start_date',
                    'end_date',
                    'pagination_limit',
                    'pagination_offset',
                    'time_zone',
                    'sort',
                    'categories',
                    'primary_id',
                    'search_text',
                    'form_types',
                    'edgar_accession',
                ],
                'required': [
                    'ids',
                    'sources',
                ],
                'nullable': [
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'ids',
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('ids',): {

                        'max_items': 1000,
                        'min_items': 1,
                    },
                    ('sort',): {

                        'max_items': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "FILINGSDATETIME": "filingsDateTime",
                        "-FILINGSDATETIME": "-filingsDateTime"
                    },
                },
                'openapi_types': {
                    'ids':
                        ([str],),
                    'sources':
                        ([str],),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                    'time_zone':
                        (str,),
                    'sort':
                        ([str],),
                    'categories':
                        ([str],),
                    'primary_id':
                        (bool,),
                    'search_text':
                        (str,),
                    'form_types':
                        ([str],),
                    'edgar_accession':
                        (str,),
                },
                'attribute_map': {
                    'ids': 'ids',
                    'sources': 'sources',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                    'time_zone': 'timeZone',
                    'sort': '_sort',
                    'categories': 'categories',
                    'primary_id': 'primaryId',
                    'search_text': 'searchText',
                    'form_types': 'formTypes',
                    'edgar_accession': 'edgarAccession',
                },
                'location_map': {
                    'ids': 'query',
                    'sources': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                    'time_zone': 'query',
                    'sort': 'query',
                    'categories': 'query',
                    'primary_id': 'query',
                    'search_text': 'query',
                    'form_types': 'query',
                    'edgar_accession': 'query',
                },
                'collection_format_map': {
                    'ids': 'csv',
                    'sources': 'csv',
                    'sort': 'csv',
                    'categories': 'csv',
                    'form_types': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def get_count(
        self,
        ids,
        sources,
        **kwargs
    ) -> CountResponse:
        """Returns the count of filings for specified source.  # noqa: E501

        Returns the count of filings documents along with other response fields.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            ids ([str]): Requested symbols or securities.  This is a comma-separated list with a maximum limit of 1000.  Each symbol can be a FactSet exchange symbol, CUSIP, SEDOL, ISIN, or Entity ID
            sources ([str]): Code for document source to include.This is a comma-separated list. Use the `/meta/sources` endpoint to get the list of available sources.  

        Keyword Args:
            start_date (str): Start Date. Format is YYYYMMDD or relative +/- days (0,-1,etc). . [optional]
            end_date (str): End Date. Format is YYYYMMDD or relative +/- days (0,-1,etc).. [optional]
            time_zone (str): timeZone to return story dates and times.Time zones, represented in POSIX format, are automatically adjusted for daylight savings. timeZone names are sourced from the IANA timezone registry.. [optional] if omitted the server will use the default value of "America/New_York"
            categories ([str]): Code for categories to include.  This is a comma-separated list. Use the `/meta/categories` endpoint to get the list of available categories.  Default = All categories.. [optional]
            primary_id (bool): Type of identifier search * true - Returns headlines of stories that have the searched identifier(s) as the primary  identifier. * false - Returns headlines of stories that mentioned or referred to the  identifier.. [optional] if omitted the server will use the default value of False
            search_text (str): Restricts the search to include only document stories that include the searched text. This parameter supports boolean operators as well.. [optional]
            form_types ([str]): The search to include any form types of given sources. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            CountResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['ids'] = \
            ids
        kwargs['sources'] = \
            sources
        return self.get_count_endpoint.call_with_http_info(**kwargs)

    def get_count_with_http_info(
        self,
        ids,
        sources,
        **kwargs
    ) -> typing.Tuple[CountResponse, int, typing.MutableMapping]:
        """Returns the count of filings for specified source.  # noqa: E501

        Returns the count of filings documents along with other response fields.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            ids ([str]): Requested symbols or securities.  This is a comma-separated list with a maximum limit of 1000.  Each symbol can be a FactSet exchange symbol, CUSIP, SEDOL, ISIN, or Entity ID
            sources ([str]): Code for document source to include.This is a comma-separated list. Use the `/meta/sources` endpoint to get the list of available sources.  

        Keyword Args:
            start_date (str): Start Date. Format is YYYYMMDD or relative +/- days (0,-1,etc). . [optional]
            end_date (str): End Date. Format is YYYYMMDD or relative +/- days (0,-1,etc).. [optional]
            time_zone (str): timeZone to return story dates and times.Time zones, represented in POSIX format, are automatically adjusted for daylight savings. timeZone names are sourced from the IANA timezone registry.. [optional] if omitted the server will use the default value of "America/New_York"
            categories ([str]): Code for categories to include.  This is a comma-separated list. Use the `/meta/categories` endpoint to get the list of available categories.  Default = All categories.. [optional]
            primary_id (bool): Type of identifier search * true - Returns headlines of stories that have the searched identifier(s) as the primary  identifier. * false - Returns headlines of stories that mentioned or referred to the  identifier.. [optional] if omitted the server will use the default value of False
            search_text (str): Restricts the search to include only document stories that include the searched text. This parameter supports boolean operators as well.. [optional]
            form_types ([str]): The search to include any form types of given sources. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            CountResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['ids'] = \
            ids
        kwargs['sources'] = \
            sources
        return self.get_count_endpoint.call_with_http_info(**kwargs)

    def get_count_async(
        self,
        ids,
        sources,
        **kwargs
    ) -> "ApplyResult[CountResponse]":
        """Returns the count of filings for specified source.  # noqa: E501

        Returns the count of filings documents along with other response fields.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            ids ([str]): Requested symbols or securities.  This is a comma-separated list with a maximum limit of 1000.  Each symbol can be a FactSet exchange symbol, CUSIP, SEDOL, ISIN, or Entity ID
            sources ([str]): Code for document source to include.This is a comma-separated list. Use the `/meta/sources` endpoint to get the list of available sources.  

        Keyword Args:
            start_date (str): Start Date. Format is YYYYMMDD or relative +/- days (0,-1,etc). . [optional]
            end_date (str): End Date. Format is YYYYMMDD or relative +/- days (0,-1,etc).. [optional]
            time_zone (str): timeZone to return story dates and times.Time zones, represented in POSIX format, are automatically adjusted for daylight savings. timeZone names are sourced from the IANA timezone registry.. [optional] if omitted the server will use the default value of "America/New_York"
            categories ([str]): Code for categories to include.  This is a comma-separated list. Use the `/meta/categories` endpoint to get the list of available categories.  Default = All categories.. [optional]
            primary_id (bool): Type of identifier search * true - Returns headlines of stories that have the searched identifier(s) as the primary  identifier. * false - Returns headlines of stories that mentioned or referred to the  identifier.. [optional] if omitted the server will use the default value of False
            search_text (str): Restricts the search to include only document stories that include the searched text. This parameter supports boolean operators as well.. [optional]
            form_types ([str]): The search to include any form types of given sources. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[CountResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['ids'] = \
            ids
        kwargs['sources'] = \
            sources
        return self.get_count_endpoint.call_with_http_info(**kwargs)

    def get_count_with_http_info_async(
        self,
        ids,
        sources,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[CountResponse, int, typing.MutableMapping]]":
        """Returns the count of filings for specified source.  # noqa: E501

        Returns the count of filings documents along with other response fields.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            ids ([str]): Requested symbols or securities.  This is a comma-separated list with a maximum limit of 1000.  Each symbol can be a FactSet exchange symbol, CUSIP, SEDOL, ISIN, or Entity ID
            sources ([str]): Code for document source to include.This is a comma-separated list. Use the `/meta/sources` endpoint to get the list of available sources.  

        Keyword Args:
            start_date (str): Start Date. Format is YYYYMMDD or relative +/- days (0,-1,etc). . [optional]
            end_date (str): End Date. Format is YYYYMMDD or relative +/- days (0,-1,etc).. [optional]
            time_zone (str): timeZone to return story dates and times.Time zones, represented in POSIX format, are automatically adjusted for daylight savings. timeZone names are sourced from the IANA timezone registry.. [optional] if omitted the server will use the default value of "America/New_York"
            categories ([str]): Code for categories to include.  This is a comma-separated list. Use the `/meta/categories` endpoint to get the list of available categories.  Default = All categories.. [optional]
            primary_id (bool): Type of identifier search * true - Returns headlines of stories that have the searched identifier(s) as the primary  identifier. * false - Returns headlines of stories that mentioned or referred to the  identifier.. [optional] if omitted the server will use the default value of False
            search_text (str): Restricts the search to include only document stories that include the searched text. This parameter supports boolean operators as well.. [optional]
            form_types ([str]): The search to include any form types of given sources. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(CountResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['ids'] = \
            ids
        kwargs['sources'] = \
            sources
        return self.get_count_endpoint.call_with_http_info(**kwargs)


    def get_filings(
        self,
        ids,
        sources,
        **kwargs
    ) -> SearchResponse:
        """Returns the filings documents and related metadata within FactSet coverage.  # noqa: E501

        Returns the filings documents within FactSet coverage along with other response fields.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            ids ([str]): Requested symbols or securities.  This is a comma-separated list with a maximum limit of 1000.  Each symbol can be a FactSet exchange symbol, CUSIP, SEDOL, ISIN, or Entity ID
            sources ([str]):

        Keyword Args:
            start_date (str): Start Date. Format is YYYYMMDD or relative +/- days (0,-1,etc). . [optional]
            end_date (str): End Date. Format is YYYYMMDD or relative +/- days (0,-1,etc).. [optional]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return. . [optional] if omitted the server will use the default value of 0
            time_zone (str): timeZone to return story dates and times.Time zones, represented in POSIX format, are automatically adjusted for daylight savings. timeZone names are sourced from the IANA timezone registry.. [optional] if omitted the server will use the default value of "America/New_York"
            sort ([str]): Enables sorting data in ascending or descending  order based on filingsDateTime.   * `filingsDateTime` - sorting results in chronological (ascending) order. If a start date is not specified, the    API has a 10-year searching limitation.   *  `-filingsDateTime` - sorting results in reverse chronological (descending) order. This is the default value if     the sort parameter isn't used in the query.. [optional] if omitted the server will use the default value of ["-filingsDateTime"]
            categories ([str]): Code for categories to include.  This is a comma-separated list. Use the `/meta/categories` endpoint to get the list of available categories.  Default = All categories.. [optional]
            primary_id (bool): Type of identifier search * true - Returns headlines of stories that have the searched identifier(s) as the primary  identifier. * false - Returns headlines of stories that mentioned or referred to the  identifier.. [optional] if omitted the server will use the default value of False
            search_text (str): Restricts the search to include only document stories that include the searched text. This parameter supports boolean operators as well.. [optional]
            form_types ([str]): The search to include any form types of given sources. [optional]
            edgar_accession (str): A unique identifier given to each EDGAR filings document. e.g. accession=0001013237-21-000069&sources=EDG.   > **Note:**  > When used in conjunction with the 'sources' parameter set to 'EDGAR, the API considers this accession for data retrieval.  > For non-EDGAR sources, this parameter is ignored.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            SearchResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['ids'] = \
            ids
        kwargs['sources'] = \
            sources
        return self.get_filings_endpoint.call_with_http_info(**kwargs)

    def get_filings_with_http_info(
        self,
        ids,
        sources,
        **kwargs
    ) -> typing.Tuple[SearchResponse, int, typing.MutableMapping]:
        """Returns the filings documents and related metadata within FactSet coverage.  # noqa: E501

        Returns the filings documents within FactSet coverage along with other response fields.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            ids ([str]): Requested symbols or securities.  This is a comma-separated list with a maximum limit of 1000.  Each symbol can be a FactSet exchange symbol, CUSIP, SEDOL, ISIN, or Entity ID
            sources ([str]):

        Keyword Args:
            start_date (str): Start Date. Format is YYYYMMDD or relative +/- days (0,-1,etc). . [optional]
            end_date (str): End Date. Format is YYYYMMDD or relative +/- days (0,-1,etc).. [optional]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return. . [optional] if omitted the server will use the default value of 0
            time_zone (str): timeZone to return story dates and times.Time zones, represented in POSIX format, are automatically adjusted for daylight savings. timeZone names are sourced from the IANA timezone registry.. [optional] if omitted the server will use the default value of "America/New_York"
            sort ([str]): Enables sorting data in ascending or descending  order based on filingsDateTime.   * `filingsDateTime` - sorting results in chronological (ascending) order. If a start date is not specified, the    API has a 10-year searching limitation.   *  `-filingsDateTime` - sorting results in reverse chronological (descending) order. This is the default value if     the sort parameter isn't used in the query.. [optional] if omitted the server will use the default value of ["-filingsDateTime"]
            categories ([str]): Code for categories to include.  This is a comma-separated list. Use the `/meta/categories` endpoint to get the list of available categories.  Default = All categories.. [optional]
            primary_id (bool): Type of identifier search * true - Returns headlines of stories that have the searched identifier(s) as the primary  identifier. * false - Returns headlines of stories that mentioned or referred to the  identifier.. [optional] if omitted the server will use the default value of False
            search_text (str): Restricts the search to include only document stories that include the searched text. This parameter supports boolean operators as well.. [optional]
            form_types ([str]): The search to include any form types of given sources. [optional]
            edgar_accession (str): A unique identifier given to each EDGAR filings document. e.g. accession=0001013237-21-000069&sources=EDG.   > **Note:**  > When used in conjunction with the 'sources' parameter set to 'EDGAR, the API considers this accession for data retrieval.  > For non-EDGAR sources, this parameter is ignored.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            SearchResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['ids'] = \
            ids
        kwargs['sources'] = \
            sources
        return self.get_filings_endpoint.call_with_http_info(**kwargs)

    def get_filings_async(
        self,
        ids,
        sources,
        **kwargs
    ) -> "ApplyResult[SearchResponse]":
        """Returns the filings documents and related metadata within FactSet coverage.  # noqa: E501

        Returns the filings documents within FactSet coverage along with other response fields.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            ids ([str]): Requested symbols or securities.  This is a comma-separated list with a maximum limit of 1000.  Each symbol can be a FactSet exchange symbol, CUSIP, SEDOL, ISIN, or Entity ID
            sources ([str]):

        Keyword Args:
            start_date (str): Start Date. Format is YYYYMMDD or relative +/- days (0,-1,etc). . [optional]
            end_date (str): End Date. Format is YYYYMMDD or relative +/- days (0,-1,etc).. [optional]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return. . [optional] if omitted the server will use the default value of 0
            time_zone (str): timeZone to return story dates and times.Time zones, represented in POSIX format, are automatically adjusted for daylight savings. timeZone names are sourced from the IANA timezone registry.. [optional] if omitted the server will use the default value of "America/New_York"
            sort ([str]): Enables sorting data in ascending or descending  order based on filingsDateTime.   * `filingsDateTime` - sorting results in chronological (ascending) order. If a start date is not specified, the    API has a 10-year searching limitation.   *  `-filingsDateTime` - sorting results in reverse chronological (descending) order. This is the default value if     the sort parameter isn't used in the query.. [optional] if omitted the server will use the default value of ["-filingsDateTime"]
            categories ([str]): Code for categories to include.  This is a comma-separated list. Use the `/meta/categories` endpoint to get the list of available categories.  Default = All categories.. [optional]
            primary_id (bool): Type of identifier search * true - Returns headlines of stories that have the searched identifier(s) as the primary  identifier. * false - Returns headlines of stories that mentioned or referred to the  identifier.. [optional] if omitted the server will use the default value of False
            search_text (str): Restricts the search to include only document stories that include the searched text. This parameter supports boolean operators as well.. [optional]
            form_types ([str]): The search to include any form types of given sources. [optional]
            edgar_accession (str): A unique identifier given to each EDGAR filings document. e.g. accession=0001013237-21-000069&sources=EDG.   > **Note:**  > When used in conjunction with the 'sources' parameter set to 'EDGAR, the API considers this accession for data retrieval.  > For non-EDGAR sources, this parameter is ignored.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[SearchResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['ids'] = \
            ids
        kwargs['sources'] = \
            sources
        return self.get_filings_endpoint.call_with_http_info(**kwargs)

    def get_filings_with_http_info_async(
        self,
        ids,
        sources,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[SearchResponse, int, typing.MutableMapping]]":
        """Returns the filings documents and related metadata within FactSet coverage.  # noqa: E501

        Returns the filings documents within FactSet coverage along with other response fields.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            ids ([str]): Requested symbols or securities.  This is a comma-separated list with a maximum limit of 1000.  Each symbol can be a FactSet exchange symbol, CUSIP, SEDOL, ISIN, or Entity ID
            sources ([str]):

        Keyword Args:
            start_date (str): Start Date. Format is YYYYMMDD or relative +/- days (0,-1,etc). . [optional]
            end_date (str): End Date. Format is YYYYMMDD or relative +/- days (0,-1,etc).. [optional]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return. . [optional] if omitted the server will use the default value of 0
            time_zone (str): timeZone to return story dates and times.Time zones, represented in POSIX format, are automatically adjusted for daylight savings. timeZone names are sourced from the IANA timezone registry.. [optional] if omitted the server will use the default value of "America/New_York"
            sort ([str]): Enables sorting data in ascending or descending  order based on filingsDateTime.   * `filingsDateTime` - sorting results in chronological (ascending) order. If a start date is not specified, the    API has a 10-year searching limitation.   *  `-filingsDateTime` - sorting results in reverse chronological (descending) order. This is the default value if     the sort parameter isn't used in the query.. [optional] if omitted the server will use the default value of ["-filingsDateTime"]
            categories ([str]): Code for categories to include.  This is a comma-separated list. Use the `/meta/categories` endpoint to get the list of available categories.  Default = All categories.. [optional]
            primary_id (bool): Type of identifier search * true - Returns headlines of stories that have the searched identifier(s) as the primary  identifier. * false - Returns headlines of stories that mentioned or referred to the  identifier.. [optional] if omitted the server will use the default value of False
            search_text (str): Restricts the search to include only document stories that include the searched text. This parameter supports boolean operators as well.. [optional]
            form_types ([str]): The search to include any form types of given sources. [optional]
            edgar_accession (str): A unique identifier given to each EDGAR filings document. e.g. accession=0001013237-21-000069&sources=EDG.   > **Note:**  > When used in conjunction with the 'sources' parameter set to 'EDGAR, the API considers this accession for data retrieval.  > For non-EDGAR sources, this parameter is ignored.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(SearchResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['ids'] = \
            ids
        kwargs['sources'] = \
            sources
        return self.get_filings_endpoint.call_with_http_info(**kwargs)


