[![FactSet](https://raw.githubusercontent.com/factset/enterprise-sdk/main/docs/images/factset-logo.svg)](https://www.factset.com)

# Global Filings client library for Python

[![API Version](https://img.shields.io/badge/api-v2.2.0-blue)](https://developer.factset.com/api-catalog/global-filings-api)
[![PyPi](https://img.shields.io/pypi/v/fds.sdk.GlobalFilings/2.3.0)](https://pypi.org/project/fds.sdk.GlobalFilings/v/2.3.0)
[![Apache-2 license](https://img.shields.io/badge/license-Apache2-brightgreen.svg)](https://www.apache.org/licenses/LICENSE-2.0)


The Filings API provides a comprehensive set of functionalities for searching and retrieving filing documents from various sources.

This API is designed to expose document search and document retrieval functionality. A document search will allow a request to query FactSet document databases based on certain search criteria specified in the request.

In addition, a document count request will provide information on the number of stories available for a particular security.

The meta endpoints, such as sources, formTypes, timeZones, and categories, provide comprehensive lists of available sources, form types, time zones, and categories, respectively.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.2.0
- SDK version: 2.3.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

For more information, please visit [https://developer.factset.com/contact](https://developer.factset.com/contact)

## Requirements

* Python >= 3.7

## Installation

### Poetry

```shell
poetry add fds.sdk.utils fds.sdk.GlobalFilings==2.3.0
```

### pip

```shell
pip install fds.sdk.utils fds.sdk.GlobalFilings==2.3.0
```

## Usage

1. [Generate authentication credentials](../../../../README.md#authentication).
2. Setup Python environment.
   1. Install and activate python 3.7+. If you're using [pyenv](https://github.com/pyenv/pyenv):

      ```sh
      pyenv install 3.9.7
      pyenv shell 3.9.7
      ```

   2. (optional) [Install poetry](https://python-poetry.org/docs/#installation).
3. [Install dependencies](#installation).
4. Run the following:

> [!IMPORTANT]
> The parameter variables defined below are just examples and may potentially contain non valid values. Please replace them with valid values.

### Example Code

```python
from fds.sdk.utils.authentication import ConfidentialClient

import fds.sdk.GlobalFilings
from fds.sdk.GlobalFilings.api import filings_api_api
from fds.sdk.GlobalFilings.models import *
from dateutil.parser import parse as dateutil_parser
from pprint import pprint

# See configuration.py for a list of all supported configuration parameters.

# Examples for each supported authentication method are below,
# choose one that satisfies your use case.

# (Preferred) OAuth 2.0: FactSetOAuth2
# See https://github.com/FactSet/enterprise-sdk#oauth-20
# for information on how to create the app-config.json file
#
# The confidential client instance should be reused in production environments.
# See https://github.com/FactSet/enterprise-sdk-utils-python#authentication
# for more information on using the ConfidentialClient class
configuration = fds.sdk.GlobalFilings.Configuration(
    fds_oauth_client=ConfidentialClient('/path/to/app-config.json')
)

# Basic authentication: FactSetApiKey
# See https://github.com/FactSet/enterprise-sdk#api-key
# for information how to create an API key
# configuration = fds.sdk.GlobalFilings.Configuration(
#     username='USERNAME-SERIAL',
#     password='API-KEY'
# )

# Enter a context with an instance of the API client
with fds.sdk.GlobalFilings.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = filings_api_api.FilingsAPIApi(api_client)
    ids = ["MODN-US"] # [str] | Requested symbols or securities.  This is a comma-separated list with a maximum limit of 1000.  Each symbol can be a FactSet exchange symbol, CUSIP, SEDOL, ISIN, or Entity ID
    sources = ["EDG"] # [str] | Code for document source to include.This is a comma-separated list. Use the `/meta/sources` endpoint to get the list of available sources.  
    start_date = "20240601" # str | Start Date. Format is YYYYMMDD or relative +/- days (0,-1,etc).  (optional)
    end_date = "20241101" # str | End Date. Format is YYYYMMDD or relative +/- days (0,-1,etc). (optional)
    time_zone = "America/New_York" # str | timeZone to return story dates and times.Time zones, represented in POSIX format, are automatically adjusted for daylight savings. timeZone names are sourced from the IANA timezone registry. (optional) if omitted the server will use the default value of "America/New_York"
    categories = ["CN:US"] # [str] | Code for categories to include.  This is a comma-separated list. Use the `/meta/categories` endpoint to get the list of available categories.  Default = All categories. (optional)
    primary_id = False # bool | Type of identifier search * true - Returns headlines of stories that have the searched identifier(s) as the primary  identifier. * false - Returns headlines of stories that mentioned or referred to the  identifier. (optional) if omitted the server will use the default value of False
    search_text = "Officer" # str | Restricts the search to include only document stories that include the searched text. This parameter supports boolean operators as well. (optional)
    form_types = ["15-12G"] # [str] | The search to include any form types of given sources (optional)

    try:
        # Returns the count of filings for specified source.
        # example passing only required values which don't have defaults set
        # and optional values
        api_response = api_instance.get_count(ids, sources, start_date=start_date, end_date=end_date, time_zone=time_zone, categories=categories, primary_id=primary_id, search_text=search_text, form_types=form_types)

        pprint(api_response)
    except fds.sdk.GlobalFilings.ApiException as e:
        print("Exception when calling FilingsAPIApi->get_count: %s\n" % e)

    # # Get response, http status code and response headers
    # try:
    #     # Returns the count of filings for specified source.
    #     api_response, http_status_code, response_headers = api_instance.get_count_with_http_info(ids, sources, start_date=start_date, end_date=end_date, time_zone=time_zone, categories=categories, primary_id=primary_id, search_text=search_text, form_types=form_types)


    #     pprint(api_response)
    #     pprint(http_status_code)
    #     pprint(response_headers)
    # except fds.sdk.GlobalFilings.ApiException as e:
    #     print("Exception when calling FilingsAPIApi->get_count: %s\n" % e)

    # # Get response asynchronous
    # try:
    #     # Returns the count of filings for specified source.
    #     async_result = api_instance.get_count_async(ids, sources, start_date=start_date, end_date=end_date, time_zone=time_zone, categories=categories, primary_id=primary_id, search_text=search_text, form_types=form_types)
    #     api_response = async_result.get()


    #     pprint(api_response)
    # except fds.sdk.GlobalFilings.ApiException as e:
    #     print("Exception when calling FilingsAPIApi->get_count: %s\n" % e)

    # # Get response, http status code and response headers asynchronous
    # try:
    #     # Returns the count of filings for specified source.
    #     async_result = api_instance.get_count_with_http_info_async(ids, sources, start_date=start_date, end_date=end_date, time_zone=time_zone, categories=categories, primary_id=primary_id, search_text=search_text, form_types=form_types)
    #     api_response, http_status_code, response_headers = async_result.get()


    #     pprint(api_response)
    #     pprint(http_status_code)
    #     pprint(response_headers)
    # except fds.sdk.GlobalFilings.ApiException as e:
    #     print("Exception when calling FilingsAPIApi->get_count: %s\n" % e)

```

### Using Pandas

To convert an API response to a Pandas DataFrame, it is necessary to transform it first to a dictionary.
```python
import pandas as pd

response_dict = api_response.to_dict()['data']

simple_json_response = pd.DataFrame(response_dict)
nested_json_response = pd.json_normalize(response_dict)
```

### Debugging

The SDK uses the standard library [`logging`](https://docs.python.org/3/library/logging.html#module-logging) module.

Setting `debug` to `True` on an instance of the `Configuration` class sets the log-level of related packages to `DEBUG`
and enables additional logging in Pythons [HTTP Client](https://docs.python.org/3/library/http.client.html).

**Note**: This prints out sensitive information (e.g. the full request and response). Use with care.

```python
import logging
import fds.sdk.GlobalFilings

logging.basicConfig(level=logging.DEBUG)

configuration = fds.sdk.GlobalFilings.Configuration(...)
configuration.debug = True
```

### Configure a Proxy

You can pass proxy settings to the Configuration class:

* `proxy`: The URL of the proxy to use.
* `proxy_headers`: a dictionary to pass additional headers to the proxy (e.g. `Proxy-Authorization`).

```python
import fds.sdk.GlobalFilings

configuration = fds.sdk.GlobalFilings.Configuration(
    # ...
    proxy="http://secret:password@localhost:5050",
    proxy_headers={
        "Custom-Proxy-Header": "Custom-Proxy-Header-Value"
    }
)
```

### Custom SSL Certificate

TLS/SSL certificate verification can be configured with the following Configuration parameters:

* `ssl_ca_cert`: a path to the certificate to use for verification in `PEM` format.
* `verify_ssl`: setting this to `False` disables the verification of certificates.
  Disabling the verification is not recommended, but it might be useful during
  local development or testing.

```python
import fds.sdk.GlobalFilings

configuration = fds.sdk.GlobalFilings.Configuration(
    # ...
    ssl_ca_cert='/path/to/ca.pem'
)
```

### Request Retries

In case the request retry behaviour should be customized, it is possible to pass a `urllib3.Retry` object to the `retry` property of the Configuration.

```python
from urllib3 import Retry
import fds.sdk.GlobalFilings

configuration = fds.sdk.GlobalFilings.Configuration(
    # ...
)

configuration.retries = Retry(total=3, status_forcelist=[500, 502, 503, 504])
```


## Documentation for API Endpoints

All URIs are relative to *https://api.factset.com/content/global-filings/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*FilingsAPIApi* | [**get_count**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/FilingsAPIApi.md#get_count) | **GET** /count | Returns the count of filings for specified source.
*FilingsAPIApi* | [**get_filings**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/FilingsAPIApi.md#get_filings) | **GET** /search | Returns the filings documents and related metadata within FactSet coverage.
*MetaApi* | [**get_formtype**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/MetaApi.md#get_formtype) | **GET** /meta/form-types | Returns the form types of specified sources.
*MetaApi* | [**get_sources**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/MetaApi.md#get_sources) | **GET** /meta/sources | Returns the sources.
*MetaApi* | [**get_timezone**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/MetaApi.md#get_timezone) | **GET** /meta/time-zones | Returns the time zones.
*MetaApi* | [**getcategories**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/MetaApi.md#getcategories) | **GET** /meta/categories | Returns the categories.


## Documentation For Models

 - [Category](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/Category.md)
 - [CategoryResponse](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/CategoryResponse.md)
 - [Count](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/Count.md)
 - [CountResponse](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/CountResponse.md)
 - [Document](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/Document.md)
 - [ErrorObject](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/ErrorObject.md)
 - [ErrorResponse](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/ErrorResponse.md)
 - [FormType](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/FormType.md)
 - [FormTypeResponse](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/FormTypeResponse.md)
 - [InvalidIdErrorObject](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/InvalidIdErrorObject.md)
 - [SearchResponse](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/SearchResponse.md)
 - [SearchResponseMeta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/SearchResponseMeta.md)
 - [SearchResponseMetaPagination](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/SearchResponseMetaPagination.md)
 - [SearchResult](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/SearchResult.md)
 - [Source](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/Source.md)
 - [SourceResponse](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/SourceResponse.md)
 - [TimeZone](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/TimeZone.md)
 - [TimeZoneResponse](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/GlobalFilings/v2/docs/TimeZoneResponse.md)


## Documentation For Authorization


## FactSetApiKey

- **Type**: HTTP basic authentication


## FactSetOAuth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: N/A


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in fds.sdk.GlobalFilings.apis and fds.sdk.GlobalFilings.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from fds.sdk.GlobalFilings.api.default_api import DefaultApi`
- `from fds.sdk.GlobalFilings.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import fds.sdk.GlobalFilings
from fds.sdk.GlobalFilings.apis import *
from fds.sdk.GlobalFilings.models import *
```

## Contributing

Please refer to the [contributing guide](../../../../CONTRIBUTING.md).

## Copyright

Copyright 2025 FactSet Research Systems Inc

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

