"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesManifest = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const constructs_1 = require("constructs");
const alb_controller_1 = require("./alb-controller");
const kubectl_provider_1 = require("./kubectl-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
const PRUNE_LABEL_PREFIX = 'aws.cdk.eks/prune-';
/**
 * Represents a manifest within the Kubernetes system.
 *
 * Alternatively, you can use `cluster.addManifest(resource[, resource, ...])`
 * to define resources on this cluster.
 *
 * Applies/deletes the manifest using `kubectl`.
 */
class KubernetesManifest extends core_2.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_eks_KubernetesManifestProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        const prune = (_b = props.prune) !== null && _b !== void 0 ? _b : props.cluster.prune;
        const pruneLabel = prune
            ? this.injectPruneLabel(props.manifest)
            : undefined;
        if ((_c = props.ingressAlb) !== null && _c !== void 0 ? _c : false) {
            this.injectIngressAlbAnnotations(props.manifest, (_d = props.ingressAlbScheme) !== null && _d !== void 0 ? _d : alb_controller_1.AlbScheme.INTERNAL);
        }
        const customResource = new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: KubernetesManifest.RESOURCE_TYPE,
            properties: {
                // `toJsonString` enables embedding CDK tokens in the manifest and will
                // render a CloudFormation-compatible JSON string (similar to
                // StepFunctions, CloudWatch Dashboards etc).
                Manifest: stack.toJsonString(props.manifest),
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                PruneLabel: pruneLabel,
                Overwrite: props.overwrite,
                SkipValidation: props.skipValidation,
            },
        });
        this.node.defaultChild = customResource.node.defaultChild;
    }
    /**
     * Injects a generated prune label to all resources in this manifest. The
     * label name will be `awscdk.eks/manifest-ADDR` where `ADDR` is the address
     * of the construct in the construct tree.
     *
     * @returns the label name
     */
    injectPruneLabel(manifest) {
        // max label name is 64 chars and addrs is always 42.
        const pruneLabel = PRUNE_LABEL_PREFIX + constructs_1.Node.of(this).addr;
        for (const resource of manifest) {
            // skip resource if it's not an object or if it does not have a "kind"
            if (typeof (resource) !== 'object' || !resource.kind) {
                continue;
            }
            if (!resource.metadata) {
                resource.metadata = {};
            }
            if (!resource.metadata.labels) {
                resource.metadata.labels = {};
            }
            resource.metadata.labels = {
                [pruneLabel]: '',
                ...resource.metadata.labels,
            };
        }
        return pruneLabel;
    }
    /**
     * Inject the necessary ingress annontations if possible (and requested).
     *
     * @see https://kubernetes-sigs.github.io/aws-load-balancer-controller/v2.2/guide/ingress/annotations/
     */
    injectIngressAlbAnnotations(manifest, scheme) {
        for (const resource of manifest) {
            // skip resource if it's not an object or if it does not have a "kind"
            if (typeof (resource) !== 'object' || !resource.kind) {
                continue;
            }
            if (resource.kind === 'Ingress') {
                resource.metadata.annotations = {
                    'kubernetes.io/ingress.class': 'alb',
                    'alb.ingress.kubernetes.io/scheme': scheme,
                    ...resource.metadata.annotations,
                };
            }
        }
    }
}
exports.KubernetesManifest = KubernetesManifest;
_a = JSII_RTTI_SYMBOL_1;
KubernetesManifest[_a] = { fqn: "@aws-cdk/aws-eks.KubernetesManifest", version: "1.156.1" };
/**
 * The CloudFormation reosurce type.
 */
KubernetesManifest.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesResource';
//# sourceMappingURL=data:application/json;base64,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