import importlib
from . import constants


def import_from_string(val):
    """
    Attempt to import a class from a string representation.
    From: django-rest-framework
    """
    try:
        # Nod to tastypie's use of importlib.
        parts = val.split('.')
        module_path, class_name = '.'.join(parts[:-1]), parts[-1]
        module = importlib.import_module(module_path)
        return getattr(module, class_name)
    except ImportError as e:
        msg = "Could not import '%s' for setting. %s: %s." % (
            val, e.__class__.__name__, e
        )
        raise ImportError(msg)


def get_all_forms():
    ret = {}
    for workflow_str in constants.DN_WORKFLOWS:
        workflow_view = import_from_string(workflow_str)
        for form in workflow_view.forms:
            ret[form.slug] = form
    return ret
