# WGDI

![Latest PyPI version](https://img.shields.io/pypi/v/wgdi.svg) [![Downloads](https://pepy.tech/badge/wgdi/month)](https://pepy.tech/project/wgdi)

| | |
| --- | --- |
| Author  | Pengchuan Sun ([sunpengchuan](https//github.com/sunpengchuan)) |
| Email   | <sunpengchuan@gmail.com> |
| License | [BSD](http://creativecommons.org/licenses/BSD/) |

## Description

WGDI (identification of whole-genome duplication), a python-based command-line tool that allows researchers to gain insights into recursive polyploidization and doing cross-species genomics alignment analysis.

The WGDI suite provides commonly used dotplot, ks, and collinearity analysis workflows together with tools for modeling and visualization, rendering these analysis accessible to genomics researchers in a convenient manner.

The use of WGDI can produce a gene-colinearity supported and hierarchical list of homologous genes, relating to specific polyploidizations and speciations.

WGDI also provides additional functions to help distinguish polyploid between subgenome and ancestral genome reconstruction and other evolutionary scenarios.

WGDI outperforms similar tools in terms of efficacy, flexibility, scalability. 

## Installation

Python package and command line interface (IDLE) for the analysis of whole genome duplications (WGDI). WGDI can be deployed in Windows, Linux, and Mac OS operating systems and can be installed via pip and conda.

#### Bioconda

```
conda install -c bioconda  wgdi
```

#### Pypi

```
pip3 install wgdi
```

Documentation for installation along with a user tutorial, a default parameter file, and test data are provided. please consult the docs at <http://wgdi.readthedocs.io/en/latest/>.

