# aliro-aqn
This is an api for the Aliro Q.Network

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.43.0
- Package version: 1.43.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install aliro-quantum-networking
```

Then import the package:
```python
import aliro_quantum_networking
```
## Getting Started

```python

## Import necessary modules

import aliro_quantum_networking
from contextlib import contextmanager
from aliro_quantum_networking.models import ClassicalChannel, MemoryInput, Node, QuantumConnection, \
    Request, SubmissionAqnInput, SubmissionAqnOutput, SubmissionAqnBaseGlobalSettings, SubmissionOverviewInput
from aliro_quantum_networking.rest import ApiException
from pprint import pprint
from matplotlib import pyplot as plt
from typing import ContextManager
import uuid


## Set up authentication
# You can retrieve your API token in your "Account" page at https://aqn.aliro.io/#/user


configuration = aliro_quantum_networking.Configuration()
configuration.api_key['Authorization'] = 'API_TOKEN'
configuration.host = 'https://aqn.aliro.io/v1'


## Define nodes
# Define the nodes in your topology.
# 
# In this example, there will be a linear topology, having two end nodes with 25 quantum memories and 1 repeater between them with 50 quantum memories.


default_coherence_time = 10  # seconds
default_raw_fidelity = 0.85
memory_request_size = 5

def new_node_memory() -> MemoryInput:
    return MemoryInput(
        coherence_time=default_coherence_time,
        memory_type='MemoryInput',
        raw_fidelity=default_raw_fidelity
    )

end_node_1 = Node(
    name='alice',
    memories=[new_node_memory() for i in range(memory_request_size)]
)

end_node_2 = Node(
    name='bob',
    memories=[new_node_memory() for i in range(memory_request_size)]
)

repeater_1 = Node(
    name='repeater1',
    memories=[new_node_memory() for i in range(memory_request_size * 2)]
)

submission_nodes = [
    end_node_1,
    repeater_1,
    end_node_2
]


## Define quantum connections
# Define the quantum connections between nodes in your topology.
# 
# In this example, there will be two quantum connections, one between the repeater and each of the end nodes.


default_quantum_connection_attenuation = 1e-5  # decibels/kilometer
default_quantum_channel_distance = 5e3  # meters

quantum_connections = [
    QuantumConnection(
        attenuation=default_quantum_connection_attenuation,
        distance=default_quantum_channel_distance,
        node_from=submission_nodes[0].name,
        node_to=submission_nodes[1].name
    ),
    QuantumConnection(
        attenuation=default_quantum_connection_attenuation,
        distance=default_quantum_channel_distance,
        node_from=submission_nodes[1].name,
        node_to=submission_nodes[2].name
    )
]


## Define classical channels
# Define the classical channels between nodes in the topology.
# 
# In this example, there will be an all-to-all classical connection topology.


default_classical_channel_delay = 25e7  # picoseconds
default_classical_channel_distance = 1e3  # meters
submission_classical_channels = []

for i in submission_nodes:
    for j in submission_nodes:
        if i.name != j.name:
            submission_classical_channels.append(
                ClassicalChannel(
                    delay=default_classical_channel_delay,
                    distance=default_classical_channel_distance,
                    node_from=i.name,
                    node_to=j.name
                )
            )


## Define the desired network request
# Define the desired network request to simulate


default_request_target_fidelity = 0.9
default_request_simulation_start_time = 1e12
default_request_simulation_end_time = 1e14

network_request = Request(
    memory_size=memory_request_size,
    node_from=submission_nodes[0].name,
    node_to=submission_nodes[2].name,
    target_fidelity=default_request_target_fidelity,
    time_beginning=default_request_simulation_start_time,
    time_end=default_request_simulation_end_time
)


## Define full submission API input
# Put all inputs into the full input to send to the Aliro API


submission_name = f'SubmissionTest_{uuid.uuid4().hex}'

submission_input = SubmissionAqnInput(
    classical_channels=submission_classical_channels,
    global_settings=SubmissionAqnBaseGlobalSettings(
        excitation_rate=80000000,
        purification_protocol_name='BBPSSW_X'
    ),
    nodes=submission_nodes,
    quantum_connections=quantum_connections,
    request=network_request,
    submission_overview=SubmissionOverviewInput(
        name=submission_name,
        runs=1,
        timeout=10,
        timeline_stop_time=3e12,
        submission_overview_type='SubmissionOverviewInput'
    )
)


## Define submissions API instance context
# This will set up our API client and catch errors.
# This will be the same for all of our calls in this example, so we can define a reusable context here.

@contextmanager
def submissions_api_client(api_method_name: str) -> ContextManager[aliro_quantum_networking.SubmissionsApi]:
    with aliro_quantum_networking.ApiClient(configuration) as api_client:
        submissions_api_instance = aliro_quantum_networking.SubmissionsApi(api_client)
        try:
            yield submissions_api_instance
        except ApiException as e:
            print(f"Exception when calling SubmissionsApi->{api_method_name}: {e}\n")



## Submit the new submission


submission_id: str
with submissions_api_client(api_method_name='submissions_post') as submissions_api_instance:
    submission_api_response = submissions_api_instance.submissions_post(submission_aqn_input=submission_input)
    pprint(submission_api_response)

    submission_id = submission_api_response.submission_id


## Wait for completion
# This will likely take a few minutes or more.


submission_details: SubmissionAqnOutput
with submissions_api_client(api_method_name='submissions_details_stream_get') as submissions_api_instance:
    for submission_get_response in submissions_api_instance.submissions_details_stream_get(
        submission_id=submission_id
    ):
        submission_details = submission_get_response
        submission_is_complete = submission_details.submission_overview.complete_date
        if submission_is_complete:
            break


## Display number of entangled memories

PICOSECONDS_PER_SECOND = 1e12

fig, axes = plt.subplots(1, 3)
axes[0].set_ylabel("Number of Entangled Memories")
axes[1].set_xlabel("Simulation Time (s)")

first_run_results = submission_details.run_results[0]
node_names = [submission_node.name for submission_node in submission_nodes]
result_memories_all_nodes = [first_run_results.nodes[node_name].memories for node_name in node_names]

for node_name, node_result_memories, axis in zip(node_names, result_memories_all_nodes, axes):
    data = sorted(info.entangled_at_time / PICOSECONDS_PER_SECOND for info in node_result_memories if info.entangled_at_time)
    axis.set_title(node_name)
    axis.plot(data, range(1, len(data) + 1), marker="o")

fig.tight_layout()


## Display fidelities for entangled memories

fig, axes = plt.subplots(1,3)
axes[0].set_ylabel("Fidelity")
axes[1].set_xlabel("Memory Number")

def set_ax_properties(axis, data):
    data_length = len(data)
    axis.bar(range(data_length), data)
    for fidelity in (default_raw_fidelity, 0.9):
        axis.plot([0, data_length], 2 * [fidelity], "k--")
    axis.set_ylim(0.7,1)

for node_name, node_result_memories, axis in zip(node_names, result_memories_all_nodes, axes):
    data = [info.fidelity for info in node_result_memories]
    axis.set_title(node_name)
    set_ax_properties(axis, data)

fig.tight_layout()

```


## Documentation for API Endpoints

All URIs are relative to *http://localhost:3998/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**auth_login_post**](docs/AuthenticationApi.md#auth_login_post) | **POST** /auth/login | login using username and password
*SubmissionsApi* | [**submissions_details_stream_get**](docs/SubmissionsApi.md#submissions_details_stream_get) | **GET** /submissions/details/stream | get details about a submission&#39;s results
*SubmissionsApi* | [**submissions_post**](docs/SubmissionsApi.md#submissions_post) | **POST** /submissions | submit a new submission
*UserApi* | [**user_api_key_post**](docs/UserApi.md#user_api_key_post) | **POST** /user/apiKey | generate Aliro API key for user
*UserApi* | [**user_information_update_post**](docs/UserApi.md#user_information_update_post) | **POST** /user/informationUpdate | update user email and name
*UserApi* | [**user_password_change_post**](docs/UserApi.md#user_password_change_post) | **POST** /user/passwordChange | change user password from known password


## Documentation For Models

 - [ApiKey](docs/ApiKey.md)
 - [ApiKeyResponse](docs/ApiKeyResponse.md)
 - [BasicSuccess](docs/BasicSuccess.md)
 - [ChangePasswordParameters](docs/ChangePasswordParameters.md)
 - [ClassicalChannel](docs/ClassicalChannel.md)
 - [CredentialsBasic](docs/CredentialsBasic.md)
 - [LoginResponse](docs/LoginResponse.md)
 - [Memory](docs/Memory.md)
 - [MemoryBase](docs/MemoryBase.md)
 - [MemoryInput](docs/MemoryInput.md)
 - [MemoryOutput](docs/MemoryOutput.md)
 - [MemoryOutputAllOf](docs/MemoryOutputAllOf.md)
 - [Node](docs/Node.md)
 - [QuantumConnection](docs/QuantumConnection.md)
 - [Request](docs/Request.md)
 - [SubmissionAqn](docs/SubmissionAqn.md)
 - [SubmissionAqnBase](docs/SubmissionAqnBase.md)
 - [SubmissionAqnInput](docs/SubmissionAqnInput.md)
 - [SubmissionAqnOutput](docs/SubmissionAqnOutput.md)
 - [SubmissionAqnOutputAllOf](docs/SubmissionAqnOutputAllOf.md)
 - [UpdateUserInformationParameters](docs/UpdateUserInformationParameters.md)
 - [UserInfo](docs/UserInfo.md)


## Documentation For Authorization


## JwtKeyAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

nick@aliroquantum.com

