#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.packetstream',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20210306',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    'general purpose bidirectional packet stream connection',
  long_description =
    ('A general purpose bidirectional packet stream connection.\n'    
 '\n'    
 '*Latest release 20210306*:\n'    
 '* Port to new cs.binary.Binary* classes.\n'    
 '* Some refactors and small fixes.\n'    
 '\n'    
 '## Class '    
 '`Packet(cs.binary.SimpleBinary,types.SimpleNamespace,cs.binary.AbstractBinary,cs.binary.BinaryMixin)`\n'    
 '\n'    
 'A protocol packet.\n'    
 '\n'    
 '### Method `Packet.__str__(self)`\n'    
 '\n'    
 'pylint: disable=signature-differs\n'    
 '\n'    
 '### Method `Packet.parse(bfr)`\n'    
 '\n'    
 'Parse a packet from a buffer.\n'    
 '\n'    
 '### Method `Packet.transcribe(self)`\n'    
 '\n'    
 'Transcribe this packet.\n'    
 '\n'    
 '## Class `PacketConnection`\n'    
 '\n'    
 'A bidirectional binary connection for exchanging requests and responses.\n'    
 '\n'    
 '### Method `PacketConnection.__init__(self, recv, send, '    
 'request_handler=None, name=None, packet_grace=None, tick=None)`\n'    
 '\n'    
 'Initialise the PacketConnection.\n'    
 '\n'    
 'Parameters:\n'    
 '* `recv`: inbound binary stream.\n'    
 '  If this is an `int` it is taken to be an OS file descriptor,\n'    
 '  otherwise it should be a `cs.buffer.CornuCopyBuffer`\n'    
 '  or a file like object with a `read1` or `read` method.\n'    
 '* `send`: outbound binary stream.\n'    
 '  If this is an `int` it is taken to be an OS file descriptor,\n'    
 '  otherwise it should be a file like object with `.write(bytes)`\n'    
 '  and `.flush()` methods.\n'    
 '  For a file descriptor sending is done via an os.dup() of\n'    
 '  the supplied descriptor, so the caller remains responsible\n'    
 '  for closing the original descriptor.\n'    
 '* `packet_grace`:\n'    
 '  default pause in the packet sending worker\n'    
 '  to allow another packet to be queued\n'    
 '  before flushing the output stream.\n'    
 '  Default: `DEFAULT_PACKET_GRACE`s.\n'    
 '  A value of `0` will flush immediately if the queue is empty.\n'    
 '* `request_handler`: an optional callable accepting\n'    
 '  (`rq_type`, `flags`, `payload`).\n'    
 '  The request_handler may return one of 5 values on success:\n'    
 '  * `None`: response will be 0 flags and an empty payload.\n'    
 '  * `int`: flags only. Response will be the flags and an empty payload.\n'    
 '  * `bytes`: payload only. Response will be 0 flags and the payload.\n'    
 '  * `str`: payload only. Response will be 0 flags and the str\n'    
 '          encoded as bytes using UTF-8.\n'    
 '  * `(int, bytes)`: Specify flags and payload for response.\n'    
 '  An unsuccessful request should raise an exception, which\n'    
 '  will cause a failure response packet.\n'    
 '* `tick`: optional tick parameter, default `None`.\n'    
 '  If `None`, do nothing.\n'    
 '  If a Boolean, call `tick_fd_2` if true, otherwise do nothing.\n'    
 '  Otherwise `tick` should be a callable accepting a byteslike value.\n'    
 '\n'    
 '### Method `PacketConnection.do(self, *a, **kw)`\n'    
 '\n'    
 'Wrapper function to check that this instance is not closed.\n'    
 '\n'    
 '### Method `PacketConnection.join(self)`\n'    
 '\n'    
 'Wait for the receive side of the connection to terminate.\n'    
 '\n'    
 '### Method `PacketConnection.request(self, *a, **kw)`\n'    
 '\n'    
 'Wrapper function to check that this instance is not closed.\n'    
 '\n'    
 '### Method `PacketConnection.shutdown(self, *a, **kw)`\n'    
 '\n'    
 'Shut down the PacketConnection, optionally blocking for outstanding '    
 'requests.\n'    
 '\n'    
 'Parameters:\n'    
 '`block`: block for outstanding requests, default False.\n'    
 '\n'    
 '## Class `Request_State(builtins.tuple)`\n'    
 '\n'    
 'RequestState(decode_response, result)\n'    
 '\n'    
 '### Property `Request_State.decode_response`\n'    
 '\n'    
 'Alias for field number 0\n'    
 '\n'    
 '### Property `Request_State.result`\n'    
 '\n'    
 'Alias for field number 1\n'    
 '\n'    
 '## Function `tick_fd_2(bs)`\n'    
 '\n'    
 'A low level tick function to write a short binary tick\n'    
 'to the standard error file descriptor.\n'    
 '\n'    
 'This may be called by the send and receive workers to give\n'    
 'an indication of activity type.\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20210306*:\n'    
 '* Port to new cs.binary.Binary* classes.\n'    
 '* Some refactors and small fixes.\n'    
 '\n'    
 '*Release 20191004*:\n'    
 '* PacketConnection: new optional parameter `packet_grace` to tune the send '    
 'delay for additional packets before a flush, default DEFAULT_PACKET_GRACE '    
 '(0.01s), 0 for no delay.\n'    
 '* Add a crude packet level activity ticker.\n'    
 '\n'    
 '*Release 20190221*:\n'    
 'DISTINFO requirement updates.\n'    
 '\n'    
 '*Release 20181228*:\n'    
 'Initial PyPI release.'),
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Topic :: System :: Networking', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  install_requires = ['cs.binary', 'cs.buffer', 'cs.excutils', 'cs.later', 'cs.logutils', 'cs.pfx', 'cs.predicate', 'cs.queues', 'cs.resources', 'cs.result', 'cs.seq', 'cs.threads'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.packetstream'],
)
