"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnTag = exports.toJson_CfnTagProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnTagProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnTagProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'ProjectId': obj.projectId,
        'Ref': obj.ref,
        'Message': obj.message,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnTagProps = toJson_CfnTagProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `GitLab::Code::Tag`
 *
 * @cloudformationResource GitLab::Code::Tag
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
 */
class CfnTag extends cdk.CfnResource {
    /**
     * Create a new `GitLab::Code::Tag`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnTag.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnTagProps(props) });
        this.props = props;
        this.attrTagId = cdk.Token.asString(this.getAtt('TagId'));
        this.attrCommitId = cdk.Token.asString(this.getAtt('CommitId'));
    }
}
exports.CfnTag = CfnTag;
_a = JSII_RTTI_SYMBOL_1;
CfnTag[_a] = { fqn: "@cdk-cloudformation/gitlab-code-tag.CfnTag", version: "1.2.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnTag.CFN_RESOURCE_TYPE_NAME = "GitLab::Code::Tag";
//# sourceMappingURL=data:application/json;base64,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