# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class VasV2PaymentsPost201ResponseTaxInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'commit_indicator': 'bool',
        'refund_indicator': 'bool'
    }

    attribute_map = {
        'commit_indicator': 'commitIndicator',
        'refund_indicator': 'refundIndicator'
    }

    def __init__(self, commit_indicator=None, refund_indicator=None):
        """
        VasV2PaymentsPost201ResponseTaxInformation - a model defined in Swagger
        """

        self._commit_indicator = None
        self._refund_indicator = None

        if commit_indicator is not None:
          self.commit_indicator = commit_indicator
        if refund_indicator is not None:
          self.refund_indicator = refund_indicator

    @property
    def commit_indicator(self):
        """
        Gets the commit_indicator of this VasV2PaymentsPost201ResponseTaxInformation.
        Indicates whether this is a committed tax transaction. For a committed tax transaction, the status in the Tax Detail Report is \"Committed.\" For an uncommitted tax transaction, the status in the Tax Detail Report is \"Uncommitted.\" Possible values: - `true`: This is a committed tax transaction. - `false` (default): This is not a committed tax transaction.  A committed tax request is a tax service request that sets the status field in the Tax Detail Report to committed. The committed status indicates that the amount calculated by the tax service is included in the amount of a capture or credit.  Use a void service request to cancel a committed tax request or a committed refund tax request. The void transaction is included as a separate entry in the Tax Detail Report. The value of the status field is cancelled. The value of the link ID is the request ID of the committed tax request or refund tax request that was voided. You can use the value of the link ID to reconcile your orders.  Optional for U.S., Canadian, international tax, and value added taxes. For more information on Tax Detail Report features refer the [Tax Service Guide](https://developer.cybersource.com/docs/cybs/en-us/tax-calculation/developer/all/rest/tax-calculation/tax-overview.html). 

        :return: The commit_indicator of this VasV2PaymentsPost201ResponseTaxInformation.
        :rtype: bool
        """
        return self._commit_indicator

    @commit_indicator.setter
    def commit_indicator(self, commit_indicator):
        """
        Sets the commit_indicator of this VasV2PaymentsPost201ResponseTaxInformation.
        Indicates whether this is a committed tax transaction. For a committed tax transaction, the status in the Tax Detail Report is \"Committed.\" For an uncommitted tax transaction, the status in the Tax Detail Report is \"Uncommitted.\" Possible values: - `true`: This is a committed tax transaction. - `false` (default): This is not a committed tax transaction.  A committed tax request is a tax service request that sets the status field in the Tax Detail Report to committed. The committed status indicates that the amount calculated by the tax service is included in the amount of a capture or credit.  Use a void service request to cancel a committed tax request or a committed refund tax request. The void transaction is included as a separate entry in the Tax Detail Report. The value of the status field is cancelled. The value of the link ID is the request ID of the committed tax request or refund tax request that was voided. You can use the value of the link ID to reconcile your orders.  Optional for U.S., Canadian, international tax, and value added taxes. For more information on Tax Detail Report features refer the [Tax Service Guide](https://developer.cybersource.com/docs/cybs/en-us/tax-calculation/developer/all/rest/tax-calculation/tax-overview.html). 

        :param commit_indicator: The commit_indicator of this VasV2PaymentsPost201ResponseTaxInformation.
        :type: bool
        """

        self._commit_indicator = commit_indicator

    @property
    def refund_indicator(self):
        """
        Gets the refund_indicator of this VasV2PaymentsPost201ResponseTaxInformation.
        Indicates whether this is a refund tax transaction. For a refund tax transaction, amounts in the Tax Detail Report will be negative. Possible values: - `true`: This is a refund tax transaction. - `false` (default): This is not a refund tax transaction.  A refund tax request is a tax service request that sets the transaction type field in the Tax Detail Report to refunded and makes the reported amount negative. Tax amounts are returned as positive amounts in reply messages, but they are saved in reports as negative amounts which enables the reporting software to accurately calculate the aggregate amounts.  Optional for U.S., Canadian, international tax, and value added taxes. For more information on Tax Detail Report features refer the [Tax Service Guide](https://developer.cybersource.com/docs/cybs/en-us/tax-calculation/developer/all/rest/tax-calculation/tax-overview.html). 

        :return: The refund_indicator of this VasV2PaymentsPost201ResponseTaxInformation.
        :rtype: bool
        """
        return self._refund_indicator

    @refund_indicator.setter
    def refund_indicator(self, refund_indicator):
        """
        Sets the refund_indicator of this VasV2PaymentsPost201ResponseTaxInformation.
        Indicates whether this is a refund tax transaction. For a refund tax transaction, amounts in the Tax Detail Report will be negative. Possible values: - `true`: This is a refund tax transaction. - `false` (default): This is not a refund tax transaction.  A refund tax request is a tax service request that sets the transaction type field in the Tax Detail Report to refunded and makes the reported amount negative. Tax amounts are returned as positive amounts in reply messages, but they are saved in reports as negative amounts which enables the reporting software to accurately calculate the aggregate amounts.  Optional for U.S., Canadian, international tax, and value added taxes. For more information on Tax Detail Report features refer the [Tax Service Guide](https://developer.cybersource.com/docs/cybs/en-us/tax-calculation/developer/all/rest/tax-calculation/tax-overview.html). 

        :param refund_indicator: The refund_indicator of this VasV2PaymentsPost201ResponseTaxInformation.
        :type: bool
        """

        self._refund_indicator = refund_indicator

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, VasV2PaymentsPost201ResponseTaxInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
