# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class SearchRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'organization_id': 'str',
        'user_name': 'str',
        'role_id': 'str',
        'permission_id': 'str'
    }

    attribute_map = {
        'organization_id': 'organizationId',
        'user_name': 'userName',
        'role_id': 'roleId',
        'permission_id': 'permissionId'
    }

    def __init__(self, organization_id=None, user_name=None, role_id=None, permission_id=None):
        """
        SearchRequest - a model defined in Swagger
        """

        self._organization_id = None
        self._user_name = None
        self._role_id = None
        self._permission_id = None

        if organization_id is not None:
          self.organization_id = organization_id
        if user_name is not None:
          self.user_name = user_name
        if role_id is not None:
          self.role_id = role_id
        if permission_id is not None:
          self.permission_id = permission_id

    @property
    def organization_id(self):
        """
        Gets the organization_id of this SearchRequest.
        This is the orgId of the organization which the user belongs to.

        :return: The organization_id of this SearchRequest.
        :rtype: str
        """
        return self._organization_id

    @organization_id.setter
    def organization_id(self, organization_id):
        """
        Sets the organization_id of this SearchRequest.
        This is the orgId of the organization which the user belongs to.

        :param organization_id: The organization_id of this SearchRequest.
        :type: str
        """

        self._organization_id = organization_id

    @property
    def user_name(self):
        """
        Gets the user_name of this SearchRequest.
        User ID of the user you want to get details on.

        :return: The user_name of this SearchRequest.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this SearchRequest.
        User ID of the user you want to get details on.

        :param user_name: The user_name of this SearchRequest.
        :type: str
        """

        self._user_name = user_name

    @property
    def role_id(self):
        """
        Gets the role_id of this SearchRequest.
        role of the user you are trying to search on.

        :return: The role_id of this SearchRequest.
        :rtype: str
        """
        return self._role_id

    @role_id.setter
    def role_id(self, role_id):
        """
        Sets the role_id of this SearchRequest.
        role of the user you are trying to search on.

        :param role_id: The role_id of this SearchRequest.
        :type: str
        """

        self._role_id = role_id

    @property
    def permission_id(self):
        """
        Gets the permission_id of this SearchRequest.
        permission that you are trying to search user on.

        :return: The permission_id of this SearchRequest.
        :rtype: str
        """
        return self._permission_id

    @permission_id.setter
    def permission_id(self, permission_id):
        """
        Sets the permission_id of this SearchRequest.
        permission that you are trying to search user on.

        :param permission_id: The permission_id of this SearchRequest.
        :type: str
        """

        self._permission_id = permission_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SearchRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
