# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class Riskv1decisionsConsumerAuthenticationInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'strong_authentication': 'Riskv1decisionsConsumerAuthenticationInformationStrongAuthentication',
        'acs_window_size': 'str',
        'alternate_authentication_data': 'str',
        'alternate_authentication_date': 'str',
        'alternate_authentication_method': 'str',
        'authentication_date': 'str',
        'authentication_transaction_id': 'str',
        'transaction_flow_indicator': 'int',
        'challenge_code': 'str',
        'challenge_status': 'str',
        'customer_card_alias': 'str',
        'decoupled_authentication_indicator': 'str',
        'decoupled_authentication_max_time': 'str',
        'default_card': 'bool',
        'device_channel': 'str',
        'installment_total_count': 'int',
        'merchant_fraud_rate': 'str',
        'marketing_opt_in': 'bool',
        'marketing_source': 'str',
        'mcc': 'str',
        'merchant_score': 'int',
        'message_category': 'str',
        'npa_code': 'str',
        'override_payment_method': 'str',
        'override_country_code': 'str',
        'prior_authentication_data': 'str',
        'prior_authentication_method': 'str',
        'prior_authentication_reference_id': 'str',
        'prior_authentication_time': 'str',
        'product_code': 'str',
        'return_url': 'str',
        'requestor_id': 'str',
        'requestor_initiated_authentication_indicator': 'str',
        'requestor_name': 'str',
        'reference_id': 'str',
        'sdk_max_timeout': 'str',
        'secure_corporate_payment_indicator': 'str',
        'transaction_mode': 'str',
        'white_list_status': 'str',
        'score_request': 'int'
    }

    attribute_map = {
        'strong_authentication': 'strongAuthentication',
        'acs_window_size': 'acsWindowSize',
        'alternate_authentication_data': 'alternateAuthenticationData',
        'alternate_authentication_date': 'alternateAuthenticationDate',
        'alternate_authentication_method': 'alternateAuthenticationMethod',
        'authentication_date': 'authenticationDate',
        'authentication_transaction_id': 'authenticationTransactionId',
        'transaction_flow_indicator': 'transactionFlowIndicator',
        'challenge_code': 'challengeCode',
        'challenge_status': 'challengeStatus',
        'customer_card_alias': 'customerCardAlias',
        'decoupled_authentication_indicator': 'decoupledAuthenticationIndicator',
        'decoupled_authentication_max_time': 'decoupledAuthenticationMaxTime',
        'default_card': 'defaultCard',
        'device_channel': 'deviceChannel',
        'installment_total_count': 'installmentTotalCount',
        'merchant_fraud_rate': 'merchantFraudRate',
        'marketing_opt_in': 'marketingOptIn',
        'marketing_source': 'marketingSource',
        'mcc': 'mcc',
        'merchant_score': 'merchantScore',
        'message_category': 'messageCategory',
        'npa_code': 'npaCode',
        'override_payment_method': 'overridePaymentMethod',
        'override_country_code': 'overrideCountryCode',
        'prior_authentication_data': 'priorAuthenticationData',
        'prior_authentication_method': 'priorAuthenticationMethod',
        'prior_authentication_reference_id': 'priorAuthenticationReferenceId',
        'prior_authentication_time': 'priorAuthenticationTime',
        'product_code': 'productCode',
        'return_url': 'returnUrl',
        'requestor_id': 'requestorId',
        'requestor_initiated_authentication_indicator': 'requestorInitiatedAuthenticationIndicator',
        'requestor_name': 'requestorName',
        'reference_id': 'referenceId',
        'sdk_max_timeout': 'sdkMaxTimeout',
        'secure_corporate_payment_indicator': 'secureCorporatePaymentIndicator',
        'transaction_mode': 'transactionMode',
        'white_list_status': 'whiteListStatus',
        'score_request': 'scoreRequest'
    }

    def __init__(self, strong_authentication=None, acs_window_size=None, alternate_authentication_data=None, alternate_authentication_date=None, alternate_authentication_method=None, authentication_date=None, authentication_transaction_id=None, transaction_flow_indicator=None, challenge_code=None, challenge_status=None, customer_card_alias=None, decoupled_authentication_indicator=None, decoupled_authentication_max_time=None, default_card=None, device_channel=None, installment_total_count=None, merchant_fraud_rate=None, marketing_opt_in=None, marketing_source=None, mcc=None, merchant_score=None, message_category=None, npa_code=None, override_payment_method=None, override_country_code=None, prior_authentication_data=None, prior_authentication_method=None, prior_authentication_reference_id=None, prior_authentication_time=None, product_code=None, return_url=None, requestor_id=None, requestor_initiated_authentication_indicator=None, requestor_name=None, reference_id=None, sdk_max_timeout=None, secure_corporate_payment_indicator=None, transaction_mode=None, white_list_status=None, score_request=None):
        """
        Riskv1decisionsConsumerAuthenticationInformation - a model defined in Swagger
        """

        self._strong_authentication = None
        self._acs_window_size = None
        self._alternate_authentication_data = None
        self._alternate_authentication_date = None
        self._alternate_authentication_method = None
        self._authentication_date = None
        self._authentication_transaction_id = None
        self._transaction_flow_indicator = None
        self._challenge_code = None
        self._challenge_status = None
        self._customer_card_alias = None
        self._decoupled_authentication_indicator = None
        self._decoupled_authentication_max_time = None
        self._default_card = None
        self._device_channel = None
        self._installment_total_count = None
        self._merchant_fraud_rate = None
        self._marketing_opt_in = None
        self._marketing_source = None
        self._mcc = None
        self._merchant_score = None
        self._message_category = None
        self._npa_code = None
        self._override_payment_method = None
        self._override_country_code = None
        self._prior_authentication_data = None
        self._prior_authentication_method = None
        self._prior_authentication_reference_id = None
        self._prior_authentication_time = None
        self._product_code = None
        self._return_url = None
        self._requestor_id = None
        self._requestor_initiated_authentication_indicator = None
        self._requestor_name = None
        self._reference_id = None
        self._sdk_max_timeout = None
        self._secure_corporate_payment_indicator = None
        self._transaction_mode = None
        self._white_list_status = None
        self._score_request = None

        if strong_authentication is not None:
          self.strong_authentication = strong_authentication
        if acs_window_size is not None:
          self.acs_window_size = acs_window_size
        if alternate_authentication_data is not None:
          self.alternate_authentication_data = alternate_authentication_data
        if alternate_authentication_date is not None:
          self.alternate_authentication_date = alternate_authentication_date
        if alternate_authentication_method is not None:
          self.alternate_authentication_method = alternate_authentication_method
        if authentication_date is not None:
          self.authentication_date = authentication_date
        if authentication_transaction_id is not None:
          self.authentication_transaction_id = authentication_transaction_id
        if transaction_flow_indicator is not None:
          self.transaction_flow_indicator = transaction_flow_indicator
        if challenge_code is not None:
          self.challenge_code = challenge_code
        if challenge_status is not None:
          self.challenge_status = challenge_status
        if customer_card_alias is not None:
          self.customer_card_alias = customer_card_alias
        if decoupled_authentication_indicator is not None:
          self.decoupled_authentication_indicator = decoupled_authentication_indicator
        if decoupled_authentication_max_time is not None:
          self.decoupled_authentication_max_time = decoupled_authentication_max_time
        if default_card is not None:
          self.default_card = default_card
        self.device_channel = device_channel
        if installment_total_count is not None:
          self.installment_total_count = installment_total_count
        if merchant_fraud_rate is not None:
          self.merchant_fraud_rate = merchant_fraud_rate
        if marketing_opt_in is not None:
          self.marketing_opt_in = marketing_opt_in
        if marketing_source is not None:
          self.marketing_source = marketing_source
        if mcc is not None:
          self.mcc = mcc
        if merchant_score is not None:
          self.merchant_score = merchant_score
        if message_category is not None:
          self.message_category = message_category
        if npa_code is not None:
          self.npa_code = npa_code
        if override_payment_method is not None:
          self.override_payment_method = override_payment_method
        if override_country_code is not None:
          self.override_country_code = override_country_code
        if prior_authentication_data is not None:
          self.prior_authentication_data = prior_authentication_data
        if prior_authentication_method is not None:
          self.prior_authentication_method = prior_authentication_method
        if prior_authentication_reference_id is not None:
          self.prior_authentication_reference_id = prior_authentication_reference_id
        if prior_authentication_time is not None:
          self.prior_authentication_time = prior_authentication_time
        if product_code is not None:
          self.product_code = product_code
        if return_url is not None:
          self.return_url = return_url
        if requestor_id is not None:
          self.requestor_id = requestor_id
        if requestor_initiated_authentication_indicator is not None:
          self.requestor_initiated_authentication_indicator = requestor_initiated_authentication_indicator
        if requestor_name is not None:
          self.requestor_name = requestor_name
        if reference_id is not None:
          self.reference_id = reference_id
        if sdk_max_timeout is not None:
          self.sdk_max_timeout = sdk_max_timeout
        if secure_corporate_payment_indicator is not None:
          self.secure_corporate_payment_indicator = secure_corporate_payment_indicator
        if transaction_mode is not None:
          self.transaction_mode = transaction_mode
        if white_list_status is not None:
          self.white_list_status = white_list_status
        if score_request is not None:
          self.score_request = score_request

    @property
    def strong_authentication(self):
        """
        Gets the strong_authentication of this Riskv1decisionsConsumerAuthenticationInformation.

        :return: The strong_authentication of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: Riskv1decisionsConsumerAuthenticationInformationStrongAuthentication
        """
        return self._strong_authentication

    @strong_authentication.setter
    def strong_authentication(self, strong_authentication):
        """
        Sets the strong_authentication of this Riskv1decisionsConsumerAuthenticationInformation.

        :param strong_authentication: The strong_authentication of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: Riskv1decisionsConsumerAuthenticationInformationStrongAuthentication
        """

        self._strong_authentication = strong_authentication

    @property
    def acs_window_size(self):
        """
        Gets the acs_window_size of this Riskv1decisionsConsumerAuthenticationInformation.
        An override field that a merchant can pass in to set the challenge window size to display to the end cardholder.  The ACS (Active Control Server) will reply with content that is formatted appropriately to this window size to allow for the best user experience.  The sizes are width x height in pixels of the window displayed in the cardholder browser window.  01 - 250x400  02 - 390x400  03 - 500x600  04 - 600x400  05 - Full page 

        :return: The acs_window_size of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._acs_window_size

    @acs_window_size.setter
    def acs_window_size(self, acs_window_size):
        """
        Sets the acs_window_size of this Riskv1decisionsConsumerAuthenticationInformation.
        An override field that a merchant can pass in to set the challenge window size to display to the end cardholder.  The ACS (Active Control Server) will reply with content that is formatted appropriately to this window size to allow for the best user experience.  The sizes are width x height in pixels of the window displayed in the cardholder browser window.  01 - 250x400  02 - 390x400  03 - 500x600  04 - 600x400  05 - Full page 

        :param acs_window_size: The acs_window_size of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._acs_window_size = acs_window_size

    @property
    def alternate_authentication_data(self):
        """
        Gets the alternate_authentication_data of this Riskv1decisionsConsumerAuthenticationInformation.
        Data that documents and supports a specific authentication process. 

        :return: The alternate_authentication_data of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._alternate_authentication_data

    @alternate_authentication_data.setter
    def alternate_authentication_data(self, alternate_authentication_data):
        """
        Sets the alternate_authentication_data of this Riskv1decisionsConsumerAuthenticationInformation.
        Data that documents and supports a specific authentication process. 

        :param alternate_authentication_data: The alternate_authentication_data of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._alternate_authentication_data = alternate_authentication_data

    @property
    def alternate_authentication_date(self):
        """
        Gets the alternate_authentication_date of this Riskv1decisionsConsumerAuthenticationInformation.
        Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM 

        :return: The alternate_authentication_date of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._alternate_authentication_date

    @alternate_authentication_date.setter
    def alternate_authentication_date(self, alternate_authentication_date):
        """
        Sets the alternate_authentication_date of this Riskv1decisionsConsumerAuthenticationInformation.
        Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM 

        :param alternate_authentication_date: The alternate_authentication_date of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._alternate_authentication_date = alternate_authentication_date

    @property
    def alternate_authentication_method(self):
        """
        Gets the alternate_authentication_method of this Riskv1decisionsConsumerAuthenticationInformation.
        Mechanism used by the cardholder to authenticate to the 3D Secure requestor. Possible values: - `01`: No authentication occurred - `02`: Login using merchant system credentials - `03`: Login using Federated ID - `04`: Login using issuer credentials - `05`: Login using third-party authenticator - `06`: Login using FIDO Authenticator 

        :return: The alternate_authentication_method of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._alternate_authentication_method

    @alternate_authentication_method.setter
    def alternate_authentication_method(self, alternate_authentication_method):
        """
        Sets the alternate_authentication_method of this Riskv1decisionsConsumerAuthenticationInformation.
        Mechanism used by the cardholder to authenticate to the 3D Secure requestor. Possible values: - `01`: No authentication occurred - `02`: Login using merchant system credentials - `03`: Login using Federated ID - `04`: Login using issuer credentials - `05`: Login using third-party authenticator - `06`: Login using FIDO Authenticator 

        :param alternate_authentication_method: The alternate_authentication_method of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._alternate_authentication_method = alternate_authentication_method

    @property
    def authentication_date(self):
        """
        Gets the authentication_date of this Riskv1decisionsConsumerAuthenticationInformation.
        The date/time of the authentication at the 3DS servers. RISK update authorization service in auth request payload with value returned in `consumerAuthenticationInformation.alternateAuthenticationData` if merchant calls via CYBS or field can be provided by merchant in authorization request if calling an external 3DS provider.  This field is supported for Cartes Bancaires Fast'R transactions on Credit Mutuel-CIC. Format: YYYYMMDDHHMMSS 

        :return: The authentication_date of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_date

    @authentication_date.setter
    def authentication_date(self, authentication_date):
        """
        Sets the authentication_date of this Riskv1decisionsConsumerAuthenticationInformation.
        The date/time of the authentication at the 3DS servers. RISK update authorization service in auth request payload with value returned in `consumerAuthenticationInformation.alternateAuthenticationData` if merchant calls via CYBS or field can be provided by merchant in authorization request if calling an external 3DS provider.  This field is supported for Cartes Bancaires Fast'R transactions on Credit Mutuel-CIC. Format: YYYYMMDDHHMMSS 

        :param authentication_date: The authentication_date of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._authentication_date = authentication_date

    @property
    def authentication_transaction_id(self):
        """
        Gets the authentication_transaction_id of this Riskv1decisionsConsumerAuthenticationInformation.
        Payer authentication transaction identifier passed to link the check enrollment and validate authentication messages.For Rupay,this is passed only in Re-Send OTP usecase. **Note**: Required for Standard integration, Rupay Seamless server to server integration for enroll service. Required for Hybrid integration for validate service. 

        :return: The authentication_transaction_id of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_transaction_id

    @authentication_transaction_id.setter
    def authentication_transaction_id(self, authentication_transaction_id):
        """
        Sets the authentication_transaction_id of this Riskv1decisionsConsumerAuthenticationInformation.
        Payer authentication transaction identifier passed to link the check enrollment and validate authentication messages.For Rupay,this is passed only in Re-Send OTP usecase. **Note**: Required for Standard integration, Rupay Seamless server to server integration for enroll service. Required for Hybrid integration for validate service. 

        :param authentication_transaction_id: The authentication_transaction_id of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._authentication_transaction_id = authentication_transaction_id

    @property
    def transaction_flow_indicator(self):
        """
        Gets the transaction_flow_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        This  field is only applicable to Rupay and is optional. Merchant will have to pass a valid value from 01 through 07 which indicates the transaction flow. Below are the possible values. 01:NW- Transaction performed at domestic merchant. 02:TW- Transaction performed at domestic merchant along with Token provisioning. 03:IT- Transaction performed at International merchant. 04:AT- Authentication Transaction Only. 05:AW- Authentication transaction for provisioning. 06:DI- Domestic InApp Transaction. 07:II- International InApp transaction. 08:GC- Guest Checkout 09:ST- SI Authentication Transaction only 10:SW- SI Authorization along with token provisioning 

        :return: The transaction_flow_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: int
        """
        return self._transaction_flow_indicator

    @transaction_flow_indicator.setter
    def transaction_flow_indicator(self, transaction_flow_indicator):
        """
        Sets the transaction_flow_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        This  field is only applicable to Rupay and is optional. Merchant will have to pass a valid value from 01 through 07 which indicates the transaction flow. Below are the possible values. 01:NW- Transaction performed at domestic merchant. 02:TW- Transaction performed at domestic merchant along with Token provisioning. 03:IT- Transaction performed at International merchant. 04:AT- Authentication Transaction Only. 05:AW- Authentication transaction for provisioning. 06:DI- Domestic InApp Transaction. 07:II- International InApp transaction. 08:GC- Guest Checkout 09:ST- SI Authentication Transaction only 10:SW- SI Authorization along with token provisioning 

        :param transaction_flow_indicator: The transaction_flow_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: int
        """

        self._transaction_flow_indicator = transaction_flow_indicator

    @property
    def challenge_code(self):
        """
        Gets the challenge_code of this Riskv1decisionsConsumerAuthenticationInformation.
        Possible values: - `01`: No preference - `02`: No challenge request - `03`: Challenge requested (3D Secure requestor preference) - `04`: Challenge requested (mandate) - `05`: No challenge requested (transactional risk analysis is already performed) - `06`: No challenge requested (Data share only) - `07`: No challenge requested (strong consumer authentication is already performed) - `08`: No challenge requested (utilize whitelist exemption if no challenge required) - `09`: Challenge requested (whitelist prompt requested if challenge required) **Note** This field will default to `01` on merchant configuration and can be overridden by the merchant. EMV 3D Secure version 2.1.0 supports values `01-04`. Version 2.2.0 supports values `01-09`. 

        :return: The challenge_code of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._challenge_code

    @challenge_code.setter
    def challenge_code(self, challenge_code):
        """
        Sets the challenge_code of this Riskv1decisionsConsumerAuthenticationInformation.
        Possible values: - `01`: No preference - `02`: No challenge request - `03`: Challenge requested (3D Secure requestor preference) - `04`: Challenge requested (mandate) - `05`: No challenge requested (transactional risk analysis is already performed) - `06`: No challenge requested (Data share only) - `07`: No challenge requested (strong consumer authentication is already performed) - `08`: No challenge requested (utilize whitelist exemption if no challenge required) - `09`: Challenge requested (whitelist prompt requested if challenge required) **Note** This field will default to `01` on merchant configuration and can be overridden by the merchant. EMV 3D Secure version 2.1.0 supports values `01-04`. Version 2.2.0 supports values `01-09`. 

        :param challenge_code: The challenge_code of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._challenge_code = challenge_code

    @property
    def challenge_status(self):
        """
        Gets the challenge_status of this Riskv1decisionsConsumerAuthenticationInformation.
        The `consumerAuthenticationInformation.challengeCode` indicates the authentication type/level, or challenge, that was presented to the cardholder at checkout by the merchant when calling the Carte Bancaire 3DS servers via CYBS RISK services. It conveys to the issuer the alternative authentication methods that the consumer used. 

        :return: The challenge_status of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._challenge_status

    @challenge_status.setter
    def challenge_status(self, challenge_status):
        """
        Sets the challenge_status of this Riskv1decisionsConsumerAuthenticationInformation.
        The `consumerAuthenticationInformation.challengeCode` indicates the authentication type/level, or challenge, that was presented to the cardholder at checkout by the merchant when calling the Carte Bancaire 3DS servers via CYBS RISK services. It conveys to the issuer the alternative authentication methods that the consumer used. 

        :param challenge_status: The challenge_status of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._challenge_status = challenge_status

    @property
    def customer_card_alias(self):
        """
        Gets the customer_card_alias of this Riskv1decisionsConsumerAuthenticationInformation.
        An alias that uniquely identifies the customer's account and credit card on file. Note This field is required if Tokenization is enabled in the merchant profile settings. 

        :return: The customer_card_alias of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._customer_card_alias

    @customer_card_alias.setter
    def customer_card_alias(self, customer_card_alias):
        """
        Sets the customer_card_alias of this Riskv1decisionsConsumerAuthenticationInformation.
        An alias that uniquely identifies the customer's account and credit card on file. Note This field is required if Tokenization is enabled in the merchant profile settings. 

        :param customer_card_alias: The customer_card_alias of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._customer_card_alias = customer_card_alias

    @property
    def decoupled_authentication_indicator(self):
        """
        Gets the decoupled_authentication_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        Indicates whether the 3DS Requestor requests the ACS to utilize Decoupled Authentication and agrees to utilize Decoupled Authentication if the ACS confirms its use.  Possible Values:  Y - Decoupled Authentication is supported and preferred if challenge is necessary  N - Do not use Decoupled Authentication  **Default Value**: N 

        :return: The decoupled_authentication_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._decoupled_authentication_indicator

    @decoupled_authentication_indicator.setter
    def decoupled_authentication_indicator(self, decoupled_authentication_indicator):
        """
        Sets the decoupled_authentication_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        Indicates whether the 3DS Requestor requests the ACS to utilize Decoupled Authentication and agrees to utilize Decoupled Authentication if the ACS confirms its use.  Possible Values:  Y - Decoupled Authentication is supported and preferred if challenge is necessary  N - Do not use Decoupled Authentication  **Default Value**: N 

        :param decoupled_authentication_indicator: The decoupled_authentication_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._decoupled_authentication_indicator = decoupled_authentication_indicator

    @property
    def decoupled_authentication_max_time(self):
        """
        Gets the decoupled_authentication_max_time of this Riskv1decisionsConsumerAuthenticationInformation.
        Indicates the maximum amount of time that the 3DS Requestor will wait for an ACS (Active control server) to provide the results of a Decoupled Authentication transaction (in minutes). Possible Values: Numeric values between 1 and 10080 accepted. 

        :return: The decoupled_authentication_max_time of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._decoupled_authentication_max_time

    @decoupled_authentication_max_time.setter
    def decoupled_authentication_max_time(self, decoupled_authentication_max_time):
        """
        Sets the decoupled_authentication_max_time of this Riskv1decisionsConsumerAuthenticationInformation.
        Indicates the maximum amount of time that the 3DS Requestor will wait for an ACS (Active control server) to provide the results of a Decoupled Authentication transaction (in minutes). Possible Values: Numeric values between 1 and 10080 accepted. 

        :param decoupled_authentication_max_time: The decoupled_authentication_max_time of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._decoupled_authentication_max_time = decoupled_authentication_max_time

    @property
    def default_card(self):
        """
        Gets the default_card of this Riskv1decisionsConsumerAuthenticationInformation.
        Indicates that the card being used is the one designated as the primary payment card for purchase. Recommended for Discover ProtectBuy. 

        :return: The default_card of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: bool
        """
        return self._default_card

    @default_card.setter
    def default_card(self, default_card):
        """
        Sets the default_card of this Riskv1decisionsConsumerAuthenticationInformation.
        Indicates that the card being used is the one designated as the primary payment card for purchase. Recommended for Discover ProtectBuy. 

        :param default_card: The default_card of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: bool
        """

        self._default_card = default_card

    @property
    def device_channel(self):
        """
        Gets the device_channel of this Riskv1decisionsConsumerAuthenticationInformation.
        Determines the channel that the transaction came through. Possible Values: SDK/Browser/3RI. 3RI - 3DS request initiated. 

        :return: The device_channel of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._device_channel

    @device_channel.setter
    def device_channel(self, device_channel):
        """
        Sets the device_channel of this Riskv1decisionsConsumerAuthenticationInformation.
        Determines the channel that the transaction came through. Possible Values: SDK/Browser/3RI. 3RI - 3DS request initiated. 

        :param device_channel: The device_channel of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._device_channel = device_channel

    @property
    def installment_total_count(self):
        """
        Gets the installment_total_count of this Riskv1decisionsConsumerAuthenticationInformation.
        An integer value greater than 1 indicating the max number of permitted authorizations for installment payments. **Note** This is required if the merchant and cardholder have agreed to installment payments. 

        :return: The installment_total_count of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: int
        """
        return self._installment_total_count

    @installment_total_count.setter
    def installment_total_count(self, installment_total_count):
        """
        Sets the installment_total_count of this Riskv1decisionsConsumerAuthenticationInformation.
        An integer value greater than 1 indicating the max number of permitted authorizations for installment payments. **Note** This is required if the merchant and cardholder have agreed to installment payments. 

        :param installment_total_count: The installment_total_count of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: int
        """

        self._installment_total_count = installment_total_count

    @property
    def merchant_fraud_rate(self):
        """
        Gets the merchant_fraud_rate of this Riskv1decisionsConsumerAuthenticationInformation.
        Calculated by merchants as per PSD2** RTS** (EEA** card fraud divided by all EEA card volumes). Possible Values: 1 = Represents fraud rate <=1  2 = Represents fraud rate >1 and <=6  3 = Represents fraud rate >6 and <=13  4 = Represents fraud rate >13 and <=25  5 = Represents fraud rate >25  EEA** = European Economic Area RTS** = Regulatory Technical Standards PSD2** = Payment Services Directive 

        :return: The merchant_fraud_rate of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._merchant_fraud_rate

    @merchant_fraud_rate.setter
    def merchant_fraud_rate(self, merchant_fraud_rate):
        """
        Sets the merchant_fraud_rate of this Riskv1decisionsConsumerAuthenticationInformation.
        Calculated by merchants as per PSD2** RTS** (EEA** card fraud divided by all EEA card volumes). Possible Values: 1 = Represents fraud rate <=1  2 = Represents fraud rate >1 and <=6  3 = Represents fraud rate >6 and <=13  4 = Represents fraud rate >13 and <=25  5 = Represents fraud rate >25  EEA** = European Economic Area RTS** = Regulatory Technical Standards PSD2** = Payment Services Directive 

        :param merchant_fraud_rate: The merchant_fraud_rate of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._merchant_fraud_rate = merchant_fraud_rate

    @property
    def marketing_opt_in(self):
        """
        Gets the marketing_opt_in of this Riskv1decisionsConsumerAuthenticationInformation.
        Indicates whether the customer has opted in for marketing offers. Recommended for Discover ProtectBuy. 

        :return: The marketing_opt_in of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: bool
        """
        return self._marketing_opt_in

    @marketing_opt_in.setter
    def marketing_opt_in(self, marketing_opt_in):
        """
        Sets the marketing_opt_in of this Riskv1decisionsConsumerAuthenticationInformation.
        Indicates whether the customer has opted in for marketing offers. Recommended for Discover ProtectBuy. 

        :param marketing_opt_in: The marketing_opt_in of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: bool
        """

        self._marketing_opt_in = marketing_opt_in

    @property
    def marketing_source(self):
        """
        Gets the marketing_source of this Riskv1decisionsConsumerAuthenticationInformation.
        Indicates origin of the marketing offer. Recommended for Discover ProtectBuy. 

        :return: The marketing_source of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._marketing_source

    @marketing_source.setter
    def marketing_source(self, marketing_source):
        """
        Sets the marketing_source of this Riskv1decisionsConsumerAuthenticationInformation.
        Indicates origin of the marketing offer. Recommended for Discover ProtectBuy. 

        :param marketing_source: The marketing_source of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._marketing_source = marketing_source

    @property
    def mcc(self):
        """
        Gets the mcc of this Riskv1decisionsConsumerAuthenticationInformation.
        Merchant category code. **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :return: The mcc of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._mcc

    @mcc.setter
    def mcc(self, mcc):
        """
        Sets the mcc of this Riskv1decisionsConsumerAuthenticationInformation.
        Merchant category code. **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :param mcc: The mcc of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._mcc = mcc

    @property
    def merchant_score(self):
        """
        Gets the merchant_score of this Riskv1decisionsConsumerAuthenticationInformation.
        Risk Score provided by merchants. This is specific for CB transactions. 

        :return: The merchant_score of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: int
        """
        return self._merchant_score

    @merchant_score.setter
    def merchant_score(self, merchant_score):
        """
        Sets the merchant_score of this Riskv1decisionsConsumerAuthenticationInformation.
        Risk Score provided by merchants. This is specific for CB transactions. 

        :param merchant_score: The merchant_score of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: int
        """

        self._merchant_score = merchant_score

    @property
    def message_category(self):
        """
        Gets the message_category of this Riskv1decisionsConsumerAuthenticationInformation.
        Category of the message for a specific use case. Possible values:  - `01`: PA- payment authentication - `02`: NPA- non-payment authentication - `03-79`: Reserved for EMVCo future use (values invalid until defined by EMVCo) - `80-99`: Reserved for DS use 

        :return: The message_category of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._message_category

    @message_category.setter
    def message_category(self, message_category):
        """
        Sets the message_category of this Riskv1decisionsConsumerAuthenticationInformation.
        Category of the message for a specific use case. Possible values:  - `01`: PA- payment authentication - `02`: NPA- non-payment authentication - `03-79`: Reserved for EMVCo future use (values invalid until defined by EMVCo) - `80-99`: Reserved for DS use 

        :param message_category: The message_category of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._message_category = message_category

    @property
    def npa_code(self):
        """
        Gets the npa_code of this Riskv1decisionsConsumerAuthenticationInformation.
        Non-Payer Authentication Indicator. Possible values: - `01`: Add card - `02`: Maintain card information - `03`: Cardholder verification for EMV token - `04-80` Reserved for EMVCo - `80-90` Reserved DS 

        :return: The npa_code of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._npa_code

    @npa_code.setter
    def npa_code(self, npa_code):
        """
        Sets the npa_code of this Riskv1decisionsConsumerAuthenticationInformation.
        Non-Payer Authentication Indicator. Possible values: - `01`: Add card - `02`: Maintain card information - `03`: Cardholder verification for EMV token - `04-80` Reserved for EMVCo - `80-90` Reserved DS 

        :param npa_code: The npa_code of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._npa_code = npa_code

    @property
    def override_payment_method(self):
        """
        Gets the override_payment_method of this Riskv1decisionsConsumerAuthenticationInformation.
        Specifies the Brazilian payment account type used for the transaction. This field overrides other payment types that might be specified in the request. Use one of the following values for this field: - `NA`: Not applicable. Do not override other payment types that are specified in the request. - `CR`: Credit card. - `DB`: Debit card. - `VSAVR`: Visa Vale Refeicao - `VSAVA`: Visa Vale Alimentacao **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :return: The override_payment_method of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._override_payment_method

    @override_payment_method.setter
    def override_payment_method(self, override_payment_method):
        """
        Sets the override_payment_method of this Riskv1decisionsConsumerAuthenticationInformation.
        Specifies the Brazilian payment account type used for the transaction. This field overrides other payment types that might be specified in the request. Use one of the following values for this field: - `NA`: Not applicable. Do not override other payment types that are specified in the request. - `CR`: Credit card. - `DB`: Debit card. - `VSAVR`: Visa Vale Refeicao - `VSAVA`: Visa Vale Alimentacao **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :param override_payment_method: The override_payment_method of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._override_payment_method = override_payment_method

    @property
    def override_country_code(self):
        """
        Gets the override_country_code of this Riskv1decisionsConsumerAuthenticationInformation.
        Two-character [ISO Standard Country Codes](https://developer.cybersource.com/library/documentation/sbc/quickref/countries_alpha_list.pdf).. 

        :return: The override_country_code of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._override_country_code

    @override_country_code.setter
    def override_country_code(self, override_country_code):
        """
        Sets the override_country_code of this Riskv1decisionsConsumerAuthenticationInformation.
        Two-character [ISO Standard Country Codes](https://developer.cybersource.com/library/documentation/sbc/quickref/countries_alpha_list.pdf).. 

        :param override_country_code: The override_country_code of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._override_country_code = override_country_code

    @property
    def prior_authentication_data(self):
        """
        Gets the prior_authentication_data of this Riskv1decisionsConsumerAuthenticationInformation.
        This field carry data that the ACS can use to verify the authentication process. 

        :return: The prior_authentication_data of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._prior_authentication_data

    @prior_authentication_data.setter
    def prior_authentication_data(self, prior_authentication_data):
        """
        Sets the prior_authentication_data of this Riskv1decisionsConsumerAuthenticationInformation.
        This field carry data that the ACS can use to verify the authentication process. 

        :param prior_authentication_data: The prior_authentication_data of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._prior_authentication_data = prior_authentication_data

    @property
    def prior_authentication_method(self):
        """
        Gets the prior_authentication_method of this Riskv1decisionsConsumerAuthenticationInformation.
        Mechanism used by the Cardholder to previously authenticate to the 3DS Requestor.  01 - Frictionless authentication occurred by ACS  02 - Cardholder challenge occurred by ACS  03 - AVS verified  04 - Other issuer methods  05-79 - Reserved for EMVCo future use (values invalid until defined by EMVCo)  80-99 - Reserved for DS use 

        :return: The prior_authentication_method of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._prior_authentication_method

    @prior_authentication_method.setter
    def prior_authentication_method(self, prior_authentication_method):
        """
        Sets the prior_authentication_method of this Riskv1decisionsConsumerAuthenticationInformation.
        Mechanism used by the Cardholder to previously authenticate to the 3DS Requestor.  01 - Frictionless authentication occurred by ACS  02 - Cardholder challenge occurred by ACS  03 - AVS verified  04 - Other issuer methods  05-79 - Reserved for EMVCo future use (values invalid until defined by EMVCo)  80-99 - Reserved for DS use 

        :param prior_authentication_method: The prior_authentication_method of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._prior_authentication_method = prior_authentication_method

    @property
    def prior_authentication_reference_id(self):
        """
        Gets the prior_authentication_reference_id of this Riskv1decisionsConsumerAuthenticationInformation.
        This data element contains a ACS Transaction ID for a prior authenticated transaction. For example, the first recurring transaction that was authenticated with the cardholder 

        :return: The prior_authentication_reference_id of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._prior_authentication_reference_id

    @prior_authentication_reference_id.setter
    def prior_authentication_reference_id(self, prior_authentication_reference_id):
        """
        Sets the prior_authentication_reference_id of this Riskv1decisionsConsumerAuthenticationInformation.
        This data element contains a ACS Transaction ID for a prior authenticated transaction. For example, the first recurring transaction that was authenticated with the cardholder 

        :param prior_authentication_reference_id: The prior_authentication_reference_id of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._prior_authentication_reference_id = prior_authentication_reference_id

    @property
    def prior_authentication_time(self):
        """
        Gets the prior_authentication_time of this Riskv1decisionsConsumerAuthenticationInformation.
        Date and time in UTC of the prior cardholder authentication. Format – YYYYMMDDHHMM 

        :return: The prior_authentication_time of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._prior_authentication_time

    @prior_authentication_time.setter
    def prior_authentication_time(self, prior_authentication_time):
        """
        Sets the prior_authentication_time of this Riskv1decisionsConsumerAuthenticationInformation.
        Date and time in UTC of the prior cardholder authentication. Format – YYYYMMDDHHMM 

        :param prior_authentication_time: The prior_authentication_time of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._prior_authentication_time = prior_authentication_time

    @property
    def product_code(self):
        """
        Gets the product_code of this Riskv1decisionsConsumerAuthenticationInformation.
        Specifies the product code, which designates the type of transaction. Specify one of the following values for this field: - AIR: Airline purchase Important Required for American Express SafeKey (U.S.). - `ACC`: Accommodation Rental - `ACF`: Account funding - `CHA`: Check acceptance - `DIG`: Digital Goods - `DSP`: Cash Dispensing - `GAS`: Fuel - `GEN`: General Retail - `LUX`: Luxury Retail - `PAL`: Prepaid activation and load - `PHY`: Goods or services purchase - `QCT`: Quasi-cash transaction - `REN`: Car Rental - `RES`: Restaurant - `SVC`: Services - `TBD`: Other - `TRA`: Travel **Important** Required for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :return: The product_code of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._product_code

    @product_code.setter
    def product_code(self, product_code):
        """
        Sets the product_code of this Riskv1decisionsConsumerAuthenticationInformation.
        Specifies the product code, which designates the type of transaction. Specify one of the following values for this field: - AIR: Airline purchase Important Required for American Express SafeKey (U.S.). - `ACC`: Accommodation Rental - `ACF`: Account funding - `CHA`: Check acceptance - `DIG`: Digital Goods - `DSP`: Cash Dispensing - `GAS`: Fuel - `GEN`: General Retail - `LUX`: Luxury Retail - `PAL`: Prepaid activation and load - `PHY`: Goods or services purchase - `QCT`: Quasi-cash transaction - `REN`: Car Rental - `RES`: Restaurant - `SVC`: Services - `TBD`: Other - `TRA`: Travel **Important** Required for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :param product_code: The product_code of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._product_code = product_code

    @property
    def return_url(self):
        """
        Gets the return_url of this Riskv1decisionsConsumerAuthenticationInformation.
        The URL of the merchant's return page. CyberSource adds this return URL to the step-up JWT and returns it in the response of the Payer Authentication enrollment call. The merchant's return URL page serves as a listening URL. Once the bank session completes, the merchant receives a POST to their URL. This response contains the completed bank session's transactionId. The merchant's return page should capture the transaction ID and send it in the Payer Authentication validation call. 

        :return: The return_url of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._return_url

    @return_url.setter
    def return_url(self, return_url):
        """
        Sets the return_url of this Riskv1decisionsConsumerAuthenticationInformation.
        The URL of the merchant's return page. CyberSource adds this return URL to the step-up JWT and returns it in the response of the Payer Authentication enrollment call. The merchant's return URL page serves as a listening URL. Once the bank session completes, the merchant receives a POST to their URL. This response contains the completed bank session's transactionId. The merchant's return page should capture the transaction ID and send it in the Payer Authentication validation call. 

        :param return_url: The return_url of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._return_url = return_url

    @property
    def requestor_id(self):
        """
        Gets the requestor_id of this Riskv1decisionsConsumerAuthenticationInformation.
        Cardinal's directory server assigned 3DS Requestor ID value

        :return: The requestor_id of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._requestor_id

    @requestor_id.setter
    def requestor_id(self, requestor_id):
        """
        Sets the requestor_id of this Riskv1decisionsConsumerAuthenticationInformation.
        Cardinal's directory server assigned 3DS Requestor ID value

        :param requestor_id: The requestor_id of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._requestor_id = requestor_id

    @property
    def requestor_initiated_authentication_indicator(self):
        """
        Gets the requestor_initiated_authentication_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        Indicates the type of 3RI request.  Possible Values:  01 - Recurring transaction  02 - Installment transaction  03 - Add card  04 - Maintain card  05 - Account verification  06 - Split/delayed shipment  07 - Top-up  08 - Mail Order  09 - Telephone Order  10 - Whitelist status check  11 - Other payment 

        :return: The requestor_initiated_authentication_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._requestor_initiated_authentication_indicator

    @requestor_initiated_authentication_indicator.setter
    def requestor_initiated_authentication_indicator(self, requestor_initiated_authentication_indicator):
        """
        Sets the requestor_initiated_authentication_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        Indicates the type of 3RI request.  Possible Values:  01 - Recurring transaction  02 - Installment transaction  03 - Add card  04 - Maintain card  05 - Account verification  06 - Split/delayed shipment  07 - Top-up  08 - Mail Order  09 - Telephone Order  10 - Whitelist status check  11 - Other payment 

        :param requestor_initiated_authentication_indicator: The requestor_initiated_authentication_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._requestor_initiated_authentication_indicator = requestor_initiated_authentication_indicator

    @property
    def requestor_name(self):
        """
        Gets the requestor_name of this Riskv1decisionsConsumerAuthenticationInformation.
        Cardinal's directory server assigned 3DS Requestor Name value

        :return: The requestor_name of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._requestor_name

    @requestor_name.setter
    def requestor_name(self, requestor_name):
        """
        Sets the requestor_name of this Riskv1decisionsConsumerAuthenticationInformation.
        Cardinal's directory server assigned 3DS Requestor Name value

        :param requestor_name: The requestor_name of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._requestor_name = requestor_name

    @property
    def reference_id(self):
        """
        Gets the reference_id of this Riskv1decisionsConsumerAuthenticationInformation.
        Reference ID that corresponds to the device fingerprinting data that was collected previously. Note Required for Hybrid integration. 

        :return: The reference_id of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._reference_id

    @reference_id.setter
    def reference_id(self, reference_id):
        """
        Sets the reference_id of this Riskv1decisionsConsumerAuthenticationInformation.
        Reference ID that corresponds to the device fingerprinting data that was collected previously. Note Required for Hybrid integration. 

        :param reference_id: The reference_id of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._reference_id = reference_id

    @property
    def sdk_max_timeout(self):
        """
        Gets the sdk_max_timeout of this Riskv1decisionsConsumerAuthenticationInformation.
        This field indicates the maximum amount of time for all 3DS 2.0 messages to be communicated between all components (in minutes).  Possible Values:  Greater than or equal to 05 (05 is the minimum timeout to set)  Cardinal Default is set to 15  NOTE: This field is a required 3DS 2.0 field and Cardinal sends in a default of 15 if nothing is passed 

        :return: The sdk_max_timeout of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._sdk_max_timeout

    @sdk_max_timeout.setter
    def sdk_max_timeout(self, sdk_max_timeout):
        """
        Sets the sdk_max_timeout of this Riskv1decisionsConsumerAuthenticationInformation.
        This field indicates the maximum amount of time for all 3DS 2.0 messages to be communicated between all components (in minutes).  Possible Values:  Greater than or equal to 05 (05 is the minimum timeout to set)  Cardinal Default is set to 15  NOTE: This field is a required 3DS 2.0 field and Cardinal sends in a default of 15 if nothing is passed 

        :param sdk_max_timeout: The sdk_max_timeout of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._sdk_max_timeout = sdk_max_timeout

    @property
    def secure_corporate_payment_indicator(self):
        """
        Gets the secure_corporate_payment_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        Indicates dedicated payment processes and procedures were used, potential secure corporate payment exemption applies. Possible Values : 0/1 

        :return: The secure_corporate_payment_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._secure_corporate_payment_indicator

    @secure_corporate_payment_indicator.setter
    def secure_corporate_payment_indicator(self, secure_corporate_payment_indicator):
        """
        Sets the secure_corporate_payment_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        Indicates dedicated payment processes and procedures were used, potential secure corporate payment exemption applies. Possible Values : 0/1 

        :param secure_corporate_payment_indicator: The secure_corporate_payment_indicator of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._secure_corporate_payment_indicator = secure_corporate_payment_indicator

    @property
    def transaction_mode(self):
        """
        Gets the transaction_mode of this Riskv1decisionsConsumerAuthenticationInformation.
        Transaction mode identifier. Identifies the channel from which the transaction originates. Possible values:  - `M`: MOTO (Mail Order Telephone Order) - `R`: Retail - `S`: eCommerce - `P`: Mobile Device - `T`: Tablet 

        :return: The transaction_mode of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._transaction_mode

    @transaction_mode.setter
    def transaction_mode(self, transaction_mode):
        """
        Sets the transaction_mode of this Riskv1decisionsConsumerAuthenticationInformation.
        Transaction mode identifier. Identifies the channel from which the transaction originates. Possible values:  - `M`: MOTO (Mail Order Telephone Order) - `R`: Retail - `S`: eCommerce - `P`: Mobile Device - `T`: Tablet 

        :param transaction_mode: The transaction_mode of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._transaction_mode = transaction_mode

    @property
    def white_list_status(self):
        """
        Gets the white_list_status of this Riskv1decisionsConsumerAuthenticationInformation.
        Enables the communication of trusted beneficiary/whitelist status between the ACS, the DS and the 3DS Requestor.  Possible Values:  Y - 3DS Requestor is whitelisted by cardholder  N - 3DS Requestor is not whitelisted by cardholder 

        :return: The white_list_status of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._white_list_status

    @white_list_status.setter
    def white_list_status(self, white_list_status):
        """
        Sets the white_list_status of this Riskv1decisionsConsumerAuthenticationInformation.
        Enables the communication of trusted beneficiary/whitelist status between the ACS, the DS and the 3DS Requestor.  Possible Values:  Y - 3DS Requestor is whitelisted by cardholder  N - 3DS Requestor is not whitelisted by cardholder 

        :param white_list_status: The white_list_status of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: str
        """

        self._white_list_status = white_list_status

    @property
    def score_request(self):
        """
        Gets the score_request of this Riskv1decisionsConsumerAuthenticationInformation.
        Risk Assessment from Mastercard. This is to be sent by merchant if they would like to request a score

        :return: The score_request of this Riskv1decisionsConsumerAuthenticationInformation.
        :rtype: int
        """
        return self._score_request

    @score_request.setter
    def score_request(self, score_request):
        """
        Sets the score_request of this Riskv1decisionsConsumerAuthenticationInformation.
        Risk Assessment from Mastercard. This is to be sent by merchant if they would like to request a score

        :param score_request: The score_request of this Riskv1decisionsConsumerAuthenticationInformation.
        :type: int
        """

        self._score_request = score_request

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Riskv1decisionsConsumerAuthenticationInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
