# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class Riskv1authenticationsBuyerInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'merchant_customer_id': 'str',
        'personal_identification': 'list[Ptsv2paymentsBuyerInformationPersonalIdentification]',
        'mobile_phone': 'int',
        'work_phone': 'int'
    }

    attribute_map = {
        'merchant_customer_id': 'merchantCustomerId',
        'personal_identification': 'personalIdentification',
        'mobile_phone': 'mobilePhone',
        'work_phone': 'workPhone'
    }

    def __init__(self, merchant_customer_id=None, personal_identification=None, mobile_phone=None, work_phone=None):
        """
        Riskv1authenticationsBuyerInformation - a model defined in Swagger
        """

        self._merchant_customer_id = None
        self._personal_identification = None
        self._mobile_phone = None
        self._work_phone = None

        if merchant_customer_id is not None:
          self.merchant_customer_id = merchant_customer_id
        if personal_identification is not None:
          self.personal_identification = personal_identification
        self.mobile_phone = mobile_phone
        if work_phone is not None:
          self.work_phone = work_phone

    @property
    def merchant_customer_id(self):
        """
        Gets the merchant_customer_id of this Riskv1authenticationsBuyerInformation.
        Your identifier for the customer.  When a subscription or customer profile is being created, the maximum length for this field for most processors is 30. Otherwise, the maximum length is 100.  #### Comercio Latino For recurring payments in Mexico, the value is the customer's contract number. Note Before you request the authorization, you must inform the issuer of the customer contract numbers that will be used for recurring transactions.  #### Worldpay VAP For a follow-on credit with Worldpay VAP, CyberSource checks the following locations, in the order given, for a customer account ID value and uses the first value it finds: 1. `customer_account_id` value in the follow-on credit request 2. Customer account ID value that was used for the capture that is being credited 3. Customer account ID value that was used for the original authorization If a customer account ID value cannot be found in any of these locations, then no value is used. 

        :return: The merchant_customer_id of this Riskv1authenticationsBuyerInformation.
        :rtype: str
        """
        return self._merchant_customer_id

    @merchant_customer_id.setter
    def merchant_customer_id(self, merchant_customer_id):
        """
        Sets the merchant_customer_id of this Riskv1authenticationsBuyerInformation.
        Your identifier for the customer.  When a subscription or customer profile is being created, the maximum length for this field for most processors is 30. Otherwise, the maximum length is 100.  #### Comercio Latino For recurring payments in Mexico, the value is the customer's contract number. Note Before you request the authorization, you must inform the issuer of the customer contract numbers that will be used for recurring transactions.  #### Worldpay VAP For a follow-on credit with Worldpay VAP, CyberSource checks the following locations, in the order given, for a customer account ID value and uses the first value it finds: 1. `customer_account_id` value in the follow-on credit request 2. Customer account ID value that was used for the capture that is being credited 3. Customer account ID value that was used for the original authorization If a customer account ID value cannot be found in any of these locations, then no value is used. 

        :param merchant_customer_id: The merchant_customer_id of this Riskv1authenticationsBuyerInformation.
        :type: str
        """

        self._merchant_customer_id = merchant_customer_id

    @property
    def personal_identification(self):
        """
        Gets the personal_identification of this Riskv1authenticationsBuyerInformation.
        This array contains detailed information about the buyer's form of persoanl identification.

        :return: The personal_identification of this Riskv1authenticationsBuyerInformation.
        :rtype: list[Ptsv2paymentsBuyerInformationPersonalIdentification]
        """
        return self._personal_identification

    @personal_identification.setter
    def personal_identification(self, personal_identification):
        """
        Sets the personal_identification of this Riskv1authenticationsBuyerInformation.
        This array contains detailed information about the buyer's form of persoanl identification.

        :param personal_identification: The personal_identification of this Riskv1authenticationsBuyerInformation.
        :type: list[Ptsv2paymentsBuyerInformationPersonalIdentification]
        """

        self._personal_identification = personal_identification

    @property
    def mobile_phone(self):
        """
        Gets the mobile_phone of this Riskv1authenticationsBuyerInformation.
        Cardholder's mobile phone number. **Important** Required for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :return: The mobile_phone of this Riskv1authenticationsBuyerInformation.
        :rtype: int
        """
        return self._mobile_phone

    @mobile_phone.setter
    def mobile_phone(self, mobile_phone):
        """
        Sets the mobile_phone of this Riskv1authenticationsBuyerInformation.
        Cardholder's mobile phone number. **Important** Required for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :param mobile_phone: The mobile_phone of this Riskv1authenticationsBuyerInformation.
        :type: int
        """

        self._mobile_phone = mobile_phone

    @property
    def work_phone(self):
        """
        Gets the work_phone of this Riskv1authenticationsBuyerInformation.
        Cardholder's work phone number.

        :return: The work_phone of this Riskv1authenticationsBuyerInformation.
        :rtype: int
        """
        return self._work_phone

    @work_phone.setter
    def work_phone(self, work_phone):
        """
        Sets the work_phone of this Riskv1authenticationsBuyerInformation.
        Cardholder's work phone number.

        :param work_phone: The work_phone of this Riskv1authenticationsBuyerInformation.
        :type: int
        """

        self._work_phone = work_phone

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Riskv1authenticationsBuyerInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
