# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class PushFunds201ResponseProcessorInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'transaction_id': 'int',
        'response_code': 'str',
        'system_trace_audit_number': 'str',
        'retrieval_reference_number': 'str',
        'action_code': 'str',
        'approval_code': 'str',
        'fee_program_indicator': 'str',
        'name': 'str',
        'routing': 'PushFunds201ResponseProcessorInformationRouting',
        'settlement': 'PushFunds201ResponseProcessorInformationSettlement'
    }

    attribute_map = {
        'transaction_id': 'transactionId',
        'response_code': 'responseCode',
        'system_trace_audit_number': 'systemTraceAuditNumber',
        'retrieval_reference_number': 'retrievalReferenceNumber',
        'action_code': 'actionCode',
        'approval_code': 'approvalCode',
        'fee_program_indicator': 'feeProgramIndicator',
        'name': 'name',
        'routing': 'routing',
        'settlement': 'settlement'
    }

    def __init__(self, transaction_id=None, response_code=None, system_trace_audit_number=None, retrieval_reference_number=None, action_code=None, approval_code=None, fee_program_indicator=None, name=None, routing=None, settlement=None):
        """
        PushFunds201ResponseProcessorInformation - a model defined in Swagger
        """

        self._transaction_id = None
        self._response_code = None
        self._system_trace_audit_number = None
        self._retrieval_reference_number = None
        self._action_code = None
        self._approval_code = None
        self._fee_program_indicator = None
        self._name = None
        self._routing = None
        self._settlement = None

        if transaction_id is not None:
          self.transaction_id = transaction_id
        if response_code is not None:
          self.response_code = response_code
        if system_trace_audit_number is not None:
          self.system_trace_audit_number = system_trace_audit_number
        if retrieval_reference_number is not None:
          self.retrieval_reference_number = retrieval_reference_number
        if action_code is not None:
          self.action_code = action_code
        if approval_code is not None:
          self.approval_code = approval_code
        if fee_program_indicator is not None:
          self.fee_program_indicator = fee_program_indicator
        if name is not None:
          self.name = name
        if routing is not None:
          self.routing = routing
        if settlement is not None:
          self.settlement = settlement

    @property
    def transaction_id(self):
        """
        Gets the transaction_id of this PushFunds201ResponseProcessorInformation.
        Network transaction identifier (TID). This value can be used to identify a specific transaction when you are discussing the transaction with your processor. 

        :return: The transaction_id of this PushFunds201ResponseProcessorInformation.
        :rtype: int
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """
        Sets the transaction_id of this PushFunds201ResponseProcessorInformation.
        Network transaction identifier (TID). This value can be used to identify a specific transaction when you are discussing the transaction with your processor. 

        :param transaction_id: The transaction_id of this PushFunds201ResponseProcessorInformation.
        :type: int
        """

        self._transaction_id = transaction_id

    @property
    def response_code(self):
        """
        Gets the response_code of this PushFunds201ResponseProcessorInformation.
        Transaction status from the processor. 

        :return: The response_code of this PushFunds201ResponseProcessorInformation.
        :rtype: str
        """
        return self._response_code

    @response_code.setter
    def response_code(self, response_code):
        """
        Sets the response_code of this PushFunds201ResponseProcessorInformation.
        Transaction status from the processor. 

        :param response_code: The response_code of this PushFunds201ResponseProcessorInformation.
        :type: str
        """

        self._response_code = response_code

    @property
    def system_trace_audit_number(self):
        """
        Gets the system_trace_audit_number of this PushFunds201ResponseProcessorInformation.
        This field is returned by authorization and incremental authorization services. System trace number that must be printed on the customer's receipt. 

        :return: The system_trace_audit_number of this PushFunds201ResponseProcessorInformation.
        :rtype: str
        """
        return self._system_trace_audit_number

    @system_trace_audit_number.setter
    def system_trace_audit_number(self, system_trace_audit_number):
        """
        Sets the system_trace_audit_number of this PushFunds201ResponseProcessorInformation.
        This field is returned by authorization and incremental authorization services. System trace number that must be printed on the customer's receipt. 

        :param system_trace_audit_number: The system_trace_audit_number of this PushFunds201ResponseProcessorInformation.
        :type: str
        """

        self._system_trace_audit_number = system_trace_audit_number

    @property
    def retrieval_reference_number(self):
        """
        Gets the retrieval_reference_number of this PushFunds201ResponseProcessorInformation.
        This field contains a number that is used with other data elements as a key to identify and track all messages related to a given cardholder transaction; that is, to a given transaction set.  Recommended format: ydddhhnnnnnn  Positions 1-4: The yddd equivalent of the date, where y = 0-9 and ddd = 001 – 366. Positions 5-12: A unique identification number generated by the merchant or assigned by Cybersource. 

        :return: The retrieval_reference_number of this PushFunds201ResponseProcessorInformation.
        :rtype: str
        """
        return self._retrieval_reference_number

    @retrieval_reference_number.setter
    def retrieval_reference_number(self, retrieval_reference_number):
        """
        Sets the retrieval_reference_number of this PushFunds201ResponseProcessorInformation.
        This field contains a number that is used with other data elements as a key to identify and track all messages related to a given cardholder transaction; that is, to a given transaction set.  Recommended format: ydddhhnnnnnn  Positions 1-4: The yddd equivalent of the date, where y = 0-9 and ddd = 001 – 366. Positions 5-12: A unique identification number generated by the merchant or assigned by Cybersource. 

        :param retrieval_reference_number: The retrieval_reference_number of this PushFunds201ResponseProcessorInformation.
        :type: str
        """

        self._retrieval_reference_number = retrieval_reference_number

    @property
    def action_code(self):
        """
        Gets the action_code of this PushFunds201ResponseProcessorInformation.
        The results of the transaction request  Note: The VisaNet Response Code for the transaction 

        :return: The action_code of this PushFunds201ResponseProcessorInformation.
        :rtype: str
        """
        return self._action_code

    @action_code.setter
    def action_code(self, action_code):
        """
        Sets the action_code of this PushFunds201ResponseProcessorInformation.
        The results of the transaction request  Note: The VisaNet Response Code for the transaction 

        :param action_code: The action_code of this PushFunds201ResponseProcessorInformation.
        :type: str
        """

        self._action_code = action_code

    @property
    def approval_code(self):
        """
        Gets the approval_code of this PushFunds201ResponseProcessorInformation.
        Issuer-generated approval code for the transaction. 

        :return: The approval_code of this PushFunds201ResponseProcessorInformation.
        :rtype: str
        """
        return self._approval_code

    @approval_code.setter
    def approval_code(self, approval_code):
        """
        Sets the approval_code of this PushFunds201ResponseProcessorInformation.
        Issuer-generated approval code for the transaction. 

        :param approval_code: The approval_code of this PushFunds201ResponseProcessorInformation.
        :type: str
        """

        self._approval_code = approval_code

    @property
    def fee_program_indicator(self):
        """
        Gets the fee_program_indicator of this PushFunds201ResponseProcessorInformation.
        This field identifies the interchange fee program applicable to each financial transaction. Fee program indicator (FPI) values correspond to the fee descriptor and rate for each existing fee program. 

        :return: The fee_program_indicator of this PushFunds201ResponseProcessorInformation.
        :rtype: str
        """
        return self._fee_program_indicator

    @fee_program_indicator.setter
    def fee_program_indicator(self, fee_program_indicator):
        """
        Sets the fee_program_indicator of this PushFunds201ResponseProcessorInformation.
        This field identifies the interchange fee program applicable to each financial transaction. Fee program indicator (FPI) values correspond to the fee descriptor and rate for each existing fee program. 

        :param fee_program_indicator: The fee_program_indicator of this PushFunds201ResponseProcessorInformation.
        :type: str
        """

        self._fee_program_indicator = fee_program_indicator

    @property
    def name(self):
        """
        Gets the name of this PushFunds201ResponseProcessorInformation.
        Name of the processor. 

        :return: The name of this PushFunds201ResponseProcessorInformation.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PushFunds201ResponseProcessorInformation.
        Name of the processor. 

        :param name: The name of this PushFunds201ResponseProcessorInformation.
        :type: str
        """

        self._name = name

    @property
    def routing(self):
        """
        Gets the routing of this PushFunds201ResponseProcessorInformation.

        :return: The routing of this PushFunds201ResponseProcessorInformation.
        :rtype: PushFunds201ResponseProcessorInformationRouting
        """
        return self._routing

    @routing.setter
    def routing(self, routing):
        """
        Sets the routing of this PushFunds201ResponseProcessorInformation.

        :param routing: The routing of this PushFunds201ResponseProcessorInformation.
        :type: PushFunds201ResponseProcessorInformationRouting
        """

        self._routing = routing

    @property
    def settlement(self):
        """
        Gets the settlement of this PushFunds201ResponseProcessorInformation.

        :return: The settlement of this PushFunds201ResponseProcessorInformation.
        :rtype: PushFunds201ResponseProcessorInformationSettlement
        """
        return self._settlement

    @settlement.setter
    def settlement(self, settlement):
        """
        Sets the settlement of this PushFunds201ResponseProcessorInformation.

        :param settlement: The settlement of this PushFunds201ResponseProcessorInformation.
        :type: PushFunds201ResponseProcessorInformationSettlement
        """

        self._settlement = settlement

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PushFunds201ResponseProcessorInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
