# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class Ptsv2paymentsTravelInformationTransitAirline(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_domestic': 'str',
        'booking_reference_number': 'str',
        'carrier_name': 'str',
        'ticket_issuer': 'Ptsv2paymentsTravelInformationTransitAirlineTicketIssuer',
        'ticket_number': 'str',
        'check_digit': 'str',
        'restricted_ticket_indicator': 'int',
        'transaction_type': 'int',
        'extended_payment_code': 'str',
        'passenger_name': 'str',
        'customer_code': 'str',
        'document_type': 'str',
        'document_number': 'str',
        'document_number_of_parts': 'int',
        'invoice_number': 'str',
        'invoice_date': 'int',
        'additional_charges': 'str',
        'total_fee_amount': 'str',
        'clearing_sequence': 'str',
        'clearing_count': 'str',
        'total_clearing_amount': 'str',
        'number_of_passengers': 'int',
        'reservation_system_code': 'str',
        'process_identifier': 'str',
        'ticket_issue_date': 'str',
        'electronic_ticket_indicator': 'bool',
        'original_ticket_number': 'str',
        'purchase_type': 'str',
        'credit_reason_indicator': 'str',
        'ticket_change_indicator': 'str',
        'plan_number': 'str',
        'arrival_date': 'str',
        'restricted_ticket_desciption': 'str',
        'exchange_ticket_amount': 'str',
        'exchange_ticket_fee_amount': 'str',
        'reservation_type': 'str',
        'boarding_fee_amount': 'str',
        'legs': 'list[Ptsv2paymentsTravelInformationTransitAirlineLegs]',
        'ancillary_information': 'Ptsv2paymentsTravelInformationTransitAirlineAncillaryInformation',
        'flight_type': 'str',
        'insurance_amount': 'str',
        'frequent_flyer_number': 'str',
        'third_party_status': 'str',
        'passenger_type': 'str',
        'total_insurance_amount': 'str'
    }

    attribute_map = {
        'is_domestic': 'isDomestic',
        'booking_reference_number': 'bookingReferenceNumber',
        'carrier_name': 'carrierName',
        'ticket_issuer': 'ticketIssuer',
        'ticket_number': 'ticketNumber',
        'check_digit': 'checkDigit',
        'restricted_ticket_indicator': 'restrictedTicketIndicator',
        'transaction_type': 'transactionType',
        'extended_payment_code': 'extendedPaymentCode',
        'passenger_name': 'passengerName',
        'customer_code': 'customerCode',
        'document_type': 'documentType',
        'document_number': 'documentNumber',
        'document_number_of_parts': 'documentNumberOfParts',
        'invoice_number': 'invoiceNumber',
        'invoice_date': 'invoiceDate',
        'additional_charges': 'additionalCharges',
        'total_fee_amount': 'totalFeeAmount',
        'clearing_sequence': 'clearingSequence',
        'clearing_count': 'clearingCount',
        'total_clearing_amount': 'totalClearingAmount',
        'number_of_passengers': 'numberOfPassengers',
        'reservation_system_code': 'reservationSystemCode',
        'process_identifier': 'processIdentifier',
        'ticket_issue_date': 'ticketIssueDate',
        'electronic_ticket_indicator': 'electronicTicketIndicator',
        'original_ticket_number': 'originalTicketNumber',
        'purchase_type': 'purchaseType',
        'credit_reason_indicator': 'creditReasonIndicator',
        'ticket_change_indicator': 'ticketChangeIndicator',
        'plan_number': 'planNumber',
        'arrival_date': 'arrivalDate',
        'restricted_ticket_desciption': 'restrictedTicketDesciption',
        'exchange_ticket_amount': 'exchangeTicketAmount',
        'exchange_ticket_fee_amount': 'exchangeTicketFeeAmount',
        'reservation_type': 'reservationType',
        'boarding_fee_amount': 'boardingFeeAmount',
        'legs': 'legs',
        'ancillary_information': 'ancillaryInformation',
        'flight_type': 'flightType',
        'insurance_amount': 'insuranceAmount',
        'frequent_flyer_number': 'frequentFlyerNumber',
        'third_party_status': 'thirdPartyStatus',
        'passenger_type': 'passengerType',
        'total_insurance_amount': 'totalInsuranceAmount'
    }

    def __init__(self, is_domestic=None, booking_reference_number=None, carrier_name=None, ticket_issuer=None, ticket_number=None, check_digit=None, restricted_ticket_indicator=None, transaction_type=None, extended_payment_code=None, passenger_name=None, customer_code=None, document_type=None, document_number=None, document_number_of_parts=None, invoice_number=None, invoice_date=None, additional_charges=None, total_fee_amount=None, clearing_sequence=None, clearing_count=None, total_clearing_amount=None, number_of_passengers=None, reservation_system_code=None, process_identifier=None, ticket_issue_date=None, electronic_ticket_indicator=None, original_ticket_number=None, purchase_type=None, credit_reason_indicator=None, ticket_change_indicator=None, plan_number=None, arrival_date=None, restricted_ticket_desciption=None, exchange_ticket_amount=None, exchange_ticket_fee_amount=None, reservation_type=None, boarding_fee_amount=None, legs=None, ancillary_information=None, flight_type=None, insurance_amount=None, frequent_flyer_number=None, third_party_status=None, passenger_type=None, total_insurance_amount=None):
        """
        Ptsv2paymentsTravelInformationTransitAirline - a model defined in Swagger
        """

        self._is_domestic = None
        self._booking_reference_number = None
        self._carrier_name = None
        self._ticket_issuer = None
        self._ticket_number = None
        self._check_digit = None
        self._restricted_ticket_indicator = None
        self._transaction_type = None
        self._extended_payment_code = None
        self._passenger_name = None
        self._customer_code = None
        self._document_type = None
        self._document_number = None
        self._document_number_of_parts = None
        self._invoice_number = None
        self._invoice_date = None
        self._additional_charges = None
        self._total_fee_amount = None
        self._clearing_sequence = None
        self._clearing_count = None
        self._total_clearing_amount = None
        self._number_of_passengers = None
        self._reservation_system_code = None
        self._process_identifier = None
        self._ticket_issue_date = None
        self._electronic_ticket_indicator = None
        self._original_ticket_number = None
        self._purchase_type = None
        self._credit_reason_indicator = None
        self._ticket_change_indicator = None
        self._plan_number = None
        self._arrival_date = None
        self._restricted_ticket_desciption = None
        self._exchange_ticket_amount = None
        self._exchange_ticket_fee_amount = None
        self._reservation_type = None
        self._boarding_fee_amount = None
        self._legs = None
        self._ancillary_information = None
        self._flight_type = None
        self._insurance_amount = None
        self._frequent_flyer_number = None
        self._third_party_status = None
        self._passenger_type = None
        self._total_insurance_amount = None

        if is_domestic is not None:
          self.is_domestic = is_domestic
        if booking_reference_number is not None:
          self.booking_reference_number = booking_reference_number
        if carrier_name is not None:
          self.carrier_name = carrier_name
        if ticket_issuer is not None:
          self.ticket_issuer = ticket_issuer
        if ticket_number is not None:
          self.ticket_number = ticket_number
        if check_digit is not None:
          self.check_digit = check_digit
        if restricted_ticket_indicator is not None:
          self.restricted_ticket_indicator = restricted_ticket_indicator
        if transaction_type is not None:
          self.transaction_type = transaction_type
        if extended_payment_code is not None:
          self.extended_payment_code = extended_payment_code
        if passenger_name is not None:
          self.passenger_name = passenger_name
        if customer_code is not None:
          self.customer_code = customer_code
        if document_type is not None:
          self.document_type = document_type
        if document_number is not None:
          self.document_number = document_number
        if document_number_of_parts is not None:
          self.document_number_of_parts = document_number_of_parts
        if invoice_number is not None:
          self.invoice_number = invoice_number
        if invoice_date is not None:
          self.invoice_date = invoice_date
        if additional_charges is not None:
          self.additional_charges = additional_charges
        if total_fee_amount is not None:
          self.total_fee_amount = total_fee_amount
        if clearing_sequence is not None:
          self.clearing_sequence = clearing_sequence
        if clearing_count is not None:
          self.clearing_count = clearing_count
        if total_clearing_amount is not None:
          self.total_clearing_amount = total_clearing_amount
        if number_of_passengers is not None:
          self.number_of_passengers = number_of_passengers
        if reservation_system_code is not None:
          self.reservation_system_code = reservation_system_code
        if process_identifier is not None:
          self.process_identifier = process_identifier
        if ticket_issue_date is not None:
          self.ticket_issue_date = ticket_issue_date
        if electronic_ticket_indicator is not None:
          self.electronic_ticket_indicator = electronic_ticket_indicator
        if original_ticket_number is not None:
          self.original_ticket_number = original_ticket_number
        if purchase_type is not None:
          self.purchase_type = purchase_type
        if credit_reason_indicator is not None:
          self.credit_reason_indicator = credit_reason_indicator
        if ticket_change_indicator is not None:
          self.ticket_change_indicator = ticket_change_indicator
        if plan_number is not None:
          self.plan_number = plan_number
        if arrival_date is not None:
          self.arrival_date = arrival_date
        if restricted_ticket_desciption is not None:
          self.restricted_ticket_desciption = restricted_ticket_desciption
        if exchange_ticket_amount is not None:
          self.exchange_ticket_amount = exchange_ticket_amount
        if exchange_ticket_fee_amount is not None:
          self.exchange_ticket_fee_amount = exchange_ticket_fee_amount
        if reservation_type is not None:
          self.reservation_type = reservation_type
        if boarding_fee_amount is not None:
          self.boarding_fee_amount = boarding_fee_amount
        if legs is not None:
          self.legs = legs
        if ancillary_information is not None:
          self.ancillary_information = ancillary_information
        if flight_type is not None:
          self.flight_type = flight_type
        if insurance_amount is not None:
          self.insurance_amount = insurance_amount
        if frequent_flyer_number is not None:
          self.frequent_flyer_number = frequent_flyer_number
        if third_party_status is not None:
          self.third_party_status = third_party_status
        if passenger_type is not None:
          self.passenger_type = passenger_type
        if total_insurance_amount is not None:
          self.total_insurance_amount = total_insurance_amount

    @property
    def is_domestic(self):
        """
        Gets the is_domestic of this Ptsv2paymentsTravelInformationTransitAirline.
        Specifies if the flight is: Domestic (01) International (02) If Y then 01 else 02 

        :return: The is_domestic of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._is_domestic

    @is_domestic.setter
    def is_domestic(self, is_domestic):
        """
        Sets the is_domestic of this Ptsv2paymentsTravelInformationTransitAirline.
        Specifies if the flight is: Domestic (01) International (02) If Y then 01 else 02 

        :param is_domestic: The is_domestic of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._is_domestic = is_domestic

    @property
    def booking_reference_number(self):
        """
        Gets the booking_reference_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Reference number for the airline booking. Required if ticket numbers are not issued. 

        :return: The booking_reference_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._booking_reference_number

    @booking_reference_number.setter
    def booking_reference_number(self, booking_reference_number):
        """
        Sets the booking_reference_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Reference number for the airline booking. Required if ticket numbers are not issued. 

        :param booking_reference_number: The booking_reference_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._booking_reference_number = booking_reference_number

    @property
    def carrier_name(self):
        """
        Gets the carrier_name of this Ptsv2paymentsTravelInformationTransitAirline.
        Airline that generated the ticket. Format: English characters only. Optional request field. 

        :return: The carrier_name of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._carrier_name

    @carrier_name.setter
    def carrier_name(self, carrier_name):
        """
        Sets the carrier_name of this Ptsv2paymentsTravelInformationTransitAirline.
        Airline that generated the ticket. Format: English characters only. Optional request field. 

        :param carrier_name: The carrier_name of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._carrier_name = carrier_name

    @property
    def ticket_issuer(self):
        """
        Gets the ticket_issuer of this Ptsv2paymentsTravelInformationTransitAirline.

        :return: The ticket_issuer of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: Ptsv2paymentsTravelInformationTransitAirlineTicketIssuer
        """
        return self._ticket_issuer

    @ticket_issuer.setter
    def ticket_issuer(self, ticket_issuer):
        """
        Sets the ticket_issuer of this Ptsv2paymentsTravelInformationTransitAirline.

        :param ticket_issuer: The ticket_issuer of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: Ptsv2paymentsTravelInformationTransitAirlineTicketIssuer
        """

        self._ticket_issuer = ticket_issuer

    @property
    def ticket_number(self):
        """
        Gets the ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Ticket number. Format: English characters only. Restricted string data type that indicates a sequence of letters, numbers, and spaces; special characters are not included. Optional request field. 

        :return: The ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._ticket_number

    @ticket_number.setter
    def ticket_number(self, ticket_number):
        """
        Sets the ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Ticket number. Format: English characters only. Restricted string data type that indicates a sequence of letters, numbers, and spaces; special characters are not included. Optional request field. 

        :param ticket_number: The ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._ticket_number = ticket_number

    @property
    def check_digit(self):
        """
        Gets the check_digit of this Ptsv2paymentsTravelInformationTransitAirline.
        Check digit for the ticket number. CyberSource recommends that you validate the check digit. With Discover and Diners Club, a valid ticket number has these characteristics: - The value is numeric. - The first three digits are a valid IATA2 license plate carrier code. - The last digit is a check digit or zero (0). - All remaining digits are nonzero. 

        :return: The check_digit of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._check_digit

    @check_digit.setter
    def check_digit(self, check_digit):
        """
        Sets the check_digit of this Ptsv2paymentsTravelInformationTransitAirline.
        Check digit for the ticket number. CyberSource recommends that you validate the check digit. With Discover and Diners Club, a valid ticket number has these characteristics: - The value is numeric. - The first three digits are a valid IATA2 license plate carrier code. - The last digit is a check digit or zero (0). - All remaining digits are nonzero. 

        :param check_digit: The check_digit of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._check_digit = check_digit

    @property
    def restricted_ticket_indicator(self):
        """
        Gets the restricted_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Flag that indicates whether or not the ticket is restricted (nonrefundable). Possible values: - 0: No restriction (refundable) - 1: Restricted (nonrefundable) Format: English characters only. Restricted string data type that indicates a sequence of letters, numbers, and spaces; special characters are not included. Optional request field. 

        :return: The restricted_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: int
        """
        return self._restricted_ticket_indicator

    @restricted_ticket_indicator.setter
    def restricted_ticket_indicator(self, restricted_ticket_indicator):
        """
        Sets the restricted_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Flag that indicates whether or not the ticket is restricted (nonrefundable). Possible values: - 0: No restriction (refundable) - 1: Restricted (nonrefundable) Format: English characters only. Restricted string data type that indicates a sequence of letters, numbers, and spaces; special characters are not included. Optional request field. 

        :param restricted_ticket_indicator: The restricted_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: int
        """

        self._restricted_ticket_indicator = restricted_ticket_indicator

    @property
    def transaction_type(self):
        """
        Gets the transaction_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Type of charge. Possible values: - 01: Charge is for an airline ticket - 02: Charge is for an item that is not an airline ticket 

        :return: The transaction_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: int
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """
        Sets the transaction_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Type of charge. Possible values: - 01: Charge is for an airline ticket - 02: Charge is for an item that is not an airline ticket 

        :param transaction_type: The transaction_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: int
        """

        self._transaction_type = transaction_type

    @property
    def extended_payment_code(self):
        """
        Gets the extended_payment_code of this Ptsv2paymentsTravelInformationTransitAirline.
        The field is not currently supported. 

        :return: The extended_payment_code of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._extended_payment_code

    @extended_payment_code.setter
    def extended_payment_code(self, extended_payment_code):
        """
        Sets the extended_payment_code of this Ptsv2paymentsTravelInformationTransitAirline.
        The field is not currently supported. 

        :param extended_payment_code: The extended_payment_code of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._extended_payment_code = extended_payment_code

    @property
    def passenger_name(self):
        """
        Gets the passenger_name of this Ptsv2paymentsTravelInformationTransitAirline.
        Name of the passenger to whom the ticket was issued.  This will always be a single passenger's name. If there are more than one passengers, provide only the primary passenger's name. Do not include special characters such as commas, hyphens, or apostrophes. Only ASCII characters are supported. Format: English characters only. Optional request field. 

        :return: The passenger_name of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._passenger_name

    @passenger_name.setter
    def passenger_name(self, passenger_name):
        """
        Sets the passenger_name of this Ptsv2paymentsTravelInformationTransitAirline.
        Name of the passenger to whom the ticket was issued.  This will always be a single passenger's name. If there are more than one passengers, provide only the primary passenger's name. Do not include special characters such as commas, hyphens, or apostrophes. Only ASCII characters are supported. Format: English characters only. Optional request field. 

        :param passenger_name: The passenger_name of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._passenger_name = passenger_name

    @property
    def customer_code(self):
        """
        Gets the customer_code of this Ptsv2paymentsTravelInformationTransitAirline.
        Reference number or code that identifies the cardholder. Format: English characters only. Restricted string data type that indicates a sequence of letters, numbers, and spaces; special characters are not included. Optional request field. 

        :return: The customer_code of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._customer_code

    @customer_code.setter
    def customer_code(self, customer_code):
        """
        Sets the customer_code of this Ptsv2paymentsTravelInformationTransitAirline.
        Reference number or code that identifies the cardholder. Format: English characters only. Restricted string data type that indicates a sequence of letters, numbers, and spaces; special characters are not included. Optional request field. 

        :param customer_code: The customer_code of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._customer_code = customer_code

    @property
    def document_type(self):
        """
        Gets the document_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Airline document type code that specifies the purpose of the transaction. Format: English characters only. Optional request field.  | Code | Description | | --- | --- | | 01 | Passenger ticket | | 02 | Additional collection | | 03 | Excess baggage | | 04 | Miscellaneous charge order (MCO) or prepaid ticket authorization | | 05 | Special service ticket | | 06 | Supported refund | | 07 | Unsupported refund | | 08 | Lost ticket application | | 09 | Tour order voucher | | 10 | Ticket by mail | | 11 | Undercharge adjustment | | 12 | Group ticket | | 13 | Exchange adjustment | | 14 | SPD or air freight | | 15 | In-flight adjustment | | 16 | Agency passenger ticket | | 17 | Agency tour order or voucher | | 18 | Agency miscellaneous charge order (MCO) | | 19 | Agency exchange order | | 20 | Agency group ticket | | 21 | Debit adjustment for duplicate refund or use | | 22 | In-flight merchandise order | | 23 | Catalogue merchandise order | | 24 | In-flight phone charges | | 25 | Frequent flyer fee or purchase | | 26 | Kennel charge | | 27 | Animal transportation charge | | 28 | Firearms case | | 29 | Upgrade charge | | 30 | Credit for unused transportation | | 31 | Credit for class of service adjustment | | 32 | Credit for denied boarding | | 33 | Credit for miscellaneous refund | | 34 | Credit for lost ticket refund | | 35 | Credit for exchange refund | | 36 | Credit for overcharge adjustment | | 37 | Credit for multiple Unused tickets | | 38 | Exchange order | | 39 | Self-service ticket | | 41 | In-flight duty-free purchase | | 42 | Senior citizen discount booklets | | 43 | Club membership fee | | 44 | Coupon book | | 45 | In-flight charges | | 46 | Tour deposit | | 47 | Frequent flyer overnight delivery charge | | 48 | Frequent flyer fulfillment | | 49 | Small package delivery | | 50 | Vendor sale | | 51 | Miscellaneous taxes or fees | | 52 | Travel agency fee | | 60 | Vendor refund or credit | | 64 | Duty free sale | | 65 | Preferred seat upgrade | | 66 | Cabin upgrade | | 67 | Lounge or club access or day pass | | 68 | Agent assisted reservation or ticketing fee | | 69 | Ticket change or cancel fee | | 70 | Trip insurance | | 71 | Unaccompanied minor | | 72 | Standby fee | | 73 | Curbside baggage | | 74 | In-flight medical equipment | | 75 | Ticket or pass print fee | | 76 | Checked sporting or special equipment | | 77 | Dry ice fee | | 78 | Mail or postage fee | | 79 | Club membership fee or temporary trial | | 80 | Frequent flyer activation or reinstatement | | 81 | Gift certificate | | 82 | Onboard or in-flight prepaid voucher | | 83 | Optional services fee | | 84 | Advance purchase for excess baggage | | 85 | Advance purchase for preferred seat upgrade | | 86 | Advance purchase for cabin upgrade | | 87 | Advance purchase for optional services | | 88 | WiFi | | 89 | Packages | | 90 | In-flight entertainment or internet access | | 91 | Overweight bag fee | | 92 | Sleep sets | | 93 | Special purchase fee | 

        :return: The document_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._document_type

    @document_type.setter
    def document_type(self, document_type):
        """
        Sets the document_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Airline document type code that specifies the purpose of the transaction. Format: English characters only. Optional request field.  | Code | Description | | --- | --- | | 01 | Passenger ticket | | 02 | Additional collection | | 03 | Excess baggage | | 04 | Miscellaneous charge order (MCO) or prepaid ticket authorization | | 05 | Special service ticket | | 06 | Supported refund | | 07 | Unsupported refund | | 08 | Lost ticket application | | 09 | Tour order voucher | | 10 | Ticket by mail | | 11 | Undercharge adjustment | | 12 | Group ticket | | 13 | Exchange adjustment | | 14 | SPD or air freight | | 15 | In-flight adjustment | | 16 | Agency passenger ticket | | 17 | Agency tour order or voucher | | 18 | Agency miscellaneous charge order (MCO) | | 19 | Agency exchange order | | 20 | Agency group ticket | | 21 | Debit adjustment for duplicate refund or use | | 22 | In-flight merchandise order | | 23 | Catalogue merchandise order | | 24 | In-flight phone charges | | 25 | Frequent flyer fee or purchase | | 26 | Kennel charge | | 27 | Animal transportation charge | | 28 | Firearms case | | 29 | Upgrade charge | | 30 | Credit for unused transportation | | 31 | Credit for class of service adjustment | | 32 | Credit for denied boarding | | 33 | Credit for miscellaneous refund | | 34 | Credit for lost ticket refund | | 35 | Credit for exchange refund | | 36 | Credit for overcharge adjustment | | 37 | Credit for multiple Unused tickets | | 38 | Exchange order | | 39 | Self-service ticket | | 41 | In-flight duty-free purchase | | 42 | Senior citizen discount booklets | | 43 | Club membership fee | | 44 | Coupon book | | 45 | In-flight charges | | 46 | Tour deposit | | 47 | Frequent flyer overnight delivery charge | | 48 | Frequent flyer fulfillment | | 49 | Small package delivery | | 50 | Vendor sale | | 51 | Miscellaneous taxes or fees | | 52 | Travel agency fee | | 60 | Vendor refund or credit | | 64 | Duty free sale | | 65 | Preferred seat upgrade | | 66 | Cabin upgrade | | 67 | Lounge or club access or day pass | | 68 | Agent assisted reservation or ticketing fee | | 69 | Ticket change or cancel fee | | 70 | Trip insurance | | 71 | Unaccompanied minor | | 72 | Standby fee | | 73 | Curbside baggage | | 74 | In-flight medical equipment | | 75 | Ticket or pass print fee | | 76 | Checked sporting or special equipment | | 77 | Dry ice fee | | 78 | Mail or postage fee | | 79 | Club membership fee or temporary trial | | 80 | Frequent flyer activation or reinstatement | | 81 | Gift certificate | | 82 | Onboard or in-flight prepaid voucher | | 83 | Optional services fee | | 84 | Advance purchase for excess baggage | | 85 | Advance purchase for preferred seat upgrade | | 86 | Advance purchase for cabin upgrade | | 87 | Advance purchase for optional services | | 88 | WiFi | | 89 | Packages | | 90 | In-flight entertainment or internet access | | 91 | Overweight bag fee | | 92 | Sleep sets | | 93 | Special purchase fee | 

        :param document_type: The document_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._document_type = document_type

    @property
    def document_number(self):
        """
        Gets the document_number of this Ptsv2paymentsTravelInformationTransitAirline.
        The field is not currently supported. 

        :return: The document_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._document_number

    @document_number.setter
    def document_number(self, document_number):
        """
        Sets the document_number of this Ptsv2paymentsTravelInformationTransitAirline.
        The field is not currently supported. 

        :param document_number: The document_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._document_number = document_number

    @property
    def document_number_of_parts(self):
        """
        Gets the document_number_of_parts of this Ptsv2paymentsTravelInformationTransitAirline.
        The field is not currently supported. 

        :return: The document_number_of_parts of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: int
        """
        return self._document_number_of_parts

    @document_number_of_parts.setter
    def document_number_of_parts(self, document_number_of_parts):
        """
        Sets the document_number_of_parts of this Ptsv2paymentsTravelInformationTransitAirline.
        The field is not currently supported. 

        :param document_number_of_parts: The document_number_of_parts of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: int
        """

        self._document_number_of_parts = document_number_of_parts

    @property
    def invoice_number(self):
        """
        Gets the invoice_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Invoice number for the airline transaction. 

        :return: The invoice_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._invoice_number

    @invoice_number.setter
    def invoice_number(self, invoice_number):
        """
        Sets the invoice_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Invoice number for the airline transaction. 

        :param invoice_number: The invoice_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._invoice_number = invoice_number

    @property
    def invoice_date(self):
        """
        Gets the invoice_date of this Ptsv2paymentsTravelInformationTransitAirline.
        Invoice date. The format is YYYYMMDD. If this value is included in the request, it is used in the creation of the invoice number. See \"Invoice Number,\" 

        :return: The invoice_date of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: int
        """
        return self._invoice_date

    @invoice_date.setter
    def invoice_date(self, invoice_date):
        """
        Sets the invoice_date of this Ptsv2paymentsTravelInformationTransitAirline.
        Invoice date. The format is YYYYMMDD. If this value is included in the request, it is used in the creation of the invoice number. See \"Invoice Number,\" 

        :param invoice_date: The invoice_date of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: int
        """

        self._invoice_date = invoice_date

    @property
    def additional_charges(self):
        """
        Gets the additional_charges of this Ptsv2paymentsTravelInformationTransitAirline.
        Description of the charge if the charge does not involve an airline ticket. For example: Excess baggage. 

        :return: The additional_charges of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._additional_charges

    @additional_charges.setter
    def additional_charges(self, additional_charges):
        """
        Sets the additional_charges of this Ptsv2paymentsTravelInformationTransitAirline.
        Description of the charge if the charge does not involve an airline ticket. For example: Excess baggage. 

        :param additional_charges: The additional_charges of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._additional_charges = additional_charges

    @property
    def total_fee_amount(self):
        """
        Gets the total_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Total fee for the ticket. This value cannot exceed `99999999999999999999` (twenty 9s). Format: English characters only. Optional request field. 

        :return: The total_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._total_fee_amount

    @total_fee_amount.setter
    def total_fee_amount(self, total_fee_amount):
        """
        Sets the total_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Total fee for the ticket. This value cannot exceed `99999999999999999999` (twenty 9s). Format: English characters only. Optional request field. 

        :param total_fee_amount: The total_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._total_fee_amount = total_fee_amount

    @property
    def clearing_sequence(self):
        """
        Gets the clearing_sequence of this Ptsv2paymentsTravelInformationTransitAirline.
        Number that identifies the clearing message when multiple clearing messages are allowed per authorized transaction. Each clearing message linked to one authorization request must include a unique clearing sequence number between 1 and the total number of clearing records. Format: English characters only. Optional request field. 

        :return: The clearing_sequence of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._clearing_sequence

    @clearing_sequence.setter
    def clearing_sequence(self, clearing_sequence):
        """
        Sets the clearing_sequence of this Ptsv2paymentsTravelInformationTransitAirline.
        Number that identifies the clearing message when multiple clearing messages are allowed per authorized transaction. Each clearing message linked to one authorization request must include a unique clearing sequence number between 1 and the total number of clearing records. Format: English characters only. Optional request field. 

        :param clearing_sequence: The clearing_sequence of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._clearing_sequence = clearing_sequence

    @property
    def clearing_count(self):
        """
        Gets the clearing_count of this Ptsv2paymentsTravelInformationTransitAirline.
        Total number of clearing messages associated with the authorization request. Format: English characters only. Optional request field. 

        :return: The clearing_count of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._clearing_count

    @clearing_count.setter
    def clearing_count(self, clearing_count):
        """
        Sets the clearing_count of this Ptsv2paymentsTravelInformationTransitAirline.
        Total number of clearing messages associated with the authorization request. Format: English characters only. Optional request field. 

        :param clearing_count: The clearing_count of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._clearing_count = clearing_count

    @property
    def total_clearing_amount(self):
        """
        Gets the total_clearing_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Total clearing amount for all transactions in the clearing count set. This value cannot exceed `99999999999999999999` (twenty 9s). Format: English characters only. If this field is not set and if the total amount from the original authorization is not NULL, the total clearing amount is set to the total amount from the original authorization. 

        :return: The total_clearing_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._total_clearing_amount

    @total_clearing_amount.setter
    def total_clearing_amount(self, total_clearing_amount):
        """
        Sets the total_clearing_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Total clearing amount for all transactions in the clearing count set. This value cannot exceed `99999999999999999999` (twenty 9s). Format: English characters only. If this field is not set and if the total amount from the original authorization is not NULL, the total clearing amount is set to the total amount from the original authorization. 

        :param total_clearing_amount: The total_clearing_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._total_clearing_amount = total_clearing_amount

    @property
    def number_of_passengers(self):
        """
        Gets the number_of_passengers of this Ptsv2paymentsTravelInformationTransitAirline.
        Number of passengers for whom the ticket was issued. Format: English characters only. Optional request field. 

        :return: The number_of_passengers of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: int
        """
        return self._number_of_passengers

    @number_of_passengers.setter
    def number_of_passengers(self, number_of_passengers):
        """
        Sets the number_of_passengers of this Ptsv2paymentsTravelInformationTransitAirline.
        Number of passengers for whom the ticket was issued. Format: English characters only. Optional request field. 

        :param number_of_passengers: The number_of_passengers of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: int
        """

        self._number_of_passengers = number_of_passengers

    @property
    def reservation_system_code(self):
        """
        Gets the reservation_system_code of this Ptsv2paymentsTravelInformationTransitAirline.
        Code that specifies the computerized reservation system used to make the reservation and purchase the ticket. Format: English characters only. Restricted string data type that indicates a sequence of letters, numbers, and spaces; special characters are not included. Optional request field. 

        :return: The reservation_system_code of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._reservation_system_code

    @reservation_system_code.setter
    def reservation_system_code(self, reservation_system_code):
        """
        Sets the reservation_system_code of this Ptsv2paymentsTravelInformationTransitAirline.
        Code that specifies the computerized reservation system used to make the reservation and purchase the ticket. Format: English characters only. Restricted string data type that indicates a sequence of letters, numbers, and spaces; special characters are not included. Optional request field. 

        :param reservation_system_code: The reservation_system_code of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._reservation_system_code = reservation_system_code

    @property
    def process_identifier(self):
        """
        Gets the process_identifier of this Ptsv2paymentsTravelInformationTransitAirline.
        Airline process identifier. This value is the airline's three-digit IATA1 code which is used to process extended payment airline tickets. 

        :return: The process_identifier of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._process_identifier

    @process_identifier.setter
    def process_identifier(self, process_identifier):
        """
        Sets the process_identifier of this Ptsv2paymentsTravelInformationTransitAirline.
        Airline process identifier. This value is the airline's three-digit IATA1 code which is used to process extended payment airline tickets. 

        :param process_identifier: The process_identifier of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._process_identifier = process_identifier

    @property
    def ticket_issue_date(self):
        """
        Gets the ticket_issue_date of this Ptsv2paymentsTravelInformationTransitAirline.
        Date on which the transaction occurred. Format: `YYYYMMDD` Format: English characters only. Optional request field. 

        :return: The ticket_issue_date of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._ticket_issue_date

    @ticket_issue_date.setter
    def ticket_issue_date(self, ticket_issue_date):
        """
        Sets the ticket_issue_date of this Ptsv2paymentsTravelInformationTransitAirline.
        Date on which the transaction occurred. Format: `YYYYMMDD` Format: English characters only. Optional request field. 

        :param ticket_issue_date: The ticket_issue_date of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._ticket_issue_date = ticket_issue_date

    @property
    def electronic_ticket_indicator(self):
        """
        Gets the electronic_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Flag that indicates whether an electronic ticket was issued. Possible values: - `true` - `false` Optional request field. 

        :return: The electronic_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: bool
        """
        return self._electronic_ticket_indicator

    @electronic_ticket_indicator.setter
    def electronic_ticket_indicator(self, electronic_ticket_indicator):
        """
        Sets the electronic_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Flag that indicates whether an electronic ticket was issued. Possible values: - `true` - `false` Optional request field. 

        :param electronic_ticket_indicator: The electronic_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: bool
        """

        self._electronic_ticket_indicator = electronic_ticket_indicator

    @property
    def original_ticket_number(self):
        """
        Gets the original_ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Original ticket number when the transaction is for a replacement ticket. 

        :return: The original_ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._original_ticket_number

    @original_ticket_number.setter
    def original_ticket_number(self, original_ticket_number):
        """
        Sets the original_ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Original ticket number when the transaction is for a replacement ticket. 

        :param original_ticket_number: The original_ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._original_ticket_number = original_ticket_number

    @property
    def purchase_type(self):
        """
        Gets the purchase_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Type of purchase. Possible values: - `EXC`: Exchange ticket - `MSC`: Miscellaneous (not a ticket purchase and not a transaction related to an exchange ticket) - `REF`: Refund - `TKT`: Ticket Format: English characters only. Optional request field. 

        :return: The purchase_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._purchase_type

    @purchase_type.setter
    def purchase_type(self, purchase_type):
        """
        Sets the purchase_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Type of purchase. Possible values: - `EXC`: Exchange ticket - `MSC`: Miscellaneous (not a ticket purchase and not a transaction related to an exchange ticket) - `REF`: Refund - `TKT`: Ticket Format: English characters only. Optional request field. 

        :param purchase_type: The purchase_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._purchase_type = purchase_type

    @property
    def credit_reason_indicator(self):
        """
        Gets the credit_reason_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Reason for the credit. Possible values: - `A`: Cancellation of the ancillary passenger transport purchase. - `B`: Cancellation of the airline ticket and the passenger transport ancillary purchase. - `C`: Cancellation of the airline ticket. - `O`: Other. - `P`: Partial refund of the airline ticket. Format: English characters only.  Optional request field. 

        :return: The credit_reason_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._credit_reason_indicator

    @credit_reason_indicator.setter
    def credit_reason_indicator(self, credit_reason_indicator):
        """
        Sets the credit_reason_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Reason for the credit. Possible values: - `A`: Cancellation of the ancillary passenger transport purchase. - `B`: Cancellation of the airline ticket and the passenger transport ancillary purchase. - `C`: Cancellation of the airline ticket. - `O`: Other. - `P`: Partial refund of the airline ticket. Format: English characters only.  Optional request field. 

        :param credit_reason_indicator: The credit_reason_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._credit_reason_indicator = credit_reason_indicator

    @property
    def ticket_change_indicator(self):
        """
        Gets the ticket_change_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Type of update. Possible values: - `C`: Change to the existing ticket. - `N`: New ticket. Format: English characters only Optional request field. 

        :return: The ticket_change_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._ticket_change_indicator

    @ticket_change_indicator.setter
    def ticket_change_indicator(self, ticket_change_indicator):
        """
        Sets the ticket_change_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Type of update. Possible values: - `C`: Change to the existing ticket. - `N`: New ticket. Format: English characters only Optional request field. 

        :param ticket_change_indicator: The ticket_change_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._ticket_change_indicator = ticket_change_indicator

    @property
    def plan_number(self):
        """
        Gets the plan_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Plan number based on the fare. This value is provided by the airline. Format: English characters only. Optional request field. 

        :return: The plan_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._plan_number

    @plan_number.setter
    def plan_number(self, plan_number):
        """
        Sets the plan_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Plan number based on the fare. This value is provided by the airline. Format: English characters only. Optional request field. 

        :param plan_number: The plan_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._plan_number = plan_number

    @property
    def arrival_date(self):
        """
        Gets the arrival_date of this Ptsv2paymentsTravelInformationTransitAirline.
        Date of arrival for the last leg of the trip. Format: `MMDDYYYY` English characters only. Optional request field. 

        :return: The arrival_date of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._arrival_date

    @arrival_date.setter
    def arrival_date(self, arrival_date):
        """
        Sets the arrival_date of this Ptsv2paymentsTravelInformationTransitAirline.
        Date of arrival for the last leg of the trip. Format: `MMDDYYYY` English characters only. Optional request field. 

        :param arrival_date: The arrival_date of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._arrival_date = arrival_date

    @property
    def restricted_ticket_desciption(self):
        """
        Gets the restricted_ticket_desciption of this Ptsv2paymentsTravelInformationTransitAirline.
        Text that describes the ticket limitations, such as _nonrefundable_. Format: English characters only. Optional request field. 

        :return: The restricted_ticket_desciption of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._restricted_ticket_desciption

    @restricted_ticket_desciption.setter
    def restricted_ticket_desciption(self, restricted_ticket_desciption):
        """
        Sets the restricted_ticket_desciption of this Ptsv2paymentsTravelInformationTransitAirline.
        Text that describes the ticket limitations, such as _nonrefundable_. Format: English characters only. Optional request field. 

        :param restricted_ticket_desciption: The restricted_ticket_desciption of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._restricted_ticket_desciption = restricted_ticket_desciption

    @property
    def exchange_ticket_amount(self):
        """
        Gets the exchange_ticket_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Amount of the exchanged ticket. Format: English characters only. 

        :return: The exchange_ticket_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._exchange_ticket_amount

    @exchange_ticket_amount.setter
    def exchange_ticket_amount(self, exchange_ticket_amount):
        """
        Sets the exchange_ticket_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Amount of the exchanged ticket. Format: English characters only. 

        :param exchange_ticket_amount: The exchange_ticket_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._exchange_ticket_amount = exchange_ticket_amount

    @property
    def exchange_ticket_fee_amount(self):
        """
        Gets the exchange_ticket_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Fee for exchanging the ticket. Format: English characters only. Optional request field. 

        :return: The exchange_ticket_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._exchange_ticket_fee_amount

    @exchange_ticket_fee_amount.setter
    def exchange_ticket_fee_amount(self, exchange_ticket_fee_amount):
        """
        Sets the exchange_ticket_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Fee for exchanging the ticket. Format: English characters only. Optional request field. 

        :param exchange_ticket_fee_amount: The exchange_ticket_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._exchange_ticket_fee_amount = exchange_ticket_fee_amount

    @property
    def reservation_type(self):
        """
        Gets the reservation_type of this Ptsv2paymentsTravelInformationTransitAirline.
        The field is not currently supported. 

        :return: The reservation_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._reservation_type

    @reservation_type.setter
    def reservation_type(self, reservation_type):
        """
        Sets the reservation_type of this Ptsv2paymentsTravelInformationTransitAirline.
        The field is not currently supported. 

        :param reservation_type: The reservation_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._reservation_type = reservation_type

    @property
    def boarding_fee_amount(self):
        """
        Gets the boarding_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Boarding fee. 

        :return: The boarding_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._boarding_fee_amount

    @boarding_fee_amount.setter
    def boarding_fee_amount(self, boarding_fee_amount):
        """
        Sets the boarding_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Boarding fee. 

        :param boarding_fee_amount: The boarding_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._boarding_fee_amount = boarding_fee_amount

    @property
    def legs(self):
        """
        Gets the legs of this Ptsv2paymentsTravelInformationTransitAirline.

        :return: The legs of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: list[Ptsv2paymentsTravelInformationTransitAirlineLegs]
        """
        return self._legs

    @legs.setter
    def legs(self, legs):
        """
        Sets the legs of this Ptsv2paymentsTravelInformationTransitAirline.

        :param legs: The legs of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: list[Ptsv2paymentsTravelInformationTransitAirlineLegs]
        """

        self._legs = legs

    @property
    def ancillary_information(self):
        """
        Gets the ancillary_information of this Ptsv2paymentsTravelInformationTransitAirline.

        :return: The ancillary_information of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: Ptsv2paymentsTravelInformationTransitAirlineAncillaryInformation
        """
        return self._ancillary_information

    @ancillary_information.setter
    def ancillary_information(self, ancillary_information):
        """
        Sets the ancillary_information of this Ptsv2paymentsTravelInformationTransitAirline.

        :param ancillary_information: The ancillary_information of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: Ptsv2paymentsTravelInformationTransitAirlineAncillaryInformation
        """

        self._ancillary_information = ancillary_information

    @property
    def flight_type(self):
        """
        Gets the flight_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Specifies the type of flight. One way (0) Return (1) Transit (2) Transit & Return (3) Multi-City (4) 

        :return: The flight_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._flight_type

    @flight_type.setter
    def flight_type(self, flight_type):
        """
        Sets the flight_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Specifies the type of flight. One way (0) Return (1) Transit (2) Transit & Return (3) Multi-City (4) 

        :param flight_type: The flight_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._flight_type = flight_type

    @property
    def insurance_amount(self):
        """
        Gets the insurance_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        The total cost of the flight insurance. Example: 10000.00 

        :return: The insurance_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._insurance_amount

    @insurance_amount.setter
    def insurance_amount(self, insurance_amount):
        """
        Sets the insurance_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        The total cost of the flight insurance. Example: 10000.00 

        :param insurance_amount: The insurance_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._insurance_amount = insurance_amount

    @property
    def frequent_flyer_number(self):
        """
        Gets the frequent_flyer_number of this Ptsv2paymentsTravelInformationTransitAirline.
        The consumer's frequent flyer number. Leave 0 if there is no frequent flyer number 

        :return: The frequent_flyer_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._frequent_flyer_number

    @frequent_flyer_number.setter
    def frequent_flyer_number(self, frequent_flyer_number):
        """
        Sets the frequent_flyer_number of this Ptsv2paymentsTravelInformationTransitAirline.
        The consumer's frequent flyer number. Leave 0 if there is no frequent flyer number 

        :param frequent_flyer_number: The frequent_flyer_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._frequent_flyer_number = frequent_flyer_number

    @property
    def third_party_status(self):
        """
        Gets the third_party_status of this Ptsv2paymentsTravelInformationTransitAirline.
        Specifies if the travel agent joins the flight (0) or not (1) 

        :return: The third_party_status of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._third_party_status

    @third_party_status.setter
    def third_party_status(self, third_party_status):
        """
        Sets the third_party_status of this Ptsv2paymentsTravelInformationTransitAirline.
        Specifies if the travel agent joins the flight (0) or not (1) 

        :param third_party_status: The third_party_status of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._third_party_status = third_party_status

    @property
    def passenger_type(self):
        """
        Gets the passenger_type of this Ptsv2paymentsTravelInformationTransitAirline.
        List of passenger types in a booking code: A (Adult) C (Child) Comma separated values for total number of passenger 

        :return: The passenger_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._passenger_type

    @passenger_type.setter
    def passenger_type(self, passenger_type):
        """
        Sets the passenger_type of this Ptsv2paymentsTravelInformationTransitAirline.
        List of passenger types in a booking code: A (Adult) C (Child) Comma separated values for total number of passenger 

        :param passenger_type: The passenger_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._passenger_type = passenger_type

    @property
    def total_insurance_amount(self):
        """
        Gets the total_insurance_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Total insurance amount. We have per leg and not total 

        :return: The total_insurance_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._total_insurance_amount

    @total_insurance_amount.setter
    def total_insurance_amount(self, total_insurance_amount):
        """
        Sets the total_insurance_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Total insurance amount. We have per leg and not total 

        :param total_insurance_amount: The total_insurance_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """

        self._total_insurance_amount = total_insurance_amount

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Ptsv2paymentsTravelInformationTransitAirline):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
