# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class PaymentsProductsServiceFeeConfigurationInformationConfigurations(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'products': 'dict(str, PaymentsProductsServiceFeeConfigurationInformationConfigurationsProducts)',
        'terminal_id': 'str',
        'merchant_id': 'str',
        'merchant_information': 'PaymentsProductsServiceFeeConfigurationInformationConfigurationsMerchantInformation',
        'payment_information': 'list[PaymentsProductsServiceFeeConfigurationInformationConfigurationsPaymentInformation]'
    }

    attribute_map = {
        'products': 'products',
        'terminal_id': 'terminalId',
        'merchant_id': 'merchantId',
        'merchant_information': 'merchantInformation',
        'payment_information': 'paymentInformation'
    }

    def __init__(self, products=None, terminal_id=None, merchant_id=None, merchant_information=None, payment_information=None):
        """
        PaymentsProductsServiceFeeConfigurationInformationConfigurations - a model defined in Swagger
        """

        self._products = None
        self._terminal_id = None
        self._merchant_id = None
        self._merchant_information = None
        self._payment_information = None

        if products is not None:
          self.products = products
        if terminal_id is not None:
          self.terminal_id = terminal_id
        if merchant_id is not None:
          self.merchant_id = merchant_id
        if merchant_information is not None:
          self.merchant_information = merchant_information
        if payment_information is not None:
          self.payment_information = payment_information

    @property
    def products(self):
        """
        Gets the products of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        Products enabled for this account. The following values are supported: virtualTerminal paymentTokenizationOtp subscriptionsOtp virtualTerminalCp eCheck 

        :return: The products of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        :rtype: dict(str, PaymentsProductsServiceFeeConfigurationInformationConfigurationsProducts)
        """
        return self._products

    @products.setter
    def products(self, products):
        """
        Sets the products of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        Products enabled for this account. The following values are supported: virtualTerminal paymentTokenizationOtp subscriptionsOtp virtualTerminalCp eCheck 

        :param products: The products of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        :type: dict(str, PaymentsProductsServiceFeeConfigurationInformationConfigurationsProducts)
        """

        self._products = products

    @property
    def terminal_id(self):
        """
        Gets the terminal_id of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        Identifier of the terminal at the retail location.

        :return: The terminal_id of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        :rtype: str
        """
        return self._terminal_id

    @terminal_id.setter
    def terminal_id(self, terminal_id):
        """
        Sets the terminal_id of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        Identifier of the terminal at the retail location.

        :param terminal_id: The terminal_id of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        :type: str
        """

        self._terminal_id = terminal_id

    @property
    def merchant_id(self):
        """
        Gets the merchant_id of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        Identifier of a merchant account.

        :return: The merchant_id of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        :rtype: str
        """
        return self._merchant_id

    @merchant_id.setter
    def merchant_id(self, merchant_id):
        """
        Sets the merchant_id of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        Identifier of a merchant account.

        :param merchant_id: The merchant_id of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        :type: str
        """

        self._merchant_id = merchant_id

    @property
    def merchant_information(self):
        """
        Gets the merchant_information of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.

        :return: The merchant_information of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        :rtype: PaymentsProductsServiceFeeConfigurationInformationConfigurationsMerchantInformation
        """
        return self._merchant_information

    @merchant_information.setter
    def merchant_information(self, merchant_information):
        """
        Sets the merchant_information of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.

        :param merchant_information: The merchant_information of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        :type: PaymentsProductsServiceFeeConfigurationInformationConfigurationsMerchantInformation
        """

        self._merchant_information = merchant_information

    @property
    def payment_information(self):
        """
        Gets the payment_information of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.

        :return: The payment_information of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        :rtype: list[PaymentsProductsServiceFeeConfigurationInformationConfigurationsPaymentInformation]
        """
        return self._payment_information

    @payment_information.setter
    def payment_information(self, payment_information):
        """
        Sets the payment_information of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.

        :param payment_information: The payment_information of this PaymentsProductsServiceFeeConfigurationInformationConfigurations.
        :type: list[PaymentsProductsServiceFeeConfigurationInformationConfigurationsPaymentInformation]
        """

        self._payment_information = payment_information

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PaymentsProductsServiceFeeConfigurationInformationConfigurations):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
