# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['attractors', 'attractors.anim', 'attractors.data', 'attractors.utils']

package_data = \
{'': ['*']}

install_requires = \
['matplotlib>=3.4.2,<4.0.0', 'pathos>=0.2.8,<0.3.0', 'tqdm>=4.61.2,<5.0.0']

entry_points = \
{'console_scripts': ['attractors = attractors.parser:cli']}

setup_kwargs = {
    'name': 'attractors',
    'version': '1.1.1',
    'description': 'Simulation and visualization of strange attractors',
    'long_description': 'Attractors\n==========\n\nAttractors is a package for simulation and visualization of strange\nattractors.\n\n|PyPI license| |PyPI version| |image1|\n\n.. |PyPI license| image:: https://img.shields.io/github/workflow/status/Vignesh-Desmond/attractors/Build?style=flat-square&logo=GitHub\n   :target: https://github.com/Vignesh-Desmond/attractors/actions/workflows/build.yml\n.. |PyPI version| image:: https://img.shields.io/pypi/v/attractors?color=blue&style=flat-square\n   :target: https://pypi.python.org/pypi/attractors/\n.. |image1| image:: https://img.shields.io/pypi/l/attractors?style=flat-square&color=orange\n   :target: https://lbesson.mit-license.org/\n\nFor complete documentation, see the repository docs at\nhttps://github.com/Vignesh-Desmond/attractors\n\nInstallation\n------------\n\nThe package is currently hosted on PyPi and can be installed with pip:\n\n``pip install attractors``\n\nAlternatively, the package can be installed locally after cloning by the\nfollowing command:\n\n``python -m pip install .``\n\nNote:\n\nThe package requires FFMPEG as a prerequisite for generating\nvisualization output. For installation, see\n`here <https://ffmpeg.org/download.html>`__\n\nDependencies\n------------\n\n-  Python (3.8+)\n-  NumPy (1.21.0+)\n-  Matplotlib (3.4.2+)\n\nUsage\n-----\n\nThe package is intended to be used mainly via the command-line\ninterface. The simplest way to visualize an Lorenz attractor is given\nbelow:\n\n::\n\n   attractors -p 100000 -s 100 -t multipoint lorenz\n\n``-p`` : Number of points for the simulation\n\n``-s`` : Simulation time\n\n``-t`` : Type of visualization\n\nThere are two types of visualizations:\n\n``multipoint`` visualization can simulate multiple initial coordinates,\nuseful to infer the chaotic nature of the attractors. Use ``--n`` to set\nthe number of initial points.\n\n``gradient`` visualization uses gradient color for the 3D plot, given a\nspecific axis.\n\nBy default, the visualization output will be saved in an MPEG4 encoded\nvideo. To show a live plot, use the ``--live`` flag (only supported for\nmultipoint).\n\nThe full list of possible settings can be obtained by the help command:\n``attractors -h``\n\n::\n\n   usage: attractors [-v] [-h] -t {multipoint,gradient}\n                     [--des {euler,rk2,rk3,rk4,rk5}] [--width WIDTH]\n                     [--height HEIGHT] [--dpi DPI] [--theme THEME] -s SIMTIME -p\n                     SIMPOINTS [--bgcolor BGCOLOR] [--cmap CMAP] [--fps FPS]\n                     [--n N] [--rk2 {heun,imp_poly,ralston}] [--outf OUTF]\n                     [--live]\n                     ATTRACTOR ...\n\n   optional arguments:\n     -v, --version         show program\'s version number and exit\n     -h, --help            show this help message and exit\n\n   required arguments:\n     -t {multipoint,gradient}, --type {multipoint,gradient}\n                           choose simulation type\n     -s SIMTIME, --simtime SIMTIME\n                           set the simulation time\n     -p SIMPOINTS, --simpoints SIMPOINTS\n                           set the number of points to be used for the simulation\n\n   other arguments:\n     --des {euler,rk2,rk3,rk4,rk5}\n                           set the Differential Equation Solver. Default: rk4\n     --width WIDTH         set width of the figure Default: 16\n     --height HEIGHT       set height of the figure Default: 9\n     --dpi DPI             set DPI of the figure Default: 120\n     --theme THEME         choose theme (color palette) to be used\n     --bgcolor BGCOLOR     Background color for figure in hex. Overrides theme\n                           settings Default: #000000\n     --cmap CMAP           Matplotlib cmap for palette. Overrides theme settings\n                           Default: jet\n     --fps FPS             Set FPS for animated video (or interactive plot)\n                           Default: 60\n     --n N                 Number of initial points for Multipoint animation\n                           Default: 3\n     --rk2 {heun,imp_poly,ralston}\n                           Method for 2nd order Runge-Kutta if specified to used.\n                           Default: heun\n     --outf OUTF           Output video filename Default: output.mp4\n     --live                Live plotting instead of generating video.\n\n   Attractor settings:\n     Choose one of the attractors and specify its parameters\n\n     ATTRACTOR\n       lorenz              Lorenz attractor\n       rabinovich_fabrikant\n                           Rabinovich Fabrikant attractor\n       lotka_volterra      Lotka Volterra attractor\n       rossler             Rossler attractor\n       wang_sun            Wang Sun attractor\n       rikitake            Rikitake attractor\n       nose_hoover         Nose Hoover attractor\n       aizawa              Aizawa attractor\n       three_cell_cnn      Three Cell CNN attractor\n       bouali_type_1       Bouali Type 1 attractor\n       bouali_type_2       Bouali Type 2 attractor\n       bouali_type_3       Bouali Type 3 attractor\n       finance             Finance attractor\n       burke_shaw          Burke Shaw attractor\n       moore_spiegel       Moore Spiegel attractor\n       sakarya             Sakarya attractor\n       dadras              Dadras attractor\n       halvorsen           Halvorsen attractor\n       hadley              Hadley attractor\n       chen                Chen attractor\n       chen_lee            Chen Lee attractor\n       chen_celikovsky     Chen Celikovsky attractor\n\nEach attractor also has its own parameters to set. The settings for each\nattractor can be obtained by the help command:\n``attractors ATTRACTOR -h``\n\nThe help message for Lorenz attractors will be as follows:\n\n::\n\n   usage: attractors lorenz [-h] [--sigma SIGMA] [--beta BETA] [--rho RHO]\n                            [--initcoord INITCOORD] [--xlim XLIM] [--ylim YLIM]\n                            [--zlim ZLIM]\n\n   optional arguments:\n     -h, --help            show this help message and exit\n\n   Lorenz attractor parameters:\n     --sigma SIGMA         Parameter for Lorenz attractor Default: 5\n     --beta BETA           Parameter for Lorenz attractor Default: 2.66667\n     --rho RHO             Parameter for Lorenz attractor Default: 28\n     --initcoord INITCOORD\n                           Initial coordinate for Lorenz attractor. Input format:\n                           "x,y,z" Default: [0.1, 0.1, 0.1]\n     --xlim XLIM           x axis limits for figure. Input format: "xmin,xmax"\n                           Default: [-20, 20]\n     --ylim YLIM           y axis limits for figure. Input format: "ymin,ymax"\n                           Default: [-30, 30]\n     --zlim ZLIM           z axis limits for figure. Input format: "zmin,zmax"\n                           Default: [5, 45]\n\nLicense\n-------\n\nThis package is licensed under the MIT License\n',
    'author': 'Vignesh Mohan',
    'author_email': 'vignesh.desmond@gmail.com',
    'maintainer': 'Vignesh Mohan',
    'maintainer_email': 'vignesh.desmond@gmail.com',
    'url': 'https://github.com/Vignesh-Desmond/attractors',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
