# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictStr
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema

class WorkstreamPatternEngineSource(BaseModel):
    """
    This is a specific model for a given WPE qdrant source.  note: application is optional b/c we may want a network sorce in the future TODO: think about adding an enum or something that will delimit the type of processor(vision/filewatcher/network/audio)  TODO: in the future we can add tabs/filepaths to this model here. TODO: Enum for source/processor ? i.e. WorkstreamPatternEngineProcessorEnum.VISION, WorkstreamPatternEngineProcessorEnum.NETWORK, WorkstreamPatternEngineProcessorEnum.FILE_IO, WorkstreamPatternEngineProcessorEnum.AUDIO, etc.  NOTE: if all three are null we will thro an error.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    name: Optional[StrictStr] = Field(default=None, description="THIS IS DEPRECATED WILL NOT BE USED")
    window: Optional[StrictStr] = Field(default=None, description="This is the name of the tab or open file")
    url: Optional[StrictStr] = Field(default=None, description="This is a url that was extracted from the WPE data.")
    application: Optional[StrictStr] = Field(default=None, description="This is the name of the window(foreground window)/application.(this will always be present)")
    installation: Optional[StrictStr] = Field(default=None, description="This is the path is which this application download location is (NOTE, not being used quite yet)")
    __properties = ["schema", "name", "window", "url", "application", "installation"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WorkstreamPatternEngineSource:
        """Create an instance of WorkstreamPatternEngineSource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WorkstreamPatternEngineSource:
        """Create an instance of WorkstreamPatternEngineSource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WorkstreamPatternEngineSource.parse_obj(obj)

        _obj = WorkstreamPatternEngineSource.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "name": obj.get("name"),
            "window": obj.get("window"),
            "url": obj.get("url"),
            "application": obj.get("application"),
            "installation": obj.get("installation")
        })
        return _obj


