# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.grouped_timestamp import GroupedTimestamp

class UserLastCheckedInStreamOutput(BaseModel):
    """
    This model represents the data streamed over the user last checked in websocket endpoint.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    user_id: Optional[StrictStr] = Field(default=None, alias="userId", description="The user ID, can be null if no user is logged in.")
    last_checked_in: Optional[GroupedTimestamp] = Field(default=None, alias="lastCheckedIn")
    needs_refresh: StrictBool = Field(default=..., alias="needsRefresh", description="Indicates whether the client needs to refresh its data.")
    update_required: Optional[StrictBool] = Field(default=None, alias="updateRequired", description="Indicates whether POS requires an update.")
    __properties = ["schema", "userId", "lastCheckedIn", "needsRefresh", "updateRequired"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UserLastCheckedInStreamOutput:
        """Create an instance of UserLastCheckedInStreamOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of last_checked_in
        if self.last_checked_in:
            _dict['lastCheckedIn'] = self.last_checked_in.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UserLastCheckedInStreamOutput:
        """Create an instance of UserLastCheckedInStreamOutput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UserLastCheckedInStreamOutput.parse_obj(obj)

        _obj = UserLastCheckedInStreamOutput.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "user_id": obj.get("userId"),
            "last_checked_in": GroupedTimestamp.from_dict(obj.get("lastCheckedIn")) if obj.get("lastCheckedIn") is not None else None,
            "needs_refresh": obj.get("needsRefresh"),
            "update_required": obj.get("updateRequired")
        })
        return _obj


