# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictStr, validator
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema

class TrackedAssetsEventIdentifierDescriptionPairs(BaseModel):
    """
    These are all of the available event types that are permitted in an object pair notation.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    assets_searched: Optional[StrictStr] = Field(default='UNKNOWN', description="A If the assets were searched")
    __properties = ["schema", "assets_searched"]

    @validator('assets_searched')
    def assets_searched_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('UNKNOWN', 'assets_were_searched',):
            raise ValueError("must be one of enum values ('UNKNOWN', 'assets_were_searched')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TrackedAssetsEventIdentifierDescriptionPairs:
        """Create an instance of TrackedAssetsEventIdentifierDescriptionPairs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TrackedAssetsEventIdentifierDescriptionPairs:
        """Create an instance of TrackedAssetsEventIdentifierDescriptionPairs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TrackedAssetsEventIdentifierDescriptionPairs.parse_obj(obj)

        _obj = TrackedAssetsEventIdentifierDescriptionPairs.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "assets_searched": obj.get("assets_searched") if obj.get("assets_searched") is not None else 'UNKNOWN'
        })
        return _obj


