# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool

class TrackedAssetEventCreationMetadataFile(BaseModel):
    """
    If an asset was created from a file attachment  # noqa: E501
    """
    keyboard: Optional[StrictBool] = Field(default=None, description="Whether the file was pasted via the keyboard")
    drag_and_drop: Optional[StrictBool] = Field(default=None, description="Whether the file was dropped onto pieces")
    interaction: Optional[StrictBool] = Field(default=None, description="Whether the file was attached via a button click")
    __properties = ["keyboard", "drag_and_drop", "interaction"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TrackedAssetEventCreationMetadataFile:
        """Create an instance of TrackedAssetEventCreationMetadataFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TrackedAssetEventCreationMetadataFile:
        """Create an instance of TrackedAssetEventCreationMetadataFile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TrackedAssetEventCreationMetadataFile.parse_obj(obj)

        _obj = TrackedAssetEventCreationMetadataFile.parse_obj({
            "keyboard": obj.get("keyboard"),
            "drag_and_drop": obj.get("drag_and_drop"),
            "interaction": obj.get("interaction")
        })
        return _obj


