# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.system_execution_information import SystemExecutionInformation
from pieces._vendor.pieces_os_client.models.tlp_code_fragment_classification_metadata import TLPCodeFragmentClassificationMetadata

class TLPCodeFragmentClassification(BaseModel):
    """
    Model for ML big query classification.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    asset: StrictStr = Field(...)
    model: StrictStr = Field(...)
    created: StrictStr = Field(...)
    classification: StrictStr = Field(...)
    probability: Union[StrictFloat, StrictInt] = Field(...)
    context: StrictStr = Field(...)
    distribution: Optional[StrictStr] = None
    metadata: Optional[TLPCodeFragmentClassificationMetadata] = None
    user: StrictStr = Field(default=..., description="identifier for the user")
    latency: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="this is the time it takes to run this model.")
    system: Optional[SystemExecutionInformation] = None
    os: StrictStr = Field(...)
    __properties = ["schema", "asset", "model", "created", "classification", "probability", "context", "distribution", "metadata", "user", "latency", "system", "os"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TLPCodeFragmentClassification:
        """Create an instance of TLPCodeFragmentClassification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of system
        if self.system:
            _dict['system'] = self.system.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TLPCodeFragmentClassification:
        """Create an instance of TLPCodeFragmentClassification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TLPCodeFragmentClassification.parse_obj(obj)

        _obj = TLPCodeFragmentClassification.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "asset": obj.get("asset"),
            "model": obj.get("model"),
            "created": obj.get("created"),
            "classification": obj.get("classification"),
            "probability": obj.get("probability"),
            "context": obj.get("context"),
            "distribution": obj.get("distribution"),
            "metadata": TLPCodeFragmentClassificationMetadata.from_dict(obj.get("metadata")) if obj.get("metadata") is not None else None,
            "user": obj.get("user"),
            "latency": obj.get("latency"),
            "system": SystemExecutionInformation.from_dict(obj.get("system")) if obj.get("system") is not None else None,
            "os": obj.get("os")
        })
        return _obj


