# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.flattened_anchors import FlattenedAnchors
from pieces._vendor.pieces_os_client.models.flattened_persons import FlattenedPersons
from pieces._vendor.pieces_os_client.models.flattened_websites import FlattenedWebsites
from pieces._vendor.pieces_os_client.models.seeds import Seeds
from pieces._vendor.pieces_os_client.models.text_location import TextLocation

class TextuallyExtractedMaterial(BaseModel):
    """
    This is an extraction, this was a person/website/anchor that was extracted  this will return the text location where this was found within the extraction.  as well return the material itself that was extracted.  Note: - seeds: will only be extracted people if provided, because the website/anchors will be created if extracted. - basically only thing that is different about the extracted people, if that if we extract a person that was not already saved,   then we will not save them, however if there are related people then we will add them as well.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    match: TextLocation = Field(...)
    websites: Optional[FlattenedWebsites] = None
    anchors: Optional[FlattenedAnchors] = None
    persons: Optional[FlattenedPersons] = None
    seeds: Optional[Seeds] = None
    __properties = ["schema", "match", "websites", "anchors", "persons", "seeds"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TextuallyExtractedMaterial:
        """Create an instance of TextuallyExtractedMaterial from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of match
        if self.match:
            _dict['match'] = self.match.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of websites
        if self.websites:
            _dict['websites'] = self.websites.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of anchors
        if self.anchors:
            _dict['anchors'] = self.anchors.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of persons
        if self.persons:
            _dict['persons'] = self.persons.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of seeds
        if self.seeds:
            _dict['seeds'] = self.seeds.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TextuallyExtractedMaterial:
        """Create an instance of TextuallyExtractedMaterial from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TextuallyExtractedMaterial.parse_obj(obj)

        _obj = TextuallyExtractedMaterial.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "match": TextLocation.from_dict(obj.get("match")) if obj.get("match") is not None else None,
            "websites": FlattenedWebsites.from_dict(obj.get("websites")) if obj.get("websites") is not None else None,
            "anchors": FlattenedAnchors.from_dict(obj.get("anchors")) if obj.get("anchors") is not None else None,
            "persons": FlattenedPersons.from_dict(obj.get("persons")) if obj.get("persons") is not None else None,
            "seeds": Seeds.from_dict(obj.get("seeds")) if obj.get("seeds") is not None else None
        })
        return _obj


