# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field
from pieces._vendor.pieces_os_client.models.anonymous_temporal_range import AnonymousTemporalRange
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema

class TemporalSearchOptions(BaseModel):
    """
    created: will return the materials based on if the range is satisfied w/ this created timestamp ** same goes for updated  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    created: Optional[AnonymousTemporalRange] = None
    updated: Optional[AnonymousTemporalRange] = None
    __properties = ["schema", "created", "updated"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TemporalSearchOptions:
        """Create an instance of TemporalSearchOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of created
        if self.created:
            _dict['created'] = self.created.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of updated
        if self.updated:
            _dict['updated'] = self.updated.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TemporalSearchOptions:
        """Create an instance of TemporalSearchOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TemporalSearchOptions.parse_obj(obj)

        _obj = TemporalSearchOptions.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "created": AnonymousTemporalRange.from_dict(obj.get("created")) if obj.get("created") is not None else None,
            "updated": AnonymousTemporalRange.from_dict(obj.get("updated")) if obj.get("updated") is not None else None
        })
        return _obj


