# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.grouped_timestamp import GroupedTimestamp
from pieces._vendor.pieces_os_client.models.referenced_user import ReferencedUser
from pieces._vendor.pieces_os_client.models.score import Score
from pieces._vendor.pieces_os_client.models.subscription_term_enum import SubscriptionTermEnum

class Subscription(BaseModel):
    """
    Subscription
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    id: StrictStr = Field(default=..., description="The id of the subscription")
    name: StrictStr = Field(default=..., description="The name of the subscription")
    created: GroupedTimestamp = Field(...)
    updated: GroupedTimestamp = Field(...)
    user: ReferencedUser = Field(...)
    next_billing_date: Optional[GroupedTimestamp] = None
    paused: Optional[GroupedTimestamp] = None
    cancelled: Optional[GroupedTimestamp] = None
    active: StrictBool = Field(...)
    term: SubscriptionTermEnum = Field(...)
    quantity: StrictInt = Field(...)
    subscription_id: StrictStr = Field(...)
    product_id: StrictStr = Field(...)
    score: Optional[Score] = None
    price_id: StrictStr = Field(...)
    __properties = ["schema", "id", "name", "created", "updated", "user", "next_billing_date", "paused", "cancelled", "active", "term", "quantity", "subscription_id", "product_id", "score", "price_id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Subscription:
        """Create an instance of Subscription from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of created
        if self.created:
            _dict['created'] = self.created.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of updated
        if self.updated:
            _dict['updated'] = self.updated.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of next_billing_date
        if self.next_billing_date:
            _dict['next_billing_date'] = self.next_billing_date.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of paused
        if self.paused:
            _dict['paused'] = self.paused.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of cancelled
        if self.cancelled:
            _dict['cancelled'] = self.cancelled.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of score
        if self.score:
            _dict['score'] = self.score.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Subscription:
        """Create an instance of Subscription from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Subscription.parse_obj(obj)

        _obj = Subscription.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "id": obj.get("id"),
            "name": obj.get("name"),
            "created": GroupedTimestamp.from_dict(obj.get("created")) if obj.get("created") is not None else None,
            "updated": GroupedTimestamp.from_dict(obj.get("updated")) if obj.get("updated") is not None else None,
            "user": ReferencedUser.from_dict(obj.get("user")) if obj.get("user") is not None else None,
            "next_billing_date": GroupedTimestamp.from_dict(obj.get("next_billing_date")) if obj.get("next_billing_date") is not None else None,
            "paused": GroupedTimestamp.from_dict(obj.get("paused")) if obj.get("paused") is not None else None,
            "cancelled": GroupedTimestamp.from_dict(obj.get("cancelled")) if obj.get("cancelled") is not None else None,
            "active": obj.get("active"),
            "term": obj.get("term"),
            "quantity": obj.get("quantity"),
            "subscription_id": obj.get("subscription_id"),
            "product_id": obj.get("product_id"),
            "score": Score.from_dict(obj.get("score")) if obj.get("score") is not None else None,
            "price_id": obj.get("price_id")
        })
        return _obj


