# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, conlist
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.flattened_anchors import FlattenedAnchors
from pieces._vendor.pieces_os_client.models.mechanism_enum import MechanismEnum
from pieces._vendor.pieces_os_client.models.person_access import PersonAccess
from pieces._vendor.pieces_os_client.models.person_model import PersonModel
from pieces._vendor.pieces_os_client.models.person_type import PersonType
from pieces._vendor.pieces_os_client.models.seeded_annotation import SeededAnnotation

class SeededPerson(BaseModel):
    """
    This is a per-cursor to a full person.  Will throw an error, if asset is passed in but acces.scope is undefined.  can optionally pass in our mechanism here, as the default will be manual unless specified.  TODO consider updating these asset, format to referenced Models  Note: model, access, mechanism will only be added if the asset is passed in.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    asset: Optional[StrictStr] = None
    mechanism: Optional[MechanismEnum] = None
    access: Optional[PersonAccess] = None
    type: PersonType = Field(...)
    model: Optional[PersonModel] = None
    annotations: Optional[conlist(SeededAnnotation)] = None
    anchors: Optional[FlattenedAnchors] = None
    __properties = ["schema", "asset", "mechanism", "access", "type", "model", "annotations", "anchors"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeededPerson:
        """Create an instance of SeededPerson from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of access
        if self.access:
            _dict['access'] = self.access.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of model
        if self.model:
            _dict['model'] = self.model.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in annotations (list)
        _items = []
        if self.annotations:
            for _item in self.annotations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['annotations'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of anchors
        if self.anchors:
            _dict['anchors'] = self.anchors.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeededPerson:
        """Create an instance of SeededPerson from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeededPerson.parse_obj(obj)

        _obj = SeededPerson.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "asset": obj.get("asset"),
            "mechanism": obj.get("mechanism"),
            "access": PersonAccess.from_dict(obj.get("access")) if obj.get("access") is not None else None,
            "type": PersonType.from_dict(obj.get("type")) if obj.get("type") is not None else None,
            "model": PersonModel.from_dict(obj.get("model")) if obj.get("model") is not None else None,
            "annotations": [SeededAnnotation.from_dict(_item) for _item in obj.get("annotations")] if obj.get("annotations") is not None else None,
            "anchors": FlattenedAnchors.from_dict(obj.get("anchors")) if obj.get("anchors") is not None else None
        })
        return _obj


