# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, conlist
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.mechanism_enum import MechanismEnum
from pieces._vendor.pieces_os_client.models.seeded_anchor import SeededAnchor
from pieces._vendor.pieces_os_client.models.seeded_annotation import SeededAnnotation
from pieces._vendor.pieces_os_client.models.seeded_asset_sensitive import SeededAssetSensitive
from pieces._vendor.pieces_os_client.models.seeded_asset_tag import SeededAssetTag
from pieces._vendor.pieces_os_client.models.seeded_asset_website import SeededAssetWebsite
from pieces._vendor.pieces_os_client.models.seeded_hint import SeededHint
from pieces._vendor.pieces_os_client.models.seeded_person import SeededPerson

class SeededAssetMetadata(BaseModel):
    """
    This is optional metadata sent with the SeededAsset and other SeededAssets ie (UE, Jetbrains...)  Note: if a user/develop didnt explicitly state a mechanism we will default to manual(user Driven only)  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    name: Optional[StrictStr] = Field(default=None, description="This is the name of the asset.")
    mechanism: Optional[MechanismEnum] = None
    tags: Optional[conlist(SeededAssetTag)] = Field(default=None, description="(optional) can add some tags to associate to this asset.")
    websites: Optional[conlist(SeededAssetWebsite)] = None
    sensitives: Optional[conlist(SeededAssetSensitive)] = None
    persons: Optional[conlist(SeededPerson)] = None
    annotations: Optional[conlist(SeededAnnotation)] = None
    hints: Optional[conlist(SeededHint)] = None
    anchors: Optional[conlist(SeededAnchor)] = None
    __properties = ["schema", "name", "mechanism", "tags", "websites", "sensitives", "persons", "annotations", "hints", "anchors"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeededAssetMetadata:
        """Create an instance of SeededAssetMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in websites (list)
        _items = []
        if self.websites:
            for _item in self.websites:
                if _item:
                    _items.append(_item.to_dict())
            _dict['websites'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in sensitives (list)
        _items = []
        if self.sensitives:
            for _item in self.sensitives:
                if _item:
                    _items.append(_item.to_dict())
            _dict['sensitives'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in persons (list)
        _items = []
        if self.persons:
            for _item in self.persons:
                if _item:
                    _items.append(_item.to_dict())
            _dict['persons'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in annotations (list)
        _items = []
        if self.annotations:
            for _item in self.annotations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['annotations'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in hints (list)
        _items = []
        if self.hints:
            for _item in self.hints:
                if _item:
                    _items.append(_item.to_dict())
            _dict['hints'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in anchors (list)
        _items = []
        if self.anchors:
            for _item in self.anchors:
                if _item:
                    _items.append(_item.to_dict())
            _dict['anchors'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeededAssetMetadata:
        """Create an instance of SeededAssetMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeededAssetMetadata.parse_obj(obj)

        _obj = SeededAssetMetadata.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "name": obj.get("name"),
            "mechanism": obj.get("mechanism"),
            "tags": [SeededAssetTag.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None,
            "websites": [SeededAssetWebsite.from_dict(_item) for _item in obj.get("websites")] if obj.get("websites") is not None else None,
            "sensitives": [SeededAssetSensitive.from_dict(_item) for _item in obj.get("sensitives")] if obj.get("sensitives") is not None else None,
            "persons": [SeededPerson.from_dict(_item) for _item in obj.get("persons")] if obj.get("persons") is not None else None,
            "annotations": [SeededAnnotation.from_dict(_item) for _item in obj.get("annotations")] if obj.get("annotations") is not None else None,
            "hints": [SeededHint.from_dict(_item) for _item in obj.get("hints")] if obj.get("hints") is not None else None,
            "anchors": [SeededAnchor.from_dict(_item) for _item in obj.get("anchors")] if obj.get("anchors") is not None else None
        })
        return _obj


