# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, conlist
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.paddle_checkout_error_detail import PaddleCheckoutErrorDetail

class PaddleCheckoutWarningEvent(BaseModel):
    """
    PaddleCheckoutWarningEvent
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    name: StrictStr = Field(...)
    code: Optional[StrictStr] = None
    detail: Optional[StrictStr] = None
    documentation_url: Optional[StrictStr] = None
    errors: Optional[conlist(PaddleCheckoutErrorDetail)] = None
    __properties = ["schema", "name", "code", "detail", "documentation_url", "errors"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PaddleCheckoutWarningEvent:
        """Create an instance of PaddleCheckoutWarningEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item in self.errors:
                if _item:
                    _items.append(_item.to_dict())
            _dict['errors'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PaddleCheckoutWarningEvent:
        """Create an instance of PaddleCheckoutWarningEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PaddleCheckoutWarningEvent.parse_obj(obj)

        _obj = PaddleCheckoutWarningEvent.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "name": obj.get("name"),
            "code": obj.get("code"),
            "detail": obj.get("detail"),
            "documentation_url": obj.get("documentation_url"),
            "errors": [PaddleCheckoutErrorDetail.from_dict(_item) for _item in obj.get("errors")] if obj.get("errors") is not None else None
        })
        return _obj


