# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.paddle_checkout_billing_cycle import PaddleCheckoutBillingCycle
from pieces._vendor.pieces_os_client.models.paddle_checkout_product import PaddleCheckoutProduct
from pieces._vendor.pieces_os_client.models.paddle_checkout_totals import PaddleCheckoutTotals

class PaddleCheckoutItem(BaseModel):
    """
    One line-item in the checkout. billing_cycle or trial_period may be null.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    price_id: StrictStr = Field(...)
    product: PaddleCheckoutProduct = Field(...)
    billing_cycle: Optional[PaddleCheckoutBillingCycle] = None
    trial_period: Optional[StrictInt] = None
    quantity: StrictInt = Field(...)
    totals: PaddleCheckoutTotals = Field(...)
    recurring_totals: Optional[PaddleCheckoutTotals] = None
    __properties = ["schema", "price_id", "product", "billing_cycle", "trial_period", "quantity", "totals", "recurring_totals"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PaddleCheckoutItem:
        """Create an instance of PaddleCheckoutItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of product
        if self.product:
            _dict['product'] = self.product.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of billing_cycle
        if self.billing_cycle:
            _dict['billing_cycle'] = self.billing_cycle.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of totals
        if self.totals:
            _dict['totals'] = self.totals.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of recurring_totals
        if self.recurring_totals:
            _dict['recurring_totals'] = self.recurring_totals.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PaddleCheckoutItem:
        """Create an instance of PaddleCheckoutItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PaddleCheckoutItem.parse_obj(obj)

        _obj = PaddleCheckoutItem.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "price_id": obj.get("price_id"),
            "product": PaddleCheckoutProduct.from_dict(obj.get("product")) if obj.get("product") is not None else None,
            "billing_cycle": PaddleCheckoutBillingCycle.from_dict(obj.get("billing_cycle")) if obj.get("billing_cycle") is not None else None,
            "trial_period": obj.get("trial_period"),
            "quantity": obj.get("quantity"),
            "totals": PaddleCheckoutTotals.from_dict(obj.get("totals")) if obj.get("totals") is not None else None,
            "recurring_totals": PaddleCheckoutTotals.from_dict(obj.get("recurring_totals")) if obj.get("recurring_totals") is not None else None
        })
        return _obj


