# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictStr
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.paddle_checkout_error_event_error import PaddleCheckoutErrorEventError

class PaddleCheckoutErrorEvent(BaseModel):
    """
    PaddleCheckoutErrorEvent
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    name: StrictStr = Field(...)
    data: Dict[str, Any] = Field(...)
    error: Optional[PaddleCheckoutErrorEventError] = None
    __properties = ["schema", "name", "data", "error"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PaddleCheckoutErrorEvent:
        """Create an instance of PaddleCheckoutErrorEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of error
        if self.error:
            _dict['error'] = self.error.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PaddleCheckoutErrorEvent:
        """Create an instance of PaddleCheckoutErrorEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PaddleCheckoutErrorEvent.parse_obj(obj)

        _obj = PaddleCheckoutErrorEvent.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "name": obj.get("name"),
            "data": obj.get("data"),
            "error": PaddleCheckoutErrorEventError.from_dict(obj.get("error")) if obj.get("error") is not None else None
        })
        return _obj


