# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictStr
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.paddle_checkout_address import PaddleCheckoutAddress
from pieces._vendor.pieces_os_client.models.paddle_checkout_business import PaddleCheckoutBusiness

class PaddleCheckoutCustomer(BaseModel):
    """
    PaddleCheckoutCustomer
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    id: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    address: Optional[PaddleCheckoutAddress] = None
    business: Optional[PaddleCheckoutBusiness] = None
    __properties = ["schema", "id", "email", "address", "business"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PaddleCheckoutCustomer:
        """Create an instance of PaddleCheckoutCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of business
        if self.business:
            _dict['business'] = self.business.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PaddleCheckoutCustomer:
        """Create an instance of PaddleCheckoutCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PaddleCheckoutCustomer.parse_obj(obj)

        _obj = PaddleCheckoutCustomer.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "id": obj.get("id"),
            "email": obj.get("email"),
            "address": PaddleCheckoutAddress.from_dict(obj.get("address")) if obj.get("address") is not None else None,
            "business": PaddleCheckoutBusiness.from_dict(obj.get("business")) if obj.get("business") is not None else None
        })
        return _obj


