# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel
from pieces._vendor.pieces_os_client.models.o_auth_account import OAuthAccount
from pieces._vendor.pieces_os_client.models.o_auth_token import OAuthToken

class OAuthGroup(BaseModel):
    """
    A model to group all of the properties associated with OAuthGroup  # noqa: E501
    """
    token: Optional[OAuthToken] = None
    account: Optional[OAuthAccount] = None
    __properties = ["token", "account"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OAuthGroup:
        """Create an instance of OAuthGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of token
        if self.token:
            _dict['token'] = self.token.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OAuthGroup:
        """Create an instance of OAuthGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OAuthGroup.parse_obj(obj)

        _obj = OAuthGroup.parse_obj({
            "token": OAuthToken.from_dict(obj.get("token")) if obj.get("token") is not None else None,
            "account": OAuthAccount.from_dict(obj.get("account")) if obj.get("account") is not None else None
        })
        return _obj


