# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.migration_status_enum import MigrationStatusEnum

class MigrationProgress(BaseModel):
    """
    This is a model used to communicate the status of a migration in progress  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    total_items: StrictInt = Field(default=..., alias="totalItems")
    processed_items: StrictInt = Field(default=..., alias="processedItems")
    current_batch: StrictInt = Field(default=..., alias="currentBatch")
    batch_size: StrictInt = Field(default=..., alias="batchSize")
    percent_complete: Union[StrictFloat, StrictInt] = Field(default=..., alias="percentComplete")
    elapsed_milliseconds: StrictInt = Field(default=..., alias="elapsedMilliseconds")
    current_stage: StrictStr = Field(default=..., alias="currentStage")
    readable: StrictStr = Field(...)
    estimated_time_remaining: Optional[StrictInt] = Field(default=None, alias="estimatedTimeRemaining")
    status: MigrationStatusEnum = Field(...)
    __properties = ["schema", "totalItems", "processedItems", "currentBatch", "batchSize", "percentComplete", "elapsedMilliseconds", "currentStage", "readable", "estimatedTimeRemaining", "status"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MigrationProgress:
        """Create an instance of MigrationProgress from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MigrationProgress:
        """Create an instance of MigrationProgress from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MigrationProgress.parse_obj(obj)

        _obj = MigrationProgress.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "total_items": obj.get("totalItems"),
            "processed_items": obj.get("processedItems"),
            "current_batch": obj.get("currentBatch"),
            "batch_size": obj.get("batchSize"),
            "percent_complete": obj.get("percentComplete"),
            "elapsed_milliseconds": obj.get("elapsedMilliseconds"),
            "current_stage": obj.get("currentStage"),
            "readable": obj.get("readable"),
            "estimated_time_remaining": obj.get("estimatedTimeRemaining"),
            "status": obj.get("status")
        })
        return _obj


